/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.client;

import ca.uhn.fhir.rest.server.EncodingEnum;
import ca.uhn.fhir.util.VersionUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.message.BasicHeader;

public abstract class BaseHttpClientInvocation {
    private List<Header> myHeaders;

    public void addHeader(String theName, String theValue) {
        if (this.myHeaders == null) {
            this.myHeaders = new ArrayList<Header>();
        }
        this.myHeaders.add((Header)new BasicHeader(theName, theValue));
    }

    public abstract HttpRequestBase asHttpRequest(String var1, Map<String, List<String>> var2, EncodingEnum var3, Boolean var4);

    protected static void appendExtraParamsWithQuestionMark(Map<String, List<String>> theExtraParams, StringBuilder theUrlBuilder, boolean theWithQuestionMark) {
        if (theExtraParams == null) {
            return;
        }
        boolean first = theWithQuestionMark;
        if (theExtraParams != null && !theExtraParams.isEmpty()) {
            for (Map.Entry<String, List<String>> next : theExtraParams.entrySet()) {
                for (String nextValue : next.getValue()) {
                    if (first) {
                        theUrlBuilder.append('?');
                        first = false;
                    } else {
                        theUrlBuilder.append('&');
                    }
                    try {
                        theUrlBuilder.append(URLEncoder.encode(next.getKey(), "UTF-8"));
                        theUrlBuilder.append('=');
                        theUrlBuilder.append(URLEncoder.encode(nextValue, "UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new Error("UTF-8 not supported - This should not happen");
                    }
                }
            }
        }
    }

    public void addHeadersToRequest(HttpRequestBase theHttpRequest, EncodingEnum theEncoding) {
        if (this.myHeaders != null) {
            for (Header next : this.myHeaders) {
                theHttpRequest.addHeader(next);
            }
        }
        theHttpRequest.addHeader("User-Agent", "HAPI-FHIR/" + VersionUtil.getVersion() + " (FHIR Client)");
        theHttpRequest.addHeader("Accept-Charset", "utf-8");
        theHttpRequest.addHeader("Accept-Encoding", "gzip");
        if (theEncoding == null) {
            theHttpRequest.addHeader("Accept", "application/xml+fhir;q=1.0, application/json+fhir;q=1.0");
        } else if (theEncoding == EncodingEnum.JSON) {
            theHttpRequest.addHeader("Accept", "application/json+fhir");
        } else if (theEncoding == EncodingEnum.XML) {
            theHttpRequest.addHeader("Accept", "application/xml+fhir");
        }
    }
}

