/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.client;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.rest.client.BaseClient;
import ca.uhn.fhir.rest.client.BaseHttpClientInvocation;
import ca.uhn.fhir.rest.client.ClientInvocationHandlerFactory;
import ca.uhn.fhir.rest.client.RestfulClientFactory;
import ca.uhn.fhir.rest.method.BaseMethodBinding;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.http.client.HttpClient;

class ClientInvocationHandler
extends BaseClient
implements InvocationHandler {
    private final Map<Method, BaseMethodBinding<?>> myBindings;
    private final Map<Method, Object> myMethodToReturnValue;
    private FhirContext myContext;
    private Map<Method, ClientInvocationHandlerFactory.ILambda> myMethodToLambda;

    public ClientInvocationHandler(HttpClient theClient, FhirContext theContext, String theUrlBase, Map<Method, Object> theMethodToReturnValue, Map<Method, BaseMethodBinding<?>> theBindings, Map<Method, ClientInvocationHandlerFactory.ILambda> theMethodToLambda, RestfulClientFactory theFactory) {
        super(theClient, theUrlBase, theFactory);
        this.myContext = theContext;
        this.myMethodToReturnValue = theMethodToReturnValue;
        this.myBindings = theBindings;
        this.myMethodToLambda = theMethodToLambda;
    }

    public void addBinding(Method theMethod, BaseMethodBinding<?> theBinding) {
        this.myBindings.put(theMethod, theBinding);
    }

    @Override
    public Object invoke(Object theProxy, Method theMethod, Object[] theArgs) throws Throwable {
        Object directRetVal = this.myMethodToReturnValue.get(theMethod);
        if (directRetVal != null) {
            return directRetVal;
        }
        BaseMethodBinding<?> binding = this.myBindings.get(theMethod);
        if (binding != null) {
            BaseHttpClientInvocation clientInvocation = binding.invokeClient(theArgs);
            return this.invokeClient(this.myContext, binding, clientInvocation);
        }
        ClientInvocationHandlerFactory.ILambda lambda = this.myMethodToLambda.get(theMethod);
        if (lambda != null) {
            return lambda.handle(this, theArgs);
        }
        throw new UnsupportedOperationException("The method '" + theMethod.getName() + "' in type " + theMethod.getDeclaringClass().getSimpleName() + " has no handler. Did you forget to annotate it with a RESTful method annotation?");
    }

    @Override
    public FhirContext getFhirContext() {
        return this.myContext;
    }
}

