/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.client;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementCompositeDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.IRuntimeDatatypeDefinition;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.model.api.Bundle;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TagList;
import ca.uhn.fhir.model.base.resource.BaseConformance;
import ca.uhn.fhir.model.base.resource.BaseOperationOutcome;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.model.primitive.UriDt;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.rest.api.MethodOutcome;
import ca.uhn.fhir.rest.api.PreferReturnEnum;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ca.uhn.fhir.rest.client.BaseClient;
import ca.uhn.fhir.rest.client.BaseHttpClientInvocation;
import ca.uhn.fhir.rest.client.IGenericClient;
import ca.uhn.fhir.rest.client.RestfulClientFactory;
import ca.uhn.fhir.rest.client.exceptions.NonFhirResponseException;
import ca.uhn.fhir.rest.gclient.IClientExecutable;
import ca.uhn.fhir.rest.gclient.ICreate;
import ca.uhn.fhir.rest.gclient.ICreateTyped;
import ca.uhn.fhir.rest.gclient.ICreateWithQuery;
import ca.uhn.fhir.rest.gclient.ICreateWithQueryTyped;
import ca.uhn.fhir.rest.gclient.ICriterion;
import ca.uhn.fhir.rest.gclient.ICriterionInternal;
import ca.uhn.fhir.rest.gclient.IDelete;
import ca.uhn.fhir.rest.gclient.IDeleteTyped;
import ca.uhn.fhir.rest.gclient.IDeleteWithQuery;
import ca.uhn.fhir.rest.gclient.IDeleteWithQueryTyped;
import ca.uhn.fhir.rest.gclient.IFetchConformanceTyped;
import ca.uhn.fhir.rest.gclient.IFetchConformanceUntyped;
import ca.uhn.fhir.rest.gclient.IGetPage;
import ca.uhn.fhir.rest.gclient.IGetPageTyped;
import ca.uhn.fhir.rest.gclient.IGetPageUntyped;
import ca.uhn.fhir.rest.gclient.IGetTags;
import ca.uhn.fhir.rest.gclient.IHistory;
import ca.uhn.fhir.rest.gclient.IHistoryTyped;
import ca.uhn.fhir.rest.gclient.IHistoryUntyped;
import ca.uhn.fhir.rest.gclient.IMeta;
import ca.uhn.fhir.rest.gclient.IMetaAddOrDeleteSourced;
import ca.uhn.fhir.rest.gclient.IMetaAddOrDeleteUnsourced;
import ca.uhn.fhir.rest.gclient.IMetaGetUnsourced;
import ca.uhn.fhir.rest.gclient.IOperation;
import ca.uhn.fhir.rest.gclient.IOperationUnnamed;
import ca.uhn.fhir.rest.gclient.IOperationUntyped;
import ca.uhn.fhir.rest.gclient.IOperationUntypedWithInput;
import ca.uhn.fhir.rest.gclient.IOperationUntypedWithInputAndPartialOutput;
import ca.uhn.fhir.rest.gclient.IParam;
import ca.uhn.fhir.rest.gclient.IQuery;
import ca.uhn.fhir.rest.gclient.IRead;
import ca.uhn.fhir.rest.gclient.IReadExecutable;
import ca.uhn.fhir.rest.gclient.IReadIfNoneMatch;
import ca.uhn.fhir.rest.gclient.IReadTyped;
import ca.uhn.fhir.rest.gclient.ISort;
import ca.uhn.fhir.rest.gclient.ITransaction;
import ca.uhn.fhir.rest.gclient.ITransactionTyped;
import ca.uhn.fhir.rest.gclient.IUntypedQuery;
import ca.uhn.fhir.rest.gclient.IUpdate;
import ca.uhn.fhir.rest.gclient.IUpdateExecutable;
import ca.uhn.fhir.rest.gclient.IUpdateTyped;
import ca.uhn.fhir.rest.gclient.IUpdateWithQuery;
import ca.uhn.fhir.rest.gclient.IUpdateWithQueryTyped;
import ca.uhn.fhir.rest.gclient.IValidate;
import ca.uhn.fhir.rest.gclient.IValidateUntyped;
import ca.uhn.fhir.rest.method.DeleteMethodBinding;
import ca.uhn.fhir.rest.method.HistoryMethodBinding;
import ca.uhn.fhir.rest.method.HttpDeleteClientInvocation;
import ca.uhn.fhir.rest.method.HttpGetClientInvocation;
import ca.uhn.fhir.rest.method.HttpPostClientInvocation;
import ca.uhn.fhir.rest.method.HttpPutClientInvocation;
import ca.uhn.fhir.rest.method.HttpSimpleGetClientInvocation;
import ca.uhn.fhir.rest.method.IClientResponseHandler;
import ca.uhn.fhir.rest.method.MethodUtil;
import ca.uhn.fhir.rest.method.OperationMethodBinding;
import ca.uhn.fhir.rest.method.ReadMethodBinding;
import ca.uhn.fhir.rest.method.SearchMethodBinding;
import ca.uhn.fhir.rest.method.SearchStyleEnum;
import ca.uhn.fhir.rest.method.TransactionMethodBinding;
import ca.uhn.fhir.rest.method.ValidateMethodBindingDstu1;
import ca.uhn.fhir.rest.method.ValidateMethodBindingDstu2;
import ca.uhn.fhir.rest.param.DateParam;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.TokenParam;
import ca.uhn.fhir.rest.server.EncodingEnum;
import ca.uhn.fhir.rest.server.IVersionSpecificBundleFactory;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.NotModifiedException;
import ca.uhn.fhir.util.ICallable;
import ca.uhn.fhir.util.ParametersUtil;
import ca.uhn.fhir.util.UrlUtil;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpRequestBase;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseConformance;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseMetaType;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericClient
extends BaseClient
implements IGenericClient {
    private static final String I18N_CANNOT_DETEMINE_RESOURCE_TYPE = "ca.uhn.fhir.rest.client.GenericClient.cannotDetermineResourceTypeFromUri";
    private static final String I18N_INCOMPLETE_URI_FOR_READ = "ca.uhn.fhir.rest.client.GenericClient.incompleteUriForRead";
    private static final String I18N_NO_VERSION_ID_FOR_VREAD = "ca.uhn.fhir.rest.client.GenericClient.noVersionIdForVread";
    private static final Logger ourLog = LoggerFactory.getLogger(GenericClient.class);
    private FhirContext myContext;
    private HttpRequestBase myLastRequest;
    private boolean myLogRequestAndResponse;

    public GenericClient(FhirContext theContext, HttpClient theHttpClient, String theServerBase, RestfulClientFactory theFactory) {
        super(theHttpClient, theServerBase, theFactory);
        this.myContext = theContext;
    }

    @Override
    public BaseConformance conformance() {
        if (this.myContext.getVersion().getVersion().equals((Object)FhirVersionEnum.DSTU2_HL7ORG)) {
            throw new IllegalArgumentException("Must call conformance(" + IBaseConformance.class.getSimpleName() + ") instead of conformance() for HL7.org structures");
        }
        HttpGetClientInvocation invocation = MethodUtil.createConformanceInvocation();
        if (this.isKeepResponses()) {
            this.myLastRequest = invocation.asHttpRequest(this.getServerBase(), this.createExtraParams(), this.getEncoding(), (Boolean)this.isPrettyPrint());
        }
        Class conformance = this.myContext.getResourceDefinition("Conformance").getImplementingClass();
        BaseClient.ResourceResponseHandler binding = new BaseClient.ResourceResponseHandler(conformance, null);
        BaseConformance resp = (BaseConformance)this.invokeClient(this.myContext, binding, invocation, this.myLogRequestAndResponse);
        return resp;
    }

    @Override
    public ICreate create() {
        return new CreateInternal();
    }

    @Override
    public MethodOutcome create(IResource theResource) {
        HttpPostClientInvocation invocation = MethodUtil.createCreateInvocation(theResource, this.myContext);
        if (this.isKeepResponses()) {
            this.myLastRequest = ((BaseHttpClientInvocation)invocation).asHttpRequest(this.getServerBase(), this.createExtraParams(), this.getEncoding(), this.isPrettyPrint());
        }
        RuntimeResourceDefinition def = this.myContext.getResourceDefinition(theResource);
        String resourceName = def.getName();
        OutcomeResponseHandler binding = new OutcomeResponseHandler(resourceName);
        MethodOutcome resp = this.invokeClient(this.myContext, binding, invocation, this.myLogRequestAndResponse);
        return resp;
    }

    @Override
    public IDelete delete() {
        return new DeleteInternal();
    }

    @Override
    public MethodOutcome delete(Class<? extends IResource> theType, IdDt theId) {
        HttpDeleteClientInvocation invocation = DeleteMethodBinding.createDeleteInvocation(theId.withResourceType(this.toResourceName(theType)));
        if (this.isKeepResponses()) {
            this.myLastRequest = invocation.asHttpRequest(this.getServerBase(), this.createExtraParams(), this.getEncoding(), this.isPrettyPrint());
        }
        String resourceName = this.myContext.getResourceDefinition(theType).getName();
        OutcomeResponseHandler binding = new OutcomeResponseHandler(resourceName);
        MethodOutcome resp = this.invokeClient(this.myContext, binding, invocation, this.myLogRequestAndResponse);
        return resp;
    }

    @Override
    public MethodOutcome delete(Class<? extends IResource> theType, String theId) {
        return this.delete(theType, new IdDt(theId));
    }

    private <T extends IBaseResource> T doReadOrVRead(Class<T> theType, IIdType theId, boolean theVRead, ICallable<T> theNotModifiedHandler, String theIfVersionMatches, Boolean thePrettyPrint, SummaryEnum theSummary, EncodingEnum theEncoding, Set<String> theSubsetElements) {
        String resName = this.toResourceName(theType);
        IIdType id = theId;
        if (!id.hasBaseUrl()) {
            id = new IdDt(resName, id.getIdPart(), id.getVersionIdPart());
        }
        HttpGetClientInvocation invocation = id.hasBaseUrl() ? (theVRead ? ReadMethodBinding.createAbsoluteVReadInvocation(id) : ReadMethodBinding.createAbsoluteReadInvocation(id)) : (theVRead ? ReadMethodBinding.createVReadInvocation(id, resName) : ReadMethodBinding.createReadInvocation(id, resName));
        if (this.isKeepResponses()) {
            this.myLastRequest = invocation.asHttpRequest(this.getServerBase(), this.createExtraParams(), this.getEncoding(), (Boolean)this.isPrettyPrint());
        }
        if (theIfVersionMatches != null) {
            invocation.addHeader("If-None-Match", '\"' + theIfVersionMatches + '\"');
        }
        boolean allowHtmlResponse = theSummary == SummaryEnum.TEXT || theSummary == null && this.getSummary() == SummaryEnum.TEXT;
        BaseClient.ResourceResponseHandler<T> binding = new BaseClient.ResourceResponseHandler<T>(theType, id, allowHtmlResponse);
        if (theNotModifiedHandler == null) {
            return (T)((IBaseResource)this.invokeClient(this.myContext, binding, invocation, theEncoding, thePrettyPrint, this.myLogRequestAndResponse, theSummary, theSubsetElements));
        }
        try {
            return (T)((IBaseResource)this.invokeClient(this.myContext, binding, invocation, theEncoding, thePrettyPrint, this.myLogRequestAndResponse, theSummary, theSubsetElements));
        }
        catch (NotModifiedException e) {
            return (T)((IBaseResource)theNotModifiedHandler.call());
        }
    }

    @Override
    public IFetchConformanceUntyped fetchConformance() {
        return new FetchConformanceInternal();
    }

    @Override
    public void forceConformanceCheck() {
        super.forceConformanceCheck();
    }

    @Override
    public FhirContext getFhirContext() {
        return this.myContext;
    }

    public HttpRequestBase getLastRequest() {
        return this.myLastRequest;
    }

    protected String getPreferredId(IBaseResource theResource, String theId) {
        if (StringUtils.isNotBlank((CharSequence)theId)) {
            return theId;
        }
        return theResource.getIdElement().getIdPart();
    }

    @Override
    public IGetTags getTags() {
        return new GetTagsInternal();
    }

    @Override
    public IHistory history() {
        return new HistoryInternal();
    }

    @Override
    public <T extends IResource> Bundle history(Class<T> theType, IdDt theIdDt, DateTimeDt theSince, Integer theLimit) {
        String resourceName = theType != null ? this.toResourceName(theType) : null;
        String id = theIdDt != null && !theIdDt.isEmpty() ? theIdDt.getValue() : null;
        HttpGetClientInvocation invocation = HistoryMethodBinding.createHistoryInvocation(resourceName, id, theSince, theLimit);
        if (this.isKeepResponses()) {
            this.myLastRequest = invocation.asHttpRequest(this.getServerBase(), this.createExtraParams(), this.getEncoding(), (Boolean)this.isPrettyPrint());
        }
        BundleResponseHandler binding = new BundleResponseHandler(theType);
        Bundle resp = this.invokeClient(this.myContext, binding, invocation, this.myLogRequestAndResponse);
        return resp;
    }

    @Override
    public <T extends IResource> Bundle history(Class<T> theType, String theId, DateTimeDt theSince, Integer theLimit) {
        return this.history(theType, new IdDt(theId), theSince, theLimit);
    }

    private Class<? extends IBaseResource> inferResourceClass(UriDt theUrl) {
        String urlString = theUrl.getValueAsString();
        int i = urlString.indexOf(63);
        if (i >= 0) {
            urlString = urlString.substring(0, i);
        }
        if ((i = urlString.indexOf("://")) >= 0) {
            urlString = urlString.substring(i + 3);
        }
        String[] pcs = urlString.split("\\/");
        for (i = pcs.length - 1; i >= 0; --i) {
            RuntimeResourceDefinition def;
            String s = pcs[i].trim();
            if (s.isEmpty() || (def = this.myContext.getResourceDefinition(s)) == null) continue;
            return def.getImplementingClass();
        }
        throw new RuntimeException(this.myContext.getLocalizer().getMessage(I18N_CANNOT_DETEMINE_RESOURCE_TYPE, theUrl.getValueAsString()));
    }

    public boolean isLogRequestAndResponse() {
        return this.myLogRequestAndResponse;
    }

    @Override
    public IGetPage loadPage() {
        return new LoadPageInternal();
    }

    @Override
    public IMeta meta() {
        if (this.myContext.getVersion().getVersion().equals((Object)FhirVersionEnum.DSTU1)) {
            throw new IllegalStateException("Can not call $meta operations on a DSTU1 client");
        }
        return new MetaInternal();
    }

    @Override
    public IOperation operation() {
        if (!this.myContext.getVersion().getVersion().isNewerThan(FhirVersionEnum.DSTU1)) {
            throw new IllegalStateException("Operations are only supported in FHIR DSTU2 and later. This client was created using a context configured for " + this.myContext.getVersion().getVersion().name());
        }
        return new OperationInternal();
    }

    @Override
    public IRead read() {
        return new ReadInternal();
    }

    @Override
    public <T extends IBaseResource> T read(Class<T> theType, String theId) {
        return this.read(theType, new IdDt(theId));
    }

    @Override
    public <T extends IBaseResource> T read(Class<T> theType, UriDt theUrl) {
        IdDt id = theUrl instanceof IdDt ? (IdDt)theUrl : new IdDt(theUrl);
        return this.doReadOrVRead(theType, id, false, null, null, false, null, null, null);
    }

    @Override
    public IBaseResource read(UriDt theUrl) {
        IdDt id = new IdDt(theUrl);
        String resourceType = id.getResourceType();
        if (StringUtils.isBlank((CharSequence)resourceType)) {
            throw new IllegalArgumentException(this.myContext.getLocalizer().getMessage(I18N_INCOMPLETE_URI_FOR_READ, theUrl.getValueAsString()));
        }
        RuntimeResourceDefinition def = this.myContext.getResourceDefinition(resourceType);
        if (def == null) {
            throw new IllegalArgumentException(this.myContext.getLocalizer().getMessage(I18N_CANNOT_DETEMINE_RESOURCE_TYPE, theUrl.getValueAsString()));
        }
        return this.read(def.getImplementingClass(), id);
    }

    @Override
    public IUntypedQuery search() {
        return new SearchInternal();
    }

    @Override
    public <T extends IBaseResource> Bundle search(Class<T> theType, Map<String, List<IQueryParameterType>> theParams) {
        LinkedHashMap<String, List<String>> params = new LinkedHashMap<String, List<String>>();
        for (Map.Entry<String, List<IQueryParameterType>> nextEntry : theParams.entrySet()) {
            ArrayList<String> valueList = new ArrayList<String>();
            String qualifier = null;
            for (IQueryParameterType nextValue : nextEntry.getValue()) {
                valueList.add(nextValue.getValueAsQueryToken());
                qualifier = nextValue.getQueryParameterQualifier();
            }
            qualifier = StringUtils.defaultString(qualifier);
            params.put(nextEntry.getKey() + qualifier, valueList);
        }
        BaseHttpClientInvocation invocation = SearchMethodBinding.createSearchInvocation(this.myContext, this.toResourceName(theType), params, null, null, null);
        if (this.isKeepResponses()) {
            this.myLastRequest = invocation.asHttpRequest(this.getServerBase(), this.createExtraParams(), this.getEncoding(), this.isPrettyPrint());
        }
        BundleResponseHandler binding = new BundleResponseHandler(theType);
        Bundle resp = this.invokeClient(this.myContext, binding, invocation, this.myLogRequestAndResponse);
        return resp;
    }

    @Override
    public <T extends IBaseResource> Bundle search(Class<T> theType, UriDt theUrl) {
        HttpGetClientInvocation invocation = new HttpGetClientInvocation(theUrl.getValueAsString());
        return this.invokeClient(this.myContext, new BundleResponseHandler(theType), invocation);
    }

    @Override
    public Bundle search(UriDt theUrl) {
        return this.search(this.inferResourceClass(theUrl), theUrl);
    }

    public void setLastRequest(HttpRequestBase theLastRequest) {
        this.myLastRequest = theLastRequest;
    }

    @Override
    public void setLogRequestAndResponse(boolean theLogRequestAndResponse) {
        this.myLogRequestAndResponse = theLogRequestAndResponse;
    }

    private String toResourceName(Class<? extends IBaseResource> theType) {
        return this.myContext.getResourceDefinition(theType).getName();
    }

    @Override
    public ITransaction transaction() {
        return new TransactionInternal();
    }

    @Override
    public List<IBaseResource> transaction(List<IBaseResource> theResources) {
        BaseHttpClientInvocation invocation = TransactionMethodBinding.createTransactionInvocation(theResources, this.myContext);
        if (this.isKeepResponses()) {
            this.myLastRequest = invocation.asHttpRequest(this.getServerBase(), this.createExtraParams(), this.getEncoding(), this.isPrettyPrint());
        }
        Bundle resp = this.invokeClient(this.myContext, new BundleResponseHandler(null), invocation, this.myLogRequestAndResponse);
        return new ArrayList<IBaseResource>(resp.toListOfResources());
    }

    @Override
    public IUpdate update() {
        return new UpdateInternal();
    }

    @Override
    public MethodOutcome update(IdDt theIdDt, IResource theResource) {
        HttpPutClientInvocation invocation = MethodUtil.createUpdateInvocation(theResource, null, theIdDt, this.myContext);
        if (this.isKeepResponses()) {
            this.myLastRequest = ((BaseHttpClientInvocation)invocation).asHttpRequest(this.getServerBase(), this.createExtraParams(), this.getEncoding(), this.isPrettyPrint());
        }
        RuntimeResourceDefinition def = this.myContext.getResourceDefinition(theResource);
        String resourceName = def.getName();
        OutcomeResponseHandler binding = new OutcomeResponseHandler(resourceName);
        MethodOutcome resp = this.invokeClient(this.myContext, binding, invocation, this.myLogRequestAndResponse);
        return resp;
    }

    @Override
    public MethodOutcome update(String theId, IResource theResource) {
        return this.update(new IdDt(theId), theResource);
    }

    @Override
    public IValidate validate() {
        return new ValidateInternal();
    }

    @Override
    public MethodOutcome validate(IResource theResource) {
        BaseHttpClientInvocation invocation = this.myContext.getVersion().getVersion().equals((Object)FhirVersionEnum.DSTU1) ? ValidateMethodBindingDstu1.createValidateInvocation(theResource, null, this.myContext) : ValidateMethodBindingDstu2.createValidateInvocation(this.myContext, theResource);
        if (this.isKeepResponses()) {
            this.myLastRequest = invocation.asHttpRequest(this.getServerBase(), this.createExtraParams(), this.getEncoding(), this.isPrettyPrint());
        }
        RuntimeResourceDefinition def = this.myContext.getResourceDefinition(theResource);
        String resourceName = def.getName();
        OutcomeResponseHandler binding = new OutcomeResponseHandler(resourceName);
        MethodOutcome resp = this.invokeClient(this.myContext, binding, invocation, this.myLogRequestAndResponse);
        return resp;
    }

    @Override
    public <T extends IBaseResource> T vread(Class<T> theType, IdDt theId) {
        if (!theId.hasVersionIdPart()) {
            throw new IllegalArgumentException(this.myContext.getLocalizer().getMessage(I18N_NO_VERSION_ID_FOR_VREAD, theId.getValue()));
        }
        return this.doReadOrVRead(theType, theId, true, null, null, false, null, null, null);
    }

    @Override
    @Deprecated
    public <T extends IResource> T vread(Class<T> theType, IdDt theId, IdDt theVersionId) {
        return (T)((IResource)this.vread(theType, theId.withVersion(theVersionId.getIdPart())));
    }

    @Override
    public <T extends IBaseResource> T vread(Class<T> theType, String theId, String theVersionId) {
        IdDt resId = new IdDt(this.toResourceName(theType), theId, theVersionId);
        return this.vread(theType, resId);
    }

    private static void addParam(Map<String, List<String>> params, String parameterName, String parameterValue) {
        if (!params.containsKey(parameterName)) {
            params.put(parameterName, new ArrayList());
        }
        params.get(parameterName).add(parameterValue);
    }

    private static void addPreferHeader(PreferReturnEnum thePrefer, BaseHttpClientInvocation theInvocation) {
        if (thePrefer != null) {
            theInvocation.addHeader("Prefer", "return=" + thePrefer.getHeaderValue());
        }
    }

    private static String validateAndEscapeConditionalUrl(String theSearchUrl) {
        Validate.notBlank((CharSequence)theSearchUrl, (String)"Conditional URL can not be blank/null", (Object[])new Object[0]);
        StringBuilder b = new StringBuilder();
        boolean haveHadQuestionMark = false;
        block3: for (int i = 0; i < theSearchUrl.length(); ++i) {
            char nextChar = theSearchUrl.charAt(i);
            if (!haveHadQuestionMark) {
                if (nextChar == '?') {
                    haveHadQuestionMark = true;
                } else if (!Character.isLetter(nextChar)) {
                    throw new IllegalArgumentException("Conditional URL must be in the format \"[ResourceType]?[Params]\" and must not have a base URL - Found: " + theSearchUrl);
                }
                b.append(nextChar);
                continue;
            }
            switch (nextChar) {
                case '$': 
                case ':': 
                case '?': 
                case '|': {
                    b.append(UrlUtil.escape(Character.toString(nextChar)));
                    continue block3;
                }
                default: {
                    b.append(nextChar);
                }
            }
        }
        return b.toString();
    }

    private class ValidateInternal
    extends BaseClientExecutable<IValidateUntyped, MethodOutcome>
    implements IValidate,
    IValidateUntyped {
        private IBaseResource myResource;

        private ValidateInternal() {
        }

        @Override
        public MethodOutcome execute() {
            BaseHttpClientInvocation invocation = ValidateMethodBindingDstu2.createValidateInvocation(GenericClient.this.myContext, this.myResource);
            BaseClient.ResourceResponseHandler handler = new BaseClient.ResourceResponseHandler(null, null);
            BaseOperationOutcome outcome = (BaseOperationOutcome)this.invoke(null, handler, invocation);
            MethodOutcome retVal = new MethodOutcome();
            retVal.setOperationOutcome(outcome);
            return retVal;
        }

        @Override
        public IValidateUntyped resource(IBaseResource theResource) {
            Validate.notNull((Object)theResource, (String)"theResource must not be null", (Object[])new Object[0]);
            this.myResource = theResource;
            return this;
        }

        @Override
        public IValidateUntyped resource(String theResourceRaw) {
            Validate.notBlank((CharSequence)theResourceRaw, (String)"theResourceRaw must not be null or blank", (Object[])new Object[0]);
            this.myResource = this.parseResourceBody(theResourceRaw);
            EncodingEnum enc = MethodUtil.detectEncodingNoDefault(theResourceRaw);
            if (enc == null) {
                throw new IllegalArgumentException("Could not detect encoding (XML/JSON) in string. Is this a valid FHIR resource?");
            }
            switch (enc) {
                case XML: {
                    this.encodedXml();
                    break;
                }
                case JSON: {
                    this.encodedJson();
                }
            }
            return this;
        }
    }

    private class UpdateInternal
    extends BaseClientExecutable<IUpdateExecutable, MethodOutcome>
    implements IUpdate,
    IUpdateTyped,
    IUpdateExecutable,
    IUpdateWithQuery,
    IUpdateWithQueryTyped {
        private CriterionList myCriterionList;
        private IIdType myId;
        private PreferReturnEnum myPrefer;
        private IBaseResource myResource;
        private String myResourceBody;
        private String mySearchUrl;

        private UpdateInternal() {
        }

        @Override
        public IUpdateWithQueryTyped and(ICriterion<?> theCriterion) {
            this.myCriterionList.add((ICriterionInternal)((Object)theCriterion));
            return this;
        }

        @Override
        public IUpdateWithQuery conditional() {
            this.myCriterionList = new CriterionList();
            return this;
        }

        @Override
        public IUpdateTyped conditionalByUrl(String theSearchUrl) {
            this.mySearchUrl = GenericClient.validateAndEscapeConditionalUrl(theSearchUrl);
            return this;
        }

        @Override
        public MethodOutcome execute() {
            HttpPutClientInvocation invocation;
            if (this.myResource == null) {
                this.myResource = this.parseResourceBody(this.myResourceBody);
            }
            if (this.getParamEncoding() != null) {
                this.myResourceBody = null;
            }
            if (this.mySearchUrl != null) {
                invocation = MethodUtil.createUpdateInvocation(GenericClient.this.myContext, this.myResource, this.myResourceBody, this.mySearchUrl);
            } else if (this.myCriterionList != null) {
                invocation = MethodUtil.createUpdateInvocation(GenericClient.this.myContext, this.myResource, this.myResourceBody, this.myCriterionList.toParamList());
            } else {
                if (this.myId == null) {
                    this.myId = this.myResource.getIdElement();
                }
                if (this.myId == null || !this.myId.hasIdPart()) {
                    throw new InvalidRequestException("No ID supplied for resource to update, can not invoke server");
                }
                invocation = MethodUtil.createUpdateInvocation(this.myResource, this.myResourceBody, this.myId, GenericClient.this.myContext);
            }
            GenericClient.addPreferHeader(this.myPrefer, invocation);
            RuntimeResourceDefinition def = GenericClient.this.myContext.getResourceDefinition(this.myResource);
            String resourceName = def.getName();
            OutcomeResponseHandler binding = new OutcomeResponseHandler(resourceName);
            HashMap<String, List<String>> params = new HashMap<String, List<String>>();
            return this.invoke(params, binding, invocation);
        }

        @Override
        public IUpdateExecutable prefer(PreferReturnEnum theReturn) {
            this.myPrefer = theReturn;
            return this;
        }

        @Override
        public IUpdateTyped resource(IBaseResource theResource) {
            Validate.notNull((Object)theResource, (String)"Resource can not be null", (Object[])new Object[0]);
            this.myResource = theResource;
            return this;
        }

        @Override
        public IUpdateTyped resource(String theResourceBody) {
            Validate.notBlank((CharSequence)theResourceBody, (String)"Body can not be null or blank", (Object[])new Object[0]);
            this.myResourceBody = theResourceBody;
            return this;
        }

        @Override
        public IUpdateWithQueryTyped where(ICriterion<?> theCriterion) {
            this.myCriterionList.add((ICriterionInternal)((Object)theCriterion));
            return this;
        }

        @Override
        public IUpdateExecutable withId(IdDt theId) {
            if (theId == null) {
                throw new NullPointerException("theId can not be null");
            }
            if (!theId.hasIdPart()) {
                throw new NullPointerException("theId must not be blank and must contain an ID, found: " + theId.getValue());
            }
            this.myId = theId;
            return this;
        }

        @Override
        public IUpdateExecutable withId(String theId) {
            if (theId == null) {
                throw new NullPointerException("theId can not be null");
            }
            if (StringUtils.isBlank((CharSequence)theId)) {
                throw new NullPointerException("theId must not be blank and must contain an ID, found: " + theId);
            }
            this.myId = new IdDt(theId);
            return this;
        }
    }

    private final class TransactionInternal
    implements ITransaction {
        private TransactionInternal() {
        }

        @Override
        public ITransactionTyped<Bundle> withBundle(Bundle theBundle) {
            Validate.notNull((Object)theBundle, (String)"theBundle must not be null", (Object[])new Object[0]);
            return new TransactionExecutable<Bundle>(theBundle);
        }

        @Override
        public ITransactionTyped<String> withBundle(String theBundle) {
            Validate.notBlank((CharSequence)theBundle, (String)"theBundle must not be null", (Object[])new Object[0]);
            return new TransactionExecutable<String>(theBundle);
        }

        @Override
        public <T extends IBaseBundle> ITransactionTyped<T> withBundle(T theBundle) {
            Validate.notNull(theBundle, (String)"theBundle must not be null", (Object[])new Object[0]);
            return new TransactionExecutable(theBundle);
        }

        @Override
        public ITransactionTyped<List<IBaseResource>> withResources(List<? extends IBaseResource> theResources) {
            Validate.notNull(theResources, (String)"theResources must not be null", (Object[])new Object[0]);
            return new TransactionExecutable<List<IBaseResource>>(theResources);
        }
    }

    private final class TransactionExecutable<T>
    extends BaseClientExecutable<ITransactionTyped<T>, T>
    implements ITransactionTyped<T> {
        private IBaseBundle myBaseBundle;
        private Bundle myBundle;
        private String myRawBundle;
        private EncodingEnum myRawBundleEncoding;
        private List<? extends IBaseResource> myResources;

        public TransactionExecutable(Bundle theResources) {
            this.myBundle = theResources;
        }

        public TransactionExecutable(IBaseBundle theBundle) {
            this.myBaseBundle = theBundle;
        }

        public TransactionExecutable(List<? extends IBaseResource> theResources) {
            this.myResources = theResources;
        }

        public TransactionExecutable(String theBundle) {
            this.myRawBundle = theBundle;
            this.myRawBundleEncoding = MethodUtil.detectEncodingNoDefault(this.myRawBundle);
            if (this.myRawBundleEncoding == null) {
                throw new IllegalArgumentException("Can not determine encoding of raw resource body");
            }
        }

        @Override
        public T execute() {
            HashMap<String, List<String>> params = new HashMap<String, List<String>>();
            if (this.myResources != null) {
                ResourceListResponseHandler binding = new ResourceListResponseHandler(null);
                BaseHttpClientInvocation invocation = TransactionMethodBinding.createTransactionInvocation(this.myResources, GenericClient.this.myContext);
                return (T)this.invoke(params, binding, invocation);
            }
            if (this.myBaseBundle != null) {
                BaseClient.ResourceResponseHandler binding = new BaseClient.ResourceResponseHandler(this.myBaseBundle.getClass(), null);
                BaseHttpClientInvocation invocation = TransactionMethodBinding.createTransactionInvocation(this.myBaseBundle, GenericClient.this.myContext);
                return (T)this.invoke(params, binding, invocation);
            }
            if (this.myRawBundle != null) {
                StringResponseHandler binding = new StringResponseHandler();
                if (this.getParamEncoding() != null && MethodUtil.detectEncodingNoDefault(this.myRawBundle) != this.getParamEncoding()) {
                    IBaseResource parsed = this.parseResourceBody(this.myRawBundle);
                    this.myRawBundle = this.getParamEncoding().newParser(GenericClient.this.getFhirContext()).encodeResourceToString(parsed);
                }
                BaseHttpClientInvocation invocation = TransactionMethodBinding.createTransactionInvocation(this.myRawBundle, GenericClient.this.myContext);
                return (T)this.invoke(params, binding, invocation);
            }
            BundleResponseHandler binding = new BundleResponseHandler(null);
            BaseHttpClientInvocation invocation = TransactionMethodBinding.createTransactionInvocation(this.myBundle, GenericClient.this.myContext);
            return (T)this.invoke(params, binding, invocation);
        }
    }

    private final class TagListResponseHandler
    implements IClientResponseHandler<TagList> {
        private TagListResponseHandler() {
        }

        @Override
        public TagList invokeClient(String theResponseMimeType, Reader theResponseReader, int theResponseStatusCode, Map<String, List<String>> theHeaders) throws BaseServerResponseException {
            EncodingEnum respType = EncodingEnum.forContentType(theResponseMimeType);
            if (respType == null) {
                throw NonFhirResponseException.newInstance(theResponseStatusCode, theResponseMimeType, theResponseReader);
            }
            IParser parser = respType.newParser(GenericClient.this.myContext);
            return parser.parseTagList(theResponseReader);
        }
    }

    private final class StringResponseHandler
    implements IClientResponseHandler<String> {
        private StringResponseHandler() {
        }

        @Override
        public String invokeClient(String theResponseMimeType, Reader theResponseReader, int theResponseStatusCode, Map<String, List<String>> theHeaders) throws IOException, BaseServerResponseException {
            return IOUtils.toString((Reader)theResponseReader);
        }
    }

    private static class SortInternal
    implements ISort {
        private SearchInternal myFor;
        private String myParamName;
        private String myParamValue;

        public SortInternal(SearchInternal theFor) {
            this.myFor = theFor;
        }

        public IQuery ascending(IParam theParam) {
            this.myParamName = "_sort:asc";
            this.myParamValue = theParam.getParamName();
            return this.myFor;
        }

        public IQuery defaultOrder(IParam theParam) {
            this.myParamName = "_sort";
            this.myParamValue = theParam.getParamName();
            return this.myFor;
        }

        public IQuery descending(IParam theParam) {
            this.myParamName = "_sort:desc";
            this.myParamValue = theParam.getParamName();
            return this.myFor;
        }

        public String getParamName() {
            return this.myParamName;
        }

        public String getParamValue() {
            return this.myParamValue;
        }
    }

    private class SearchInternal
    extends BaseClientExecutable<IQuery<Object>, Object>
    implements IQuery<Object>,
    IUntypedQuery {
        private String myCompartmentName;
        private CriterionList myCriterion;
        private List<Include> myInclude;
        private DateRangeParam myLastUpdated;
        private Integer myParamLimit;
        private List<String> myProfile;
        private String myResourceId;
        private String myResourceName;
        private Class<? extends IBaseResource> myResourceType;
        private Class<? extends IBaseBundle> myReturnBundleType;
        private List<Include> myRevInclude;
        private SearchStyleEnum mySearchStyle;
        private List<TokenParam> mySecurity;
        private List<SortInternal> mySort;
        private List<TokenParam> myTags;
        private String mySearchUrl;

        public SearchInternal() {
            this.myCriterion = new CriterionList();
            this.myInclude = new ArrayList<Include>();
            this.myProfile = new ArrayList<String>();
            this.myRevInclude = new ArrayList<Include>();
            this.mySecurity = new ArrayList<TokenParam>();
            this.mySort = new ArrayList<SortInternal>();
            this.myTags = new ArrayList<TokenParam>();
            this.myResourceType = null;
            this.myResourceName = null;
            this.mySearchUrl = null;
        }

        @Override
        public IQuery and(ICriterion<?> theCriterion) {
            this.myCriterion.add((ICriterionInternal)((Object)theCriterion));
            return this;
        }

        @Override
        public IBase execute() {
            LinkedHashMap<String, List<String>> params = new LinkedHashMap<String, List<String>>();
            this.myCriterion.populateParamList(params);
            for (TokenParam tokenParam : this.myTags) {
                GenericClient.addParam(params, "_tag", tokenParam.getValueAsQueryToken());
            }
            for (TokenParam tokenParam : this.mySecurity) {
                GenericClient.addParam(params, "_security", tokenParam.getValueAsQueryToken());
            }
            for (String string : this.myProfile) {
                GenericClient.addParam(params, "_profile", string);
            }
            for (Include include : this.myInclude) {
                if (include.isRecurse()) {
                    GenericClient.addParam(params, "_include:recurse", include.getValue());
                    continue;
                }
                GenericClient.addParam(params, "_include", include.getValue());
            }
            for (Include include : this.myRevInclude) {
                GenericClient.addParam(params, "_revinclude", include.getValue());
            }
            for (SortInternal sortInternal : this.mySort) {
                GenericClient.addParam(params, sortInternal.getParamName(), sortInternal.getParamValue());
            }
            if (this.myParamLimit != null) {
                GenericClient.addParam(params, "_count", Integer.toString(this.myParamLimit));
            }
            if (this.myLastUpdated != null) {
                for (DateParam dateParam : this.myLastUpdated.getValuesAsQueryTokens()) {
                    GenericClient.addParam(params, "_lastUpdated", dateParam.getValueAsQueryToken());
                }
            }
            if (this.myReturnBundleType == null && GenericClient.this.myContext.getVersion().getVersion().equals((Object)FhirVersionEnum.DSTU2_HL7ORG)) {
                throw new IllegalArgumentException("When using the client with HL7.org structures, you must specify the bundle return type for the client by adding \".returnBundle(org.hl7.fhir.instance.model.Bundle.class)\" to your search method call before the \".execute()\" method");
            }
            IClientResponseHandler<Bundle> binding = this.myReturnBundleType != null ? new BaseClient.ResourceResponseHandler<IBaseBundle>(this.myReturnBundleType, null) : new BundleResponseHandler(this.myResourceType);
            IdDt idDt = this.myResourceId != null ? new IdDt(this.myResourceId) : null;
            BaseHttpClientInvocation invocation = this.mySearchUrl != null ? SearchMethodBinding.createSearchInvocation(this.mySearchUrl, params) : SearchMethodBinding.createSearchInvocation(GenericClient.this.myContext, this.myResourceName, params, idDt, this.myCompartmentName, this.mySearchStyle);
            return this.invoke(params, binding, invocation);
        }

        public IQuery forAllResources() {
            return this;
        }

        public IQuery forResource(Class<? extends IBaseResource> theResourceType) {
            this.setType(theResourceType);
            return this;
        }

        public IQuery forResource(String theResourceName) {
            this.setType(theResourceName);
            return this;
        }

        @Override
        public IQuery include(Include theInclude) {
            this.myInclude.add(theInclude);
            return this;
        }

        @Override
        public IQuery lastUpdated(DateRangeParam theLastUpdated) {
            this.myLastUpdated = theLastUpdated;
            return this;
        }

        @Override
        public IQuery limitTo(int theLimitTo) {
            this.myParamLimit = theLimitTo > 0 ? Integer.valueOf(theLimitTo) : null;
            return this;
        }

        @Override
        public IQuery returnBundle(Class theClass) {
            if (theClass == null) {
                throw new NullPointerException("theClass must not be null");
            }
            this.myReturnBundleType = theClass;
            return this;
        }

        @Override
        public IQuery revInclude(Include theInclude) {
            this.myRevInclude.add(theInclude);
            return this;
        }

        private void setType(Class<? extends IBaseResource> theResourceType) {
            this.myResourceType = theResourceType;
            RuntimeResourceDefinition definition = GenericClient.this.myContext.getResourceDefinition(theResourceType);
            this.myResourceName = definition.getName();
        }

        private void setType(String theResourceName) {
            this.myResourceType = GenericClient.this.myContext.getResourceDefinition(theResourceName).getImplementingClass();
            this.myResourceName = theResourceName;
        }

        @Override
        public ISort sort() {
            SortInternal retVal = new SortInternal(this);
            this.mySort.add(retVal);
            return retVal;
        }

        @Override
        public IQuery usingStyle(SearchStyleEnum theStyle) {
            this.mySearchStyle = theStyle;
            return this;
        }

        @Override
        public IQuery where(ICriterion<?> theCriterion) {
            this.myCriterion.add((ICriterionInternal)((Object)theCriterion));
            return this;
        }

        @Override
        public IQuery withIdAndCompartment(String theResourceId, String theCompartmentName) {
            this.myResourceId = theResourceId;
            this.myCompartmentName = theCompartmentName;
            return this;
        }

        @Override
        public IQuery<Object> withProfile(String theProfileUri) {
            Validate.notBlank((CharSequence)theProfileUri, (String)"theProfileUri must not be null or empty", (Object[])new Object[0]);
            this.myProfile.add(theProfileUri);
            return this;
        }

        @Override
        public IQuery<Object> withSecurity(String theSystem, String theCode) {
            Validate.notBlank((CharSequence)theCode, (String)"theCode must not be null or empty", (Object[])new Object[0]);
            this.mySecurity.add(new TokenParam(theSystem, theCode));
            return this;
        }

        @Override
        public IQuery<Object> withTag(String theSystem, String theCode) {
            Validate.notBlank((CharSequence)theCode, (String)"theCode must not be null or empty", (Object[])new Object[0]);
            this.myTags.add(new TokenParam(theSystem, theCode));
            return this;
        }

        public IQuery byUrl(String theSearchUrl) {
            Validate.notBlank((CharSequence)theSearchUrl, (String)"theSearchUrl must not be blank/null", (Object[])new Object[0]);
            if (theSearchUrl.startsWith("http://") || theSearchUrl.startsWith("https://")) {
                this.mySearchUrl = theSearchUrl;
                int qIndex = this.mySearchUrl.indexOf(63);
                if (qIndex != -1) {
                    this.mySearchUrl = this.mySearchUrl.substring(0, qIndex) + GenericClient.validateAndEscapeConditionalUrl(this.mySearchUrl.substring(qIndex));
                }
            } else {
                String searchUrl = theSearchUrl;
                if (searchUrl.startsWith("/")) {
                    searchUrl = searchUrl.substring(1);
                }
                if (!searchUrl.matches("[a-zA-Z]+($|\\?.*)")) {
                    throw new IllegalArgumentException("Search URL must be either a complete URL starting with http: or https:, or a relative FHIR URL in the form [ResourceType]?[Params]");
                }
                int qIndex = searchUrl.indexOf(63);
                this.mySearchUrl = qIndex == -1 ? GenericClient.this.getUrlBase() + '/' + searchUrl : GenericClient.this.getUrlBase() + '/' + GenericClient.validateAndEscapeConditionalUrl(searchUrl);
            }
            return this;
        }
    }

    private final class ResourceListResponseHandler
    implements IClientResponseHandler<List<IBaseResource>> {
        private Class<? extends IResource> myType;

        public ResourceListResponseHandler(Class<? extends IResource> theType) {
            this.myType = theType;
        }

        @Override
        public List<IBaseResource> invokeClient(String theResponseMimeType, Reader theResponseReader, int theResponseStatusCode, Map<String, List<String>> theHeaders) throws BaseServerResponseException {
            if (GenericClient.this.myContext.getVersion().getVersion().isNewerThan(FhirVersionEnum.DSTU1)) {
                Class bundleType = GenericClient.this.myContext.getResourceDefinition("Bundle").getImplementingClass();
                BaseClient.ResourceResponseHandler handler = new BaseClient.ResourceResponseHandler(bundleType, null);
                Object response = handler.invokeClient(theResponseMimeType, theResponseReader, theResponseStatusCode, (Map)theHeaders);
                IVersionSpecificBundleFactory bundleFactory = GenericClient.this.myContext.newBundleFactory();
                bundleFactory.initializeWithBundleResource((IBaseResource)response);
                return bundleFactory.toListOfResources();
            }
            return new ArrayList<IBaseResource>(((Bundle)new BundleResponseHandler(this.myType).invokeClient(theResponseMimeType, theResponseReader, theResponseStatusCode, (Map)theHeaders)).toListOfResources());
        }
    }

    private class ReadInternal
    extends BaseClientExecutable
    implements IRead,
    IReadTyped,
    IReadExecutable {
        private IIdType myId;
        private String myIfVersionMatches;
        private ICallable myNotModifiedHandler;
        private RuntimeResourceDefinition myType;

        private ReadInternal() {
        }

        @Override
        public Object execute() {
            if (this.myId.hasVersionIdPart()) {
                return GenericClient.this.doReadOrVRead(this.myType.getImplementingClass(), this.myId, true, this.myNotModifiedHandler, this.myIfVersionMatches, this.myPrettyPrint, this.mySummaryMode, this.myParamEncoding, this.getSubsetElements());
            }
            return GenericClient.this.doReadOrVRead(this.myType.getImplementingClass(), this.myId, false, this.myNotModifiedHandler, this.myIfVersionMatches, this.myPrettyPrint, this.mySummaryMode, this.myParamEncoding, this.getSubsetElements());
        }

        public IReadIfNoneMatch ifVersionMatches(String theVersion) {
            this.myIfVersionMatches = theVersion;
            return new IReadIfNoneMatch(){

                public IReadExecutable returnNull() {
                    ReadInternal.this.myNotModifiedHandler = new ICallable(){

                        public Object call() {
                            return null;
                        }
                    };
                    return ReadInternal.this;
                }

                public IReadExecutable returnResource(final IBaseResource theInstance) {
                    ReadInternal.this.myNotModifiedHandler = new ICallable(){

                        public Object call() {
                            return theInstance;
                        }
                    };
                    return ReadInternal.this;
                }

                public IReadExecutable throwNotModifiedException() {
                    ReadInternal.this.myNotModifiedHandler = null;
                    return ReadInternal.this;
                }
            };
        }

        private void processUrl() {
            String resourceType = this.myId.getResourceType();
            if (StringUtils.isBlank((CharSequence)resourceType)) {
                throw new IllegalArgumentException(GenericClient.this.myContext.getLocalizer().getMessage(GenericClient.I18N_INCOMPLETE_URI_FOR_READ, this.myId));
            }
            this.myType = GenericClient.this.myContext.getResourceDefinition(resourceType);
            if (this.myType == null) {
                throw new IllegalArgumentException(GenericClient.this.myContext.getLocalizer().getMessage(GenericClient.I18N_CANNOT_DETEMINE_RESOURCE_TYPE, this.myId));
            }
        }

        @Override
        public <T extends IBaseResource> IReadTyped<T> resource(Class<T> theResourceType) {
            Validate.notNull(theResourceType, (String)"theResourceType must not be null", (Object[])new Object[0]);
            this.myType = GenericClient.this.myContext.getResourceDefinition(theResourceType);
            if (this.myType == null) {
                throw new IllegalArgumentException(GenericClient.this.myContext.getLocalizer().getMessage(GenericClient.I18N_CANNOT_DETEMINE_RESOURCE_TYPE, theResourceType));
            }
            return this;
        }

        @Override
        public IReadTyped<IBaseResource> resource(String theResourceAsText) {
            Validate.notBlank((CharSequence)theResourceAsText, (String)"You must supply a value for theResourceAsText", (Object[])new Object[0]);
            this.myType = GenericClient.this.myContext.getResourceDefinition(theResourceAsText);
            if (this.myType == null) {
                throw new IllegalArgumentException(GenericClient.this.myContext.getLocalizer().getMessage(GenericClient.I18N_CANNOT_DETEMINE_RESOURCE_TYPE, theResourceAsText));
            }
            return this;
        }

        public IReadExecutable withId(IIdType theId) {
            Validate.notNull((Object)theId, (String)"The ID can not be null", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)theId.getIdPart(), (String)"The ID can not be blank", (Object[])new Object[0]);
            this.myId = theId.toUnqualified();
            return this;
        }

        public IReadExecutable withId(Long theId) {
            Validate.notNull((Object)theId, (String)"The ID can not be null", (Object[])new Object[0]);
            this.myId = new IdDt(this.myType.getName(), theId);
            return this;
        }

        public IReadExecutable withId(String theId) {
            Validate.notBlank((CharSequence)theId, (String)"The ID can not be blank", (Object[])new Object[0]);
            this.myId = new IdDt(this.myType.getName(), theId);
            return this;
        }

        public IReadExecutable withIdAndVersion(String theId, String theVersion) {
            Validate.notBlank((CharSequence)theId, (String)"The ID can not be blank", (Object[])new Object[0]);
            this.myId = new IdDt(this.myType.getName(), theId, theVersion);
            return this;
        }

        public IReadExecutable withUrl(IIdType theUrl) {
            Validate.notNull((Object)theUrl, (String)"theUrl can not be null", (Object[])new Object[0]);
            this.myId = theUrl;
            this.processUrl();
            return this;
        }

        public IReadExecutable withUrl(String theUrl) {
            this.myId = new IdDt(theUrl);
            this.processUrl();
            return this;
        }
    }

    private final class OutcomeResponseHandler
    implements IClientResponseHandler<MethodOutcome> {
        private final String myResourceName;

        private OutcomeResponseHandler(String theResourceName) {
            this.myResourceName = theResourceName;
        }

        @Override
        public MethodOutcome invokeClient(String theResponseMimeType, Reader theResponseReader, int theResponseStatusCode, Map<String, List<String>> theHeaders) throws BaseServerResponseException {
            MethodOutcome response = MethodUtil.process2xxResponse(GenericClient.this.myContext, this.myResourceName, theResponseStatusCode, theResponseMimeType, theResponseReader, theHeaders);
            if (theResponseStatusCode == 201) {
                response.setCreated(true);
            }
            return response;
        }
    }

    private final class OperationOutcomeResponseHandler
    implements IClientResponseHandler<BaseOperationOutcome> {
        private OperationOutcomeResponseHandler() {
        }

        @Override
        public BaseOperationOutcome invokeClient(String theResponseMimeType, Reader theResponseReader, int theResponseStatusCode, Map<String, List<String>> theHeaders) throws BaseServerResponseException {
            BaseOperationOutcome retVal;
            EncodingEnum respType = EncodingEnum.forContentType(theResponseMimeType);
            if (respType == null) {
                return null;
            }
            IParser parser = respType.newParser(GenericClient.this.myContext);
            try {
                retVal = (BaseOperationOutcome)parser.parseResource(theResponseReader);
            }
            catch (DataFormatException e) {
                ourLog.warn("Failed to parse OperationOutcome response", (Throwable)e);
                return null;
            }
            MethodUtil.parseClientRequestResourceHeaders(null, theHeaders, retVal);
            return retVal;
        }
    }

    private class OperationInternal
    extends BaseClientExecutable
    implements IOperation,
    IOperationUnnamed,
    IOperationUntyped,
    IOperationUntypedWithInput,
    IOperationUntypedWithInputAndPartialOutput {
        private IIdType myId;
        private String myOperationName;
        private IBaseParameters myParameters;
        private Class<? extends IBaseResource> myType;
        private boolean myUseHttpGet;
        private RuntimeResourceDefinition myParametersDef;

        private OperationInternal() {
        }

        @Override
        public Object execute() {
            String id;
            String resourceName;
            if (this.myType != null) {
                resourceName = GenericClient.this.myContext.getResourceDefinition(this.myType).getName();
                id = null;
            } else if (this.myId != null) {
                resourceName = this.myId.getResourceType();
                id = this.myId.getIdPart();
            } else {
                resourceName = null;
                id = null;
            }
            BaseHttpClientInvocation invocation = OperationMethodBinding.createOperationInvocation(GenericClient.this.myContext, resourceName, id, this.myOperationName, this.myParameters, this.myUseHttpGet);
            BaseClient.ResourceResponseHandler handler = new BaseClient.ResourceResponseHandler(null, null);
            Object retVal = this.invoke(null, handler, invocation);
            if (GenericClient.this.myContext.getResourceDefinition((IBaseResource)retVal).getName().equals("Parameters")) {
                return retVal;
            }
            RuntimeResourceDefinition def = GenericClient.this.myContext.getResourceDefinition("Parameters");
            IBaseResource parameters = (IBaseResource)def.newInstance();
            BaseRuntimeChildDefinition paramChild = def.getChildByName("parameter");
            BaseRuntimeElementCompositeDefinition paramChildElem = (BaseRuntimeElementCompositeDefinition)paramChild.getChildByName("parameter");
            Object parameter = paramChildElem.newInstance();
            paramChild.getMutator().addValue(parameters, (IBase)parameter);
            BaseRuntimeChildDefinition resourceElem = paramChildElem.getChildByName("resource");
            resourceElem.getMutator().addValue(parameter, (IBase)retVal);
            return parameters;
        }

        @Override
        public IOperationUntyped named(String theName) {
            Validate.notBlank((CharSequence)theName, (String)"theName can not be null", (Object[])new Object[0]);
            this.myOperationName = theName;
            return this;
        }

        @Override
        public IOperationUnnamed onInstance(IIdType theId) {
            this.myId = theId;
            return this;
        }

        @Override
        public IOperationUnnamed onServer() {
            return this;
        }

        @Override
        public IOperationUnnamed onType(Class<? extends IBaseResource> theResourceType) {
            this.myType = theResourceType;
            return this;
        }

        @Override
        public IOperationUntypedWithInput useHttpGet() {
            this.myUseHttpGet = true;
            return this;
        }

        @Override
        public <T extends IBaseParameters> IOperationUntypedWithInput<T> withNoParameters(Class<T> theOutputParameterType) {
            Validate.notNull(theOutputParameterType, (String)"theOutputParameterType may not be null", (Object[])new Object[0]);
            RuntimeResourceDefinition def = GenericClient.this.myContext.getResourceDefinition(theOutputParameterType);
            if (def == null) {
                throw new IllegalArgumentException("theOutputParameterType must refer to a HAPI FHIR Resource type: " + theOutputParameterType.getName());
            }
            if (!"Parameters".equals(def.getName())) {
                throw new IllegalArgumentException("theOutputParameterType must refer to a HAPI FHIR Resource type for a resource named Parameters - " + theOutputParameterType.getName() + " is a resource named: " + def.getName());
            }
            this.myParameters = (IBaseParameters)((IBaseResource)def.newInstance());
            return this;
        }

        public IOperationUntypedWithInput withParameters(IBaseParameters theParameters) {
            Validate.notNull((Object)theParameters, (String)"theParameters can not be null", (Object[])new Object[0]);
            this.myParameters = theParameters;
            return this;
        }

        @Override
        public <T extends IBaseParameters> IOperationUntypedWithInputAndPartialOutput<T> withParameter(Class<T> theParameterType, String theName, IBase theValue) {
            Validate.notNull(theParameterType, (String)"theParameterType must not be null", (Object[])new Object[0]);
            Validate.notEmpty((CharSequence)theName, (String)"theName must not be null", (Object[])new Object[0]);
            Validate.notNull((Object)theValue, (String)"theValue must not be null", (Object[])new Object[0]);
            this.myParametersDef = GenericClient.this.myContext.getResourceDefinition(theParameterType);
            this.myParameters = (IBaseParameters)((IBaseResource)this.myParametersDef.newInstance());
            this.addParam(theName, theValue);
            return this;
        }

        private void addParam(String theName, IBase theValue) {
            BaseRuntimeChildDefinition parameterChild = this.myParametersDef.getChildByName("parameter");
            BaseRuntimeElementCompositeDefinition parameterElem = (BaseRuntimeElementCompositeDefinition)parameterChild.getChildByName("parameter");
            Object parameter = parameterElem.newInstance();
            parameterChild.getMutator().addValue(this.myParameters, (IBase)parameter);
            IPrimitiveType name = (IPrimitiveType)GenericClient.this.myContext.getElementDefinition("string").newInstance();
            name.setValue(theName);
            parameterElem.getChildByName("name").getMutator().setValue(parameter, name);
            if (theValue instanceof IBaseDatatype) {
                Class<? extends IBaseDatatype> profileOf;
                BaseRuntimeElementDefinition<?> datatypeDef = GenericClient.this.myContext.getElementDefinition(theValue.getClass());
                if (datatypeDef instanceof IRuntimeDatatypeDefinition && (profileOf = ((IRuntimeDatatypeDefinition)((Object)datatypeDef)).getProfileOf()) != null) {
                    datatypeDef = GenericClient.this.myContext.getElementDefinition(profileOf);
                }
                String childElementName = "value" + StringUtils.capitalize((String)datatypeDef.getName());
                BaseRuntimeChildDefinition childByName = parameterElem.getChildByName(childElementName);
                childByName.getMutator().setValue(parameter, theValue);
            } else if (theValue instanceof IBaseResource) {
                parameterElem.getChildByName("resource").getMutator().setValue(parameter, theValue);
            } else {
                throw new IllegalArgumentException("Don't know how to handle parameter of type " + theValue.getClass());
            }
        }

        public IOperationUntypedWithInputAndPartialOutput andParameter(String theName, IBase theValue) {
            Validate.notEmpty((CharSequence)theName, (String)"theName must not be null", (Object[])new Object[0]);
            Validate.notNull((Object)theValue, (String)"theValue must not be null", (Object[])new Object[0]);
            this.addParam(theName, theValue);
            return this;
        }
    }

    private final class MetaParametersResponseHandler<T extends IBaseMetaType>
    implements IClientResponseHandler<T> {
        private Class<T> myType;

        public MetaParametersResponseHandler(Class<T> theMetaType) {
            this.myType = theMetaType;
        }

        @Override
        public T invokeClient(String theResponseMimeType, Reader theResponseReader, int theResponseStatusCode, Map<String, List<String>> theHeaders) throws BaseServerResponseException {
            EncodingEnum respType = EncodingEnum.forContentType(theResponseMimeType);
            if (respType == null) {
                throw NonFhirResponseException.newInstance(theResponseStatusCode, theResponseMimeType, theResponseReader);
            }
            IParser parser = respType.newParser(GenericClient.this.myContext);
            RuntimeResourceDefinition type = GenericClient.this.myContext.getResourceDefinition("Parameters");
            Object retVal = parser.parseResource(type.getImplementingClass(), theResponseReader);
            BaseRuntimeChildDefinition paramChild = type.getChildByName("parameter");
            BaseRuntimeElementCompositeDefinition paramChildElem = (BaseRuntimeElementCompositeDefinition)paramChild.getChildByName("parameter");
            List<IBase> parameter = paramChild.getAccessor().getValues(retVal);
            if (parameter == null || parameter.isEmpty()) {
                return (T)((IBaseMetaType)GenericClient.this.myContext.getElementDefinition(this.myType).newInstance());
            }
            IBase param = parameter.get(0);
            List<IBase> meta = paramChildElem.getChildByName("value[x]").getAccessor().getValues(param);
            if (meta.isEmpty()) {
                return (T)((IBaseMetaType)GenericClient.this.myContext.getElementDefinition(this.myType).newInstance());
            }
            return (T)((IBaseMetaType)meta.get(0));
        }
    }

    private static enum MetaOperation {
        ADD,
        DELETE,
        GET;

    }

    private class MetaInternal
    extends BaseClientExecutable
    implements IMeta,
    IMetaAddOrDeleteUnsourced,
    IMetaGetUnsourced,
    IMetaAddOrDeleteSourced {
        private IIdType myId;
        private IBaseMetaType myMeta;
        private Class<? extends IBaseMetaType> myMetaType;
        private String myOnType;
        private MetaOperation myOperation;

        private MetaInternal() {
        }

        @Override
        public IMetaAddOrDeleteUnsourced add() {
            this.myOperation = MetaOperation.ADD;
            return this;
        }

        @Override
        public IMetaAddOrDeleteUnsourced delete() {
            this.myOperation = MetaOperation.DELETE;
            return this;
        }

        @Override
        public Object execute() {
            BaseHttpClientInvocation invocation = null;
            IBaseParameters parameters = ParametersUtil.newInstance(GenericClient.this.myContext);
            switch (this.myOperation) {
                case ADD: {
                    ParametersUtil.addParameterToParameters(GenericClient.this.myContext, parameters, this.myMeta, "meta");
                    invocation = OperationMethodBinding.createOperationInvocation(GenericClient.this.myContext, this.myId.getResourceType(), this.myId.getIdPart(), "$meta-add", parameters, false);
                    break;
                }
                case DELETE: {
                    ParametersUtil.addParameterToParameters(GenericClient.this.myContext, parameters, this.myMeta, "meta");
                    invocation = OperationMethodBinding.createOperationInvocation(GenericClient.this.myContext, this.myId.getResourceType(), this.myId.getIdPart(), "$meta-delete", parameters, false);
                    break;
                }
                case GET: {
                    invocation = this.myId != null ? OperationMethodBinding.createOperationInvocation(GenericClient.this.myContext, this.myOnType, this.myId.getIdPart(), "$meta", parameters, true) : (this.myOnType != null ? OperationMethodBinding.createOperationInvocation(GenericClient.this.myContext, this.myOnType, null, "$meta", parameters, true) : OperationMethodBinding.createOperationInvocation(GenericClient.this.myContext, null, null, "$meta", parameters, true));
                }
            }
            if (invocation == null) {
                throw new IllegalStateException();
            }
            MetaParametersResponseHandler<? extends IBaseMetaType> handler = new MetaParametersResponseHandler<IBaseMetaType>(this.myMetaType);
            return this.invoke(null, handler, invocation);
        }

        public IClientExecutable fromResource(IIdType theId) {
            this.setIdInternal(theId);
            return this;
        }

        public IClientExecutable fromServer() {
            return this;
        }

        public IClientExecutable fromType(String theResourceName) {
            Validate.notBlank((CharSequence)theResourceName, (String)"theResourceName must not be blank", (Object[])new Object[0]);
            this.myOnType = theResourceName;
            return this;
        }

        @Override
        public <T extends IBaseMetaType> IMetaGetUnsourced<T> get(Class<T> theType) {
            this.myMetaType = theType;
            this.myOperation = MetaOperation.GET;
            return this;
        }

        @Override
        public <T extends IBaseMetaType> IClientExecutable<IClientExecutable<?, ?>, T> meta(T theMeta) {
            Validate.notNull(theMeta, (String)"theMeta must not be null", (Object[])new Object[0]);
            this.myMeta = theMeta;
            this.myMetaType = this.myMeta.getClass();
            return this;
        }

        @Override
        public IMetaAddOrDeleteSourced onResource(IIdType theId) {
            this.setIdInternal(theId);
            return this;
        }

        private void setIdInternal(IIdType theId) {
            Validate.notBlank((CharSequence)theId.getResourceType(), (String)"theId must contain a resource type", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)theId.getIdPart(), (String)"theId must contain an ID part", (Object[])new Object[0]);
            this.myOnType = theId.getResourceType();
            this.myId = theId;
        }
    }

    private final class LoadPageInternal
    implements IGetPage,
    IGetPageUntyped {
        private static final String PREV = "prev";
        private static final String PREVIOUS = "previous";
        private String myPageUrl;

        private LoadPageInternal() {
        }

        public <T extends IBaseBundle> IGetPageTyped andReturnBundle(Class<T> theBundleType) {
            Validate.notNull(theBundleType, (String)"theBundleType must not be null", (Object[])new Object[0]);
            return new GetPageInternal(this.myPageUrl, theBundleType);
        }

        public IGetPageTyped andReturnDstu1Bundle() {
            return new GetPageInternal(this.myPageUrl);
        }

        @Override
        public IGetPageUntyped byUrl(String thePageUrl) {
            if (StringUtils.isBlank((CharSequence)thePageUrl)) {
                throw new IllegalArgumentException("thePagingUrl must not be blank or null");
            }
            this.myPageUrl = thePageUrl;
            return this;
        }

        public IGetPageTyped next(Bundle theBundle) {
            return new GetPageInternal((String)theBundle.getLinkNext().getValue());
        }

        @Override
        public <T extends IBaseBundle> IGetPageTyped<T> next(T theBundle) {
            return this.nextOrPrevious("next", theBundle);
        }

        private <T extends IBaseBundle> IGetPageTyped<T> nextOrPrevious(String theWantRel, T theBundle) {
            RuntimeResourceDefinition def = GenericClient.this.myContext.getResourceDefinition(theBundle);
            List<IBase> links = def.getChildByName("link").getAccessor().getValues(theBundle);
            if (links == null || links.isEmpty()) {
                throw new IllegalArgumentException(GenericClient.this.myContext.getLocalizer().getMessage(GenericClient.class, "noPagingLinkFoundInBundle", theWantRel));
            }
            for (IBase nextLink : links) {
                String url;
                List<IBase> urls;
                String relation;
                BaseRuntimeElementCompositeDefinition linkDef = (BaseRuntimeElementCompositeDefinition)GenericClient.this.myContext.getElementDefinition(nextLink.getClass());
                List<IBase> rel = linkDef.getChildByName("relation").getAccessor().getValues(nextLink);
                if (rel == null || rel.isEmpty() || !theWantRel.equals(relation = ((IPrimitiveType)rel.get(0)).getValueAsString()) && (theWantRel != PREVIOUS || !PREV.equals(relation)) || (urls = linkDef.getChildByName("url").getAccessor().getValues(nextLink)) == null || urls.isEmpty() || StringUtils.isBlank((CharSequence)(url = ((IPrimitiveType)urls.get(0)).getValueAsString()))) continue;
                return this.byUrl(url).andReturnBundle(theBundle.getClass());
            }
            throw new IllegalArgumentException(GenericClient.this.myContext.getLocalizer().getMessage(GenericClient.class, "noPagingLinkFoundInBundle", theWantRel));
        }

        public IGetPageTyped previous(Bundle theBundle) {
            return new GetPageInternal((String)theBundle.getLinkPrevious().getValue());
        }

        @Override
        public <T extends IBaseBundle> IGetPageTyped<T> previous(T theBundle) {
            return this.nextOrPrevious(PREVIOUS, theBundle);
        }

        public IGetPageTyped url(String thePageUrl) {
            return new GetPageInternal(thePageUrl);
        }
    }

    private class HistoryInternal
    extends BaseClientExecutable
    implements IHistory,
    IHistoryUntyped,
    IHistoryTyped {
        private Integer myCount;
        private IIdType myId;
        private Class<? extends IBaseBundle> myReturnType;
        private InstantDt mySince;
        private Class<? extends IBaseResource> myType;

        private HistoryInternal() {
        }

        public IHistoryTyped andReturnBundle(Class theType) {
            this.myReturnType = theType;
            return this;
        }

        public IHistoryTyped andReturnDstu1Bundle() {
            return this;
        }

        public IHistoryTyped count(Integer theCount) {
            this.myCount = theCount;
            return this;
        }

        @Override
        public Object execute() {
            String id;
            String resourceName;
            if (this.myType != null) {
                resourceName = GenericClient.this.myContext.getResourceDefinition(this.myType).getName();
                id = null;
            } else if (this.myId != null) {
                resourceName = this.myId.getResourceType();
                id = this.myId.getIdPart();
            } else {
                resourceName = null;
                id = null;
            }
            HttpGetClientInvocation invocation = HistoryMethodBinding.createHistoryInvocation(resourceName, id, this.mySince, this.myCount);
            IClientResponseHandler<Bundle> handler = this.myReturnType != null ? new BaseClient.ResourceResponseHandler<IBaseBundle>(this.myReturnType, null) : new BundleResponseHandler(null);
            return this.invoke(null, handler, invocation);
        }

        @Override
        public IHistoryUntyped onInstance(IIdType theId) {
            if (!theId.hasResourceType()) {
                throw new IllegalArgumentException("Resource ID does not have a resource type: " + theId.getValue());
            }
            this.myId = theId;
            return this;
        }

        @Override
        public IHistoryUntyped onServer() {
            return this;
        }

        @Override
        public IHistoryUntyped onType(Class<? extends IBaseResource> theResourceType) {
            this.myType = theResourceType;
            return this;
        }

        public IHistoryTyped since(Date theCutoff) {
            this.mySince = theCutoff != null ? new InstantDt(theCutoff) : null;
            return this;
        }

        public IHistoryTyped since(InstantDt theCutoff) {
            this.mySince = theCutoff;
            return this;
        }
    }

    private class GetTagsInternal
    extends BaseClientExecutable<IGetTags, TagList>
    implements IGetTags {
        private String myId;
        private String myResourceName;
        private String myVersionId;

        private GetTagsInternal() {
        }

        @Override
        public TagList execute() {
            LinkedHashMap<String, List<String>> params = new LinkedHashMap<String, List<String>>();
            Map<String, List<String>> initial = GenericClient.this.createExtraParams();
            if (initial != null) {
                params.putAll(initial);
            }
            TagListResponseHandler binding = new TagListResponseHandler();
            ArrayList<String> urlFragments = new ArrayList<String>();
            if (StringUtils.isNotBlank((CharSequence)this.myResourceName)) {
                urlFragments.add(this.myResourceName);
                if (StringUtils.isNotBlank((CharSequence)this.myId)) {
                    urlFragments.add(this.myId);
                    if (StringUtils.isNotBlank((CharSequence)this.myVersionId)) {
                        urlFragments.add("_history");
                        urlFragments.add(this.myVersionId);
                    }
                }
            }
            urlFragments.add("_tags");
            HttpGetClientInvocation invocation = new HttpGetClientInvocation(params, urlFragments);
            return this.invoke(params, binding, invocation);
        }

        @Override
        public IGetTags forResource(Class<? extends IResource> theClass) {
            this.setResourceClass(theClass);
            return this;
        }

        @Override
        public IGetTags forResource(Class<? extends IResource> theClass, String theId) {
            this.setResourceClass(theClass);
            this.myId = theId;
            return this;
        }

        @Override
        public IGetTags forResource(Class<? extends IResource> theClass, String theId, String theVersionId) {
            this.setResourceClass(theClass);
            this.myId = theId;
            this.myVersionId = theVersionId;
            return this;
        }

        private void setResourceClass(Class<? extends IResource> theClass) {
            this.myResourceName = theClass != null ? GenericClient.this.myContext.getResourceDefinition(theClass).getName() : null;
        }
    }

    private class GetPageInternal
    extends BaseClientExecutable<IGetPageTyped<Object>, Object>
    implements IGetPageTyped<Object> {
        private Class<? extends IBaseBundle> myBundleType;
        private String myUrl;

        public GetPageInternal(String theUrl) {
            this.myUrl = theUrl;
        }

        public GetPageInternal(String theUrl, Class<? extends IBaseBundle> theBundleType) {
            this.myUrl = theUrl;
            this.myBundleType = theBundleType;
        }

        @Override
        public Object execute() {
            IClientResponseHandler<Bundle> binding = this.myBundleType == null ? new BundleResponseHandler(null) : new BaseClient.ResourceResponseHandler<IBaseBundle>(this.myBundleType, null);
            HttpSimpleGetClientInvocation invocation = new HttpSimpleGetClientInvocation(this.myUrl);
            Map<String, List<String>> params = null;
            return this.invoke(params, binding, invocation);
        }
    }

    private class FetchConformanceInternal
    extends BaseClientExecutable
    implements IFetchConformanceUntyped,
    IFetchConformanceTyped {
        private RuntimeResourceDefinition myType;

        private FetchConformanceInternal() {
        }

        @Override
        public Object execute() {
            BaseClient.ResourceResponseHandler binding = new BaseClient.ResourceResponseHandler(this.myType.getImplementingClass(), null);
            HttpGetClientInvocation invocation = MethodUtil.createConformanceInvocation();
            return super.invoke(null, binding, invocation);
        }

        @Override
        public <T extends IBaseConformance> IFetchConformanceTyped<T> ofType(Class<T> theResourceType) {
            Validate.notNull(theResourceType, (String)"theResourceType must not be null", (Object[])new Object[0]);
            this.myType = GenericClient.this.myContext.getResourceDefinition(theResourceType);
            if (this.myType == null) {
                throw new IllegalArgumentException(GenericClient.this.myContext.getLocalizer().getMessage(GenericClient.I18N_CANNOT_DETEMINE_RESOURCE_TYPE, theResourceType));
            }
            return this;
        }
    }

    private class DeleteInternal
    extends BaseClientExecutable<IDeleteTyped, BaseOperationOutcome>
    implements IDelete,
    IDeleteTyped,
    IDeleteWithQuery,
    IDeleteWithQueryTyped {
        private CriterionList myCriterionList;
        private IIdType myId;
        private String myResourceType;
        private String mySearchUrl;

        private DeleteInternal() {
        }

        @Override
        public IDeleteWithQueryTyped and(ICriterion<?> theCriterion) {
            this.myCriterionList.add((ICriterionInternal)((Object)theCriterion));
            return this;
        }

        @Override
        public BaseOperationOutcome execute() {
            HttpDeleteClientInvocation invocation;
            if (this.myId != null) {
                invocation = DeleteMethodBinding.createDeleteInvocation(this.myId);
            } else if (this.myCriterionList != null) {
                Map<String, List<String>> params = this.myCriterionList.toParamList();
                invocation = DeleteMethodBinding.createDeleteInvocation(this.myResourceType, params);
            } else {
                invocation = DeleteMethodBinding.createDeleteInvocation(this.mySearchUrl);
            }
            OperationOutcomeResponseHandler binding = new OperationOutcomeResponseHandler();
            HashMap<String, List<String>> params = new HashMap<String, List<String>>();
            return this.invoke(params, binding, invocation);
        }

        @Override
        public IDeleteTyped resource(IResource theResource) {
            Validate.notNull((Object)theResource, (String)"theResource can not be null", (Object[])new Object[0]);
            IdDt id = theResource.getId();
            Validate.notNull((Object)id, (String)"theResource.getId() can not be null", (Object[])new Object[0]);
            if (!id.hasResourceType() || !id.hasIdPart()) {
                throw new IllegalArgumentException("theResource.getId() must contain a resource type and logical ID at a minimum (e.g. Patient/1234), found: " + id.getValue());
            }
            this.myId = id;
            return this;
        }

        @Override
        public IDeleteTyped resourceById(IIdType theId) {
            Validate.notNull((Object)theId, (String)"theId can not be null", (Object[])new Object[0]);
            if (!theId.hasResourceType() || !theId.hasIdPart()) {
                throw new IllegalArgumentException("theId must contain a resource type and logical ID at a minimum (e.g. Patient/1234)found: " + theId.getValue());
            }
            this.myId = theId;
            return this;
        }

        @Override
        public IDeleteTyped resourceById(String theResourceType, String theLogicalId) {
            Validate.notBlank((CharSequence)theResourceType, (String)"theResourceType can not be blank/null", (Object[])new Object[0]);
            if (GenericClient.this.myContext.getResourceDefinition(theResourceType) == null) {
                throw new IllegalArgumentException("Unknown resource type");
            }
            Validate.notBlank((CharSequence)theLogicalId, (String)"theLogicalId can not be blank/null", (Object[])new Object[0]);
            if (theLogicalId.contains("/")) {
                throw new IllegalArgumentException("LogicalId can not contain '/' (should only be the logical ID portion, not a qualified ID)");
            }
            this.myId = new IdDt(theResourceType, theLogicalId);
            return this;
        }

        @Override
        public IDeleteWithQuery resourceConditionalByType(String theResourceType) {
            Validate.notBlank((CharSequence)theResourceType, (String)"theResourceType can not be blank/null", (Object[])new Object[0]);
            if (GenericClient.this.myContext.getResourceDefinition(theResourceType) == null) {
                throw new IllegalArgumentException("Unknown resource type: " + theResourceType);
            }
            this.myResourceType = theResourceType;
            this.myCriterionList = new CriterionList();
            return this;
        }

        @Override
        public IDeleteTyped resourceConditionalByUrl(String theSearchUrl) {
            this.mySearchUrl = GenericClient.validateAndEscapeConditionalUrl(theSearchUrl);
            return this;
        }

        @Override
        public IDeleteWithQueryTyped where(ICriterion<?> theCriterion) {
            this.myCriterionList.add((ICriterionInternal)((Object)theCriterion));
            return this;
        }

        @Override
        public IDeleteWithQuery resourceConditionalByType(Class<? extends IBaseResource> theResourceType) {
            Validate.notNull(theResourceType, (String)"theResourceType can not be null", (Object[])new Object[0]);
            this.myCriterionList = new CriterionList();
            this.myResourceType = GenericClient.this.myContext.getResourceDefinition(theResourceType).getName();
            return this;
        }
    }

    private static class CriterionList
    extends ArrayList<ICriterionInternal> {
        private static final long serialVersionUID = 1L;

        private CriterionList() {
        }

        public void populateParamList(Map<String, List<String>> theParams) {
            for (ICriterionInternal next : this) {
                String parameterName = next.getParameterName();
                String parameterValue = next.getParameterValue();
                GenericClient.addParam(theParams, parameterName, parameterValue);
            }
        }

        public Map<String, List<String>> toParamList() {
            LinkedHashMap<String, List<String>> retVal = new LinkedHashMap<String, List<String>>();
            this.populateParamList(retVal);
            return retVal;
        }
    }

    private class CreateInternal
    extends BaseClientExecutable<ICreateTyped, MethodOutcome>
    implements ICreate,
    ICreateTyped,
    ICreateWithQuery,
    ICreateWithQueryTyped {
        private CriterionList myCriterionList;
        private String myId;
        private PreferReturnEnum myPrefer;
        private IBaseResource myResource;
        private String myResourceBody;
        private String mySearchUrl;

        private CreateInternal() {
        }

        @Override
        public ICreateWithQueryTyped and(ICriterion<?> theCriterion) {
            this.myCriterionList.add((ICriterionInternal)((Object)theCriterion));
            return this;
        }

        @Override
        public ICreateWithQuery conditional() {
            this.myCriterionList = new CriterionList();
            return this;
        }

        @Override
        public ICreateTyped conditionalByUrl(String theSearchUrl) {
            this.mySearchUrl = GenericClient.validateAndEscapeConditionalUrl(theSearchUrl);
            return this;
        }

        @Override
        public MethodOutcome execute() {
            if (this.myResource == null) {
                this.myResource = this.parseResourceBody(this.myResourceBody);
            }
            this.myId = GenericClient.this.getPreferredId(this.myResource, this.myId);
            if (this.getParamEncoding() != null) {
                this.myResourceBody = null;
            }
            HttpPostClientInvocation invocation = this.mySearchUrl != null ? MethodUtil.createCreateInvocation(this.myResource, this.myResourceBody, this.myId, GenericClient.this.myContext, this.mySearchUrl) : (this.myCriterionList != null ? MethodUtil.createCreateInvocation(this.myResource, this.myResourceBody, this.myId, GenericClient.this.myContext, this.myCriterionList.toParamList()) : MethodUtil.createCreateInvocation(this.myResource, this.myResourceBody, this.myId, GenericClient.this.myContext));
            GenericClient.addPreferHeader(this.myPrefer, invocation);
            RuntimeResourceDefinition def = GenericClient.this.myContext.getResourceDefinition(this.myResource);
            String resourceName = def.getName();
            OutcomeResponseHandler binding = new OutcomeResponseHandler(resourceName);
            HashMap<String, List<String>> params = new HashMap<String, List<String>>();
            return this.invoke(params, binding, invocation);
        }

        @Override
        public ICreateTyped prefer(PreferReturnEnum theReturn) {
            this.myPrefer = theReturn;
            return this;
        }

        @Override
        public ICreateTyped resource(IBaseResource theResource) {
            Validate.notNull((Object)theResource, (String)"Resource can not be null", (Object[])new Object[0]);
            this.myResource = theResource;
            return this;
        }

        @Override
        public ICreateTyped resource(String theResourceBody) {
            Validate.notBlank((CharSequence)theResourceBody, (String)"Body can not be null or blank", (Object[])new Object[0]);
            this.myResourceBody = theResourceBody;
            return this;
        }

        @Override
        public ICreateWithQueryTyped where(ICriterion<?> theCriterion) {
            this.myCriterionList.add((ICriterionInternal)((Object)theCriterion));
            return this;
        }

        @Override
        public CreateInternal withId(IdDt theId) {
            this.myId = theId.getIdPart();
            return this;
        }

        @Override
        public CreateInternal withId(String theId) {
            this.myId = theId;
            return this;
        }
    }

    private final class BundleResponseHandler
    implements IClientResponseHandler<Bundle> {
        private Class<? extends IBaseResource> myType;

        public BundleResponseHandler(Class<? extends IBaseResource> theType) {
            this.myType = theType;
        }

        @Override
        public Bundle invokeClient(String theResponseMimeType, Reader theResponseReader, int theResponseStatusCode, Map<String, List<String>> theHeaders) throws BaseServerResponseException {
            EncodingEnum respType = EncodingEnum.forContentType(theResponseMimeType);
            if (respType == null) {
                throw NonFhirResponseException.newInstance(theResponseStatusCode, theResponseMimeType, theResponseReader);
            }
            IParser parser = respType.newParser(GenericClient.this.myContext);
            return parser.parseBundle(this.myType, theResponseReader);
        }
    }

    private abstract class BaseClientExecutable<T extends IClientExecutable<?, ?>, Y>
    implements IClientExecutable<T, Y> {
        protected EncodingEnum myParamEncoding;
        protected Boolean myPrettyPrint;
        private boolean myQueryLogRequestAndResponse;
        private HashSet<String> mySubsetElements;
        protected SummaryEnum mySummaryMode;

        private BaseClientExecutable() {
        }

        @Override
        public T andLogRequestAndResponse(boolean theLogRequestAndResponse) {
            this.myQueryLogRequestAndResponse = theLogRequestAndResponse;
            return (T)this;
        }

        @Override
        public T encodedJson() {
            this.myParamEncoding = EncodingEnum.JSON;
            return (T)this;
        }

        @Override
        public T encodedXml() {
            this.myParamEncoding = EncodingEnum.XML;
            return (T)this;
        }

        protected EncodingEnum getParamEncoding() {
            return this.myParamEncoding;
        }

        protected HashSet<String> getSubsetElements() {
            return this.mySubsetElements;
        }

        protected <Z> Z invoke(Map<String, List<String>> theParams, IClientResponseHandler<Z> theHandler, BaseHttpClientInvocation theInvocation) {
            if (GenericClient.this.isKeepResponses()) {
                GenericClient.this.myLastRequest = theInvocation.asHttpRequest(GenericClient.this.getServerBase(), theParams, GenericClient.this.getEncoding(), this.myPrettyPrint);
            }
            Z resp = GenericClient.this.invokeClient(GenericClient.this.myContext, theHandler, theInvocation, this.myParamEncoding, this.myPrettyPrint, this.myQueryLogRequestAndResponse || GenericClient.this.myLogRequestAndResponse, this.mySummaryMode, this.mySubsetElements);
            return resp;
        }

        protected IBaseResource parseResourceBody(String theResourceBody) {
            EncodingEnum encoding = MethodUtil.detectEncodingNoDefault(theResourceBody);
            if (encoding == null) {
                throw new InvalidRequestException("FHIR client can't determine resource encoding");
            }
            return encoding.newParser(GenericClient.this.myContext).parseResource(theResourceBody);
        }

        @Override
        public T prettyPrint() {
            this.myPrettyPrint = true;
            return (T)this;
        }

        @Override
        public T elementsSubset(String ... theElements) {
            this.mySubsetElements = theElements != null && theElements.length > 0 ? new HashSet<String>(Arrays.asList(theElements)) : null;
            return (T)this;
        }

        @Override
        public T summaryMode(SummaryEnum theSummary) {
            this.mySummaryMode = theSummary;
            return (T)this;
        }
    }
}

