/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.client;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.rest.client.BaseClient;
import ca.uhn.fhir.rest.client.ClientInvocationHandlerFactory;
import ca.uhn.fhir.rest.client.GenericClient;
import ca.uhn.fhir.rest.client.IClientInterceptor;
import ca.uhn.fhir.rest.client.IGenericClient;
import ca.uhn.fhir.rest.client.IRestfulClientFactory;
import ca.uhn.fhir.rest.client.ServerValidationModeEnum;
import ca.uhn.fhir.rest.client.api.IRestfulClient;
import ca.uhn.fhir.rest.client.exceptions.FhirClientConnectionException;
import ca.uhn.fhir.rest.client.exceptions.FhirClientInappropriateForServerException;
import ca.uhn.fhir.rest.method.BaseMethodBinding;
import ca.uhn.fhir.util.FhirTerser;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthenticationStrategy;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.ProxyAuthenticationStrategy;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestfulClientFactory
implements IRestfulClientFactory {
    private static final Logger ourLog = LoggerFactory.getLogger(RestfulClientFactory.class);
    private int myConnectionRequestTimeout = 10000;
    private int myConnectTimeout = 10000;
    private FhirContext myContext;
    private HttpClient myHttpClient;
    private Map<Class<? extends IRestfulClient>, ClientInvocationHandlerFactory> myInvocationHandlers = new HashMap<Class<? extends IRestfulClient>, ClientInvocationHandlerFactory>();
    private HttpHost myProxy;
    private ServerValidationModeEnum myServerValidationMode = DEFAULT_SERVER_VALIDATION_MODE;
    private int mySocketTimeout = 10000;
    private Set<String> myValidatedServerBaseUrls = Collections.synchronizedSet(new HashSet());
    private String myProxyUsername;
    private String myProxyPassword;

    public RestfulClientFactory() {
    }

    public RestfulClientFactory(FhirContext theFhirContext) {
        this.myContext = theFhirContext;
    }

    @Override
    public int getConnectionRequestTimeout() {
        return this.myConnectionRequestTimeout;
    }

    @Override
    public int getConnectTimeout() {
        return this.myConnectTimeout;
    }

    @Override
    public synchronized HttpClient getHttpClient() {
        if (this.myHttpClient == null) {
            PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(5000L, TimeUnit.MILLISECONDS);
            RequestConfig defaultRequestConfig = RequestConfig.custom().setSocketTimeout(this.mySocketTimeout).setConnectTimeout(this.myConnectTimeout).setConnectionRequestTimeout(this.myConnectionRequestTimeout).setStaleConnectionCheckEnabled(true).setProxy(this.myProxy).build();
            HttpClientBuilder builder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultRequestConfig(defaultRequestConfig).disableCookieManagement();
            if (this.myProxy != null && StringUtils.isNotBlank((CharSequence)this.myProxyUsername) && StringUtils.isNotBlank((CharSequence)this.myProxyPassword)) {
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(new AuthScope(this.myProxy.getHostName(), this.myProxy.getPort()), (Credentials)new UsernamePasswordCredentials(this.myProxyUsername, this.myProxyPassword));
                builder.setProxyAuthenticationStrategy((AuthenticationStrategy)new ProxyAuthenticationStrategy());
                builder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
            }
            this.myHttpClient = builder.build();
        }
        return this.myHttpClient;
    }

    @Override
    public void setProxyCredentials(String theUsername, String thePassword) {
        this.myProxyUsername = theUsername;
        this.myProxyPassword = thePassword;
    }

    @Override
    public ServerValidationModeEnum getServerValidationMode() {
        return this.myServerValidationMode;
    }

    @Override
    public int getSocketTimeout() {
        return this.mySocketTimeout;
    }

    private <T extends IRestfulClient> T instantiateProxy(Class<T> theClientType, InvocationHandler theInvocationHandler) {
        IRestfulClient proxy = (IRestfulClient)Proxy.newProxyInstance(theClientType.getClassLoader(), new Class[]{theClientType}, theInvocationHandler);
        return (T)proxy;
    }

    @Override
    public synchronized <T extends IRestfulClient> T newClient(Class<T> theClientType, String theServerBase) {
        if (!theClientType.isInterface()) {
            throw new ConfigurationException(theClientType.getCanonicalName() + " is not an interface");
        }
        ClientInvocationHandlerFactory invocationHandler = this.myInvocationHandlers.get(theClientType);
        if (invocationHandler == null) {
            HttpClient httpClient = this.getHttpClient();
            invocationHandler = new ClientInvocationHandlerFactory(httpClient, this.myContext, theServerBase, theClientType);
            for (Method nextMethod : theClientType.getMethods()) {
                BaseMethodBinding<?> binding = BaseMethodBinding.bindMethod(nextMethod, this.myContext, null);
                invocationHandler.addBinding(nextMethod, binding);
            }
            this.myInvocationHandlers.put(theClientType, invocationHandler);
        }
        T proxy = this.instantiateProxy(theClientType, invocationHandler.newInvocationHandler(this));
        return proxy;
    }

    @Override
    public synchronized IGenericClient newGenericClient(String theServerBase) {
        HttpClient httpClient = this.getHttpClient();
        return new GenericClient(this.myContext, httpClient, theServerBase, this);
    }

    public void validateServerBaseIfConfiguredToDoSo(String theServerBase, HttpClient theHttpClient, BaseClient theClient) {
        String serverBase = this.normalizeBaseUrlForMap(theServerBase);
        switch (this.myServerValidationMode) {
            case NEVER: {
                break;
            }
            case ONCE: {
                if (this.myValidatedServerBaseUrls.contains(serverBase)) break;
                this.validateServerBase(serverBase, theHttpClient, theClient);
            }
        }
    }

    private String normalizeBaseUrlForMap(String theServerBase) {
        String serverBase = theServerBase;
        if (!serverBase.endsWith("/")) {
            serverBase = serverBase + "/";
        }
        return serverBase;
    }

    @Override
    public synchronized void setConnectionRequestTimeout(int theConnectionRequestTimeout) {
        this.myConnectionRequestTimeout = theConnectionRequestTimeout;
        this.myHttpClient = null;
    }

    @Override
    public synchronized void setConnectTimeout(int theConnectTimeout) {
        this.myConnectTimeout = theConnectTimeout;
        this.myHttpClient = null;
    }

    public void setFhirContext(FhirContext theContext) {
        if (this.myContext != null && this.myContext != theContext) {
            throw new IllegalStateException("RestfulClientFactory instance is already associated with one FhirContext. RestfulClientFactory instances can not be shared.");
        }
        this.myContext = theContext;
    }

    @Override
    public synchronized void setHttpClient(HttpClient theHttpClient) {
        this.myHttpClient = theHttpClient;
    }

    @Override
    public void setProxy(String theHost, Integer thePort) {
        this.myProxy = theHost != null ? new HttpHost(theHost, thePort.intValue(), "http") : null;
    }

    @Override
    public void setServerValidationMode(ServerValidationModeEnum theServerValidationMode) {
        Validate.notNull((Object)((Object)theServerValidationMode), (String)"theServerValidationMode may not be null", (Object[])new Object[0]);
        this.myServerValidationMode = theServerValidationMode;
    }

    @Override
    public synchronized void setSocketTimeout(int theSocketTimeout) {
        this.mySocketTimeout = theSocketTimeout;
        this.myHttpClient = null;
    }

    void validateServerBase(String theServerBase, HttpClient theHttpClient, BaseClient theClient) {
        FhirVersionEnum contextFhirVersion;
        IBaseResource conformance;
        GenericClient client = new GenericClient(this.myContext, theHttpClient, theServerBase, this);
        client.setEncoding(theClient.getEncoding());
        for (IClientInterceptor interceptor : theClient.getInterceptors()) {
            client.registerInterceptor(interceptor);
        }
        client.setDontValidateConformance(true);
        try {
            Class implementingClass = this.myContext.getResourceDefinition("Conformance").getImplementingClass();
            conformance = (IBaseResource)client.fetchConformance().ofType(implementingClass).execute();
        }
        catch (FhirClientConnectionException e) {
            throw new FhirClientConnectionException(this.myContext.getLocalizer().getMessage(RestfulClientFactory.class, "failedToRetrieveConformance", theServerBase + "metadata"), (Throwable)e);
        }
        FhirTerser t = this.myContext.newTerser();
        String serverFhirVersionString = null;
        Object value = t.getSingleValueOrNull(conformance, "fhirVersion");
        if (value instanceof IPrimitiveType) {
            serverFhirVersionString = ((IPrimitiveType)value).getValueAsString();
        }
        FhirVersionEnum serverFhirVersionEnum = null;
        if (!StringUtils.isBlank((CharSequence)serverFhirVersionString)) {
            if (serverFhirVersionString.startsWith("0.80") || serverFhirVersionString.startsWith("0.0.8")) {
                serverFhirVersionEnum = FhirVersionEnum.DSTU1;
            } else if (serverFhirVersionString.startsWith("0.4")) {
                serverFhirVersionEnum = FhirVersionEnum.DSTU2;
            } else if (serverFhirVersionString.startsWith("0.5")) {
                serverFhirVersionEnum = FhirVersionEnum.DSTU2;
            } else {
                ourLog.debug("Server conformance statement indicates unknown FHIR version: {}", (Object)serverFhirVersionString);
            }
        }
        if (serverFhirVersionEnum != null && !(contextFhirVersion = this.myContext.getVersion().getVersion()).isEquivalentTo(serverFhirVersionEnum)) {
            throw new FhirClientInappropriateForServerException(this.myContext.getLocalizer().getMessage(RestfulClientFactory.class, "wrongVersionInConformance", new Object[]{theServerBase + "metadata", serverFhirVersionString, serverFhirVersionEnum, contextFhirVersion}));
        }
        this.myValidatedServerBaseUrls.add(this.normalizeBaseUrlForMap(theServerBase));
    }

    @Override
    public ServerValidationModeEnum getServerValidationModeEnum() {
        return this.getServerValidationMode();
    }

    @Override
    public void setServerValidationModeEnum(ServerValidationModeEnum theServerValidationMode) {
        this.setServerValidationMode(theServerValidationMode);
    }
}

