/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.client.exceptions;

import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import java.io.IOException;
import java.io.Reader;
import net.sourceforge.cobertura.CoverageIgnore;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

@CoverageIgnore
public class NonFhirResponseException
extends BaseServerResponseException {
    private static final long serialVersionUID = 1L;

    NonFhirResponseException(int theStatusCode, String theMessage) {
        super(theStatusCode, theMessage);
    }

    public static NonFhirResponseException newInstance(int theStatusCode, String theContentType, Reader theReader) {
        String responseBody = "";
        try {
            responseBody = IOUtils.toString((Reader)theReader);
        }
        catch (IOException e) {
            IOUtils.closeQuietly((Reader)theReader);
        }
        NonFhirResponseException retVal = StringUtils.isBlank((CharSequence)theContentType) ? new NonFhirResponseException(theStatusCode, "Response contains no Content-Type") : (theContentType.contains("text") ? new NonFhirResponseException(theStatusCode, "Response contains non FHIR Content-Type '" + theContentType + "' : " + responseBody) : new NonFhirResponseException(theStatusCode, "Response contains non FHIR Content-Type '" + theContentType + "'"));
        retVal.setResponseBody(responseBody);
        return retVal;
    }
}

