/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.client.interceptor;

import ca.uhn.fhir.rest.client.IClientInterceptor;
import net.sourceforge.cobertura.CoverageIgnore;
import org.apache.commons.lang3.Validate;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;

public class BearerTokenAuthInterceptor
implements IClientInterceptor {
    private String myToken;

    @CoverageIgnore
    public BearerTokenAuthInterceptor() {
    }

    public BearerTokenAuthInterceptor(String theToken) {
        Validate.notNull((Object)"theToken must not be null");
        this.myToken = theToken;
    }

    public String getToken() {
        return this.myToken;
    }

    @Override
    public void interceptRequest(HttpRequestBase theRequest) {
        theRequest.addHeader("Authorization", "Bearer " + this.myToken);
    }

    @Override
    public void interceptResponse(HttpResponse theResponse) {
    }

    public void setToken(String theToken) {
        this.myToken = theToken;
    }
}

