/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.client.interceptor;

import ca.uhn.fhir.rest.client.IClientInterceptor;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Validate;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.HttpEntityWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingInterceptor
implements IClientInterceptor {
    private static final Logger ourLog = LoggerFactory.getLogger(LoggingInterceptor.class);
    private Logger myLog = ourLog;
    private boolean myLogRequestBody = false;
    private boolean myLogRequestHeaders = false;
    private boolean myLogRequestSummary = true;
    private boolean myLogResponseBody = false;
    private boolean myLogResponseHeaders = false;
    private boolean myLogResponseSummary = true;

    public LoggingInterceptor() {
    }

    public LoggingInterceptor(boolean theVerbose) {
        if (theVerbose) {
            this.setLogRequestBody(true);
            this.setLogRequestSummary(true);
            this.setLogResponseBody(true);
            this.setLogResponseSummary(true);
            this.setLogRequestHeaders(true);
            this.setLogResponseHeaders(true);
        }
    }

    @Override
    public void interceptRequest(HttpRequestBase theRequest) {
        HttpEntity entity;
        if (this.myLogRequestSummary) {
            this.myLog.info("Client request: {}", (Object)theRequest);
        }
        if (this.myLogRequestHeaders) {
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < theRequest.getAllHeaders().length; ++i) {
                Header next = theRequest.getAllHeaders()[i];
                b.append(next.getName() + ": " + next.getValue());
                if (i + 1 >= theRequest.getAllHeaders().length) continue;
                b.append('\n');
            }
            this.myLog.info("Client request headers:\n{}", (Object)b.toString());
        }
        if (this.myLogRequestBody && theRequest instanceof HttpEntityEnclosingRequest && (entity = ((HttpEntityEnclosingRequest)theRequest).getEntity()).isRepeatable()) {
            try {
                String content = IOUtils.toString((InputStream)entity.getContent());
                this.myLog.info("Client request body:\n{}", (Object)content);
            }
            catch (IllegalStateException e) {
                this.myLog.warn("Failed to replay request contents (during logging attempt, actual FHIR call did not fail)", (Throwable)e);
            }
            catch (IOException e) {
                this.myLog.warn("Failed to replay request contents (during logging attempt, actual FHIR call did not fail)", (Throwable)e);
            }
        }
    }

    @Override
    public void interceptResponse(HttpResponse theResponse) throws IOException {
        if (this.myLogResponseSummary) {
            String message = "HTTP " + theResponse.getStatusLine().getStatusCode() + " " + theResponse.getStatusLine().getReasonPhrase();
            this.myLog.info("Client response: {}", (Object)message);
        }
        if (this.myLogResponseHeaders) {
            StringBuilder b = new StringBuilder();
            if (theResponse.getAllHeaders() != null) {
                for (int i = 0; i < theResponse.getAllHeaders().length; ++i) {
                    Header next = theResponse.getAllHeaders()[i];
                    b.append(next.getName() + ": " + next.getValue());
                    if (i + 1 >= theResponse.getAllHeaders().length) continue;
                    b.append('\n');
                }
            }
            if (b.length() == 0) {
                this.myLog.info("Client response headers: (none)");
            } else {
                this.myLog.info("Client response headers:\n{}", (Object)b.toString());
            }
        }
        if (this.myLogResponseBody) {
            HttpEntity respEntity = theResponse.getEntity();
            if (respEntity != null) {
                byte[] bytes;
                try {
                    bytes = IOUtils.toByteArray((InputStream)respEntity.getContent());
                }
                catch (IllegalStateException e) {
                    throw new InternalErrorException(e);
                }
                this.myLog.info("Client response body:\n{}", (Object)new String(bytes, "UTF-8"));
                theResponse.setEntity((HttpEntity)new MyEntityWrapper(respEntity, bytes));
            } else {
                this.myLog.info("Client response body: (none)");
            }
        }
    }

    public void setLogger(Logger theLogger) {
        Validate.notNull((Object)theLogger, (String)"theLogger can not be null", (Object[])new Object[0]);
        this.myLog = theLogger;
    }

    public void setLogRequestBody(boolean theValue) {
        this.myLogRequestBody = theValue;
    }

    public void setLogRequestHeaders(boolean theValue) {
        this.myLogRequestHeaders = theValue;
    }

    public void setLogRequestSummary(boolean theValue) {
        this.myLogRequestSummary = theValue;
    }

    public void setLogResponseBody(boolean theValue) {
        this.myLogResponseBody = theValue;
    }

    public void setLogResponseHeaders(boolean theValue) {
        this.myLogResponseHeaders = theValue;
    }

    public void setLogResponseSummary(boolean theValue) {
        this.myLogResponseSummary = theValue;
    }

    private static class MyEntityWrapper
    extends HttpEntityWrapper {
        private byte[] myBytes;

        public MyEntityWrapper(HttpEntity theWrappedEntity, byte[] theBytes) {
            super(theWrappedEntity);
            this.myBytes = theBytes;
        }

        public InputStream getContent() throws IOException {
            return new ByteArrayInputStream(this.myBytes);
        }

        public void writeTo(OutputStream theOutstream) throws IOException {
            theOutstream.write(this.myBytes);
        }
    }
}

