/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.gclient;

import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.rest.gclient.BaseClientParam;
import ca.uhn.fhir.rest.gclient.ICriterion;
import ca.uhn.fhir.rest.gclient.ICriterionInternal;
import ca.uhn.fhir.rest.gclient.IParam;
import java.util.Date;

public class DateClientParam
extends BaseClientParam
implements IParam {
    private String myParamName;

    @Override
    public String getParamName() {
        return this.myParamName;
    }

    public DateClientParam(String theParamName) {
        this.myParamName = theParamName;
    }

    public IDateSpecifier after() {
        return new DateWithPrefix(">");
    }

    public IDateSpecifier afterOrEquals() {
        return new DateWithPrefix(">=");
    }

    public IDateSpecifier before() {
        return new DateWithPrefix("<");
    }

    public IDateSpecifier beforeOrEquals() {
        return new DateWithPrefix("<=");
    }

    public IDateSpecifier exactly() {
        return new DateWithPrefix("");
    }

    public static interface IDateSpecifier {
        public ICriterion<DateClientParam> day(Date var1);

        public ICriterion<DateClientParam> day(String var1);

        public ICriterion<DateClientParam> now();

        public ICriterion<DateClientParam> second(Date var1);

        public ICriterion<DateClientParam> second(String var1);
    }

    private class DateWithPrefix
    implements IDateSpecifier {
        private String myPrefix;

        public DateWithPrefix(String thePrefix) {
            this.myPrefix = thePrefix;
        }

        @Override
        public ICriterion<DateClientParam> day(Date theValue) {
            DateTimeDt dt = new DateTimeDt(theValue);
            dt.setPrecision(TemporalPrecisionEnum.DAY);
            return new Criterion(this.myPrefix + dt.getValueAsString());
        }

        @Override
        public ICriterion<DateClientParam> day(String theValue) {
            DateTimeDt dt = new DateTimeDt(theValue);
            dt.setPrecision(TemporalPrecisionEnum.DAY);
            return new Criterion(this.myPrefix + dt.getValueAsString());
        }

        @Override
        public ICriterion<DateClientParam> now() {
            DateTimeDt dt = new DateTimeDt();
            dt.setPrecision(TemporalPrecisionEnum.DAY);
            return new Criterion(this.myPrefix + dt.getValueAsString());
        }

        @Override
        public ICriterion<DateClientParam> second(Date theValue) {
            DateTimeDt dt = new DateTimeDt(theValue);
            dt.setPrecision(TemporalPrecisionEnum.SECOND);
            return new Criterion(this.myPrefix + dt.getValueAsString());
        }

        @Override
        public ICriterion<DateClientParam> second(String theValue) {
            DateTimeDt dt = new DateTimeDt(theValue);
            dt.setPrecision(TemporalPrecisionEnum.SECOND);
            return new Criterion(this.myPrefix + dt.getValueAsString());
        }
    }

    private class Criterion
    implements ICriterion<DateClientParam>,
    ICriterionInternal {
        private String myValue;

        public Criterion(String theValue) {
            this.myValue = theValue;
        }

        @Override
        public String getParameterName() {
            return DateClientParam.this.myParamName;
        }

        @Override
        public String getParameterValue() {
            return this.myValue;
        }
    }
}

