/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.gclient;

import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.BaseClientParam;
import ca.uhn.fhir.rest.gclient.ICriterion;
import ca.uhn.fhir.rest.gclient.IParam;
import ca.uhn.fhir.rest.gclient.StringCriterion;
import java.util.Arrays;
import java.util.List;

public class StringClientParam
extends BaseClientParam
implements IParam {
    private final String myParamName;

    public StringClientParam(String theParamName) {
        this.myParamName = theParamName;
    }

    @Override
    public String getParamName() {
        return this.myParamName;
    }

    public IStringMatch matches() {
        return new StringMatches();
    }

    public IStringMatch matchesExactly() {
        return new StringExactly();
    }

    private class StringMatches
    implements IStringMatch {
        private StringMatches() {
        }

        @Override
        public ICriterion<StringClientParam> value(String theValue) {
            return new StringCriterion<StringClientParam>(StringClientParam.this.getParamName(), theValue);
        }

        @Override
        public ICriterion<StringClientParam> value(StringDt theValue) {
            return new StringCriterion<StringClientParam>(StringClientParam.this.getParamName(), (String)theValue.getValue());
        }

        @Override
        public ICriterion<StringClientParam> values(List<String> theValue) {
            return new StringCriterion<StringClientParam>(StringClientParam.this.getParamName(), theValue);
        }

        @Override
        public ICriterion<?> values(String ... theValues) {
            return new StringCriterion(StringClientParam.this.getParamName(), Arrays.asList(theValues));
        }
    }

    private class StringExactly
    implements IStringMatch {
        private StringExactly() {
        }

        @Override
        public ICriterion<StringClientParam> value(String theValue) {
            return new StringCriterion<StringClientParam>(StringClientParam.this.getParamName() + ":exact", theValue);
        }

        @Override
        public ICriterion<StringClientParam> value(StringDt theValue) {
            return new StringCriterion<StringClientParam>(StringClientParam.this.getParamName() + ":exact", (String)theValue.getValue());
        }

        @Override
        public ICriterion<StringClientParam> values(List<String> theValue) {
            return new StringCriterion<StringClientParam>(StringClientParam.this.getParamName() + ":exact", theValue);
        }

        @Override
        public ICriterion<?> values(String ... theValues) {
            return new StringCriterion(StringClientParam.this.getParamName() + ":exact", Arrays.asList(theValues));
        }
    }

    public static interface IStringMatch {
        public ICriterion<StringClientParam> value(String var1);

        public ICriterion<StringClientParam> values(List<String> var1);

        public ICriterion<StringClientParam> value(StringDt var1);

        public ICriterion<?> values(String ... var1);
    }
}

