/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.gclient;

import ca.uhn.fhir.rest.gclient.ICriterion;
import ca.uhn.fhir.rest.gclient.ICriterionInternal;
import ca.uhn.fhir.rest.gclient.IParam;
import ca.uhn.fhir.rest.param.ParameterUtil;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

class StringCriterion<A extends IParam>
implements ICriterion<A>,
ICriterionInternal {
    private String myValue;
    private String myName;

    public StringCriterion(String theName, String theValue) {
        this.myName = theName;
        this.myValue = ParameterUtil.escape(theValue);
    }

    public StringCriterion(String theName, List<String> theValue) {
        this.myName = theName;
        StringBuilder b = new StringBuilder();
        for (String next : theValue) {
            if (StringUtils.isBlank((CharSequence)next)) continue;
            if (b.length() > 0) {
                b.append(',');
            }
            b.append(ParameterUtil.escape(next));
        }
        this.myValue = b.toString();
    }

    @Override
    public String getParameterName() {
        return this.myName;
    }

    @Override
    public String getParameterValue() {
        return this.myValue;
    }
}

