/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.method;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.Bundle;
import ca.uhn.fhir.model.api.TagList;
import ca.uhn.fhir.model.valueset.BundleTypeEnum;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.rest.client.BaseHttpClientInvocation;
import ca.uhn.fhir.rest.method.MethodUtil;
import ca.uhn.fhir.rest.server.Constants;
import ca.uhn.fhir.rest.server.EncodingEnum;
import ca.uhn.fhir.rest.server.IVersionSpecificBundleFactory;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.message.BasicNameValuePair;
import org.hl7.fhir.instance.model.api.IBaseBinary;
import org.hl7.fhir.instance.model.api.IBaseResource;

abstract class BaseHttpClientInvocationWithContents
extends BaseHttpClientInvocation {
    private final Bundle myBundle;
    private final BundleTypeEnum myBundleType;
    private final String myContents;
    private boolean myContentsIsBundle;
    private final FhirContext myContext;
    private Map<String, List<String>> myIfNoneExistParams;
    private String myIfNoneExistString;
    private boolean myOmitResourceId = false;
    private Map<String, List<String>> myParams;
    private final IBaseResource myResource;
    private final List<? extends IBaseResource> myResources;
    private final TagList myTagList;
    private final String myUrlPath;

    public BaseHttpClientInvocationWithContents(FhirContext theContext, Bundle theBundle) {
        this.myContext = theContext;
        this.myResource = null;
        this.myTagList = null;
        this.myUrlPath = null;
        this.myResources = null;
        this.myBundle = theBundle;
        this.myContents = null;
        this.myBundleType = null;
    }

    public BaseHttpClientInvocationWithContents(FhirContext theContext, IBaseResource theResource, Map<String, List<String>> theParams, String ... theUrlPath) {
        this.myContext = theContext;
        this.myResource = theResource;
        this.myTagList = null;
        this.myUrlPath = StringUtils.join((Object[])theUrlPath, (char)'/');
        this.myResources = null;
        this.myBundle = null;
        this.myContents = null;
        this.myContentsIsBundle = false;
        this.myParams = theParams;
        this.myBundleType = null;
    }

    public BaseHttpClientInvocationWithContents(FhirContext theContext, IBaseResource theResource, String theUrlPath) {
        this.myContext = theContext;
        this.myResource = theResource;
        this.myUrlPath = theUrlPath;
        this.myTagList = null;
        this.myResources = null;
        this.myBundle = null;
        this.myContents = null;
        this.myBundleType = null;
    }

    public BaseHttpClientInvocationWithContents(FhirContext theContext, List<? extends IBaseResource> theResources, BundleTypeEnum theBundleType) {
        this.myContext = theContext;
        this.myResource = null;
        this.myTagList = null;
        this.myUrlPath = null;
        this.myResources = theResources;
        this.myBundle = null;
        this.myContents = null;
        this.myBundleType = theBundleType;
    }

    public BaseHttpClientInvocationWithContents(FhirContext theContext, Map<String, List<String>> theParams, String ... theUrlPath) {
        this.myContext = theContext;
        this.myResource = null;
        this.myTagList = null;
        this.myUrlPath = StringUtils.join((Object[])theUrlPath, (char)'/');
        this.myResources = null;
        this.myBundle = null;
        this.myContents = null;
        this.myContentsIsBundle = false;
        this.myParams = theParams;
        this.myBundleType = null;
    }

    public BaseHttpClientInvocationWithContents(FhirContext theContext, String theContents, boolean theIsBundle, String theUrlPath) {
        this.myContext = theContext;
        this.myResource = null;
        this.myTagList = null;
        this.myUrlPath = theUrlPath;
        this.myResources = null;
        this.myBundle = null;
        this.myContents = theContents;
        this.myContentsIsBundle = theIsBundle;
        this.myBundleType = null;
    }

    public BaseHttpClientInvocationWithContents(FhirContext theContext, String theContents, Map<String, List<String>> theParams, String ... theUrlPath) {
        this.myContext = theContext;
        this.myResource = null;
        this.myTagList = null;
        this.myUrlPath = StringUtils.join((Object[])theUrlPath, (char)'/');
        this.myResources = null;
        this.myBundle = null;
        this.myContents = theContents;
        this.myContentsIsBundle = false;
        this.myParams = theParams;
        this.myBundleType = null;
    }

    public BaseHttpClientInvocationWithContents(FhirContext theContext, TagList theTagList, String ... theUrlPath) {
        if (theTagList == null) {
            throw new NullPointerException("Tag list must not be null");
        }
        this.myResource = null;
        this.myContext = theContext;
        this.myTagList = theTagList;
        this.myResources = null;
        this.myBundle = null;
        this.myContents = null;
        this.myBundleType = null;
        this.myUrlPath = StringUtils.join((Object[])theUrlPath, (char)'/');
    }

    private void addMatchHeaders(HttpRequestBase theHttpRequest, StringBuilder theUrlBase) {
        StringBuilder b;
        if (this.myIfNoneExistParams != null) {
            BaseHttpClientInvocationWithContents.appendExtraParamsWithQuestionMark(this.myIfNoneExistParams, b, (b = this.newHeaderBuilder(theUrlBase)).indexOf("?") == -1);
            theHttpRequest.addHeader("If-None-Exist", b.toString());
        }
        if (this.myIfNoneExistString != null) {
            b.append((b = this.newHeaderBuilder(theUrlBase)).indexOf("?") == -1 ? (char)'?' : '&');
            b.append(this.myIfNoneExistString.substring(this.myIfNoneExistString.indexOf(63) + 1));
            theHttpRequest.addHeader("If-None-Exist", b.toString());
        }
    }

    @Override
    public HttpRequestBase asHttpRequest(String theUrlBase, Map<String, List<String>> theExtraParams, EncodingEnum theEncoding, Boolean thePrettyPrint) throws DataFormatException {
        ByteArrayEntity entity;
        String contentType;
        IParser parser;
        StringBuilder url = new StringBuilder();
        if (this.myUrlPath == null) {
            url.append(theUrlBase);
        } else {
            if (!this.myUrlPath.contains("://")) {
                url.append(theUrlBase);
                if (!theUrlBase.endsWith("/")) {
                    url.append('/');
                }
            }
            url.append(this.myUrlPath);
        }
        BaseHttpClientInvocationWithContents.appendExtraParamsWithQuestionMark(theExtraParams, url, url.indexOf("?") == -1);
        if (this.myResource != null && IBaseBinary.class.isAssignableFrom(this.myResource.getClass())) {
            IBaseBinary binary = (IBaseBinary)this.myResource;
            ByteArrayEntity entity2 = new ByteArrayEntity(binary.getContent());
            entity2.setContentType(binary.getContentType());
            HttpRequestBase retVal = this.createRequest(url, (AbstractHttpEntity)entity2);
            this.addMatchHeaders(retVal, url);
            return retVal;
        }
        EncodingEnum encoding = null;
        encoding = theEncoding;
        if (this.myContents != null) {
            encoding = MethodUtil.detectEncoding(this.myContents);
        }
        if (encoding == EncodingEnum.JSON) {
            parser = this.myContext.newJsonParser();
        } else {
            encoding = EncodingEnum.XML;
            parser = this.myContext.newXmlParser();
        }
        if (thePrettyPrint != null) {
            parser.setPrettyPrint(thePrettyPrint);
        }
        parser.setOmitResourceId(this.myOmitResourceId);
        if (this.myParams != null) {
            contentType = null;
            ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
            for (Map.Entry<String, List<String>> nextParam : this.myParams.entrySet()) {
                List<String> value = nextParam.getValue();
                for (String s : value) {
                    parameters.add(new BasicNameValuePair(nextParam.getKey(), s));
                }
            }
            try {
                entity = new UrlEncodedFormEntity(parameters, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new InternalErrorException("Server does not support UTF-8 (should not happen)", (Throwable)e);
            }
        } else {
            String contents;
            if (this.myTagList != null) {
                contents = parser.encodeTagListToString(this.myTagList);
                contentType = encoding.getResourceContentType();
            } else if (this.myBundle != null) {
                contents = parser.encodeBundleToString(this.myBundle);
                contentType = encoding.getBundleContentType();
            } else if (this.myResources != null) {
                IVersionSpecificBundleFactory bundleFactory = this.myContext.newBundleFactory();
                bundleFactory.initializeBundleFromResourceList("", this.myResources, "", "", this.myResources.size(), this.myBundleType);
                Bundle bundle = bundleFactory.getDstu1Bundle();
                if (bundle != null) {
                    contents = parser.encodeBundleToString(bundle);
                    contentType = encoding.getBundleContentType();
                } else {
                    IBaseResource bundleRes = bundleFactory.getResourceBundle();
                    contents = parser.encodeResourceToString(bundleRes);
                    contentType = encoding.getResourceContentType();
                }
            } else if (this.myContents != null) {
                contents = this.myContents;
                contentType = this.myContentsIsBundle && this.myContext.getVersion().getVersion().equals((Object)FhirVersionEnum.DSTU1) ? encoding.getBundleContentType() : encoding.getResourceContentType();
            } else {
                contents = parser.encodeResourceToString(this.myResource);
                contentType = encoding.getResourceContentType();
            }
            entity = new ByteArrayEntity(contents.getBytes(Constants.CHARSET_UTF8));
        }
        HttpRequestBase retVal = this.createRequest(url, (AbstractHttpEntity)entity);
        super.addHeadersToRequest(retVal, encoding);
        this.addMatchHeaders(retVal, url);
        if (contentType != null) {
            retVal.addHeader("Content-Type", contentType + "; charset=UTF-8");
        }
        return retVal;
    }

    protected abstract HttpRequestBase createRequest(StringBuilder var1, AbstractHttpEntity var2);

    private StringBuilder newHeaderBuilder(StringBuilder theUrlBase) {
        StringBuilder b = new StringBuilder();
        b.append((CharSequence)theUrlBase);
        if (theUrlBase.length() > 0 && theUrlBase.charAt(theUrlBase.length() - 1) == '/') {
            b.deleteCharAt(b.length() - 1);
        }
        return b;
    }

    public void setIfNoneExistParams(Map<String, List<String>> theIfNoneExist) {
        this.myIfNoneExistParams = theIfNoneExist;
    }

    public void setIfNoneExistString(String theIfNoneExistString) {
        this.myIfNoneExistString = theIfNoneExistString;
    }

    public void setOmitResourceId(boolean theOmitResourceId) {
        this.myOmitResourceId = theOmitResourceId;
    }
}

