/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.Bundle;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TagList;
import ca.uhn.fhir.model.base.resource.BaseOperationOutcome;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.rest.annotation.AddTags;
import ca.uhn.fhir.rest.annotation.Create;
import ca.uhn.fhir.rest.annotation.Delete;
import ca.uhn.fhir.rest.annotation.DeleteTags;
import ca.uhn.fhir.rest.annotation.GetTags;
import ca.uhn.fhir.rest.annotation.History;
import ca.uhn.fhir.rest.annotation.Metadata;
import ca.uhn.fhir.rest.annotation.Operation;
import ca.uhn.fhir.rest.annotation.Read;
import ca.uhn.fhir.rest.annotation.Search;
import ca.uhn.fhir.rest.annotation.Transaction;
import ca.uhn.fhir.rest.annotation.Update;
import ca.uhn.fhir.rest.annotation.Validate;
import ca.uhn.fhir.rest.api.MethodOutcome;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.client.BaseHttpClientInvocation;
import ca.uhn.fhir.rest.client.exceptions.NonFhirResponseException;
import ca.uhn.fhir.rest.method.AddTagsMethodBinding;
import ca.uhn.fhir.rest.method.ConditionalParamBinder;
import ca.uhn.fhir.rest.method.ConformanceMethodBinding;
import ca.uhn.fhir.rest.method.CreateMethodBinding;
import ca.uhn.fhir.rest.method.DeleteMethodBinding;
import ca.uhn.fhir.rest.method.DeleteTagsMethodBinding;
import ca.uhn.fhir.rest.method.DynamicSearchMethodBinding;
import ca.uhn.fhir.rest.method.GetTagsMethodBinding;
import ca.uhn.fhir.rest.method.HistoryMethodBinding;
import ca.uhn.fhir.rest.method.IClientResponseHandler;
import ca.uhn.fhir.rest.method.IParameter;
import ca.uhn.fhir.rest.method.IncludeParameter;
import ca.uhn.fhir.rest.method.MethodUtil;
import ca.uhn.fhir.rest.method.OperationMethodBinding;
import ca.uhn.fhir.rest.method.ReadMethodBinding;
import ca.uhn.fhir.rest.method.RequestDetails;
import ca.uhn.fhir.rest.method.SearchMethodBinding;
import ca.uhn.fhir.rest.method.TransactionMethodBinding;
import ca.uhn.fhir.rest.method.UpdateMethodBinding;
import ca.uhn.fhir.rest.method.ValidateMethodBindingDstu1;
import ca.uhn.fhir.rest.method.ValidateMethodBindingDstu2;
import ca.uhn.fhir.rest.server.BundleProviders;
import ca.uhn.fhir.rest.server.EncodingEnum;
import ca.uhn.fhir.rest.server.IBundleProvider;
import ca.uhn.fhir.rest.server.IDynamicSearchResourceProvider;
import ca.uhn.fhir.rest.server.IResourceProvider;
import ca.uhn.fhir.rest.server.RestfulServer;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.MethodNotAllowedException;
import ca.uhn.fhir.rest.server.exceptions.PreconditionFailedException;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import ca.uhn.fhir.rest.server.exceptions.ResourceVersionConflictException;
import ca.uhn.fhir.rest.server.exceptions.UnclassifiedServerFailureException;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import ca.uhn.fhir.rest.server.interceptor.IServerInterceptor;
import ca.uhn.fhir.util.ReflectionUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseMethodBinding<T>
implements IClientResponseHandler<T> {
    private static final Logger ourLog = LoggerFactory.getLogger(BaseMethodBinding.class);
    private static volatile IRequestReader ourRequestReader;
    private FhirContext myContext;
    private Method myMethod;
    private List<IParameter> myParameters;
    private Object myProvider;
    private boolean mySupportsConditional;
    private boolean mySupportsConditionalMultiple;

    public BaseMethodBinding(Method theMethod, FhirContext theContext, Object theProvider) {
        assert (theMethod != null);
        assert (theContext != null);
        this.myMethod = theMethod;
        this.myContext = theContext;
        this.myProvider = theProvider;
        this.myParameters = MethodUtil.getResourceParameters(theContext, theMethod, theProvider, this.getRestOperationType());
        for (IParameter next : this.myParameters) {
            if (!(next instanceof ConditionalParamBinder)) continue;
            this.mySupportsConditional = true;
            if (!((ConditionalParamBinder)next).isSupportsMultiple()) break;
            this.mySupportsConditionalMultiple = true;
            break;
        }
    }

    protected IParser createAppropriateParserForParsingResponse(String theResponseMimeType, Reader theResponseReader, int theResponseStatusCode) {
        EncodingEnum encoding = EncodingEnum.forContentType(theResponseMimeType);
        if (encoding == null) {
            NonFhirResponseException ex = NonFhirResponseException.newInstance(theResponseStatusCode, theResponseMimeType, theResponseReader);
            BaseMethodBinding.populateException(ex, theResponseReader);
            throw ex;
        }
        IParser parser = encoding.newParser(this.getContext());
        return parser;
    }

    protected IParser createAppropriateParserForParsingServerRequest(RequestDetails theRequest) {
        EncodingEnum encoding;
        String contentTypeHeader = theRequest.getServletRequest().getHeader("content-type");
        if (StringUtils.isBlank((CharSequence)contentTypeHeader)) {
            encoding = EncodingEnum.XML;
        } else {
            int semicolon = contentTypeHeader.indexOf(59);
            if (semicolon != -1) {
                contentTypeHeader = contentTypeHeader.substring(0, semicolon);
            }
            encoding = EncodingEnum.forContentType(contentTypeHeader);
        }
        if (encoding == null) {
            throw new InvalidRequestException("Request contins non-FHIR conent-type header value: " + contentTypeHeader);
        }
        IParser parser = encoding.newParser(this.getContext());
        return parser;
    }

    protected Object[] createParametersForServerRequest(RequestDetails theRequest, byte[] theRequestContents) {
        Object[] params = new Object[this.getParameters().size()];
        for (int i = 0; i < this.getParameters().size(); ++i) {
            IParameter param = this.getParameters().get(i);
            if (param == null) continue;
            params[i] = param.translateQueryParametersIntoServerArgument(theRequest, theRequestContents, this);
        }
        return params;
    }

    public List<Class<?>> getAllowableParamAnnotations() {
        return null;
    }

    public FhirContext getContext() {
        return this.myContext;
    }

    public Set<String> getIncludes() {
        TreeSet<String> retVal = new TreeSet<String>();
        for (IParameter next : this.myParameters) {
            if (!(next instanceof IncludeParameter)) continue;
            retVal.addAll(((IncludeParameter)next).getAllow());
        }
        return retVal;
    }

    public Method getMethod() {
        return this.myMethod;
    }

    public List<IParameter> getParameters() {
        return this.myParameters;
    }

    public Object getProvider() {
        return this.myProvider;
    }

    public Set<Include> getRequestIncludesFromParams(Object[] params) {
        if (params == null || params.length == 0) {
            return null;
        }
        int index = 0;
        boolean match = false;
        for (IParameter parameter : this.myParameters) {
            if (parameter instanceof IncludeParameter) {
                match = true;
                break;
            }
            ++index;
        }
        if (!match) {
            return null;
        }
        if (index >= params.length) {
            ourLog.warn("index out of parameter range (should never happen");
            return null;
        }
        if (params[index] instanceof Set) {
            return (Set)params[index];
        }
        if (params[index] instanceof Iterable) {
            HashSet<Include> includes = new HashSet<Include>();
            for (Object o : (Iterable)params[index]) {
                if (!(o instanceof Include)) continue;
                includes.add((Include)o);
            }
            return includes;
        }
        ourLog.warn("include params wasn't Set or Iterable, it was {}", params[index].getClass());
        return null;
    }

    public abstract String getResourceName();

    public abstract RestOperationTypeEnum getRestOperationType();

    public RestOperationTypeEnum getRestOperationType(RequestDetails theRequestDetails) {
        return this.getRestOperationType();
    }

    public abstract boolean incomingServerRequestMatchesMethod(RequestDetails var1);

    public abstract BaseHttpClientInvocation invokeClient(Object[] var1) throws InternalErrorException;

    public abstract void invokeServer(RestfulServer var1, RequestDetails var2) throws BaseServerResponseException, IOException;

    protected final Object invokeServerMethod(RestfulServer theServer, RequestDetails theRequest, Object[] theMethodParams) {
        RestOperationTypeEnum operationType = this.getRestOperationType(theRequest);
        if (operationType != null) {
            for (IServerInterceptor next : theServer.getInterceptors()) {
                IServerInterceptor.ActionRequestDetails details = new IServerInterceptor.ActionRequestDetails(theRequest);
                this.populateActionRequestDetailsForInterceptor(theRequest, details, theMethodParams);
                next.incomingRequestPreHandled(operationType, details);
            }
        }
        try {
            Method method = this.getMethod();
            return method.invoke(this.getProvider(), theMethodParams);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof BaseServerResponseException) {
                throw (BaseServerResponseException)e.getCause();
            }
            throw new InternalErrorException("Failed to call access method", (Throwable)e);
        }
        catch (Exception e) {
            throw new InternalErrorException("Failed to call access method", (Throwable)e);
        }
    }

    public boolean isSupportsConditional() {
        return this.mySupportsConditional;
    }

    public boolean isSupportsConditionalMultiple() {
        return this.mySupportsConditionalMultiple;
    }

    protected byte[] loadRequestContents(RequestDetails theRequest) throws IOException {
        IRequestReader reader = ourRequestReader;
        if (reader == null) {
            try {
                Class.forName("javax.servlet.ServletInputStream");
                String className = BaseMethodBinding.class.getName() + "$" + "ActiveRequestReader";
                try {
                    reader = (IRequestReader)Class.forName(className).newInstance();
                }
                catch (Exception e1) {
                    throw new ConfigurationException("Failed to instantiate class " + className, e1);
                }
            }
            catch (ClassNotFoundException e) {
                String className = BaseMethodBinding.class.getName() + "$" + "InactiveRequestReader";
                try {
                    reader = (IRequestReader)Class.forName(className).newInstance();
                }
                catch (Exception e1) {
                    throw new ConfigurationException("Failed to instantiate class " + className, e1);
                }
            }
            ourRequestReader = reader;
        }
        InputStream inputStream = reader.getInputStream(theRequest);
        byte[] requestContents = IOUtils.toByteArray((InputStream)inputStream);
        theRequest.setRawRequest(requestContents);
        return requestContents;
    }

    protected void populateActionRequestDetailsForInterceptor(RequestDetails theRequestDetails, IServerInterceptor.ActionRequestDetails theDetails, Object[] theMethodParams) {
    }

    protected BaseServerResponseException processNon2xxResponseAndReturnExceptionToThrow(int theStatusCode, String theResponseMimeType, Reader theResponseReader) {
        BaseServerResponseException ex;
        switch (theStatusCode) {
            case 400: {
                ex = new InvalidRequestException("Server responded with HTTP 400");
                break;
            }
            case 404: {
                ex = new ResourceNotFoundException("Server responded with HTTP 404");
                break;
            }
            case 405: {
                ex = new MethodNotAllowedException("Server responded with HTTP 405");
                break;
            }
            case 409: {
                ex = new ResourceVersionConflictException("Server responded with HTTP 409");
                break;
            }
            case 412: {
                ex = new PreconditionFailedException("Server responded with HTTP 412");
                break;
            }
            case 422: {
                IParser parser = this.createAppropriateParserForParsingResponse(theResponseMimeType, theResponseReader, theStatusCode);
                BaseOperationOutcome operationOutcome = (BaseOperationOutcome)parser.parseResource(theResponseReader);
                ex = new UnprocessableEntityException(this.myContext, (IBaseOperationOutcome)operationOutcome);
                break;
            }
            default: {
                ex = new UnclassifiedServerFailureException(theStatusCode, "Server responded with HTTP " + theStatusCode);
            }
        }
        BaseMethodBinding.populateException(ex, theResponseReader);
        return ex;
    }

    public void setParameters(List<IParameter> theParameters) {
        this.myParameters = theParameters;
    }

    protected IBundleProvider toResourceList(Object response) throws InternalErrorException {
        if (response == null) {
            return BundleProviders.newEmptyList();
        }
        if (response instanceof IBundleProvider) {
            return (IBundleProvider)response;
        }
        if (response instanceof IBaseResource) {
            return BundleProviders.newList((IBaseResource)response);
        }
        if (response instanceof Collection) {
            ArrayList<IBaseResource> retVal = new ArrayList<IBaseResource>();
            for (Object next : (Collection)response) {
                retVal.add((IBaseResource)next);
            }
            return BundleProviders.newList(retVal);
        }
        if (response instanceof MethodOutcome) {
            IBaseResource retVal = ((MethodOutcome)response).getOperationOutcome();
            if (retVal == null) {
                retVal = (IBaseResource)this.getContext().getResourceDefinition("OperationOutcome").newInstance();
            }
            return BundleProviders.newList(retVal);
        }
        throw new InternalErrorException("Unexpected return type: " + response.getClass().getCanonicalName());
    }

    public static BaseMethodBinding<?> bindMethod(Method theMethod, FhirContext theContext, Object theProvider) {
        Class<IBaseResource> returnType;
        Operation operation;
        Transaction transaction;
        DeleteTags deleteTags;
        AddTags addTags;
        GetTags getTags;
        Validate validate;
        History history;
        Delete delete;
        Update update;
        Create create;
        Metadata conformance;
        Search search;
        Read read = theMethod.getAnnotation(Read.class);
        if (!BaseMethodBinding.verifyMethodHasZeroOrOneOperationAnnotation(theMethod, read, search = theMethod.getAnnotation(Search.class), conformance = theMethod.getAnnotation(Metadata.class), create = theMethod.getAnnotation(Create.class), update = theMethod.getAnnotation(Update.class), delete = theMethod.getAnnotation(Delete.class), history = theMethod.getAnnotation(History.class), validate = theMethod.getAnnotation(Validate.class), getTags = theMethod.getAnnotation(GetTags.class), addTags = theMethod.getAnnotation(AddTags.class), deleteTags = theMethod.getAnnotation(DeleteTags.class), transaction = theMethod.getAnnotation(Transaction.class), operation = theMethod.getAnnotation(Operation.class))) {
            return null;
        }
        Class<? extends IBaseResource> returnTypeFromRp = null;
        if (theProvider instanceof IResourceProvider && !BaseMethodBinding.verifyIsValidResourceReturnType(returnTypeFromRp = ((IResourceProvider)theProvider).getResourceType())) {
            throw new ConfigurationException("getResourceType() from " + IResourceProvider.class.getSimpleName() + " type " + theMethod.getDeclaringClass().getCanonicalName() + " returned " + BaseMethodBinding.toLogString(returnTypeFromRp) + " - Must return a resource type");
        }
        Class<?> returnTypeFromMethod = theMethod.getReturnType();
        if (getTags != null) {
            if (!TagList.class.equals(returnTypeFromMethod)) {
                throw new ConfigurationException("Method '" + theMethod.getName() + "' from type " + theMethod.getDeclaringClass().getCanonicalName() + " is annotated with @" + GetTags.class.getSimpleName() + " but does not return type " + TagList.class.getName());
            }
        } else if (!(MethodOutcome.class.equals(returnTypeFromMethod) || IBundleProvider.class.equals(returnTypeFromMethod) || Bundle.class.equals(returnTypeFromMethod) || Void.TYPE.equals(returnTypeFromMethod))) {
            if (Collection.class.isAssignableFrom(returnTypeFromMethod)) {
                returnTypeFromMethod = ReflectionUtil.getGenericCollectionTypeOfMethodReturnType(theMethod);
                if (!BaseMethodBinding.verifyIsValidResourceReturnType(returnTypeFromMethod) && !BaseMethodBinding.isResourceInterface(returnTypeFromMethod)) {
                    throw new ConfigurationException("Method '" + theMethod.getName() + "' from " + IResourceProvider.class.getSimpleName() + " type " + theMethod.getDeclaringClass().getCanonicalName() + " returns a collection with generic type " + BaseMethodBinding.toLogString(returnTypeFromMethod) + " - Must return a resource type or a collection (List, Set) with a resource type parameter (e.g. List<Patient> or List<IBaseResource> )");
                }
            } else if (!BaseMethodBinding.isResourceInterface(returnTypeFromMethod) && !BaseMethodBinding.verifyIsValidResourceReturnType(returnTypeFromMethod)) {
                throw new ConfigurationException("Method '" + theMethod.getName() + "' from " + IResourceProvider.class.getSimpleName() + " type " + theMethod.getDeclaringClass().getCanonicalName() + " returns " + BaseMethodBinding.toLogString(returnTypeFromMethod) + " - Must return a resource type (eg Patient, " + Bundle.class.getSimpleName() + ", " + IBundleProvider.class.getSimpleName() + ", etc., see the documentation for more details)");
            }
        }
        Class<IBaseResource> returnTypeFromAnnotation = IBaseResource.class;
        if (read != null) {
            returnTypeFromAnnotation = read.type();
        } else if (search != null) {
            returnTypeFromAnnotation = search.type();
        } else if (history != null) {
            returnTypeFromAnnotation = history.type();
        } else if (delete != null) {
            returnTypeFromAnnotation = delete.type();
        } else if (create != null) {
            returnTypeFromAnnotation = create.type();
        } else if (update != null) {
            returnTypeFromAnnotation = update.type();
        } else if (validate != null) {
            returnTypeFromAnnotation = validate.type();
        } else if (getTags != null) {
            returnTypeFromAnnotation = getTags.type();
        } else if (addTags != null) {
            returnTypeFromAnnotation = addTags.type();
        } else if (deleteTags != null) {
            returnTypeFromAnnotation = deleteTags.type();
        }
        if (returnTypeFromRp != null) {
            if (returnTypeFromAnnotation != null && !BaseMethodBinding.isResourceInterface(returnTypeFromAnnotation)) {
                if (!returnTypeFromRp.isAssignableFrom(returnTypeFromAnnotation)) {
                    throw new ConfigurationException("Method '" + theMethod.getName() + "' in type " + theMethod.getDeclaringClass().getCanonicalName() + " returns type " + returnTypeFromMethod.getCanonicalName() + " - Must return " + returnTypeFromRp.getCanonicalName() + " (or a subclass of it) per IResourceProvider contract");
                }
                if (!returnTypeFromRp.isAssignableFrom(returnTypeFromAnnotation)) {
                    throw new ConfigurationException("Method '" + theMethod.getName() + "' in type " + theMethod.getDeclaringClass().getCanonicalName() + " claims to return type " + returnTypeFromAnnotation.getCanonicalName() + " per method annotation - Must return " + returnTypeFromRp.getCanonicalName() + " (or a subclass of it) per IResourceProvider contract");
                }
                returnType = returnTypeFromAnnotation;
            } else {
                returnType = returnTypeFromRp;
            }
        } else if (!BaseMethodBinding.isResourceInterface(returnTypeFromAnnotation)) {
            if (!BaseMethodBinding.verifyIsValidResourceReturnType(returnTypeFromAnnotation)) {
                throw new ConfigurationException("Method '" + theMethod.getName() + "' from " + IResourceProvider.class.getSimpleName() + " type " + theMethod.getDeclaringClass().getCanonicalName() + " returns " + BaseMethodBinding.toLogString(returnTypeFromAnnotation) + " according to annotation - Must return a resource type");
            }
            returnType = returnTypeFromAnnotation;
        } else {
            returnType = returnTypeFromMethod;
        }
        if (read != null) {
            return new ReadMethodBinding((Class<? extends IBaseResource>)returnType, theMethod, theContext, theProvider);
        }
        if (search != null) {
            if (search.dynamic()) {
                IDynamicSearchResourceProvider provider = (IDynamicSearchResourceProvider)theProvider;
                return new DynamicSearchMethodBinding(returnType, theMethod, theContext, provider);
            }
            return new SearchMethodBinding((Class<? extends IBaseResource>)returnType, theMethod, theContext, theProvider);
        }
        if (conformance != null) {
            return new ConformanceMethodBinding(theMethod, theContext, theProvider);
        }
        if (create != null) {
            return new CreateMethodBinding(theMethod, theContext, theProvider);
        }
        if (update != null) {
            return new UpdateMethodBinding(theMethod, theContext, theProvider);
        }
        if (delete != null) {
            return new DeleteMethodBinding(theMethod, theContext, theProvider);
        }
        if (history != null) {
            return new HistoryMethodBinding(theMethod, theContext, theProvider);
        }
        if (validate != null) {
            if (theContext.getVersion().getVersion() == FhirVersionEnum.DSTU1) {
                return new ValidateMethodBindingDstu1(theMethod, theContext, theProvider);
            }
            return new ValidateMethodBindingDstu2(returnType, returnTypeFromRp, theMethod, theContext, theProvider, validate);
        }
        if (getTags != null) {
            return new GetTagsMethodBinding(theMethod, theContext, theProvider, getTags);
        }
        if (addTags != null) {
            return new AddTagsMethodBinding(theMethod, theContext, theProvider, addTags);
        }
        if (deleteTags != null) {
            return new DeleteTagsMethodBinding(theMethod, theContext, theProvider, deleteTags);
        }
        if (transaction != null) {
            return new TransactionMethodBinding(theMethod, theContext, theProvider);
        }
        if (operation != null) {
            return new OperationMethodBinding(returnType, returnTypeFromRp, theMethod, theContext, theProvider, operation);
        }
        throw new ConfigurationException("Did not detect any FHIR annotations on method '" + theMethod.getName() + "' on type: " + theMethod.getDeclaringClass().getCanonicalName());
    }

    private static boolean isResourceInterface(Class<?> theReturnTypeFromMethod) {
        return theReturnTypeFromMethod.equals(IBaseResource.class) || theReturnTypeFromMethod.equals(IResource.class) || theReturnTypeFromMethod.equals(IAnyResource.class);
    }

    private static void populateException(BaseServerResponseException theEx, Reader theResponseReader) {
        try {
            String responseText = IOUtils.toString((Reader)theResponseReader);
            theEx.setResponseBody(responseText);
        }
        catch (IOException e) {
            ourLog.debug("Failed to read response", (Throwable)e);
        }
    }

    private static String toLogString(Class<?> theType) {
        if (theType == null) {
            return null;
        }
        return theType.getCanonicalName();
    }

    private static boolean verifyIsValidResourceReturnType(Class<?> theReturnType) {
        if (theReturnType == null) {
            return false;
        }
        return IBaseResource.class.isAssignableFrom(theReturnType);
    }

    public static boolean verifyMethodHasZeroOrOneOperationAnnotation(Method theNextMethod, Object ... theAnnotations) {
        Object obj1 = null;
        for (Object object : theAnnotations) {
            if (object == null) continue;
            if (obj1 == null) {
                obj1 = object;
                continue;
            }
            throw new ConfigurationException("Method " + theNextMethod.getName() + " on type '" + theNextMethod.getDeclaringClass().getSimpleName() + " has annotations @" + obj1.getClass().getSimpleName() + " and @" + object.getClass().getSimpleName() + ". Can not have both.");
        }
        return obj1 != null;
    }

    private static interface IRequestReader {
        public InputStream getInputStream(RequestDetails var1) throws IOException;
    }

    static class InactiveRequestReader
    implements IRequestReader {
        InactiveRequestReader() {
        }

        @Override
        public InputStream getInputStream(RequestDetails theRequestDetails) {
            throw new IllegalStateException("The servlet-api JAR is not found on the classpath. Please check that this library is available.");
        }
    }

    static class ActiveRequestReader
    implements IRequestReader {
        ActiveRequestReader() {
        }

        @Override
        public InputStream getInputStream(RequestDetails theRequestDetails) throws IOException {
            return theRequestDetails.getServletRequest().getInputStream();
        }
    }
}

