/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.rest.annotation.ResourceParam;
import ca.uhn.fhir.rest.client.BaseHttpClientInvocation;
import ca.uhn.fhir.rest.method.BaseOutcomeReturningMethodBinding;
import ca.uhn.fhir.rest.method.IParameter;
import ca.uhn.fhir.rest.method.MethodUtil;
import ca.uhn.fhir.rest.method.RequestDetails;
import ca.uhn.fhir.rest.param.ResourceParameter;
import ca.uhn.fhir.rest.server.IResourceProvider;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.interceptor.IServerInterceptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;

abstract class BaseOutcomeReturningMethodBindingWithResourceParam
extends BaseOutcomeReturningMethodBinding {
    private Integer myIdParamIndex;
    private String myResourceName;
    private int myResourceParameterIndex = -1;
    private Class<? extends IBaseResource> myResourceType;
    private Class<? extends IIdType> myIdParamType;

    public BaseOutcomeReturningMethodBindingWithResourceParam(Method theMethod, FhirContext theContext, Class<?> theMethodAnnotation, Object theProvider) {
        super(theMethod, theContext, theMethodAnnotation, theProvider);
        ResourceParameter resourceParameter = null;
        int index = 0;
        for (IParameter next : this.getParameters()) {
            if (next instanceof ResourceParameter) {
                resourceParameter = (ResourceParameter)next;
                if (resourceParameter.getMode() != ResourceParameter.Mode.RESOURCE) continue;
                if (this.myResourceType != null) {
                    throw new ConfigurationException("Method " + theMethod.getName() + " on type " + theMethod.getDeclaringClass() + " has more than one @ResourceParam. Only one is allowed.");
                }
                this.myResourceType = resourceParameter.getResourceType();
                this.myResourceParameterIndex = index;
            }
            ++index;
        }
        if ((this.myResourceType == null || Modifier.isAbstract(this.myResourceType.getModifiers())) && theProvider instanceof IResourceProvider) {
            this.myResourceType = ((IResourceProvider)theProvider).getResourceType();
        }
        if (this.myResourceType == null) {
            throw new ConfigurationException("Unable to determine resource type for method: " + theMethod);
        }
        this.myResourceName = theContext.getResourceDefinition(this.myResourceType).getName();
        this.myIdParamIndex = MethodUtil.findIdParameterIndex(theMethod);
        if (this.myIdParamIndex != null) {
            this.myIdParamType = theMethod.getParameterTypes()[this.myIdParamIndex];
        }
        if (resourceParameter == null) {
            throw new ConfigurationException("Method " + theMethod.getName() + " in type " + theMethod.getDeclaringClass().getCanonicalName() + " does not have a resource parameter annotated with @" + ResourceParam.class.getSimpleName());
        }
    }

    @Override
    protected void populateActionRequestDetailsForInterceptor(RequestDetails theRequestDetails, IServerInterceptor.ActionRequestDetails theDetails, Object[] theMethodParams) {
        super.populateActionRequestDetailsForInterceptor(theRequestDetails, theDetails, theMethodParams);
        if (this.myResourceParameterIndex != -1) {
            theDetails.setResource((IBaseResource)theMethodParams[this.myResourceParameterIndex]);
        } else {
            theDetails.setResource(ResourceParameter.parseResourceFromRequest(theRequestDetails, this, this.myResourceType));
        }
    }

    @Override
    protected void addParametersForServerRequest(RequestDetails theRequest, Object[] theParams) {
        if (this.myIdParamIndex != null) {
            theParams[this.myIdParamIndex.intValue()] = MethodUtil.convertIdToType(theRequest.getId(), this.myIdParamType);
        }
    }

    @Override
    public String getResourceName() {
        return this.myResourceName;
    }

    @Override
    public BaseHttpClientInvocation invokeClient(Object[] theArgs) throws InternalErrorException {
        IResource resource = (IResource)theArgs[this.myResourceParameterIndex];
        if (resource == null) {
            throw new NullPointerException("Resource can not be null");
        }
        BaseHttpClientInvocation retVal = this.createClientInvocation(theArgs, resource);
        return retVal;
    }
}

