/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.method;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.method.BaseMethodBinding;
import ca.uhn.fhir.rest.method.IParameter;
import ca.uhn.fhir.rest.method.RequestDetails;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBaseResource;

class ConditionalParamBinder
implements IParameter {
    private RestOperationTypeEnum myOperationType;
    private boolean mySupportsMultiple;

    ConditionalParamBinder(RestOperationTypeEnum theOperationType, boolean theSupportsMultiple) {
        Validate.notNull((Object)((Object)theOperationType), (String)"theOperationType can not be null", (Object[])new Object[0]);
        this.myOperationType = theOperationType;
        this.mySupportsMultiple = theSupportsMultiple;
    }

    @Override
    public void initializeTypes(Method theMethod, Class<? extends Collection<?>> theOuterCollectionType, Class<? extends Collection<?>> theInnerCollectionType, Class<?> theParameterType) {
    }

    public boolean isSupportsMultiple() {
        return this.mySupportsMultiple;
    }

    @Override
    public void translateClientArgumentIntoQueryArgument(FhirContext theContext, Object theSourceClientArgument, Map<String, List<String>> theTargetQueryArguments, IBaseResource theTargetResource) throws InternalErrorException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object translateQueryParametersIntoServerArgument(RequestDetails theRequest, byte[] theRequestContents, BaseMethodBinding<?> theMethodBinding) throws InternalErrorException, InvalidRequestException {
        if (this.myOperationType == RestOperationTypeEnum.CREATE) {
            String retVal = theRequest.getServletRequest().getHeader("If-None-Exist");
            if (StringUtils.isBlank((CharSequence)retVal)) {
                return null;
            }
            if (retVal.startsWith(theRequest.getFhirServerBase())) {
                retVal = retVal.substring(theRequest.getFhirServerBase().length());
            }
            return retVal;
        }
        if (this.myOperationType != RestOperationTypeEnum.DELETE && this.myOperationType != RestOperationTypeEnum.UPDATE) {
            return null;
        }
        if (theRequest.getId() != null && theRequest.getId().hasIdPart()) {
            return null;
        }
        boolean haveParam = false;
        for (String next : theRequest.getParameters().keySet()) {
            if (next.startsWith("_")) continue;
            haveParam = true;
            break;
        }
        if (!haveParam) {
            return null;
        }
        int questionMarkIndex = theRequest.getCompleteUrl().indexOf(63);
        return theRequest.getResourceName() + theRequest.getCompleteUrl().substring(questionMarkIndex);
    }
}

