/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.valueset.BundleTypeEnum;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.method.BaseResourceReturningMethodBinding;
import ca.uhn.fhir.rest.method.HttpGetClientInvocation;
import ca.uhn.fhir.rest.method.IParameter;
import ca.uhn.fhir.rest.method.MethodUtil;
import ca.uhn.fhir.rest.method.RequestDetails;
import ca.uhn.fhir.rest.server.IBundleProvider;
import ca.uhn.fhir.rest.server.RestfulServer;
import ca.uhn.fhir.rest.server.SimpleBundleProvider;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import java.lang.reflect.Method;
import org.hl7.fhir.instance.model.api.IBaseConformance;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class ConformanceMethodBinding
extends BaseResourceReturningMethodBinding {
    public ConformanceMethodBinding(Method theMethod, FhirContext theContext, Object theProvider) {
        super(theMethod.getReturnType(), theMethod, theContext, theProvider);
        BaseResourceReturningMethodBinding.MethodReturnTypeEnum methodReturnType = this.getMethodReturnType();
        Class genericReturnType = (Class)theMethod.getGenericReturnType();
        if (methodReturnType != BaseResourceReturningMethodBinding.MethodReturnTypeEnum.RESOURCE || !IBaseConformance.class.isAssignableFrom(genericReturnType)) {
            throw new ConfigurationException("Conformance resource provider method '" + theMethod.getName() + "' should return a Conformance resource class, returns: " + theMethod.getReturnType());
        }
    }

    @Override
    public BaseResourceReturningMethodBinding.ReturnTypeEnum getReturnType() {
        return BaseResourceReturningMethodBinding.ReturnTypeEnum.RESOURCE;
    }

    @Override
    public HttpGetClientInvocation invokeClient(Object[] theArgs) throws InternalErrorException {
        HttpGetClientInvocation retVal = MethodUtil.createConformanceInvocation();
        if (theArgs != null) {
            for (int idx = 0; idx < theArgs.length; ++idx) {
                IParameter nextParam = this.getParameters().get(idx);
                nextParam.translateClientArgumentIntoQueryArgument(this.getContext(), theArgs[idx], null, null);
            }
        }
        return retVal;
    }

    @Override
    public IBundleProvider invokeServer(RestfulServer theServer, RequestDetails theRequest, Object[] theMethodParams) throws BaseServerResponseException {
        IBaseResource conf = (IBaseResource)this.invokeServerMethod(theServer, theRequest, theMethodParams);
        return new SimpleBundleProvider(conf);
    }

    @Override
    public boolean incomingServerRequestMatchesMethod(RequestDetails theRequest) {
        if (theRequest.getRequestType() == RequestTypeEnum.OPTIONS) {
            return true;
        }
        return theRequest.getRequestType() == RequestTypeEnum.GET && "metadata".equals(theRequest.getOperation());
    }

    @Override
    public RestOperationTypeEnum getRestOperationType() {
        return RestOperationTypeEnum.METADATA;
    }

    @Override
    protected BundleTypeEnum getResponseBundleType() {
        return null;
    }
}

