/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.annotation.Delete;
import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.annotation.VersionIdParam;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.client.BaseHttpClientInvocation;
import ca.uhn.fhir.rest.method.BaseOutcomeReturningMethodBinding;
import ca.uhn.fhir.rest.method.HttpDeleteClientInvocation;
import ca.uhn.fhir.rest.method.HttpPostClientInvocation;
import ca.uhn.fhir.rest.method.IParameter;
import ca.uhn.fhir.rest.method.MethodUtil;
import ca.uhn.fhir.rest.method.RequestDetails;
import ca.uhn.fhir.rest.server.IResourceProvider;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hl7.fhir.instance.model.api.IIdType;

public class DeleteMethodBinding
extends BaseOutcomeReturningMethodBinding {
    private String myResourceName;
    private Integer myIdParameterIndex;

    public DeleteMethodBinding(Method theMethod, FhirContext theContext, Object theProvider) {
        super(theMethod, theContext, Delete.class, theProvider);
        RuntimeResourceDefinition def;
        Delete deleteAnnotation = theMethod.getAnnotation(Delete.class);
        Class<? extends IResource> resourceType = deleteAnnotation.type();
        if (resourceType != IResource.class) {
            def = theContext.getResourceDefinition(resourceType);
            this.myResourceName = def.getName();
        } else if (theProvider != null && theProvider instanceof IResourceProvider) {
            def = theContext.getResourceDefinition(((IResourceProvider)theProvider).getResourceType());
            this.myResourceName = def.getName();
        } else {
            throw new ConfigurationException("Can not determine resource type for method '" + theMethod.getName() + "' on type " + theMethod.getDeclaringClass().getCanonicalName() + " - Did you forget to include the resourceType() value on the @" + Delete.class.getSimpleName() + " method annotation?");
        }
        this.myIdParameterIndex = MethodUtil.findIdParameterIndex(theMethod);
        if (this.myIdParameterIndex == null) {
            throw new ConfigurationException("Method '" + theMethod.getName() + "' on type '" + theMethod.getDeclaringClass().getCanonicalName() + "' has no parameter annotated with the @" + IdParam.class.getSimpleName() + " annotation");
        }
        Integer versionIdParameterIndex = MethodUtil.findVersionIdParameterIndex(theMethod);
        if (versionIdParameterIndex != null) {
            throw new ConfigurationException("Method '" + theMethod.getName() + "' on type '" + theMethod.getDeclaringClass().getCanonicalName() + "' has a parameter annotated with the @" + VersionIdParam.class.getSimpleName() + " annotation but delete methods may not have this annotation");
        }
    }

    @Override
    protected boolean allowVoidReturnType() {
        return true;
    }

    @Override
    public RestOperationTypeEnum getRestOperationType() {
        return RestOperationTypeEnum.DELETE;
    }

    @Override
    protected Set<RequestTypeEnum> provideAllowableRequestTypes() {
        return Collections.singleton(RequestTypeEnum.DELETE);
    }

    @Override
    protected BaseHttpClientInvocation createClientInvocation(Object[] theArgs, IResource theResource) {
        StringBuilder urlExtension = new StringBuilder();
        urlExtension.append(this.getContext().getResourceDefinition(theResource).getName());
        return new HttpPostClientInvocation(this.getContext(), theResource, urlExtension.toString());
    }

    @Override
    public String getResourceName() {
        return this.myResourceName;
    }

    @Override
    public BaseHttpClientInvocation invokeClient(Object[] theArgs) throws InternalErrorException {
        IdDt idDt = (IdDt)theArgs[this.myIdParameterIndex];
        if (idDt == null) {
            throw new NullPointerException("ID can not be null");
        }
        if (!idDt.hasResourceType()) {
            idDt = idDt.withResourceType(this.getResourceName());
        } else if (!this.getResourceName().equals(idDt.getResourceType())) {
            throw new InvalidRequestException("ID parameter has the wrong resource type, expected '" + this.getResourceName() + "', found: " + idDt.getResourceType());
        }
        HttpDeleteClientInvocation retVal = DeleteMethodBinding.createDeleteInvocation(idDt);
        for (int idx = 0; idx < theArgs.length; ++idx) {
            IParameter nextParam = this.getParameters().get(idx);
            nextParam.translateClientArgumentIntoQueryArgument(this.getContext(), theArgs[idx], null, null);
        }
        return retVal;
    }

    public static HttpDeleteClientInvocation createDeleteInvocation(IIdType theId) {
        HttpDeleteClientInvocation retVal = new HttpDeleteClientInvocation(theId);
        return retVal;
    }

    @Override
    protected void addParametersForServerRequest(RequestDetails theRequest, Object[] theParams) {
        theParams[this.myIdParameterIndex.intValue()] = theRequest.getId();
    }

    @Override
    protected String getMatchingOperation() {
        return null;
    }

    public static HttpDeleteClientInvocation createDeleteInvocation(String theSearchUrl) {
        HttpDeleteClientInvocation retVal = new HttpDeleteClientInvocation(theSearchUrl);
        return retVal;
    }

    public static HttpDeleteClientInvocation createDeleteInvocation(String theResourceType, Map<String, List<String>> theParams) {
        return new HttpDeleteClientInvocation(theResourceType, theParams);
    }
}

