/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.method;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementCompositeDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.IRuntimeDatatypeDefinition;
import ca.uhn.fhir.context.RuntimeChildPrimitiveDatatypeDefinition;
import ca.uhn.fhir.context.RuntimePrimitiveDatatypeDefinition;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.i18n.HapiLocalizer;
import ca.uhn.fhir.rest.annotation.OperationParam;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.api.ValidationModeEnum;
import ca.uhn.fhir.rest.method.BaseMethodBinding;
import ca.uhn.fhir.rest.method.IParameter;
import ca.uhn.fhir.rest.method.QualifiedParamList;
import ca.uhn.fhir.rest.method.RequestDetails;
import ca.uhn.fhir.rest.param.CollectionBinder;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.ResourceParameter;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.MethodNotAllowedException;
import ca.uhn.fhir.util.FhirTerser;
import ca.uhn.fhir.util.ParametersUtil;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public class OperationParameter
implements IParameter {
    private IConverter myConverter;
    private Class<? extends Collection> myInnerCollectionType;
    private int myMax;
    private int myMin;
    private final String myName;
    private final String myOperationName;
    private Class<?> myParameterType;
    private String myParamType;
    private FhirContext myContext;
    private boolean myAllowGet;

    public OperationParameter(FhirContext theCtx, String theOperationName, OperationParam theOperationParam) {
        this(theCtx, theOperationName, theOperationParam.name(), theOperationParam.min(), theOperationParam.max());
    }

    OperationParameter(FhirContext theCtx, String theOperationName, String theParameterName, int theMin, int theMax) {
        this.myOperationName = theOperationName;
        this.myName = theParameterName;
        this.myMin = theMin;
        this.myMax = theMax;
        this.myContext = theCtx;
    }

    public int getMax() {
        return this.myMax;
    }

    public int getMin() {
        return this.myMin;
    }

    public String getName() {
        return this.myName;
    }

    public String getParamType() {
        return this.myParamType;
    }

    @Override
    public void initializeTypes(Method theMethod, Class<? extends Collection<?>> theOuterCollectionType, Class<? extends Collection<?>> theInnerCollectionType, Class<?> theParameterType) {
        this.myParameterType = theParameterType;
        if (theInnerCollectionType != null) {
            this.myInnerCollectionType = CollectionBinder.getInstantiableCollectionType(theInnerCollectionType, this.myName);
        } else {
            this.myMax = 1;
        }
        boolean bl = this.myAllowGet = IPrimitiveType.class.isAssignableFrom(this.myParameterType) || String.class.equals(this.myParameterType);
        if (!this.myParameterType.equals(IBase.class) && !this.myParameterType.equals(String.class)) {
            if (IBaseResource.class.isAssignableFrom(this.myParameterType) && this.myParameterType.isInterface()) {
                this.myParamType = "Resource";
            } else if (DateRangeParam.class.isAssignableFrom(this.myParameterType)) {
                this.myParamType = "date";
                this.myMax = 2;
                this.myAllowGet = true;
            } else {
                if (!IBase.class.isAssignableFrom(this.myParameterType) || this.myParameterType.isInterface() || Modifier.isAbstract(this.myParameterType.getModifiers())) {
                    throw new ConfigurationException("Invalid type for @OperationParam: " + this.myParameterType.getName());
                }
                this.myParamType = this.myParameterType.equals(ValidationModeEnum.class) ? "code" : this.myContext.getElementDefinition(this.myParameterType).getName();
            }
        }
    }

    public OperationParameter setConverter(IConverter theConverter) {
        this.myConverter = theConverter;
        return this;
    }

    @Override
    public void translateClientArgumentIntoQueryArgument(FhirContext theContext, Object theSourceClientArgument, Map<String, List<String>> theTargetQueryArguments, IBaseResource theTargetResource) throws InternalErrorException {
        assert (theTargetResource != null);
        Object sourceClientArgument = theSourceClientArgument;
        if (sourceClientArgument == null) {
            return;
        }
        if (this.myConverter != null) {
            sourceClientArgument = this.myConverter.outgoingClient(sourceClientArgument);
        }
        ParametersUtil.addParameterToParameters(theContext, theTargetResource, sourceClientArgument, this.myName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object translateQueryParametersIntoServerArgument(RequestDetails theRequest, byte[] theRequestContents, BaseMethodBinding<?> theMethodBinding) throws InternalErrorException, InvalidRequestException {
        ArrayList<Object> matchingParamValues;
        block17: {
            block18: {
                matchingParamValues = new ArrayList<Object>();
                if (theRequest.getRequestType() != RequestTypeEnum.GET) break block18;
                String[] paramValues = theRequest.getParameters().get(this.myName);
                if (paramValues == null || paramValues.length <= 0) break block17;
                if (!this.myAllowGet) {
                    HapiLocalizer localizer = theRequest.getServer().getFhirContext().getLocalizer();
                    String msg = localizer.getMessage(OperationParameter.class, "urlParamNotPrimitive", this.myOperationName, this.myName);
                    throw new MethodNotAllowedException(msg, RequestTypeEnum.POST);
                }
                if (DateRangeParam.class.isAssignableFrom(this.myParameterType)) {
                    ArrayList<QualifiedParamList> parameters = new ArrayList<QualifiedParamList>();
                    parameters.add(QualifiedParamList.singleton(paramValues[0]));
                    if (paramValues.length > 1) {
                        parameters.add(QualifiedParamList.singleton(paramValues[1]));
                    }
                    DateRangeParam dateRangeParam = new DateRangeParam();
                    dateRangeParam.setValuesAsQueryTokens(parameters);
                    matchingParamValues.add(dateRangeParam);
                    break block17;
                } else if (String.class.isAssignableFrom(this.myParameterType)) {
                    for (String next : paramValues) {
                        matchingParamValues.add(next);
                    }
                    break block17;
                } else {
                    for (String nextValue : paramValues) {
                        FhirContext ctx = theRequest.getServer().getFhirContext();
                        RuntimePrimitiveDatatypeDefinition def = (RuntimePrimitiveDatatypeDefinition)ctx.getElementDefinition(this.myParameterType);
                        IPrimitiveType instance = (IPrimitiveType)def.newInstance();
                        instance.setValueAsString(nextValue);
                        matchingParamValues.add(instance);
                    }
                }
                break block17;
            }
            FhirContext ctx = theRequest.getServer().getFhirContext();
            if (theRequest.getRequestType() == RequestTypeEnum.GET) {
                return null;
            }
            Class wantedResourceType = theMethodBinding.getContext().getResourceDefinition("Parameters").getImplementingClass();
            Object requestContents = ResourceParameter.loadResourceFromRequest(theRequest, theMethodBinding, wantedResourceType);
            RuntimeResourceDefinition def = ctx.getResourceDefinition((IBaseResource)requestContents);
            BaseRuntimeChildDefinition paramChild = def.getChildByName("parameter");
            BaseRuntimeElementCompositeDefinition paramChildElem = (BaseRuntimeElementCompositeDefinition)paramChild.getChildByName("parameter");
            RuntimeChildPrimitiveDatatypeDefinition nameChild = (RuntimeChildPrimitiveDatatypeDefinition)paramChildElem.getChildByName("name");
            BaseRuntimeChildDefinition valueChild = paramChildElem.getChildByName("value[x]");
            BaseRuntimeChildDefinition resourceChild = paramChildElem.getChildByName("resource");
            BaseRuntimeChildDefinition.IAccessor paramChildAccessor = paramChild.getAccessor();
            List<IBase> values = paramChildAccessor.getValues(requestContents);
            for (IBase nextParameter : values) {
                IPrimitiveType nextName;
                List<IBase> nextNames = nameChild.getAccessor().getValues(nextParameter);
                if (nextNames == null || nextNames.size() <= 0 || !this.myName.equals((nextName = (IPrimitiveType)nextNames.get(0)).getValueAsString())) continue;
                if (this.myParameterType.isAssignableFrom(nextParameter.getClass())) {
                    matchingParamValues.add(nextParameter);
                    continue;
                }
                List<IBase> paramValues = valueChild.getAccessor().getValues(nextParameter);
                List<IBase> paramResources = resourceChild.getAccessor().getValues(nextParameter);
                if (paramValues != null && paramValues.size() > 0) {
                    this.tryToAddValues(paramValues, matchingParamValues);
                    continue;
                }
                if (paramResources == null || paramResources.size() <= 0) continue;
                this.tryToAddValues(paramResources, matchingParamValues);
            }
        }
        if (matchingParamValues.isEmpty()) {
            return null;
        }
        if (this.myInnerCollectionType == null) {
            return matchingParamValues.get(0);
        }
        try {
            Collection retVal = this.myInnerCollectionType.newInstance();
            retVal.addAll(matchingParamValues);
            return retVal;
        }
        catch (InstantiationException e) {
            throw new InternalErrorException("Failed to instantiate " + this.myInnerCollectionType, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new InternalErrorException("Failed to instantiate " + this.myInnerCollectionType, (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void tryToAddValues(List<IBase> theParamValues, List<Object> theMatchingParamValues) {
        for (IBase iBase : theParamValues) {
            void var4_4;
            if (iBase == null) continue;
            if (this.myConverter != null) {
                Object object = this.myConverter.incomingServer(iBase);
            }
            if (!this.myParameterType.isAssignableFrom(var4_4.getClass())) {
                IRuntimeDatatypeDefinition targetTypeDtDef;
                Class<?> sourceType = var4_4.getClass();
                Class<?> targetType = this.myParameterType;
                BaseRuntimeElementDefinition<?> sourceTypeDef = this.myContext.getElementDefinition(sourceType);
                BaseRuntimeElementDefinition<?> targetTypeDef = this.myContext.getElementDefinition(targetType);
                if (targetTypeDef instanceof IRuntimeDatatypeDefinition && sourceTypeDef instanceof IRuntimeDatatypeDefinition && (targetTypeDtDef = (IRuntimeDatatypeDefinition)((Object)targetTypeDef)).isProfileOf(sourceType)) {
                    FhirTerser terser = this.myContext.newTerser();
                    Object newTarget = targetTypeDef.newInstance();
                    terser.cloneInto((IBase)var4_4, (IBase)newTarget, true);
                    theMatchingParamValues.add(newTarget);
                    continue;
                }
                this.throwWrongParamType(var4_4);
            }
            theMatchingParamValues.add(var4_4);
        }
    }

    private void throwWrongParamType(Object nextValue) {
        throw new InvalidRequestException("Request has parameter " + this.myName + " of type " + nextValue.getClass().getSimpleName() + " but method expects type " + this.myParameterType.getSimpleName());
    }

    public static interface IConverter {
        public Object incomingServer(Object var1);

        public Object outgoingClient(Object var1);
    }
}

