/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.method;

import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.server.RestfulServer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RequestDetails {
    private Map<String, ArrayList<String>> myHeaders = new HashMap<String, ArrayList<String>>();
    private String myCompartmentName;
    private String myCompleteUrl;
    private String myFhirServerBase;
    private IdDt myId;
    private String myOperation;
    private Map<String, String[]> myParameters;
    private byte[] myRawRequest;
    private String myRequestPath;
    private RequestTypeEnum myRequestType;
    private String myResourceName;
    private boolean myRespondGzip;
    private RestOperationTypeEnum myRestOperationType;
    private String mySecondaryOperation;
    private RestfulServer myServer;
    private HttpServletRequest myServletRequest;
    private HttpServletResponse myServletResponse;
    private Map<String, List<String>> myUnqualifiedToQualifiedNames;

    public String getCompartmentName() {
        return this.myCompartmentName;
    }

    public String getCompleteUrl() {
        return this.myCompleteUrl;
    }

    public String getFhirServerBase() {
        return this.myFhirServerBase;
    }

    public IdDt getId() {
        return this.myId;
    }

    public String getOperation() {
        return this.myOperation;
    }

    public Map<String, String[]> getParameters() {
        return this.myParameters;
    }

    public byte[] getRawRequest() {
        return this.myRawRequest;
    }

    public String getRequestPath() {
        return this.myRequestPath;
    }

    public RequestTypeEnum getRequestType() {
        return this.myRequestType;
    }

    public String getResourceName() {
        return this.myResourceName;
    }

    public RestOperationTypeEnum getRestOperationType() {
        return this.myRestOperationType;
    }

    public String getSecondaryOperation() {
        return this.mySecondaryOperation;
    }

    public RestfulServer getServer() {
        return this.myServer;
    }

    public HttpServletRequest getServletRequest() {
        return this.myServletRequest;
    }

    public HttpServletResponse getServletResponse() {
        return this.myServletResponse;
    }

    public Map<String, List<String>> getUnqualifiedToQualifiedNames() {
        return this.myUnqualifiedToQualifiedNames;
    }

    public boolean isRespondGzip() {
        return this.myRespondGzip;
    }

    public void setCompartmentName(String theCompartmentName) {
        this.myCompartmentName = theCompartmentName;
    }

    public void setCompleteUrl(String theCompleteUrl) {
        this.myCompleteUrl = theCompleteUrl;
    }

    public void setFhirServerBase(String theFhirServerBase) {
        this.myFhirServerBase = theFhirServerBase;
    }

    public void setId(IdDt theId) {
        this.myId = theId;
    }

    public void setOperation(String theOperation) {
        this.myOperation = theOperation;
    }

    public void setParameters(Map<String, String[]> theParams) {
        this.myParameters = theParams;
        block0: for (String next : theParams.keySet()) {
            for (int i = 0; i < next.length(); ++i) {
                String unqualified;
                List<String> list;
                char nextChar = next.charAt(i);
                if (nextChar != ':' && nextChar != '.') continue;
                if (this.myUnqualifiedToQualifiedNames == null) {
                    this.myUnqualifiedToQualifiedNames = new HashMap<String, List<String>>();
                }
                if ((list = this.myUnqualifiedToQualifiedNames.get(unqualified = next.substring(0, i))) == null) {
                    list = new ArrayList<String>(4);
                    this.myUnqualifiedToQualifiedNames.put(unqualified, list);
                }
                list.add(next);
                continue block0;
            }
        }
        if (this.myUnqualifiedToQualifiedNames == null) {
            this.myUnqualifiedToQualifiedNames = Collections.emptyMap();
        }
    }

    public void setRawRequest(byte[] theRawRequest) {
        this.myRawRequest = theRawRequest;
    }

    public void setRequestPath(String theRequestPath) {
        assert (theRequestPath.length() == 0 || theRequestPath.charAt(0) != '/');
        this.myRequestPath = theRequestPath;
    }

    public void setRequestType(RequestTypeEnum theRequestType) {
        this.myRequestType = theRequestType;
    }

    public void setResourceName(String theResourceName) {
        this.myResourceName = theResourceName;
    }

    public void setRespondGzip(boolean theRespondGzip) {
        this.myRespondGzip = theRespondGzip;
    }

    public void setRestOperationType(RestOperationTypeEnum theRestOperationType) {
        this.myRestOperationType = theRestOperationType;
    }

    public void setSecondaryOperation(String theSecondaryOperation) {
        this.mySecondaryOperation = theSecondaryOperation;
    }

    public void setServer(RestfulServer theServer) {
        this.myServer = theServer;
    }

    public void setServletRequest(HttpServletRequest theRequest) {
        this.myServletRequest = theRequest;
    }

    public void setServletResponse(HttpServletResponse theServletResponse) {
        this.myServletResponse = theServletResponse;
    }

    public static RequestDetails withResourceAndParams(String theResourceName, RequestTypeEnum theRequestType, Set<String> theParamNames) {
        RequestDetails retVal = new RequestDetails();
        retVal.setResourceName(theResourceName);
        retVal.setRequestType(theRequestType);
        HashMap<String, String[]> paramNames = new HashMap<String, String[]>();
        for (String next : theParamNames) {
            paramNames.put(next, new String[0]);
        }
        retVal.setParameters(paramNames);
        return retVal;
    }

    public void addHeader(String theName, String theValue) {
        String lowerCase = theName.toLowerCase();
        ArrayList<String> list = this.myHeaders.get(lowerCase);
        if (list == null) {
            list = new ArrayList();
            this.myHeaders.put(lowerCase, list);
        }
        list.add(theValue);
    }

    public String getFirstHeader(String theName) {
        ArrayList<String> list = this.myHeaders.get(theName.toLowerCase());
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }
}

