/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.method;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.IQueryParameterOr;
import ca.uhn.fhir.rest.method.IParamBinder;
import ca.uhn.fhir.rest.method.MethodUtil;
import ca.uhn.fhir.rest.method.QualifiedParamList;
import ca.uhn.fhir.rest.param.StringParam;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import java.util.Collections;
import java.util.List;

final class StringBinder
implements IParamBinder<String> {
    StringBinder() {
    }

    @Override
    public List<IQueryParameterOr<?>> encode(FhirContext theContext, Object theString) throws InternalErrorException {
        String retVal = (String)theString;
        List<IQueryParameterOr<?>> retValList = Collections.singletonList(MethodUtil.singleton(new StringParam(retVal)));
        return retValList;
    }

    @Override
    public String parse(String theName, List<QualifiedParamList> theParams) throws InternalErrorException, InvalidRequestException {
        if (theParams.size() == 0 || theParams.get(0).size() == 0) {
            return "";
        }
        if (theParams.size() > 1 || theParams.get(0).size() > 1) {
            throw new InvalidRequestException("Multiple values detected for non-repeatable parameter '" + theName + "'. This server is not configured to allow multiple (AND) values for this param.");
        }
        return (String)theParams.get(0).get(0);
    }
}

