/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ca.uhn.fhir.rest.method.BaseMethodBinding;
import ca.uhn.fhir.rest.method.IParameter;
import ca.uhn.fhir.rest.method.RequestDetails;
import ca.uhn.fhir.rest.param.CollectionBinder;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class SummaryEnumParameter
implements IParameter {
    private Class<? extends Collection> myInnerCollectionType;

    @Override
    public void translateClientArgumentIntoQueryArgument(FhirContext theContext, Object theSourceClientArgument, Map<String, List<String>> theTargetQueryArguments, IBaseResource theTargetResource) throws InternalErrorException {
        if (theSourceClientArgument instanceof Collection) {
            ArrayList<String> values = new ArrayList<String>();
            for (SummaryEnum next : (Collection)theSourceClientArgument) {
                if (next == null) continue;
                values.add(next.getCode());
            }
            theTargetQueryArguments.put("_summary", values);
        } else {
            SummaryEnum ss = (SummaryEnum)((Object)theSourceClientArgument);
            if (ss != null) {
                theTargetQueryArguments.put("_summary", Collections.singletonList(ss.getCode()));
            }
        }
    }

    @Override
    public Object translateQueryParametersIntoServerArgument(RequestDetails theRequest, byte[] theRequestContents, BaseMethodBinding<?> theMethodBinding) throws InternalErrorException, InvalidRequestException {
        Set<SummaryEnum> value = SummaryEnumParameter.getSummaryValueOrNull(theRequest);
        if (value == null || value.isEmpty()) {
            return null;
        }
        if (this.myInnerCollectionType == null) {
            return value.iterator().next();
        }
        try {
            Collection retVal = this.myInnerCollectionType.newInstance();
            retVal.addAll(value);
            return retVal;
        }
        catch (InstantiationException e) {
            throw new InternalErrorException("Failed to instantiate " + this.myInnerCollectionType, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new InternalErrorException("Failed to instantiate " + this.myInnerCollectionType, (Throwable)e);
        }
    }

    public static Set<SummaryEnum> getSummaryValueOrNull(RequestDetails theRequest) {
        Set<Object> retVal;
        String[] summary = theRequest.getParameters().get("_summary");
        if (summary == null || summary.length == 0) {
            retVal = null;
        } else if (StringUtils.isBlank((CharSequence)summary[0])) {
            retVal = null;
        } else if (summary.length == 1) {
            retVal = SummaryEnumParameter.toCollectionOrNull(SummaryEnum.fromCode(summary[0]));
            if (retVal == null) {
                retVal = SummaryEnumParameter.toCollectionOrNull(SummaryEnum.fromCode(summary[0].toLowerCase()));
            }
        } else {
            retVal = new HashSet();
            for (String next : summary) {
                SummaryEnum value = SummaryEnum.fromCode(next);
                if (value == null) {
                    value = SummaryEnum.fromCode(next.toLowerCase());
                }
                if (value == null) continue;
                retVal.add((Object)value);
            }
        }
        if (retVal != null && retVal.contains((Object)SummaryEnum.TEXT) && retVal.size() > 1) {
            String msg = theRequest.getServer().getFhirContext().getLocalizer().getMessage(SummaryEnumParameter.class, "cantCombineText", new Object[0]);
            throw new InvalidRequestException(msg);
        }
        return retVal;
    }

    private static Set<SummaryEnum> toCollectionOrNull(SummaryEnum theFromCode) {
        if (theFromCode == null) {
            return null;
        }
        return Collections.singleton(theFromCode);
    }

    @Override
    public void initializeTypes(Method theMethod, Class<? extends Collection<?>> theOuterCollectionType, Class<? extends Collection<?>> theInnerCollectionType, Class<?> theParameterType) {
        if (theOuterCollectionType != null) {
            throw new ConfigurationException("Method '" + theMethod.getName() + "' in type '" + theMethod.getDeclaringClass().getCanonicalName() + "' is of type " + SummaryEnum.class + " but can not be a collection of collections");
        }
        if (theInnerCollectionType != null) {
            this.myInnerCollectionType = CollectionBinder.getInstantiableCollectionType(theInnerCollectionType, SummaryEnum.class.getSimpleName());
        }
    }
}

