/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.method;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.annotation.Validate;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.client.BaseHttpClientInvocation;
import ca.uhn.fhir.rest.method.BaseOutcomeReturningMethodBindingWithResourceParam;
import ca.uhn.fhir.rest.method.HttpPostClientInvocation;
import ca.uhn.fhir.rest.method.IParameter;
import ca.uhn.fhir.rest.method.MethodUtil;
import ca.uhn.fhir.rest.method.RequestDetails;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;

public class ValidateMethodBindingDstu1
extends BaseOutcomeReturningMethodBindingWithResourceParam {
    private Integer myIdParameterIndex;

    public ValidateMethodBindingDstu1(Method theMethod, FhirContext theContext, Object theProvider) {
        super(theMethod, theContext, Validate.class, theProvider);
        this.myIdParameterIndex = MethodUtil.findIdParameterIndex(theMethod);
    }

    @Override
    public RestOperationTypeEnum getRestOperationType() {
        return RestOperationTypeEnum.VALIDATE;
    }

    @Override
    protected void addParametersForServerRequest(RequestDetails theRequest, Object[] theParams) {
        if (this.myIdParameterIndex != null) {
            theParams[this.myIdParameterIndex.intValue()] = theRequest.getId();
        }
    }

    @Override
    protected BaseHttpClientInvocation createClientInvocation(Object[] theArgs, IResource theResource) {
        FhirContext context = this.getContext();
        IdDt idDt = null;
        if (this.myIdParameterIndex != null) {
            idDt = (IdDt)theArgs[this.myIdParameterIndex];
        }
        HttpPostClientInvocation retVal = ValidateMethodBindingDstu1.createValidateInvocation(theResource, idDt, context);
        for (int idx = 0; idx < theArgs.length; ++idx) {
            IParameter nextParam = this.getParameters().get(idx);
            nextParam.translateClientArgumentIntoQueryArgument(this.getContext(), theArgs[idx], null, null);
        }
        return retVal;
    }

    public static HttpPostClientInvocation createValidateInvocation(IResource theResource, IdDt theId, FhirContext theContext) {
        StringBuilder urlExtension = new StringBuilder();
        urlExtension.append(theContext.getResourceDefinition(theResource).getName());
        urlExtension.append('/');
        urlExtension.append("_validate");
        if (theId != null && !theId.isEmpty()) {
            String id = theId.getValue();
            urlExtension.append('/');
            urlExtension.append(id);
        }
        HttpPostClientInvocation retVal = new HttpPostClientInvocation(theContext, theResource, urlExtension.toString());
        return retVal;
    }

    @Override
    protected boolean allowVoidReturnType() {
        return true;
    }

    @Override
    protected Set<RequestTypeEnum> provideAllowableRequestTypes() {
        return Collections.singleton(RequestTypeEnum.POST);
    }

    @Override
    protected String getMatchingOperation() {
        return "_validate";
    }
}

