/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.param;

import ca.uhn.fhir.model.api.ICompositeDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.SimpleSetter;
import ca.uhn.fhir.model.base.composite.BaseQuantityDt;
import ca.uhn.fhir.model.dstu.valueset.QuantityCompararatorEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DecimalDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.model.primitive.UriDt;
import ca.uhn.fhir.util.ElementUtil;
import java.math.BigDecimal;
import java.util.List;

class InternalQuantityDt
extends BaseQuantityDt
implements ICompositeDatatype {
    @Child(name="value", type={DecimalDt.class}, order=0, min=0, max=1)
    @Description(shortDefinition="Numerical value (with implicit precision)", formalDefinition="The value of the measured amount. The value includes an implicit precision in the presentation of the value")
    private DecimalDt myValue;
    @Child(name="comparator", type={CodeDt.class}, order=1, min=0, max=1)
    @Description(shortDefinition="< | <= | >= | > - how to understand the value", formalDefinition="How the value should be understood and represented - whether the actual value is greater or less than the stated value due to measurement issues. E.g. if the comparator is \"<\" , then the real value is < stated value")
    private BoundCodeDt<QuantityCompararatorEnum> myComparator;
    @Child(name="units", type={StringDt.class}, order=2, min=0, max=1)
    @Description(shortDefinition="Unit representation", formalDefinition="A human-readable form of the units")
    private StringDt myUnits;
    @Child(name="system", type={UriDt.class}, order=3, min=0, max=1)
    @Description(shortDefinition="System that defines coded unit form", formalDefinition="The identification of the system that provides the coded form of the unit")
    private UriDt mySystem;
    @Child(name="code", type={CodeDt.class}, order=4, min=0, max=1)
    @Description(shortDefinition="Coded form of the unit", formalDefinition="A computer processable form of the units in some unit representation system")
    private CodeDt myCode;

    public InternalQuantityDt() {
    }

    @SimpleSetter
    public InternalQuantityDt(@SimpleSetter.Parameter(name="theValue") double theValue) {
        this.setValue(theValue);
    }

    @SimpleSetter
    public InternalQuantityDt(@SimpleSetter.Parameter(name="theValue") long theValue) {
        this.setValue(theValue);
    }

    @SimpleSetter
    public InternalQuantityDt(@SimpleSetter.Parameter(name="theComparator") QuantityCompararatorEnum theComparator, @SimpleSetter.Parameter(name="theValue") double theValue, @SimpleSetter.Parameter(name="theUnits") String theUnits) {
        this.setValue(theValue);
        this.setComparator(theComparator);
        this.setUnits(theUnits);
    }

    @SimpleSetter
    public InternalQuantityDt(@SimpleSetter.Parameter(name="theComparator") QuantityCompararatorEnum theComparator, @SimpleSetter.Parameter(name="theValue") long theValue, @SimpleSetter.Parameter(name="theUnits") String theUnits) {
        this.setValue(theValue);
        this.setComparator(theComparator);
        this.setUnits(theUnits);
    }

    @SimpleSetter
    public InternalQuantityDt(@SimpleSetter.Parameter(name="theComparator") QuantityCompararatorEnum theComparator, @SimpleSetter.Parameter(name="theValue") double theValue, @SimpleSetter.Parameter(name="theSystem") String theSystem, @SimpleSetter.Parameter(name="theUnits") String theUnits) {
        this.setValue(theValue);
        this.setComparator(theComparator);
        this.setSystem(theSystem);
        this.setUnits(theUnits);
    }

    @SimpleSetter
    public InternalQuantityDt(@SimpleSetter.Parameter(name="theComparator") QuantityCompararatorEnum theComparator, @SimpleSetter.Parameter(name="theValue") long theValue, @SimpleSetter.Parameter(name="theSystem") String theSystem, @SimpleSetter.Parameter(name="theUnits") String theUnits) {
        this.setValue(theValue);
        this.setComparator(theComparator);
        this.setSystem(theSystem);
        this.setUnits(theUnits);
    }

    @Override
    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty(this.myValue, this.myComparator, this.myUnits, this.mySystem, this.myCode);
    }

    @Override
    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, this.myValue, this.myComparator, this.myUnits, this.mySystem, this.myCode);
    }

    @Override
    public DecimalDt getValueElement() {
        if (this.myValue == null) {
            this.myValue = new DecimalDt();
        }
        return this.myValue;
    }

    public InternalQuantityDt setValue(DecimalDt theValue) {
        this.myValue = theValue;
        return this;
    }

    public InternalQuantityDt setValue(long theValue) {
        this.myValue = new DecimalDt(theValue);
        return this;
    }

    public InternalQuantityDt setValue(double theValue) {
        this.myValue = new DecimalDt(theValue);
        return this;
    }

    @Override
    public InternalQuantityDt setValue(BigDecimal theValue) {
        this.myValue = new DecimalDt(theValue);
        return this;
    }

    public BoundCodeDt<QuantityCompararatorEnum> getComparatorElement() {
        if (this.myComparator == null) {
            this.myComparator = new BoundCodeDt<QuantityCompararatorEnum>(QuantityCompararatorEnum.VALUESET_BINDER);
        }
        return this.myComparator;
    }

    public InternalQuantityDt setComparator(BoundCodeDt<QuantityCompararatorEnum> theValue) {
        this.myComparator = theValue;
        return this;
    }

    public InternalQuantityDt setComparator(QuantityCompararatorEnum theValue) {
        this.getComparatorElement().setValueAsEnum(theValue);
        return this;
    }

    @Override
    public StringDt getUnitsElement() {
        if (this.myUnits == null) {
            this.myUnits = new StringDt();
        }
        return this.myUnits;
    }

    public InternalQuantityDt setUnits(StringDt theValue) {
        this.myUnits = theValue;
        return this;
    }

    @Override
    public InternalQuantityDt setUnits(String theString) {
        this.myUnits = new StringDt(theString);
        return this;
    }

    @Override
    public UriDt getSystemElement() {
        if (this.mySystem == null) {
            this.mySystem = new UriDt();
        }
        return this.mySystem;
    }

    public InternalQuantityDt setSystem(UriDt theValue) {
        this.mySystem = theValue;
        return this;
    }

    @Override
    public InternalQuantityDt setSystem(String theUri) {
        this.mySystem = new UriDt(theUri);
        return this;
    }

    @Override
    public CodeDt getCodeElement() {
        if (this.myCode == null) {
            this.myCode = new CodeDt();
        }
        return this.myCode;
    }

    public InternalQuantityDt setCode(CodeDt theValue) {
        this.myCode = theValue;
        return this;
    }

    @Override
    public InternalQuantityDt setCode(String theCode) {
        this.myCode = new CodeDt(theCode);
        return this;
    }

    @Override
    public Boolean getMissing() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setMissing(Boolean theMissing) {
        throw new UnsupportedOperationException();
    }
}

