/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.param;

import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.model.dstu.valueset.QuantityCompararatorEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DecimalDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.model.primitive.UriDt;
import ca.uhn.fhir.rest.param.BaseParam;
import ca.uhn.fhir.rest.param.InternalQuantityDt;
import ca.uhn.fhir.rest.param.ParameterUtil;
import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class QuantityParam
extends BaseParam
implements IQueryParameterType {
    private boolean myApproximate;
    private InternalQuantityDt myQuantity = new InternalQuantityDt();

    public QuantityParam() {
    }

    public QuantityParam(QuantityCompararatorEnum theComparator, BigDecimal theValue, String theSystem, String theUnits) {
        this.setComparator(theComparator);
        this.setValue(theValue);
        this.setSystem(theSystem);
        this.setUnits(theUnits);
    }

    public QuantityParam(QuantityCompararatorEnum theComparator, double theValue, String theSystem, String theUnits) {
        this.setComparator(theComparator);
        this.setValue(theValue);
        this.setSystem(theSystem);
        this.setUnits(theUnits);
    }

    public QuantityParam(QuantityCompararatorEnum theComparator, long theValue, String theSystem, String theUnits) {
        this.setComparator(theComparator);
        this.setValue(theValue);
        this.setSystem(theSystem);
        this.setUnits(theUnits);
    }

    public QuantityParam(String theQuantity) {
        this.setValueAsQueryToken(null, theQuantity);
    }

    public QuantityParam(String theQuantity, String theSystem, String theUnits) {
        this.setValueAsQueryToken(null, theQuantity);
        this.setSystem(theSystem);
        this.setUnits(theUnits);
    }

    private void clear() {
        this.setMissing(null);
        this.myQuantity.setComparator((BoundCodeDt<QuantityCompararatorEnum>)null);
        this.myQuantity.setCode((CodeDt)null);
        this.myQuantity.setSystem((UriDt)null);
        this.myQuantity.setUnits((StringDt)null);
        this.myQuantity.setValue((DecimalDt)null);
        this.myApproximate = false;
    }

    @Override
    String doGetQueryParameterQualifier() {
        return null;
    }

    @Override
    String doGetValueAsQueryToken() {
        StringBuilder b = new StringBuilder();
        if (this.myApproximate) {
            b.append('~');
        } else {
            b.append(StringUtils.defaultString((String)ParameterUtil.escape((String)this.myQuantity.getComparatorElement().getValue())));
        }
        if (!this.myQuantity.getValueElement().isEmpty()) {
            b.append(StringUtils.defaultString((String)ParameterUtil.escape(this.myQuantity.getValueElement().getValueAsString())));
        }
        b.append('|');
        if (!this.myQuantity.getSystemElement().isEmpty()) {
            b.append(StringUtils.defaultString((String)ParameterUtil.escape(this.myQuantity.getSystemElement().getValueAsString())));
        }
        b.append('|');
        if (!this.myQuantity.getUnitsElement().isEmpty()) {
            b.append(StringUtils.defaultString((String)ParameterUtil.escape(this.myQuantity.getUnitsElement().getValueAsString())));
        }
        return b.toString();
    }

    @Override
    void doSetValueAsQueryToken(String theQualifier, String theValue) {
        this.clear();
        if (theValue == null) {
            return;
        }
        List<String> parts = ParameterUtil.splitParameterString(theValue, '|', true);
        if (parts.size() > 0 && StringUtils.isNotBlank((CharSequence)parts.get(0))) {
            if (parts.get(0).startsWith("~")) {
                this.myQuantity.setComparator((QuantityCompararatorEnum)null);
                this.myApproximate = true;
                this.myQuantity.setValue(new BigDecimal(parts.get(0).substring(1)));
            } else if (parts.get(0).startsWith("<=")) {
                this.myQuantity.setComparator(QuantityCompararatorEnum.LESSTHAN_OR_EQUALS);
                this.myQuantity.setValue(new BigDecimal(parts.get(0).substring(2)));
            } else if (parts.get(0).startsWith("<")) {
                this.myQuantity.setComparator(QuantityCompararatorEnum.LESSTHAN);
                String valStr = parts.get(0).substring(1);
                this.myQuantity.setValue(new BigDecimal(valStr));
            } else if (parts.get(0).startsWith(">=")) {
                this.myQuantity.setComparator(QuantityCompararatorEnum.GREATERTHAN_OR_EQUALS);
                this.myQuantity.setValue(new BigDecimal(parts.get(0).substring(2)));
            } else if (parts.get(0).startsWith(">")) {
                this.myQuantity.setComparator(QuantityCompararatorEnum.GREATERTHAN);
                this.myQuantity.setValue(new BigDecimal(parts.get(0).substring(1)));
            } else {
                this.myQuantity.setValue(new BigDecimal(parts.get(0)));
            }
        }
        if (parts.size() > 1 && StringUtils.isNotBlank((CharSequence)parts.get(1))) {
            this.myQuantity.setSystem(parts.get(1));
        }
        if (parts.size() > 2 && StringUtils.isNotBlank((CharSequence)parts.get(2))) {
            this.myQuantity.setUnits(parts.get(2));
        }
    }

    public QuantityCompararatorEnum getComparator() {
        return this.myQuantity.getComparatorElement().getValueAsEnum();
    }

    public UriDt getSystem() {
        return this.myQuantity.getSystemElement();
    }

    public String getUnits() {
        return (String)this.myQuantity.getUnitsElement().getValue();
    }

    public DecimalDt getValue() {
        return this.myQuantity.getValueElement();
    }

    public boolean isApproximate() {
        return this.myApproximate;
    }

    public void setApproximate(boolean theApproximate) {
        this.myApproximate = theApproximate;
        if (theApproximate) {
            this.myQuantity.setComparator((QuantityCompararatorEnum)null);
        }
    }

    public QuantityParam setComparator(QuantityCompararatorEnum theComparator) {
        this.myQuantity.setComparator(theComparator);
        return this;
    }

    public QuantityParam setComparator(String theComparator) {
        if ("~".equals(theComparator)) {
            this.myApproximate = true;
            this.myQuantity.setComparator((QuantityCompararatorEnum)null);
        } else {
            this.myApproximate = false;
            this.myQuantity.setComparator(QuantityCompararatorEnum.VALUESET_BINDER.fromCodeString(theComparator));
        }
        return this;
    }

    public QuantityParam setSystem(String theSystem) {
        this.myQuantity.setSystem(theSystem);
        return this;
    }

    public QuantityParam setSystem(UriDt theSystem) {
        this.myQuantity.setSystem(theSystem);
        return this;
    }

    public QuantityParam setUnits(String theUnits) {
        this.myQuantity.setUnits(theUnits);
        return this;
    }

    public QuantityParam setValue(BigDecimal theValue) {
        this.myQuantity.setValue(theValue);
        return this;
    }

    public QuantityParam setValue(DecimalDt theValue) {
        this.myQuantity.setValue(theValue);
        return this;
    }

    public QuantityParam setValue(double theValue) {
        this.myQuantity.setValue(theValue);
        return this;
    }

    public QuantityParam setValue(long theValue) {
        this.myQuantity.setValue(theValue);
        return this;
    }

    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        b.append("cmp", (Object)this.myQuantity.getComparatorElement().getValueAsString());
        b.append("value", (Object)this.myQuantity.getValueElement().getValueAsString());
        b.append("system", (Object)this.myQuantity.getSystemElement().getValueAsString());
        b.append("units", (Object)this.myQuantity.getUnitsElement().getValueAsString());
        if (this.getMissing() != null) {
            b.append("missing", (Object)this.getMissing());
        }
        return b.toString();
    }
}

