/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.param;

import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.param.BaseParam;
import ca.uhn.fhir.rest.param.ParameterUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class StringParam
extends BaseParam
implements IQueryParameterType {
    private boolean myExact;
    private String myValue;

    public StringParam() {
    }

    public StringParam(String theValue) {
        this.setValue(theValue);
    }

    public StringParam(String theValue, boolean theExact) {
        this.setValue(theValue);
        this.setExact(theExact);
    }

    @Override
    String doGetQueryParameterQualifier() {
        if (this.isExact()) {
            return ":exact";
        }
        return null;
    }

    @Override
    String doGetValueAsQueryToken() {
        return ParameterUtil.escape(this.myValue);
    }

    @Override
    void doSetValueAsQueryToken(String theQualifier, String theValue) {
        if (":exact".equals(theQualifier)) {
            this.setExact(true);
        } else {
            this.setExact(false);
        }
        this.myValue = ParameterUtil.unescape(theValue);
    }

    public String getValue() {
        return this.myValue;
    }

    public StringDt getValueAsStringDt() {
        return new StringDt(this.myValue);
    }

    public String getValueNotNull() {
        return StringUtils.defaultString((String)this.myValue);
    }

    public boolean isEmpty() {
        return StringUtils.isEmpty((CharSequence)this.myValue);
    }

    public boolean isExact() {
        return this.myExact;
    }

    public void setExact(boolean theExact) {
        this.myExact = theExact;
    }

    public void setValue(String theValue) {
        this.myValue = theValue;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        builder.append("value", (Object)this.getValue());
        if (this.myExact) {
            builder.append("exact", this.myExact);
        }
        if (this.getMissing() != null) {
            builder.append("missing", this.getMissing().booleanValue());
        }
        return builder.toString();
    }
}

