/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.param;

import ca.uhn.fhir.model.base.composite.BaseCodingDt;
import ca.uhn.fhir.model.base.composite.BaseIdentifierDt;
import ca.uhn.fhir.rest.param.BaseOrListParam;
import ca.uhn.fhir.rest.param.InternalCodingDt;
import ca.uhn.fhir.rest.param.TokenParam;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.cobertura.CoverageIgnore;

public class TokenOrListParam
extends BaseOrListParam<TokenParam> {
    public TokenOrListParam() {
    }

    public TokenOrListParam(String theSystem, String ... theValues) {
        for (String next : theValues) {
            this.add(theSystem, next);
        }
    }

    public void add(BaseCodingDt theCodingDt) {
        this.add(new TokenParam(theCodingDt));
    }

    public void add(BaseIdentifierDt theIdentifierDt) {
        this.add(new TokenParam(theIdentifierDt));
    }

    public void add(String theSystem, String theValue) {
        this.add(new TokenParam(theSystem, theValue));
    }

    public List<BaseCodingDt> getListAsCodings() {
        ArrayList<BaseCodingDt> retVal = new ArrayList<BaseCodingDt>();
        for (TokenParam next : this.getValuesAsQueryTokens()) {
            InternalCodingDt nextCoding = next.getValueAsCoding();
            if (nextCoding.isEmpty()) continue;
            retVal.add(nextCoding);
        }
        return retVal;
    }

    @Override
    @CoverageIgnore
    TokenParam newInstance() {
        return new TokenParam();
    }

    public boolean doesCodingListMatch(List<? extends BaseCodingDt> theCodings) {
        List<BaseCodingDt> paramCodings = this.getListAsCodings();
        for (BaseCodingDt baseCodingDt : theCodings) {
            for (BaseCodingDt paramCoding : paramCodings) {
                if (!baseCodingDt.matchesToken(paramCoding)) continue;
                return true;
            }
        }
        return false;
    }

    @CoverageIgnore
    public TokenOrListParam addOr(TokenParam theParameter) {
        this.add(theParameter);
        return this;
    }
}

