/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.param;

import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.model.base.composite.BaseCodingDt;
import ca.uhn.fhir.model.base.composite.BaseIdentifierDt;
import ca.uhn.fhir.model.primitive.UriDt;
import ca.uhn.fhir.rest.param.BaseParam;
import ca.uhn.fhir.rest.param.InternalCodingDt;
import ca.uhn.fhir.rest.param.ParameterUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class TokenParam
extends BaseParam
implements IQueryParameterType {
    private String mySystem;
    private boolean myText;
    private String myValue;

    public TokenParam() {
    }

    public TokenParam(BaseCodingDt theCodingDt) {
        this(TokenParam.toSystemValue(theCodingDt.getSystemElement()), (String)theCodingDt.getCodeElement().getValue());
    }

    public TokenParam(BaseIdentifierDt theIdentifierDt) {
        this(TokenParam.toSystemValue(theIdentifierDt.getSystemElement()), (String)theIdentifierDt.getValueElement().getValue());
    }

    public TokenParam(String theSystem, String theValue) {
        this.setSystem(theSystem);
        this.setValue(theValue);
    }

    public TokenParam(String theSystem, String theValue, boolean theText) {
        if (theText && StringUtils.isNotBlank((CharSequence)theSystem)) {
            throw new IllegalArgumentException("theSystem can not be non-blank if theText is true (:text searches do not include a system). In other words, set the first parameter to null for a text search");
        }
        this.setSystem(theSystem);
        this.setValue(theValue);
        this.setText(theText);
    }

    @Override
    String doGetQueryParameterQualifier() {
        if (this.isText()) {
            return ":text";
        }
        return null;
    }

    @Override
    String doGetValueAsQueryToken() {
        if (this.getSystem() != null) {
            return ParameterUtil.escape(StringUtils.defaultString((String)this.getSystem())) + '|' + ParameterUtil.escape(this.getValue());
        }
        return ParameterUtil.escape(this.getValue());
    }

    @Override
    void doSetValueAsQueryToken(String theQualifier, String theParameter) {
        this.setText(":text".equals(theQualifier));
        this.setSystem(null);
        if (theParameter == null) {
            this.setValue(null);
        } else {
            int barIndex = ParameterUtil.nonEscapedIndexOf(theParameter, '|');
            if (barIndex != -1) {
                this.setSystem(theParameter.substring(0, barIndex));
                this.setValue(ParameterUtil.unescape(theParameter.substring(barIndex + 1)));
            } else {
                this.setValue(ParameterUtil.unescape(theParameter));
            }
        }
    }

    public String getSystem() {
        return this.mySystem;
    }

    public String getValue() {
        return this.myValue;
    }

    public InternalCodingDt getValueAsCoding() {
        return new InternalCodingDt(this.mySystem, this.myValue);
    }

    public String getValueNotNull() {
        return StringUtils.defaultString((String)this.myValue);
    }

    public boolean isEmpty() {
        return StringUtils.isEmpty((CharSequence)this.myValue);
    }

    public boolean isText() {
        return this.myText;
    }

    public void setSystem(String theSystem) {
        this.mySystem = theSystem;
    }

    public void setText(boolean theText) {
        this.myText = theText;
    }

    public void setValue(String theValue) {
        this.myValue = theValue;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        builder.append("system", (Object)StringUtils.defaultString((String)this.getSystem()));
        builder.append("value", (Object)this.getValue());
        if (this.myText) {
            builder.append(":text", this.myText);
        }
        if (this.getMissing() != null) {
            builder.append(":missing", (Object)this.getMissing());
        }
        return builder.toString();
    }

    private static String toSystemValue(UriDt theSystem) {
        return theSystem.getValueAsString();
    }
}

