/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.param;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.model.api.Bundle;
import ca.uhn.fhir.model.api.BundleEntry;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.rest.annotation.TransactionParam;
import ca.uhn.fhir.rest.method.BaseMethodBinding;
import ca.uhn.fhir.rest.method.IParameter;
import ca.uhn.fhir.rest.method.RequestDetails;
import ca.uhn.fhir.rest.param.ResourceParameter;
import ca.uhn.fhir.rest.server.EncodingEnum;
import ca.uhn.fhir.rest.server.RestfulServerUtils;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import java.io.Reader;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class TransactionParameter
implements IParameter {
    private FhirContext myContext;
    private ParamStyle myParamStyle;
    private Class<? extends IBaseResource> myResourceBundleType;

    public TransactionParameter(FhirContext theContext) {
        this.myContext = theContext;
    }

    private String createParameterTypeError(Method theMethod) {
        return "Method '" + theMethod.getName() + "' in type '" + theMethod.getDeclaringClass().getCanonicalName() + "' is annotated with @" + TransactionParam.class.getName() + " but is not of type List<" + IResource.class.getCanonicalName() + "> or Bundle";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void initializeTypes(Method theMethod, Class<? extends Collection<?>> theOuterCollectionType, Class<? extends Collection<?>> theInnerCollectionType, Class<?> theParameterType) {
        if (theOuterCollectionType != null) {
            throw new ConfigurationException("Method '" + theMethod.getName() + "' in type '" + theMethod.getDeclaringClass().getCanonicalName() + "' is annotated with @" + TransactionParam.class.getName() + " but can not be a collection of collections");
        }
        if (theParameterType.equals(Bundle.class)) {
            this.myParamStyle = ParamStyle.DSTU1_BUNDLE;
            if (theInnerCollectionType == null) return;
            throw new ConfigurationException(this.createParameterTypeError(theMethod));
        }
        if (!Modifier.isInterface(theParameterType.getModifiers()) && IBaseResource.class.isAssignableFrom(theParameterType)) {
            Class<?> parameterType = theParameterType;
            RuntimeResourceDefinition def = this.myContext.getResourceDefinition(parameterType);
            if (!"Bundle".equals(def.getName())) throw new ConfigurationException(this.createParameterTypeError(theMethod));
            this.myParamStyle = ParamStyle.RESOURCE_BUNDLE;
            this.myResourceBundleType = parameterType;
            return;
        } else {
            if (!theInnerCollectionType.equals(List.class)) {
                throw new ConfigurationException(this.createParameterTypeError(theMethod));
            }
            if (!theParameterType.equals(IResource.class)) {
                throw new ConfigurationException(this.createParameterTypeError(theMethod));
            }
            this.myParamStyle = ParamStyle.RESOURCE_LIST;
        }
    }

    @Override
    public void translateClientArgumentIntoQueryArgument(FhirContext theContext, Object theSourceClientArgument, Map<String, List<String>> theTargetQueryArguments, IBaseResource theTargetResource) throws InternalErrorException {
    }

    @Override
    public Object translateQueryParametersIntoServerArgument(RequestDetails theRequest, byte[] theRequestContents, BaseMethodBinding<?> theMethodBinding) throws InternalErrorException, InvalidRequestException {
        EncodingEnum encoding = RestfulServerUtils.determineRequestEncoding(theRequest);
        IParser parser = encoding.newParser(this.myContext);
        Reader reader = ResourceParameter.createRequestReader(theRequest, theRequestContents);
        switch (this.myParamStyle) {
            case DSTU1_BUNDLE: {
                Bundle bundle = parser.parseBundle(reader);
                return bundle;
            }
            case RESOURCE_LIST: {
                Bundle bundle = parser.parseBundle(reader);
                ArrayList<IResource> resourceList = new ArrayList<IResource>();
                for (BundleEntry next : bundle.getEntries()) {
                    if (next.getResource() == null) continue;
                    resourceList.add(next.getResource());
                }
                return resourceList;
            }
            case RESOURCE_BUNDLE: {
                return parser.parseResource(this.myResourceBundleType, reader);
            }
        }
        throw new IllegalStateException("Unknown type: " + (Object)((Object)this.myParamStyle));
    }

    public ParamStyle getParamStyle() {
        return this.myParamStyle;
    }

    public static enum ParamStyle {
        DSTU1_BUNDLE,
        RESOURCE_BUNDLE,
        RESOURCE_LIST;

    }
}

