/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server;

import ca.uhn.fhir.rest.server.EncodingEnum;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Constants {
    public static final String CHARSET_NAME_UTF8 = "UTF-8";
    public static final Charset CHARSET_UTF8;
    public static final String CHARSET_UTF8_CTSUFFIX = "; charset=UTF-8";
    public static final String CT_ATOM_XML = "application/atom+xml";
    public static final String CT_FHIR_JSON = "application/json+fhir";
    public static final String CT_FHIR_XML = "application/xml+fhir";
    public static final String CT_HTML = "text/html";
    public static final String CT_HTML_WITH_UTF8 = "text/html; charset=UTF-8";
    public static final String CT_JSON = "application/json";
    public static final String CT_OCTET_STREAM = "application/octet-stream";
    public static final String CT_TEXT = "text/plain";
    public static final String CT_TEXT_WITH_UTF8 = "text/plain; charset=UTF-8";
    public static final String CT_XML = "application/xml";
    public static final String ENCODING_GZIP = "gzip";
    public static final String EXTOP_VALIDATE = "$validate";
    public static final String EXTOP_VALIDATE_MODE = "mode";
    public static final String EXTOP_VALIDATE_PROFILE = "profile";
    public static final String EXTOP_VALIDATE_RESOURCE = "resource";
    public static final String FORMAT_JSON = "json";
    public static final Set<String> FORMAT_VAL_JSON;
    public static final Map<String, EncodingEnum> FORMAT_VAL_TO_ENCODING;
    public static final Set<String> FORMAT_VAL_XML;
    public static final String FORMAT_XML = "xml";
    public static final String HEADER_ACCEPT = "Accept";
    public static final String HEADER_ACCEPT_ENCODING = "Accept-Encoding";
    public static final String HEADER_ACCEPT_VALUE_ALL = "application/xml+fhir;q=1.0, application/json+fhir;q=1.0";
    public static final String HEADER_ALLOW = "Allow";
    public static final String HEADER_AUTHORIZATION = "Authorization";
    public static final String HEADER_AUTHORIZATION_VALPREFIX_BASIC = "Basic ";
    public static final String HEADER_AUTHORIZATION_VALPREFIX_BEARER = "Bearer ";
    public static final String HEADER_CATEGORY = "Category";
    public static final String HEADER_CATEGORY_LC;
    public static final String HEADER_CONTENT_DISPOSITION = "Content-Disposition";
    public static final String HEADER_CONTENT_ENCODING = "Content-Encoding";
    public static final String HEADER_CONTENT_LOCATION = "Content-Location";
    public static final String HEADER_CONTENT_LOCATION_LC;
    public static final String HEADER_CONTENT_TYPE = "Content-Type";
    public static final String HEADER_COOKIE = "Cookie";
    public static final String HEADER_CORS_ALLOW_METHODS = "Access-Control-Allow-Methods";
    public static final String HEADER_CORS_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    public static final String HEADER_CORS_EXPOSE_HEADERS = "Access-Control-Expose-Headers";
    public static final String HEADER_ETAG = "ETag";
    public static final String HEADER_ETAG_LC;
    public static final String HEADER_IF_MATCH = "If-Match";
    public static final String HEADER_IF_MATCH_LC;
    public static final String HEADER_IF_NONE_EXIST = "If-None-Exist";
    public static final String HEADER_IF_NONE_EXIST_LC;
    public static final String HEADER_IF_NONE_MATCH = "If-None-Match";
    public static final String HEADER_IF_NONE_MATCH_LC;
    public static final String HEADER_LAST_MODIFIED = "Last-Modified";
    public static final String HEADER_LAST_MODIFIED_LOWERCASE;
    public static final String HEADER_LOCATION = "Location";
    public static final String HEADER_LOCATION_LC;
    public static final String HEADER_PREFER = "Prefer";
    public static final String HEADER_PREFER_RETURN = "return";
    public static final String HEADER_PREFER_RETURN_MINIMAL = "minimal";
    public static final String HEADER_PREFER_RETURN_REPRESENTATION = "representation";
    public static final String HEADER_SUFFIX_CT_UTF_8 = "; charset=UTF-8";
    public static final String HEADERVALUE_CORS_ALLOW_METHODS_ALL = "GET, POST, PUT, DELETE, OPTIONS";
    public static final Map<Integer, String> HTTP_STATUS_NAMES;
    public static final String LINK_FHIR_BASE = "fhir-base";
    public static final String LINK_FIRST = "first";
    public static final String LINK_LAST = "last";
    public static final String LINK_NEXT = "next";
    public static final String LINK_PREVIOUS = "previous";
    public static final String LINK_SELF = "self";
    public static final String OPENSEARCH_NS_OLDER = "http://purl.org/atompub/tombstones/1.0";
    public static final String PARAM_COUNT = "_count";
    public static final String PARAM_DELETE = "_delete";
    public static final String PARAM_ELEMENTS = "_elements";
    public static final String PARAM_FORMAT = "_format";
    public static final String PARAM_HISTORY = "_history";
    public static final String PARAM_INCLUDE = "_include";
    public static final String PARAM_INCLUDE_QUALIFIER_RECURSE = ":recurse";
    public static final String PARAM_INCLUDE_RECURSE = "_include:recurse";
    public static final String PARAM_LASTUPDATED = "_lastUpdated";
    public static final String PARAM_NARRATIVE = "_narrative";
    public static final String PARAM_PAGINGACTION = "_getpages";
    public static final String PARAM_PAGINGOFFSET = "_getpagesoffset";
    public static final String PARAM_PRETTY = "_pretty";
    public static final String PARAM_PRETTY_VALUE_TRUE = "true";
    public static final String PARAM_PROFILE = "_profile";
    public static final String PARAM_QUERY = "_query";
    public static final String PARAM_REVINCLUDE = "_revinclude";
    public static final String PARAM_SEARCH = "_search";
    public static final String PARAM_SECURITY = "_security";
    public static final String PARAM_SINCE = "_since";
    public static final String PARAM_SORT = "_sort";
    public static final String PARAM_SORT_ASC = "_sort:asc";
    public static final String PARAM_SORT_DESC = "_sort:desc";
    public static final String PARAM_SUMMARY = "_summary";
    public static final String PARAM_TAG = "_tag";
    public static final String PARAM_TAGS = "_tags";
    public static final String PARAM_VALIDATE = "_validate";
    public static final String PARAMQUALIFIER_MISSING = ":missing";
    public static final String PARAMQUALIFIER_MISSING_FALSE = "false";
    public static final String PARAMQUALIFIER_MISSING_TRUE = "true";
    public static final String PARAMQUALIFIER_STRING_EXACT = ":exact";
    public static final String PARAMQUALIFIER_TOKEN_TEXT = ":text";
    public static final int STATUS_HTTP_200_OK = 200;
    public static final int STATUS_HTTP_201_CREATED = 201;
    public static final int STATUS_HTTP_204_NO_CONTENT = 204;
    public static final int STATUS_HTTP_304_NOT_MODIFIED = 304;
    public static final int STATUS_HTTP_400_BAD_REQUEST = 400;
    public static final int STATUS_HTTP_401_CLIENT_UNAUTHORIZED = 401;
    public static final int STATUS_HTTP_403_FORBIDDEN = 403;
    public static final int STATUS_HTTP_404_NOT_FOUND = 404;
    public static final int STATUS_HTTP_405_METHOD_NOT_ALLOWED = 405;
    public static final int STATUS_HTTP_409_CONFLICT = 409;
    public static final int STATUS_HTTP_410_GONE = 410;
    public static final int STATUS_HTTP_412_PRECONDITION_FAILED = 412;
    public static final int STATUS_HTTP_422_UNPROCESSABLE_ENTITY = 422;
    public static final int STATUS_HTTP_500_INTERNAL_ERROR = 500;
    public static final int STATUS_HTTP_501_NOT_IMPLEMENTED = 501;
    public static final String TAG_SUBSETTED_CODE = "SUBSETTED";
    public static final String TAG_SUBSETTED_SYSTEM = "http://hl7.org/fhir/v3/ObservationValue";
    public static final String URL_TOKEN_HISTORY = "_history";
    public static final String URL_TOKEN_METADATA = "metadata";
    public static final String PARAM_CONTENT = "_content";
    public static final String PARAM_TEXT = "_text";
    public static final Object PARAM_BUNDLETYPE;

    static {
        HEADER_CATEGORY_LC = HEADER_CATEGORY.toLowerCase();
        HEADER_CONTENT_LOCATION_LC = HEADER_CONTENT_LOCATION.toLowerCase();
        HEADER_ETAG_LC = HEADER_ETAG.toLowerCase();
        HEADER_IF_MATCH_LC = HEADER_IF_MATCH.toLowerCase();
        HEADER_IF_NONE_EXIST_LC = HEADER_IF_NONE_EXIST.toLowerCase();
        HEADER_IF_NONE_MATCH_LC = HEADER_IF_NONE_MATCH.toLowerCase();
        HEADER_LAST_MODIFIED_LOWERCASE = HEADER_LAST_MODIFIED.toLowerCase();
        HEADER_LOCATION_LC = HEADER_LOCATION.toLowerCase();
        PARAM_BUNDLETYPE = "_bundletype";
        HashMap<String, EncodingEnum> valToEncoding = new HashMap<String, EncodingEnum>();
        HashSet<String> valXml = new HashSet<String>();
        valXml.add(CT_FHIR_XML);
        valXml.add("text/xml");
        valXml.add(CT_XML);
        valXml.add(FORMAT_XML);
        FORMAT_VAL_XML = Collections.unmodifiableSet(valXml);
        for (String string : valXml) {
            valToEncoding.put(string, EncodingEnum.XML);
        }
        HashSet<String> valJson = new HashSet<String>();
        valJson.add(CT_FHIR_JSON);
        valJson.add("text/json");
        valJson.add(CT_JSON);
        valJson.add(FORMAT_JSON);
        FORMAT_VAL_JSON = Collections.unmodifiableSet(valJson);
        for (String string : valJson) {
            valToEncoding.put(string, EncodingEnum.JSON);
        }
        FORMAT_VAL_TO_ENCODING = Collections.unmodifiableMap(valToEncoding);
        CHARSET_UTF8 = Charset.forName(CHARSET_NAME_UTF8);
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        hashMap.put(200, "OK");
        hashMap.put(201, "Created");
        hashMap.put(202, "Accepted");
        hashMap.put(203, "Non-Authoritative Information");
        hashMap.put(204, "No Content");
        hashMap.put(205, "Reset Content");
        hashMap.put(206, "Partial Content");
        hashMap.put(207, "Multi-Status");
        hashMap.put(208, "Already Reported");
        hashMap.put(226, "IM Used");
        hashMap.put(300, "Multiple Choices");
        hashMap.put(301, "Moved Permanently");
        hashMap.put(302, "Found");
        hashMap.put(302, "Moved Temporarily");
        hashMap.put(303, "See Other");
        hashMap.put(304, "Not Modified");
        hashMap.put(305, "Use Proxy");
        hashMap.put(307, "Temporary Redirect");
        hashMap.put(308, "Permanent Redirect");
        hashMap.put(400, "Bad Request");
        hashMap.put(401, "Unauthorized");
        hashMap.put(402, "Payment Required");
        hashMap.put(403, "Forbidden");
        hashMap.put(404, "Not Found");
        hashMap.put(405, "Method Not Allowed");
        hashMap.put(406, "Not Acceptable");
        hashMap.put(407, "Proxy Authentication Required");
        hashMap.put(408, "Request Timeout");
        hashMap.put(409, "Conflict");
        hashMap.put(410, "Gone");
        hashMap.put(411, "Length Required");
        hashMap.put(412, "Precondition Failed");
        hashMap.put(413, "Payload Too Large");
        hashMap.put(413, "Request Entity Too Large");
        hashMap.put(414, "URI Too Long");
        hashMap.put(414, "Request-URI Too Long");
        hashMap.put(415, "Unsupported Media Type");
        hashMap.put(416, "Requested range not satisfiable");
        hashMap.put(417, "Expectation Failed");
        hashMap.put(418, "I'm a teapot");
        hashMap.put(419, "Insufficient Space On Resource");
        hashMap.put(420, "Method Failure");
        hashMap.put(421, "Destination Locked");
        hashMap.put(422, "Unprocessable Entity");
        hashMap.put(423, "Locked");
        hashMap.put(424, "Failed Dependency");
        hashMap.put(426, "Upgrade Required");
        hashMap.put(428, "Precondition Required");
        hashMap.put(429, "Too Many Requests");
        hashMap.put(431, "Request Header Fields Too Large");
        hashMap.put(500, "Internal Server Error");
        hashMap.put(501, "Not Implemented");
        hashMap.put(502, "Bad Gateway");
        hashMap.put(503, "Service Unavailable");
        hashMap.put(504, "Gateway Timeout");
        hashMap.put(505, "HTTP Version not supported");
        hashMap.put(506, "Variant Also Negotiates");
        hashMap.put(507, "Insufficient Storage");
        hashMap.put(508, "Loop Detected");
        hashMap.put(509, "Bandwidth Limit Exceeded");
        hashMap.put(510, "Not Extended");
        hashMap.put(511, "Network Authentication Required");
        HTTP_STATUS_NAMES = Collections.unmodifiableMap(hashMap);
    }
}

