/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.ProvidedResourceScanner;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.model.api.Bundle;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.model.valueset.BundleTypeEnum;
import ca.uhn.fhir.rest.annotation.Destroy;
import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.annotation.Initialize;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ca.uhn.fhir.rest.method.BaseMethodBinding;
import ca.uhn.fhir.rest.method.ConformanceMethodBinding;
import ca.uhn.fhir.rest.method.RequestDetails;
import ca.uhn.fhir.rest.server.AddProfileTagEnum;
import ca.uhn.fhir.rest.server.BundleInclusionRule;
import ca.uhn.fhir.rest.server.Constants;
import ca.uhn.fhir.rest.server.ETagSupportEnum;
import ca.uhn.fhir.rest.server.EncodingEnum;
import ca.uhn.fhir.rest.server.IBundleProvider;
import ca.uhn.fhir.rest.server.IPagingProvider;
import ca.uhn.fhir.rest.server.IResourceProvider;
import ca.uhn.fhir.rest.server.IServerAddressStrategy;
import ca.uhn.fhir.rest.server.IServerConformanceProvider;
import ca.uhn.fhir.rest.server.IVersionSpecificBundleFactory;
import ca.uhn.fhir.rest.server.IncomingRequestAddressStrategy;
import ca.uhn.fhir.rest.server.ResourceBinding;
import ca.uhn.fhir.rest.server.RestfulServerUtils;
import ca.uhn.fhir.rest.server.exceptions.AuthenticationException;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.NotModifiedException;
import ca.uhn.fhir.rest.server.interceptor.ExceptionHandlingInterceptor;
import ca.uhn.fhir.rest.server.interceptor.IServerInterceptor;
import ca.uhn.fhir.util.ReflectionUtil;
import ca.uhn.fhir.util.UrlUtil;
import ca.uhn.fhir.util.VersionUtil;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestfulServer
extends HttpServlet {
    private static final ExceptionHandlingInterceptor DEFAULT_EXCEPTION_HANDLER = new ExceptionHandlingInterceptor();
    private static final long serialVersionUID = 1L;
    public static final ETagSupportEnum DEFAULT_ETAG_SUPPORT = ETagSupportEnum.ENABLED;
    private static final Logger ourLog = LoggerFactory.getLogger(RestfulServer.class);
    private AddProfileTagEnum myAddProfileTag;
    private BundleInclusionRule myBundleInclusionRule = BundleInclusionRule.BASED_ON_INCLUDES;
    private boolean myDefaultPrettyPrint = false;
    private EncodingEnum myDefaultResponseEncoding = EncodingEnum.XML;
    private ETagSupportEnum myETagSupport = DEFAULT_ETAG_SUPPORT;
    private FhirContext myFhirContext;
    private String myImplementationDescription;
    private final List<IServerInterceptor> myInterceptors = new ArrayList<IServerInterceptor>();
    private IPagingProvider myPagingProvider;
    private final List<Object> myPlainProviders = new ArrayList<Object>();
    private Map<String, ResourceBinding> myResourceNameToBinding = new HashMap<String, ResourceBinding>();
    private final List<IResourceProvider> myResourceProviders = new ArrayList<IResourceProvider>();
    private Map<String, IResourceProvider> myTypeToProvider = new HashMap<String, IResourceProvider>();
    private IServerAddressStrategy myServerAddressStrategy = new IncomingRequestAddressStrategy();
    private ResourceBinding myServerBinding = new ResourceBinding();
    private BaseMethodBinding<?> myServerConformanceMethod;
    private Object myServerConformanceProvider;
    private String myServerName = "HAPI FHIR Server";
    private String myServerVersion = VersionUtil.getVersion();
    private boolean myStarted;
    private boolean myUseBrowserFriendlyContentTypes;
    private Lock myProviderRegistrationMutex = new ReentrantLock();

    public RestfulServer() {
        this(null);
    }

    public RestfulServer(FhirContext theCtx) {
        this.myFhirContext = theCtx;
    }

    public void addHeadersToResponse(HttpServletResponse theHttpResponse) {
        theHttpResponse.addHeader("X-Powered-By", "HAPI FHIR " + VersionUtil.getVersion() + " RESTful Server");
    }

    private void assertProviderIsValid(Object theNext) throws ConfigurationException {
        if (!Modifier.isPublic(theNext.getClass().getModifiers())) {
            throw new ConfigurationException("Can not use provider '" + theNext.getClass() + "' - Class must be public");
        }
    }

    public void destroy() {
        if (this.getResourceProviders() != null) {
            for (IResourceProvider iResourceProvider : this.getResourceProviders()) {
                this.invokeDestroy(iResourceProvider);
            }
        }
        if (this.myServerConformanceProvider != null) {
            this.invokeDestroy(this.myServerConformanceProvider);
        }
        if (this.getPlainProviders() != null) {
            for (Object next : this.getPlainProviders()) {
                this.invokeDestroy(next);
            }
        }
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handleRequest(RequestTypeEnum.DELETE, request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handleRequest(RequestTypeEnum.GET, request, response);
    }

    protected void doOptions(HttpServletRequest theReq, HttpServletResponse theResp) throws ServletException, IOException {
        this.handleRequest(RequestTypeEnum.OPTIONS, theReq, theResp);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handleRequest(RequestTypeEnum.POST, request, response);
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handleRequest(RequestTypeEnum.PUT, request, response);
    }

    protected int escapedLength(String theServletPath) {
        int delta = 0;
        for (int i = 0; i < theServletPath.length(); ++i) {
            char next = theServletPath.charAt(i);
            if (next != ' ') continue;
            delta += 2;
        }
        return theServletPath.length() + delta;
    }

    private void removeResourceMethods(Object theProvider) throws Exception {
        ourLog.info("Removing RESTful methods for: {}", theProvider.getClass());
        Class<?> clazz = theProvider.getClass();
        Class<?> supertype = clazz.getSuperclass();
        ArrayList<String> resourceNames = new ArrayList<String>();
        while (!Object.class.equals(supertype)) {
            this.removeResourceMethods(theProvider, supertype, resourceNames);
            supertype = supertype.getSuperclass();
        }
        this.removeResourceMethods(theProvider, clazz, resourceNames);
        for (String resourceName : resourceNames) {
            this.myResourceNameToBinding.remove(resourceName);
        }
    }

    private void removeResourceMethods(Object theProvider, Class<?> clazz, Collection<String> resourceNames) throws ConfigurationException {
        for (Method m : ReflectionUtil.getDeclaredMethods(clazz)) {
            BaseMethodBinding<?> foundMethodBinding = BaseMethodBinding.bindMethod(m, this.getFhirContext(), theProvider);
            if (foundMethodBinding == null) continue;
            if (foundMethodBinding instanceof ConformanceMethodBinding) {
                this.myServerConformanceMethod = null;
                continue;
            }
            String resourceName = foundMethodBinding.getResourceName();
            if (resourceNames.contains(resourceName)) continue;
            resourceNames.add(resourceName);
        }
    }

    private void findResourceMethods(Object theProvider) throws Exception {
        ourLog.info("Scanning type for RESTful methods: {}", theProvider.getClass());
        int count = 0;
        Class<?> clazz = theProvider.getClass();
        Class<?> supertype = clazz.getSuperclass();
        while (!Object.class.equals(supertype)) {
            count += this.findResourceMethods(theProvider, supertype);
            supertype = supertype.getSuperclass();
        }
        if ((count += this.findResourceMethods(theProvider, clazz)) == 0) {
            throw new ConfigurationException("Did not find any annotated RESTful methods on provider class " + theProvider.getClass().getCanonicalName());
        }
    }

    private int findResourceMethods(Object theProvider, Class<?> clazz) throws ConfigurationException {
        int count = 0;
        for (Method m : ReflectionUtil.getDeclaredMethods(clazz)) {
            ResourceBinding resourceBinding;
            BaseMethodBinding<?> foundMethodBinding = BaseMethodBinding.bindMethod(m, this.getFhirContext(), theProvider);
            if (foundMethodBinding == null) continue;
            ++count;
            if (foundMethodBinding instanceof ConformanceMethodBinding) {
                this.myServerConformanceMethod = foundMethodBinding;
                continue;
            }
            if (!Modifier.isPublic(m.getModifiers())) {
                throw new ConfigurationException("Method '" + m.getName() + "' is not public, FHIR RESTful methods must be public");
            }
            if (Modifier.isStatic(m.getModifiers())) {
                throw new ConfigurationException("Method '" + m.getName() + "' is static, FHIR RESTful methods must not be static");
            }
            ourLog.debug("Scanning public method: {}#{}", theProvider.getClass(), (Object)m.getName());
            String resourceName = foundMethodBinding.getResourceName();
            if (resourceName == null) {
                resourceBinding = this.myServerBinding;
            } else {
                RuntimeResourceDefinition definition = this.getFhirContext().getResourceDefinition(resourceName);
                if (this.myResourceNameToBinding.containsKey(definition.getName())) {
                    resourceBinding = this.myResourceNameToBinding.get(definition.getName());
                } else {
                    resourceBinding = new ResourceBinding();
                    resourceBinding.setResourceName(resourceName);
                    this.myResourceNameToBinding.put(resourceName, resourceBinding);
                }
            }
            List<Class<?>> allowableParams = foundMethodBinding.getAllowableParamAnnotations();
            if (allowableParams != null) {
                Annotation[][] annotationArray = m.getParameterAnnotations();
                int n = annotationArray.length;
                for (int i = 0; i < n; ++i) {
                    Annotation[] nextParamAnnotations;
                    for (Annotation annotation : nextParamAnnotations = annotationArray[i]) {
                        Package pack = annotation.annotationType().getPackage();
                        if (!pack.equals(IdParam.class.getPackage()) || allowableParams.contains(annotation.annotationType())) continue;
                        throw new ConfigurationException("Method[" + m.toString() + "] is not allowed to have a parameter annotated with " + annotation);
                    }
                }
            }
            resourceBinding.addMethod(foundMethodBinding);
            ourLog.debug(" * Method: {}#{} is a handler", theProvider.getClass(), (Object)m.getName());
        }
        return count;
    }

    public AddProfileTagEnum getAddProfileTag() {
        return this.myAddProfileTag;
    }

    public BundleInclusionRule getBundleInclusionRule() {
        return this.myBundleInclusionRule;
    }

    public EncodingEnum getDefaultResponseEncoding() {
        return this.myDefaultResponseEncoding;
    }

    public ETagSupportEnum getETagSupport() {
        return this.myETagSupport;
    }

    public FhirContext getFhirContext() {
        if (this.myFhirContext == null) {
            this.myFhirContext = new FhirContext();
        }
        return this.myFhirContext;
    }

    public String getImplementationDescription() {
        return this.myImplementationDescription;
    }

    public List<IServerInterceptor> getInterceptors() {
        return Collections.unmodifiableList(this.myInterceptors);
    }

    public IPagingProvider getPagingProvider() {
        return this.myPagingProvider;
    }

    public Collection<Object> getPlainProviders() {
        return this.myPlainProviders;
    }

    protected String getRequestPath(String requestFullPath, String servletContextPath, String servletPath) {
        return requestFullPath.substring(this.escapedLength(servletContextPath) + this.escapedLength(servletPath));
    }

    public Collection<ResourceBinding> getResourceBindings() {
        return this.myResourceNameToBinding.values();
    }

    public Collection<IResourceProvider> getResourceProviders() {
        return this.myResourceProviders;
    }

    public IServerAddressStrategy getServerAddressStrategy() {
        return this.myServerAddressStrategy;
    }

    public String getServerBaseForRequest(HttpServletRequest theRequest) {
        String fhirServerBase = this.myServerAddressStrategy.determineServerBase(this.getServletContext(), theRequest);
        if (fhirServerBase.endsWith("/")) {
            fhirServerBase = fhirServerBase.substring(0, fhirServerBase.length() - 1);
        }
        return fhirServerBase;
    }

    public List<BaseMethodBinding<?>> getServerBindings() {
        return this.myServerBinding.getMethodBindings();
    }

    public Object getServerConformanceProvider() {
        return this.myServerConformanceProvider;
    }

    public String getServerName() {
        return this.myServerName;
    }

    public IResourceProvider getServerProfilesProvider() {
        return this.getFhirContext().getVersion().createServerProfilesProvider(this);
    }

    public String getServerVersion() {
        return this.myServerVersion;
    }

    private void handlePagingRequest(RequestDetails theRequest, HttpServletResponse theResponse, String thePagingAction) throws IOException {
        IBundleProvider resultList = this.getPagingProvider().retrieveResultList(thePagingAction);
        if (resultList == null) {
            ourLog.info("Client requested unknown paging ID[{}]", (Object)thePagingAction);
            theResponse.setStatus(410);
            this.addHeadersToResponse(theResponse);
            theResponse.setContentType("text/plain");
            theResponse.setCharacterEncoding("UTF-8");
            theResponse.getWriter().append("Search ID[" + thePagingAction + "] does not exist and may have expired.");
            theResponse.getWriter().close();
            return;
        }
        Integer count = RestfulServerUtils.extractCountParameter(theRequest);
        if (count == null) {
            count = this.getPagingProvider().getDefaultPageSize();
        } else if (count > this.getPagingProvider().getMaximumPageSize()) {
            count = this.getPagingProvider().getMaximumPageSize();
        }
        Integer offsetI = RestfulServerUtils.tryToExtractNamedParameter(theRequest, "_getpagesoffset");
        if (offsetI == null || offsetI < 0) {
            offsetI = 0;
        }
        int start = Math.min(offsetI, resultList.size() - 1);
        EncodingEnum responseEncoding = RestfulServerUtils.determineResponseEncodingNoDefault(theRequest.getServletRequest(), this.getDefaultResponseEncoding());
        boolean prettyPrint = RestfulServerUtils.prettyPrintResponse(this, theRequest);
        boolean requestIsBrowser = RestfulServer.requestIsBrowser(theRequest.getServletRequest());
        Set<SummaryEnum> summaryMode = RestfulServerUtils.determineSummaryMode(theRequest);
        boolean respondGzip = theRequest.isRespondGzip();
        IVersionSpecificBundleFactory bundleFactory = this.getFhirContext().newBundleFactory();
        HashSet<Include> includes = new HashSet<Include>();
        String[] reqIncludes = theRequest.getServletRequest().getParameterValues("_include");
        if (reqIncludes != null) {
            for (String nextInclude : reqIncludes) {
                includes.add(new Include(nextInclude));
            }
        }
        String linkSelfBase = this.getServerAddressStrategy().determineServerBase(this.getServletContext(), theRequest.getServletRequest());
        String linkSelf = linkSelfBase + theRequest.getCompleteUrl().substring(theRequest.getCompleteUrl().indexOf(63));
        BundleTypeEnum bundleType = null;
        String[] bundleTypeValues = theRequest.getParameters().get(Constants.PARAM_BUNDLETYPE);
        if (bundleTypeValues != null) {
            bundleType = BundleTypeEnum.VALUESET_BINDER.fromCodeString(bundleTypeValues[0]);
        }
        bundleFactory.initializeBundleFromBundleProvider(this, resultList, responseEncoding, theRequest.getFhirServerBase(), linkSelf, prettyPrint, start, count, thePagingAction, bundleType, includes);
        Bundle bundle = bundleFactory.getDstu1Bundle();
        if (bundle != null) {
            for (int i = this.getInterceptors().size() - 1; i >= 0; --i) {
                IServerInterceptor next = this.getInterceptors().get(i);
                boolean continueProcessing = next.outgoingResponse(theRequest, bundle, theRequest.getServletRequest(), theRequest.getServletResponse());
                if (continueProcessing) continue;
                ourLog.debug("Interceptor {} returned false, not continuing processing");
                return;
            }
            RestfulServerUtils.streamResponseAsBundle(this, theResponse, bundle, theRequest.getFhirServerBase(), summaryMode, respondGzip, requestIsBrowser, theRequest);
        } else {
            IBaseResource resBundle = bundleFactory.getResourceBundle();
            for (int i = this.getInterceptors().size() - 1; i >= 0; --i) {
                IServerInterceptor next = this.getInterceptors().get(i);
                boolean continueProcessing = next.outgoingResponse(theRequest, resBundle, theRequest.getServletRequest(), theRequest.getServletResponse());
                if (continueProcessing) continue;
                ourLog.debug("Interceptor {} returned false, not continuing processing");
                return;
            }
            RestfulServerUtils.streamResponseAsResource(this, theResponse, resBundle, prettyPrint, summaryMode, 200, theRequest.isRespondGzip(), false, theRequest);
        }
    }

    protected void handleRequest(RequestTypeEnum theRequestType, HttpServletRequest theRequest, HttpServletResponse theResponse) throws ServletException, IOException {
        IServerInterceptor next;
        String fhirServerBase = null;
        boolean requestIsBrowser = RestfulServer.requestIsBrowser(theRequest);
        RequestDetails requestDetails = new RequestDetails();
        requestDetails.setServer(this);
        requestDetails.setRequestType(theRequestType);
        requestDetails.setServletRequest(theRequest);
        requestDetails.setServletResponse(theResponse);
        Enumeration iter = theRequest.getHeaderNames();
        while (iter.hasMoreElements()) {
            String nextName = (String)iter.nextElement();
            Enumeration valueIter = theRequest.getHeaders(nextName);
            while (valueIter.hasMoreElements()) {
                requestDetails.addHeader(nextName, (String)valueIter.nextElement());
            }
        }
        try {
            String contentLocation;
            String requestPath;
            for (IServerInterceptor next2 : this.myInterceptors) {
                boolean continueProcessing = next2.incomingRequestPreProcessed(theRequest, theResponse);
                if (continueProcessing) continue;
                ourLog.debug("Interceptor {} returned false, not continuing processing");
                return;
            }
            String requestFullPath = StringUtils.defaultString((String)theRequest.getRequestURI());
            String servletPath = StringUtils.defaultString((String)theRequest.getServletPath());
            StringBuffer requestUrl = theRequest.getRequestURL();
            String servletContextPath = IncomingRequestAddressStrategy.determineServletContextPath(theRequest, this);
            if (ourLog.isTraceEnabled()) {
                ourLog.trace("Request FullPath: {}", (Object)requestFullPath);
                ourLog.trace("Servlet Path: {}", (Object)servletPath);
                ourLog.trace("Request Url: {}", (Object)requestUrl);
                ourLog.trace("Context Path: {}", (Object)servletContextPath);
            }
            if ((requestPath = this.getRequestPath(requestFullPath, servletContextPath, servletPath)).length() > 0 && requestPath.charAt(0) == '/') {
                requestPath = requestPath.substring(1);
            }
            fhirServerBase = this.getServerBaseForRequest(theRequest);
            String completeUrl = StringUtils.isNotBlank((CharSequence)theRequest.getQueryString()) ? requestUrl + "?" + theRequest.getQueryString() : requestUrl.toString();
            HashMap<String, String[]> params = new HashMap<String, String[]>(theRequest.getParameterMap());
            requestDetails.setParameters(params);
            this.populateRequestDetailsFromRequestPath(requestDetails, requestPath);
            if (theRequestType == RequestTypeEnum.PUT && (contentLocation = theRequest.getHeader("Content-Location")) != null) {
                IdDt id = new IdDt(contentLocation);
                requestDetails.setId(id);
            }
            String acceptEncoding = theRequest.getHeader("Accept-Encoding");
            boolean respondGzip = false;
            if (acceptEncoding != null) {
                String[] parts;
                for (String string : parts = acceptEncoding.trim().split("\\s*,\\s*")) {
                    if (!string.equals("gzip")) continue;
                    respondGzip = true;
                }
            }
            requestDetails.setRespondGzip(respondGzip);
            requestDetails.setRequestPath(requestPath);
            requestDetails.setFhirServerBase(fhirServerBase);
            requestDetails.setCompleteUrl(completeUrl);
            String pagingAction = theRequest.getParameter("_getpages");
            if (this.getPagingProvider() != null && StringUtils.isNotBlank((CharSequence)pagingAction)) {
                requestDetails.setRestOperationType(RestOperationTypeEnum.GET_PAGE);
                if (theRequestType != RequestTypeEnum.GET) {
                    throw new InvalidRequestException(this.getFhirContext().getLocalizer().getMessage(RestfulServer.class, "getPagesNonHttpGet", new Object[0]));
                }
                this.handlePagingRequest(requestDetails, theResponse, pagingAction);
                return;
            }
            BaseMethodBinding<?> resourceMethod = this.determineResourceMethod(requestDetails, requestPath);
            requestDetails.setRestOperationType(resourceMethod.getRestOperationType());
            for (IServerInterceptor next3 : this.myInterceptors) {
                boolean continueProcessing = next3.incomingRequestPostProcessed(requestDetails, theRequest, theResponse);
                if (continueProcessing) continue;
                ourLog.debug("Interceptor {} returned false, not continuing processing");
                return;
            }
            resourceMethod.invokeServer(this, requestDetails);
        }
        catch (NotModifiedException e) {
            for (int i = this.getInterceptors().size() - 1; i >= 0; --i) {
                next = this.getInterceptors().get(i);
                if (next.handleException(requestDetails, e, theRequest, theResponse)) continue;
                ourLog.debug("Interceptor {} returned false, not continuing processing");
                return;
            }
            this.writeExceptionToResponse(theResponse, e);
        }
        catch (AuthenticationException e) {
            for (int i = this.getInterceptors().size() - 1; i >= 0; --i) {
                next = this.getInterceptors().get(i);
                if (next.handleException(requestDetails, e, theRequest, theResponse)) continue;
                ourLog.debug("Interceptor {} returned false, not continuing processing");
                return;
            }
            if (requestIsBrowser) {
                theResponse.setHeader("WWW-Authenticate", "BASIC realm=\"FHIR\"");
            }
            this.writeExceptionToResponse(theResponse, e);
        }
        catch (Throwable e) {
            IServerInterceptor next4;
            int i;
            BaseServerResponseException exception = null;
            for (i = this.getInterceptors().size() - 1; i >= 0; --i) {
                next4 = this.getInterceptors().get(i);
                exception = next4.preProcessOutgoingException(requestDetails, e, theRequest);
                if (exception == null) continue;
                ourLog.debug("Interceptor {} returned false, not continuing processing");
                break;
            }
            if (exception == null) {
                exception = DEFAULT_EXCEPTION_HANDLER.preProcessOutgoingException(requestDetails, e, theRequest);
            }
            for (i = this.getInterceptors().size() - 1; i >= 0; --i) {
                next4 = this.getInterceptors().get(i);
                if (next4.handleException(requestDetails, exception, theRequest, theResponse)) continue;
                ourLog.debug("Interceptor {} returned false, not continuing processing");
                return;
            }
            requestDetails.getParameters().remove("_summary");
            requestDetails.getParameters().remove("_elements");
            DEFAULT_EXCEPTION_HANDLER.handleException(requestDetails, exception, theRequest, theResponse);
        }
    }

    public BaseMethodBinding<?> determineResourceMethod(RequestDetails requestDetails, String requestPath) {
        RequestTypeEnum requestType = requestDetails.getRequestType();
        ResourceBinding resourceBinding = null;
        BaseMethodBinding<?> resourceMethod = null;
        String resourceName = requestDetails.getResourceName();
        if ("metadata".equals(resourceName) || requestType == RequestTypeEnum.OPTIONS) {
            resourceMethod = this.myServerConformanceMethod;
        } else if (resourceName == null) {
            resourceBinding = this.myServerBinding;
        } else {
            resourceBinding = this.myResourceNameToBinding.get(resourceName);
            if (resourceBinding == null) {
                throw new InvalidRequestException("Unknown resource type '" + resourceName + "' - Server knows how to handle: " + this.myResourceNameToBinding.keySet());
            }
        }
        if (resourceMethod == null && resourceBinding != null) {
            resourceMethod = resourceBinding.getMethod(requestDetails);
        }
        if (resourceMethod == null) {
            if (StringUtils.isBlank((CharSequence)requestPath)) {
                throw new InvalidRequestException(this.myFhirContext.getLocalizer().getMessage(RestfulServer.class, "rootRequest", new Object[0]));
            }
            throw new InvalidRequestException(this.myFhirContext.getLocalizer().getMessage(RestfulServer.class, "unknownMethod", requestType.name(), requestPath, requestDetails.getParameters().keySet()));
        }
        return resourceMethod;
    }

    public void populateRequestDetailsFromRequestPath(RequestDetails theRequestDetails, String theRequestPath) {
        String nextString;
        StringTokenizer tok = new StringTokenizer(theRequestPath, "/");
        String resourceName = null;
        IdDt id = null;
        String operation = null;
        String compartment = null;
        if (tok.hasMoreTokens() && RestfulServer.partIsOperation(resourceName = tok.nextToken())) {
            operation = resourceName;
            resourceName = null;
        }
        theRequestDetails.setResourceName(resourceName);
        if (tok.hasMoreTokens()) {
            nextString = tok.nextToken();
            if (RestfulServer.partIsOperation(nextString)) {
                operation = nextString;
            } else {
                id = new IdDt(resourceName, UrlUtil.unescape(nextString));
            }
        }
        if (tok.hasMoreTokens()) {
            nextString = tok.nextToken();
            if (nextString.equals("_history")) {
                if (tok.hasMoreTokens()) {
                    String versionString = tok.nextToken();
                    if (id == null) {
                        throw new InvalidRequestException("Don't know how to handle request path: " + theRequestPath);
                    }
                    id = new IdDt(resourceName, id.getIdPart(), UrlUtil.unescape(versionString));
                } else {
                    operation = "_history";
                }
            } else if (RestfulServer.partIsOperation(nextString)) {
                if (operation != null) {
                    throw new InvalidRequestException("URL Path contains two operations: " + theRequestPath);
                }
                operation = nextString;
            } else {
                compartment = nextString;
            }
        }
        String secondaryOperation = null;
        while (tok.hasMoreTokens()) {
            String nextString2 = tok.nextToken();
            if (operation == null) {
                operation = nextString2;
                continue;
            }
            if (secondaryOperation == null) {
                secondaryOperation = nextString2;
                continue;
            }
            throw new InvalidRequestException("URL path has unexpected token '" + nextString2 + "' at the end: " + theRequestPath);
        }
        theRequestDetails.setId(id);
        theRequestDetails.setOperation(operation);
        theRequestDetails.setSecondaryOperation(secondaryOperation);
        theRequestDetails.setCompartmentName(compartment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void init() throws ServletException {
        this.myProviderRegistrationMutex.lock();
        try {
            IServerConformanceProvider<? extends IBaseResource> confProvider;
            this.initialize();
            try {
                ourLog.info("Initializing HAPI FHIR restful server running in " + this.getFhirContext().getVersion().getVersion().name() + " mode");
                ProvidedResourceScanner providedResourceScanner = new ProvidedResourceScanner(this.getFhirContext());
                providedResourceScanner.scanForProvidedResources((Object)this);
                Collection<IResourceProvider> resourceProvider = this.getResourceProviders();
                this.registerProviders(resourceProvider, true);
                Collection<Object> providers = this.getPlainProviders();
                this.registerProviders(providers, true);
                this.findResourceMethods(this.getServerProfilesProvider());
                confProvider = this.getServerConformanceProvider();
                if (confProvider == null) {
                    confProvider = this.getFhirContext().getVersion().createServerConformanceProvider(this);
                }
                this.findResourceMethods(confProvider);
            }
            catch (Exception ex) {
                ourLog.error("An error occurred while loading request handlers!", (Throwable)ex);
                throw new ServletException("Failed to initialize FHIR Restful server", (Throwable)ex);
            }
            ourLog.trace("Invoking provider initialize methods");
            if (this.getResourceProviders() != null) {
                for (IResourceProvider iResourceProvider : this.getResourceProviders()) {
                    this.invokeInitialize(iResourceProvider);
                }
            }
            if (confProvider != null) {
                this.invokeInitialize(confProvider);
            }
            if (this.getPlainProviders() != null) {
                for (Object next : this.getPlainProviders()) {
                    this.invokeInitialize(next);
                }
            }
            this.myStarted = true;
            ourLog.info("A FHIR has been lit on this server");
        }
        finally {
            this.myProviderRegistrationMutex.unlock();
        }
    }

    protected void initialize() throws ServletException {
    }

    public void registerProvider(Object provider) throws Exception {
        if (provider != null) {
            ArrayList<Object> providerList = new ArrayList<Object>(1);
            providerList.add(provider);
            this.registerProviders(providerList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerProviders(Collection<? extends Object> providers) throws Exception {
        this.myProviderRegistrationMutex.lock();
        try {
            if (!this.myStarted) {
                for (Object object : providers) {
                    ourLog.info("Registration of provider [" + object.getClass().getName() + "] will be delayed until FHIR server startup");
                    if (object instanceof IResourceProvider) {
                        this.myResourceProviders.add((IResourceProvider)object);
                        continue;
                    }
                    this.myPlainProviders.add(object);
                }
                return;
            }
        }
        finally {
            this.myProviderRegistrationMutex.unlock();
        }
        this.registerProviders(providers, false);
    }

    protected void registerProviders(Collection<? extends Object> providers, boolean inInit) throws Exception {
        ArrayList<IResourceProvider> newResourceProviders = new ArrayList<IResourceProvider>();
        ArrayList<Object> newPlainProviders = new ArrayList<Object>();
        ProvidedResourceScanner providedResourceScanner = new ProvidedResourceScanner(this.getFhirContext());
        if (providers != null) {
            for (Object object : providers) {
                if (object instanceof IResourceProvider) {
                    IResourceProvider rsrcProvider = (IResourceProvider)object;
                    Class<? extends IBaseResource> resourceType = rsrcProvider.getResourceType();
                    if (resourceType == null) {
                        throw new NullPointerException("getResourceType() on class '" + rsrcProvider.getClass().getCanonicalName() + "' returned null");
                    }
                    String resourceName = this.getFhirContext().getResourceDefinition(resourceType).getName();
                    if (this.myTypeToProvider.containsKey(resourceName)) {
                        throw new ServletException("Multiple resource providers return resource type[" + resourceName + "]: First[" + this.myTypeToProvider.get(resourceName).getClass().getCanonicalName() + "] and Second[" + rsrcProvider.getClass().getCanonicalName() + "]");
                    }
                    if (!inInit) {
                        this.myResourceProviders.add(rsrcProvider);
                    }
                    this.myTypeToProvider.put(resourceName, rsrcProvider);
                    providedResourceScanner.scanForProvidedResources(rsrcProvider);
                    newResourceProviders.add(rsrcProvider);
                    continue;
                }
                if (!inInit) {
                    this.myPlainProviders.add(object);
                }
                newPlainProviders.add(object);
            }
            if (!newResourceProviders.isEmpty()) {
                ourLog.info("Added {} resource provider(s). Total {}", (Object)newResourceProviders.size(), (Object)this.myTypeToProvider.size());
                for (IResourceProvider iResourceProvider : newResourceProviders) {
                    this.assertProviderIsValid(iResourceProvider);
                    this.findResourceMethods(iResourceProvider);
                }
            }
            if (!newPlainProviders.isEmpty()) {
                ourLog.info("Added {} plain provider(s). Total {}", (Object)newPlainProviders.size());
                for (Object object : newPlainProviders) {
                    this.assertProviderIsValid(object);
                    this.findResourceMethods(object);
                }
            }
            if (!inInit) {
                ourLog.trace("Invoking provider initialize methods");
                if (!newResourceProviders.isEmpty()) {
                    for (IResourceProvider iResourceProvider : newResourceProviders) {
                        this.invokeInitialize(iResourceProvider);
                    }
                }
                if (!newPlainProviders.isEmpty()) {
                    for (Object object : newPlainProviders) {
                        this.invokeInitialize(object);
                    }
                }
            }
        }
    }

    public void unregisterProvider(Object provider) throws Exception {
        if (provider != null) {
            ArrayList<Object> providerList = new ArrayList<Object>(1);
            providerList.add(provider);
            this.unregisterProviders(providerList);
        }
    }

    public void unregisterProviders(Collection<? extends Object> providers) throws Exception {
        ProvidedResourceScanner providedResourceScanner = new ProvidedResourceScanner(this.getFhirContext());
        if (providers != null) {
            for (Object object : providers) {
                this.removeResourceMethods(object);
                if (object instanceof IResourceProvider) {
                    this.myResourceProviders.remove(object);
                    IResourceProvider rsrcProvider = (IResourceProvider)object;
                    Class<? extends IBaseResource> resourceType = rsrcProvider.getResourceType();
                    String resourceName = this.getFhirContext().getResourceDefinition(resourceType).getName();
                    this.myTypeToProvider.remove(resourceName);
                    providedResourceScanner.removeProvidedResources(rsrcProvider);
                } else {
                    this.myPlainProviders.remove(object);
                }
                this.invokeDestroy(object);
            }
        }
    }

    private void invokeDestroy(Object theProvider) {
        this.invokeDestroy(theProvider, theProvider.getClass());
    }

    private void invokeInitialize(Object theProvider) {
        this.invokeInitialize(theProvider, theProvider.getClass());
    }

    private void invokeDestroy(Object theProvider, Class<?> clazz) {
        for (Method m : ReflectionUtil.getDeclaredMethods(clazz)) {
            Destroy destroy = m.getAnnotation(Destroy.class);
            if (destroy == null) continue;
            try {
                m.invoke(theProvider, new Object[0]);
            }
            catch (IllegalAccessException e) {
                ourLog.error("Exception occurred in destroy ", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                ourLog.error("Exception occurred in destroy ", (Throwable)e);
            }
            return;
        }
        Class<?> supertype = clazz.getSuperclass();
        if (!Object.class.equals(supertype)) {
            this.invokeDestroy(theProvider, supertype);
        }
    }

    private void invokeInitialize(Object theProvider, Class<?> clazz) {
        for (Method m : ReflectionUtil.getDeclaredMethods(clazz)) {
            Initialize initialize = m.getAnnotation(Initialize.class);
            if (initialize == null) continue;
            try {
                m.invoke(theProvider, new Object[0]);
            }
            catch (IllegalAccessException e) {
                ourLog.error("Exception occurred in destroy ", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                ourLog.error("Exception occurred in destroy ", (Throwable)e);
            }
            return;
        }
        Class<?> supertype = clazz.getSuperclass();
        if (!Object.class.equals(supertype)) {
            this.invokeInitialize(theProvider, supertype);
        }
    }

    public boolean isDefaultPrettyPrint() {
        return this.myDefaultPrettyPrint;
    }

    public boolean isUseBrowserFriendlyContentTypes() {
        return this.myUseBrowserFriendlyContentTypes;
    }

    public void registerInterceptor(IServerInterceptor theInterceptor) {
        Validate.notNull((Object)theInterceptor, (String)"Interceptor can not be null", (Object[])new Object[0]);
        this.myInterceptors.add(theInterceptor);
    }

    public void setAddProfileTag(AddProfileTagEnum theAddProfileTag) {
        Validate.notNull((Object)((Object)theAddProfileTag), (String)"theAddProfileTag must not be null", (Object[])new Object[0]);
        this.myAddProfileTag = theAddProfileTag;
    }

    public void setBundleInclusionRule(BundleInclusionRule theBundleInclusionRule) {
        this.myBundleInclusionRule = theBundleInclusionRule;
    }

    public void setDefaultPrettyPrint(boolean theDefaultPrettyPrint) {
        this.myDefaultPrettyPrint = theDefaultPrettyPrint;
    }

    public void setDefaultResponseEncoding(EncodingEnum theDefaultResponseEncoding) {
        Validate.notNull((Object)((Object)theDefaultResponseEncoding), (String)"theDefaultResponseEncoding can not be null", (Object[])new Object[0]);
        this.myDefaultResponseEncoding = theDefaultResponseEncoding;
    }

    public void setETagSupport(ETagSupportEnum theETagSupport) {
        if (theETagSupport == null) {
            throw new NullPointerException("theETagSupport can not be null");
        }
        this.myETagSupport = theETagSupport;
    }

    public void setFhirContext(FhirContext theFhirContext) {
        Validate.notNull((Object)theFhirContext, (String)"FhirContext must not be null", (Object[])new Object[0]);
        this.myFhirContext = theFhirContext;
    }

    public void setImplementationDescription(String theImplementationDescription) {
        this.myImplementationDescription = theImplementationDescription;
    }

    public void setInterceptors(IServerInterceptor ... theList) {
        this.myInterceptors.clear();
        if (theList != null) {
            this.myInterceptors.addAll(Arrays.asList(theList));
        }
    }

    public void setInterceptors(List<IServerInterceptor> theList) {
        this.myInterceptors.clear();
        if (theList != null) {
            this.myInterceptors.addAll(theList);
        }
    }

    public void setPagingProvider(IPagingProvider thePagingProvider) {
        this.myPagingProvider = thePagingProvider;
    }

    public void setPlainProviders(Collection<Object> theProviders) {
        this.myPlainProviders.clear();
        if (theProviders != null) {
            this.myPlainProviders.addAll(theProviders);
        }
    }

    public void setPlainProviders(Object ... theProv) {
        this.setPlainProviders(Arrays.asList(theProv));
    }

    public void setProviders(Object ... theProviders) {
        this.myPlainProviders.clear();
        if (theProviders != null) {
            this.myPlainProviders.addAll(Arrays.asList(theProviders));
        }
    }

    public void setResourceProviders(Collection<IResourceProvider> theResourceProviders) {
        this.myResourceProviders.clear();
        if (theResourceProviders != null) {
            this.myResourceProviders.addAll(theResourceProviders);
        }
    }

    public void setResourceProviders(IResourceProvider ... theResourceProviders) {
        this.myResourceProviders.clear();
        if (theResourceProviders != null) {
            this.myResourceProviders.addAll(Arrays.asList(theResourceProviders));
        }
    }

    public void setServerAddressStrategy(IServerAddressStrategy theServerAddressStrategy) {
        Validate.notNull((Object)theServerAddressStrategy, (String)"Server address strategy can not be null", (Object[])new Object[0]);
        this.myServerAddressStrategy = theServerAddressStrategy;
    }

    public void setServerConformanceProvider(Object theServerConformanceProvider) {
        if (this.myStarted) {
            throw new IllegalStateException("Server is already started");
        }
        try {
            Method setRestfulServer = theServerConformanceProvider.getClass().getMethod("setRestfulServer", RestfulServer.class);
            if (setRestfulServer != null) {
                setRestfulServer.invoke(theServerConformanceProvider, new Object[]{this});
            }
        }
        catch (Exception e) {
            ourLog.warn("Error calling IServerConformanceProvider.setRestfulServer", (Throwable)e);
        }
        this.myServerConformanceProvider = theServerConformanceProvider;
    }

    public void setServerName(String theServerName) {
        this.myServerName = theServerName;
    }

    public void setServerVersion(String theServerVersion) {
        this.myServerVersion = theServerVersion;
    }

    public void setUseBrowserFriendlyContentTypes(boolean theUseBrowserFriendlyContentTypes) {
        this.myUseBrowserFriendlyContentTypes = theUseBrowserFriendlyContentTypes;
    }

    public void unregisterInterceptor(IServerInterceptor theInterceptor) {
        Validate.notNull((Object)theInterceptor, (String)"Interceptor can not be null", (Object[])new Object[0]);
        this.myInterceptors.remove(theInterceptor);
    }

    private void writeExceptionToResponse(HttpServletResponse theResponse, BaseServerResponseException theException) throws IOException {
        theResponse.setStatus(theException.getStatusCode());
        this.addHeadersToResponse(theResponse);
        theResponse.setContentType("text/plain");
        theResponse.setCharacterEncoding("UTF-8");
        theResponse.getWriter().write(theException.getMessage());
    }

    private static boolean partIsOperation(String nextString) {
        return nextString.length() > 0 && (nextString.charAt(0) == '_' || nextString.charAt(0) == '$');
    }

    public static boolean requestIsBrowser(HttpServletRequest theRequest) {
        String userAgent = theRequest.getHeader("User-Agent");
        return userAgent != null && userAgent.contains("Mozilla");
    }
}

