/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.model.api.BasePrimitive;
import ca.uhn.fhir.model.api.Bundle;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.ResourceMetadataKeyEnum;
import ca.uhn.fhir.model.api.Tag;
import ca.uhn.fhir.model.api.TagList;
import ca.uhn.fhir.model.valueset.BundleTypeEnum;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.rest.api.PreferReturnEnum;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ca.uhn.fhir.rest.method.ElementsParameter;
import ca.uhn.fhir.rest.method.RequestDetails;
import ca.uhn.fhir.rest.method.SummaryEnumParameter;
import ca.uhn.fhir.rest.server.AddProfileTagEnum;
import ca.uhn.fhir.rest.server.Constants;
import ca.uhn.fhir.rest.server.ETagSupportEnum;
import ca.uhn.fhir.rest.server.EncodingEnum;
import ca.uhn.fhir.rest.server.RestfulServer;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.DateUtils;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBaseBinary;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestfulServerUtils {
    static final Pattern ACCEPT_HEADER_PATTERN = Pattern.compile("\\s*([a-zA-Z0-9+.*/-]+)\\s*(;\\s*([a-zA-Z]+)\\s*=\\s*([a-zA-Z0-9.]+)\\s*)?(,?)");
    private static final Logger ourLog = LoggerFactory.getLogger(RestfulServerUtils.class);
    private static final HashSet<String> TEXT_ENCODE_ELEMENTS = new HashSet<String>(Arrays.asList("Bundle", "*.text"));

    public static void addProfileToBundleEntry(FhirContext theContext, IBaseResource theResource, String theServerBase) {
        if (theResource instanceof IResource) {
            RuntimeResourceDefinition nextDef;
            String profile;
            TagList tl = ResourceMetadataKeyEnum.TAG_LIST.get((IResource)theResource);
            if (tl == null) {
                tl = new TagList();
                ResourceMetadataKeyEnum.TAG_LIST.put((IResource)theResource, tl);
            }
            if (StringUtils.isNotBlank((CharSequence)(profile = (nextDef = theContext.getResourceDefinition(theResource)).getResourceProfile(theServerBase)))) {
                tl.add(new Tag("http://hl7.org/fhir/tag/profile", profile, null));
            }
        }
    }

    public static void configureResponseParser(RequestDetails theRequestDetails, IParser parser) {
        boolean prettyPrint = RestfulServerUtils.prettyPrintResponse(theRequestDetails.getServer(), theRequestDetails);
        parser.setPrettyPrint(prettyPrint);
        parser.setServerBaseUrl(theRequestDetails.getFhirServerBase());
        Set<SummaryEnum> summaryMode = RestfulServerUtils.determineSummaryMode(theRequestDetails);
        Set<String> elements = ElementsParameter.getElementsValueOrNull(theRequestDetails);
        if (elements != null && summaryMode != null && !summaryMode.equals(Collections.singleton(SummaryEnum.FALSE))) {
            throw new InvalidRequestException("Cannot combine the _summary and _elements parameters");
        }
        Set<String> elementsAppliesTo = null;
        if (elements != null && StringUtils.isNotBlank((CharSequence)theRequestDetails.getResourceName())) {
            elementsAppliesTo = Collections.singleton(theRequestDetails.getResourceName());
        }
        if (summaryMode != null) {
            if (summaryMode.contains((Object)SummaryEnum.COUNT)) {
                parser.setEncodeElements(Collections.singleton("Bundle.total"));
            } else if (summaryMode.contains((Object)SummaryEnum.TEXT)) {
                parser.setEncodeElements(TEXT_ENCODE_ELEMENTS);
            } else {
                parser.setSuppressNarratives(summaryMode.contains((Object)SummaryEnum.DATA));
                parser.setSummaryMode(summaryMode.contains((Object)SummaryEnum.TRUE));
            }
        }
        if (elements != null && elements.size() > 0) {
            HashSet<String> newElements = new HashSet<String>();
            for (String next : elements) {
                newElements.add("*." + next);
            }
            parser.setEncodeElements(newElements);
            parser.setEncodeElementsAppliesToResourceTypes(elementsAppliesTo);
        }
    }

    public static String createPagingLink(Set<Include> theIncludes, String theServerBase, String theSearchId, int theOffset, int theCount, EncodingEnum theResponseEncoding, boolean thePrettyPrint, BundleTypeEnum theBundleType) {
        try {
            StringBuilder b = new StringBuilder();
            b.append(theServerBase);
            b.append('?');
            b.append("_getpages");
            b.append('=');
            b.append(URLEncoder.encode(theSearchId, "UTF-8"));
            b.append('&');
            b.append("_getpagesoffset");
            b.append('=');
            b.append(theOffset);
            b.append('&');
            b.append("_count");
            b.append('=');
            b.append(theCount);
            if (theResponseEncoding != null) {
                b.append('&');
                b.append("_format");
                b.append('=');
                b.append(theResponseEncoding.getRequestContentType());
            }
            if (thePrettyPrint) {
                b.append('&');
                b.append("_pretty");
                b.append('=');
                b.append("true");
            }
            if (theIncludes != null) {
                for (Include nextInclude : theIncludes) {
                    if (!StringUtils.isNotBlank((CharSequence)nextInclude.getValue())) continue;
                    b.append('&');
                    b.append("_include");
                    b.append('=');
                    b.append(URLEncoder.encode(nextInclude.getValue(), "UTF-8"));
                }
            }
            if (theBundleType != null) {
                b.append('&');
                b.append(Constants.PARAM_BUNDLETYPE);
                b.append('=');
                b.append(theBundleType.getCode());
            }
            return b.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("UTF-8 not supported", e);
        }
    }

    public static EncodingEnum determineRequestEncoding(RequestDetails theReq) {
        EncodingEnum retVal = RestfulServerUtils.determineRequestEncodingNoDefault(theReq);
        if (retVal != null) {
            return retVal;
        }
        return EncodingEnum.XML;
    }

    public static EncodingEnum determineRequestEncodingNoDefault(RequestDetails theReq) {
        EncodingEnum retVal = null;
        Enumeration acceptValues = theReq.getServletRequest().getHeaders("Content-Type");
        if (acceptValues != null) {
            block0: while (acceptValues.hasMoreElements() && retVal == null) {
                String nextAcceptHeaderValue = (String)acceptValues.nextElement();
                if (nextAcceptHeaderValue == null || !StringUtils.isNotBlank((CharSequence)nextAcceptHeaderValue)) continue;
                for (String nextPart : nextAcceptHeaderValue.split(",")) {
                    int scIdx = nextPart.indexOf(59);
                    if (scIdx == 0) continue;
                    if (scIdx != -1) {
                        nextPart = nextPart.substring(0, scIdx);
                    }
                    if ((retVal = Constants.FORMAT_VAL_TO_ENCODING.get(nextPart = nextPart.trim())) != null) continue block0;
                }
            }
        }
        return retVal;
    }

    public static EncodingEnum determineResponseEncodingNoDefault(HttpServletRequest theReq, EncodingEnum thePrefer) {
        Enumeration acceptValues;
        String[] format = theReq.getParameterValues("_format");
        if (format != null) {
            for (String nextFormat : format) {
                EncodingEnum retVal = Constants.FORMAT_VAL_TO_ENCODING.get(nextFormat);
                if (retVal == null) continue;
                return retVal;
            }
        }
        if ((acceptValues = theReq.getHeaders("Accept")) != null) {
            float bestQ = -1.0f;
            EncodingEnum retVal = null;
            while (acceptValues.hasMoreElements()) {
                String nextAcceptHeaderValue = (String)acceptValues.nextElement();
                StringTokenizer tok = new StringTokenizer(nextAcceptHeaderValue, ",");
                while (tok.hasMoreTokens()) {
                    EncodingEnum encoding;
                    String nextToken = tok.nextToken();
                    int startSpaceIndex = -1;
                    for (int i = 0; i < nextToken.length(); ++i) {
                        if (nextToken.charAt(i) == ' ') continue;
                        startSpaceIndex = i;
                        break;
                    }
                    if (startSpaceIndex == -1) continue;
                    int endSpaceIndex = -1;
                    for (int i = startSpaceIndex; i < nextToken.length(); ++i) {
                        if (nextToken.charAt(i) != ' ' && nextToken.charAt(i) != ';') continue;
                        endSpaceIndex = i;
                        break;
                    }
                    float q = 1.0f;
                    boolean pretty = false;
                    if (endSpaceIndex == -1) {
                        encoding = startSpaceIndex == 0 ? Constants.FORMAT_VAL_TO_ENCODING.get(nextToken) : Constants.FORMAT_VAL_TO_ENCODING.get(nextToken.substring(startSpaceIndex));
                    } else {
                        encoding = Constants.FORMAT_VAL_TO_ENCODING.get(nextToken.substring(startSpaceIndex, endSpaceIndex));
                        String remaining = nextToken.substring(endSpaceIndex + 1);
                        StringTokenizer qualifierTok = new StringTokenizer(remaining, ";");
                        while (qualifierTok.hasMoreTokens()) {
                            String nextQualifier = qualifierTok.nextToken();
                            int equalsIndex = nextQualifier.indexOf(61);
                            if (equalsIndex == -1) continue;
                            String nextQualifierKey = nextQualifier.substring(0, equalsIndex).trim();
                            String nextQualifierValue = nextQualifier.substring(equalsIndex + 1, nextQualifier.length()).trim();
                            if (!nextQualifierKey.equals("q")) continue;
                            try {
                                q = Float.parseFloat(nextQualifierValue);
                                q = Math.max(q, 0.0f);
                            }
                            catch (NumberFormatException e) {
                                ourLog.debug("Invalid Accept header q value: {}", (Object)nextQualifierValue);
                            }
                        }
                    }
                    if (encoding == null || !(q > bestQ) && (q != bestQ || encoding != thePrefer)) continue;
                    retVal = encoding;
                    bestQ = q;
                }
            }
            return retVal;
        }
        return null;
    }

    public static EncodingEnum determineResponseEncodingWithDefault(RestfulServer theServer, HttpServletRequest theReq) {
        EncodingEnum retVal = RestfulServerUtils.determineResponseEncodingNoDefault(theReq, theServer.getDefaultResponseEncoding());
        if (retVal == null) {
            retVal = theServer.getDefaultResponseEncoding();
        }
        return retVal;
    }

    public static Set<SummaryEnum> determineSummaryMode(RequestDetails theRequest) {
        String[] narrative;
        Map<String, String[]> requestParams = theRequest.getParameters();
        Set<SummaryEnum> retVal = SummaryEnumParameter.getSummaryValueOrNull(theRequest);
        if (retVal == null && (narrative = requestParams.get("_narrative")) != null && narrative.length > 0) {
            try {
                NarrativeModeEnum narrativeMode = NarrativeModeEnum.valueOfCaseInsensitive(narrative[0]);
                switch (narrativeMode) {
                    case NORMAL: {
                        retVal = Collections.singleton(SummaryEnum.FALSE);
                        break;
                    }
                    case ONLY: {
                        retVal = Collections.singleton(SummaryEnum.TEXT);
                        break;
                    }
                    case SUPPRESS: {
                        retVal = Collections.singleton(SummaryEnum.DATA);
                    }
                }
            }
            catch (IllegalArgumentException e) {
                ourLog.debug("Invalid {} parameger: {}", (Object)"_narrative", (Object)narrative[0]);
            }
        }
        if (retVal == null) {
            retVal = Collections.singleton(SummaryEnum.FALSE);
        }
        return retVal;
    }

    public static Integer extractCountParameter(RequestDetails theRequest) {
        String paramName = "_count";
        return RestfulServerUtils.tryToExtractNamedParameter(theRequest, paramName);
    }

    public static IParser getNewParser(FhirContext theContext, RequestDetails theRequestDetails) {
        IParser parser;
        EncodingEnum responseEncoding = RestfulServerUtils.determineResponseEncodingWithDefault(theRequestDetails.getServer(), theRequestDetails.getServletRequest());
        switch (responseEncoding) {
            case JSON: {
                parser = theContext.newJsonParser();
                break;
            }
            default: {
                parser = theContext.newXmlParser();
            }
        }
        RestfulServerUtils.configureResponseParser(theRequestDetails, parser);
        return parser;
    }

    static Writer getWriter(HttpServletResponse theHttpResponse, boolean theRespondGzip) throws UnsupportedEncodingException, IOException {
        Writer writer;
        if (theRespondGzip) {
            theHttpResponse.addHeader("Content-Encoding", "gzip");
            writer = new OutputStreamWriter((OutputStream)new GZIPOutputStream((OutputStream)theHttpResponse.getOutputStream()), "UTF-8");
        } else {
            writer = theHttpResponse.getWriter();
        }
        return writer;
    }

    public static Set<String> parseAcceptHeaderAndReturnHighestRankedOptions(HttpServletRequest theRequest) {
        HashSet<String> retVal = new HashSet<String>();
        Enumeration acceptValues = theRequest.getHeaders("Accept");
        if (acceptValues != null) {
            float bestQ = -1.0f;
            block2: while (acceptValues.hasMoreElements()) {
                String nextAcceptHeaderValue = (String)acceptValues.nextElement();
                Matcher m = ACCEPT_HEADER_PATTERN.matcher(nextAcceptHeaderValue);
                float q = 1.0f;
                while (m.find()) {
                    String contentTypeGroup = m.group(1);
                    if (StringUtils.isNotBlank((CharSequence)contentTypeGroup)) {
                        String name = m.group(3);
                        String value = m.group(4);
                        if (name != null && value != null && "q".equals(name)) {
                            try {
                                q = Float.parseFloat(value);
                                q = Math.max(q, 0.0f);
                            }
                            catch (NumberFormatException e) {
                                ourLog.debug("Invalid Accept header q value: {}", (Object)value);
                            }
                        }
                        if (q > bestQ) {
                            retVal.clear();
                            bestQ = q;
                        }
                        if (q == bestQ) {
                            retVal.add(contentTypeGroup.trim());
                        }
                    }
                    if (",".equals(m.group(5))) continue;
                    continue block2;
                }
            }
        }
        return retVal;
    }

    public static PreferReturnEnum parsePreferHeader(String theValue) {
        if (StringUtils.isBlank((CharSequence)theValue)) {
            return null;
        }
        StringTokenizer tok = new StringTokenizer(theValue, ",");
        while (tok.hasMoreTokens()) {
            String value;
            String key;
            String next = tok.nextToken();
            int eqIndex = next.indexOf(61);
            if (eqIndex == -1 || eqIndex >= next.length() - 2 || !(key = next.substring(0, eqIndex).trim()).equals("return") || (value = next.substring(eqIndex + 1).trim()).length() < 2) continue;
            if ('\"' == value.charAt(0) && '\"' == value.charAt(value.length() - 1)) {
                value = value.substring(1, value.length() - 1);
            }
            return PreferReturnEnum.fromHeaderValue(value);
        }
        return null;
    }

    public static boolean prettyPrintResponse(RestfulServer theServer, RequestDetails theRequest) {
        boolean prettyPrint;
        Map<String, String[]> requestParams = theRequest.getParameters();
        String[] pretty = requestParams.get("_pretty");
        if (pretty != null && pretty.length > 0) {
            prettyPrint = "true".equals(pretty[0]);
        } else {
            prettyPrint = theServer.isDefaultPrettyPrint();
            Enumeration acceptValues = theRequest.getServletRequest().getHeaders("Accept");
            if (acceptValues != null) {
                while (acceptValues.hasMoreElements()) {
                    String nextAcceptHeaderValue = (String)acceptValues.nextElement();
                    if (!nextAcceptHeaderValue.contains("pretty=true")) continue;
                    prettyPrint = true;
                }
            }
        }
        return prettyPrint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void streamResponseAsBundle(RestfulServer theServer, HttpServletResponse theHttpResponse, Bundle bundle, String theServerBase, Set<SummaryEnum> theSummaryMode, boolean theRespondGzip, boolean theRequestIsBrowser, RequestDetails theRequestDetails) throws IOException {
        assert (!theServerBase.endsWith("/"));
        theHttpResponse.setStatus(200);
        EncodingEnum responseEncoding = RestfulServerUtils.determineResponseEncodingWithDefault(theServer, theRequestDetails.getServletRequest());
        if (theRequestIsBrowser && theServer.isUseBrowserFriendlyContentTypes()) {
            theHttpResponse.setContentType(responseEncoding.getBrowserFriendlyBundleContentType());
        } else {
            theHttpResponse.setContentType(responseEncoding.getBundleContentType());
        }
        theHttpResponse.setCharacterEncoding("UTF-8");
        theServer.addHeadersToResponse(theHttpResponse);
        Writer writer = RestfulServerUtils.getWriter(theHttpResponse, theRespondGzip);
        try {
            IParser parser = RestfulServerUtils.getNewParser(theServer.getFhirContext(), theRequestDetails);
            if (theSummaryMode.contains((Object)SummaryEnum.TEXT)) {
                parser.setEncodeElements(TEXT_ENCODE_ELEMENTS);
            }
            parser.encodeBundleToWriter(bundle, writer);
        }
        finally {
            writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void streamResponseAsResource(RestfulServer theServer, HttpServletResponse theHttpResponse, IBaseResource theResource, boolean theRequestIsBrowser, Set<SummaryEnum> theSummaryMode, int stausCode, boolean theRespondGzip, boolean theAddContentLocationHeader, RequestDetails theRequestDetails) throws IOException {
        Serializable lastUpdated;
        theHttpResponse.setStatus(stausCode);
        EncodingEnum responseEncoding = RestfulServerUtils.determineResponseEncodingNoDefault(theRequestDetails.getServletRequest(), theServer.getDefaultResponseEncoding());
        String serverBase = theRequestDetails.getFhirServerBase();
        if (theAddContentLocationHeader && theResource.getIdElement() != null && theResource.getIdElement().hasIdPart() && StringUtils.isNotBlank((CharSequence)serverBase)) {
            String resName = theServer.getFhirContext().getResourceDefinition(theResource).getName();
            IIdType fullId = theResource.getIdElement().withServerBase(serverBase, resName);
            theHttpResponse.addHeader("Content-Location", fullId.getValue());
        }
        if (theServer.getETagSupport() == ETagSupportEnum.ENABLED && theResource.getIdElement().hasVersionIdPart()) {
            theHttpResponse.addHeader("ETag", "W/\"" + theResource.getIdElement().getVersionIdPart() + '\"');
        }
        if (theServer.getAddProfileTag() != AddProfileTagEnum.NEVER) {
            RuntimeResourceDefinition def = theServer.getFhirContext().getResourceDefinition(theResource);
            if (theServer.getAddProfileTag() == AddProfileTagEnum.ALWAYS || !def.isStandardProfile()) {
                RestfulServerUtils.addProfileToBundleEntry(theServer.getFhirContext(), theResource, serverBase);
            }
        }
        if (theResource instanceof IBaseBinary && responseEncoding == null) {
            IBaseBinary bin = (IBaseBinary)theResource;
            if (StringUtils.isNotBlank((CharSequence)bin.getContentType())) {
                theHttpResponse.setContentType(bin.getContentType());
            } else {
                theHttpResponse.setContentType("application/octet-stream");
            }
            if (bin.getContent() == null || bin.getContent().length == 0) {
                return;
            }
            theHttpResponse.addHeader("Content-Disposition", "Attachment;");
            theHttpResponse.setContentLength(bin.getContent().length);
            ServletOutputStream oos = theHttpResponse.getOutputStream();
            oos.write(bin.getContent());
            oos.close();
            return;
        }
        responseEncoding = responseEncoding != null ? responseEncoding : theServer.getDefaultResponseEncoding();
        boolean encodingDomainResourceAsText = theSummaryMode.contains((Object)SummaryEnum.TEXT);
        if (encodingDomainResourceAsText && "Bundle".equals(theServer.getFhirContext().getResourceDefinition(theResource).getName())) {
            encodingDomainResourceAsText = false;
        }
        if (theRequestIsBrowser && theServer.isUseBrowserFriendlyContentTypes()) {
            theHttpResponse.setContentType(responseEncoding.getBrowserFriendlyBundleContentType());
        } else if (encodingDomainResourceAsText) {
            theHttpResponse.setContentType("text/html");
        } else {
            theHttpResponse.setContentType(responseEncoding.getResourceContentType());
        }
        theHttpResponse.setCharacterEncoding("UTF-8");
        theServer.addHeadersToResponse(theHttpResponse);
        if (theResource instanceof IResource) {
            TagList list;
            lastUpdated = ResourceMetadataKeyEnum.UPDATED.get((IResource)theResource);
            if (lastUpdated != null && !((BasePrimitive)lastUpdated).isEmpty()) {
                theHttpResponse.addHeader("Last-Modified", DateUtils.formatDate((Date)((Date)((BasePrimitive)lastUpdated).getValue())));
            }
            if ((list = (TagList)((IResource)theResource).getResourceMetadata().get(ResourceMetadataKeyEnum.TAG_LIST)) != null) {
                for (Tag tag : list) {
                    if (!StringUtils.isNotBlank((CharSequence)tag.getTerm())) continue;
                    theHttpResponse.addHeader("Category", tag.toHeaderValue());
                }
            }
        } else {
            lastUpdated = ((IAnyResource)theResource).getMeta().getLastUpdated();
            if (lastUpdated != null) {
                theHttpResponse.addHeader("Last-Modified", DateUtils.formatDate((Date)lastUpdated));
            }
        }
        Writer writer = RestfulServerUtils.getWriter(theHttpResponse, theRespondGzip);
        try {
            if (encodingDomainResourceAsText && theResource instanceof IResource) {
                writer.append(((IResource)theResource).getText().getDiv().getValueAsString());
            } else {
                IParser parser = RestfulServerUtils.getNewParser(theServer.getFhirContext(), theRequestDetails);
                parser.encodeResourceToWriter(theResource, writer);
            }
        }
        finally {
            writer.close();
        }
    }

    public static void validateResourceListNotNull(List<? extends IBaseResource> theResourceList) {
        if (theResourceList == null) {
            throw new InternalErrorException("IBundleProvider returned a null list of resources - This is not allowed");
        }
    }

    public static Integer tryToExtractNamedParameter(RequestDetails theRequest, String theParamName) {
        String[] retVal = theRequest.getParameters().get(theParamName);
        if (retVal == null) {
            return null;
        }
        try {
            return Integer.parseInt(retVal[0]);
        }
        catch (NumberFormatException e) {
            ourLog.debug("Failed to parse {} value '{}': {}", new Object[]{theParamName, retVal[0], e});
            return null;
        }
    }

    private static enum NarrativeModeEnum {
        NORMAL,
        ONLY,
        SUPPRESS;


        public static NarrativeModeEnum valueOfCaseInsensitive(String theCode) {
            return NarrativeModeEnum.valueOf(NarrativeModeEnum.class, theCode.toUpperCase());
        }
    }
}

