/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor;

import ca.uhn.fhir.model.api.Bundle;
import ca.uhn.fhir.model.api.TagList;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.method.RequestDetails;
import ca.uhn.fhir.rest.server.exceptions.AuthenticationException;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;

public interface IServerInterceptor {
    public boolean handleException(RequestDetails var1, BaseServerResponseException var2, HttpServletRequest var3, HttpServletResponse var4) throws ServletException, IOException;

    public boolean incomingRequestPostProcessed(RequestDetails var1, HttpServletRequest var2, HttpServletResponse var3) throws AuthenticationException;

    public void incomingRequestPreHandled(RestOperationTypeEnum var1, ActionRequestDetails var2);

    public boolean incomingRequestPreProcessed(HttpServletRequest var1, HttpServletResponse var2);

    public boolean outgoingResponse(RequestDetails var1, Bundle var2, HttpServletRequest var3, HttpServletResponse var4) throws AuthenticationException;

    public boolean outgoingResponse(RequestDetails var1, HttpServletRequest var2, HttpServletResponse var3) throws AuthenticationException;

    public boolean outgoingResponse(RequestDetails var1, IBaseResource var2, HttpServletRequest var3, HttpServletResponse var4) throws AuthenticationException;

    public boolean outgoingResponse(RequestDetails var1, TagList var2, HttpServletRequest var3, HttpServletResponse var4) throws AuthenticationException;

    public BaseServerResponseException preProcessOutgoingException(RequestDetails var1, Throwable var2, HttpServletRequest var3) throws ServletException;

    public static class ActionRequestDetails {
        private final IIdType myId;
        private boolean myLocked = false;
        private IBaseResource myResource;
        private final String myResourceType;

        public ActionRequestDetails(IIdType theId, String theResourceType) {
            this.myId = theId;
            this.myResourceType = theResourceType;
        }

        public ActionRequestDetails(RequestDetails theRequestDetails) {
            this.myId = theRequestDetails.getId();
            this.myResourceType = theRequestDetails.getResourceName();
        }

        public ActionRequestDetails(IIdType theId, String theResourceType, IBaseResource theResource) {
            this(theId, theResourceType);
            this.myResource = theResource;
        }

        public IIdType getId() {
            return this.myId;
        }

        public IBaseResource getResource() {
            return this.myResource;
        }

        public String getResourceType() {
            return this.myResourceType;
        }

        public void lock() {
            this.myLocked = true;
        }

        public void setResource(IBaseResource theObject) {
            this.validateNotLocked();
            this.myResource = theObject;
        }

        private void validateNotLocked() {
            if (this.myLocked) {
                throw new IllegalStateException("Values on this object may not be changed");
            }
        }
    }
}

