/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor;

import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.method.RequestDetails;
import ca.uhn.fhir.rest.server.EncodingEnum;
import ca.uhn.fhir.rest.server.RestfulServerUtils;
import ca.uhn.fhir.rest.server.exceptions.AuthenticationException;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.interceptor.InterceptorAdapter;
import ca.uhn.fhir.util.UrlUtil;
import java.io.IOException;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class ResponseHighlighterInterceptor
extends InterceptorAdapter {
    public static final String PARAM_RAW_TRUE = "true";
    public static final String PARAM_RAW = "_raw";

    private String format(String theResultBody, EncodingEnum theEncodingEnum) {
        String str = StringEscapeUtils.escapeHtml4((String)theResultBody);
        if (str == null || theEncodingEnum == null) {
            return str;
        }
        StringBuilder b = new StringBuilder();
        if (theEncodingEnum == EncodingEnum.JSON) {
            boolean inValue = false;
            boolean inQuote = false;
            for (int i = 0; i < str.length(); ++i) {
                int nextChar6;
                int prevChar = i > 0 ? (int)str.charAt(i - 1) : 32;
                char nextChar = str.charAt(i);
                int nextChar2 = i + 1 < str.length() ? (int)str.charAt(i + 1) : 32;
                int nextChar3 = i + 2 < str.length() ? (int)str.charAt(i + 2) : 32;
                int nextChar4 = i + 3 < str.length() ? (int)str.charAt(i + 3) : 32;
                int nextChar5 = i + 4 < str.length() ? (int)str.charAt(i + 4) : 32;
                int n = nextChar6 = i + 5 < str.length() ? (int)str.charAt(i + 5) : 32;
                if (inQuote) {
                    b.append(nextChar);
                    if (prevChar != 92 && nextChar == '&' && nextChar2 == 113 && nextChar3 == 117 && nextChar4 == 111 && nextChar5 == 116 && nextChar6 == 59) {
                        b.append("quot;</span>");
                        i += 5;
                        inQuote = false;
                        continue;
                    }
                    if (nextChar != '\\' || nextChar2 != 34) continue;
                    b.append("quot;</span>");
                    i += 5;
                    inQuote = false;
                    continue;
                }
                if (nextChar == ':') {
                    inValue = true;
                    b.append(nextChar);
                    continue;
                }
                if (nextChar == '[' || nextChar == '{') {
                    b.append("<span class='hlControl'>");
                    b.append(nextChar);
                    b.append("</span>");
                    inValue = false;
                    continue;
                }
                if (nextChar == '}' || nextChar == '}' || nextChar == ',') {
                    b.append("<span class='hlControl'>");
                    b.append(nextChar);
                    b.append("</span>");
                    inValue = false;
                    continue;
                }
                if (nextChar == '&' && nextChar2 == 113 && nextChar3 == 117 && nextChar4 == 111 && nextChar5 == 116 && nextChar6 == 59) {
                    if (inValue) {
                        b.append("<span class='hlQuot'>&quot;");
                    } else {
                        b.append("<span class='hlTagName'>&quot;");
                    }
                    inQuote = true;
                    i += 5;
                    continue;
                }
                if (nextChar == ':') {
                    b.append("<span class='hlControl'>");
                    b.append(nextChar);
                    b.append("</span>");
                    inValue = true;
                    continue;
                }
                b.append(nextChar);
            }
        } else {
            boolean inQuote = false;
            boolean inTag = false;
            for (int i = 0; i < str.length(); ++i) {
                int nextChar6;
                char nextChar = str.charAt(i);
                int nextChar2 = i + 1 < str.length() ? (int)str.charAt(i + 1) : 32;
                int nextChar3 = i + 2 < str.length() ? (int)str.charAt(i + 2) : 32;
                int nextChar4 = i + 3 < str.length() ? (int)str.charAt(i + 3) : 32;
                int nextChar5 = i + 4 < str.length() ? (int)str.charAt(i + 4) : 32;
                int n = nextChar6 = i + 5 < str.length() ? (int)str.charAt(i + 5) : 32;
                if (inQuote) {
                    b.append(nextChar);
                    if (nextChar != '&' || nextChar2 != 113 || nextChar3 != 117 || nextChar4 != 111 || nextChar5 != 116 || nextChar6 != 59) continue;
                    b.append("quot;</span>");
                    i += 5;
                    inQuote = false;
                    continue;
                }
                if (inTag) {
                    if (nextChar == '&' && nextChar2 == 103 && nextChar3 == 116 && nextChar4 == 59) {
                        b.append("</span><span class='hlControl'>&gt;</span>");
                        inTag = false;
                        i += 3;
                        continue;
                    }
                    if (nextChar == ' ') {
                        b.append("</span><span class='hlAttr'>");
                        b.append(nextChar);
                        continue;
                    }
                    if (nextChar == '&' && nextChar2 == 113 && nextChar3 == 117 && nextChar4 == 111 && nextChar5 == 116 && nextChar6 == 59) {
                        b.append("<span class='hlQuot'>&quot;");
                        inQuote = true;
                        i += 5;
                        continue;
                    }
                    b.append(nextChar);
                    continue;
                }
                if (nextChar == '&' && nextChar2 == 108 && nextChar3 == 116 && nextChar4 == 59) {
                    b.append("<span class='hlControl'>&lt;</span><span class='hlTagName'>");
                    inTag = true;
                    i += 3;
                    continue;
                }
                b.append(nextChar);
            }
        }
        return b.toString();
    }

    @Override
    public boolean outgoingResponse(RequestDetails theRequestDetails, IBaseResource theResponseObject, HttpServletRequest theServletRequest, HttpServletResponse theServletResponse) throws AuthenticationException {
        Set<String> highestRankedAcceptValues = RestfulServerUtils.parseAcceptHeaderAndReturnHighestRankedOptions(theRequestDetails.getServletRequest());
        if (!highestRankedAcceptValues.contains("text/html")) {
            return super.outgoingResponse(theRequestDetails, theResponseObject, theServletRequest, theServletResponse);
        }
        String requestedWith = theServletRequest.getHeader("X-Requested-With");
        if (requestedWith != null) {
            return super.outgoingResponse(theRequestDetails, theResponseObject, theServletRequest, theServletResponse);
        }
        if (theRequestDetails.getRequestType() != RequestTypeEnum.GET) {
            return super.outgoingResponse(theRequestDetails, theResponseObject, theServletRequest, theServletResponse);
        }
        String[] rawParamValues = theRequestDetails.getParameters().get(PARAM_RAW);
        if (rawParamValues != null && rawParamValues.length > 0 && rawParamValues[0].equals(PARAM_RAW_TRUE)) {
            return super.outgoingResponse(theRequestDetails, theResponseObject, theServletRequest, theServletResponse);
        }
        this.streamResponse(theRequestDetails, theServletResponse, theResponseObject);
        return false;
    }

    private void streamResponse(RequestDetails theRequestDetails, HttpServletResponse theServletResponse, IBaseResource resource) {
        IParser p;
        if (theRequestDetails.getParameters().containsKey("_format")) {
            p = RestfulServerUtils.getNewParser(theRequestDetails.getServer().getFhirContext(), theRequestDetails);
        } else {
            EncodingEnum defaultResponseEncoding = theRequestDetails.getServer().getDefaultResponseEncoding();
            p = defaultResponseEncoding.newParser(theRequestDetails.getServer().getFhirContext());
            RestfulServerUtils.configureResponseParser(theRequestDetails, p);
        }
        EncodingEnum encoding = p.getEncoding();
        String encoded = p.encodeResourceToString(resource);
        theServletResponse.setContentType("text/html; charset=UTF-8");
        StringBuilder rawB = new StringBuilder();
        for (String next : theRequestDetails.getParameters().keySet()) {
            if (next.equals(PARAM_RAW)) continue;
            for (String nextValue : theRequestDetails.getParameters().get(next)) {
                if (StringUtils.isBlank((CharSequence)nextValue)) continue;
                if (rawB.length() == 0) {
                    rawB.append('?');
                } else {
                    rawB.append('&');
                }
                rawB.append(UrlUtil.escape(next));
                rawB.append('=');
                rawB.append(UrlUtil.escape(nextValue));
            }
        }
        if (rawB.length() == 0) {
            rawB.append('?');
        } else {
            rawB.append('&');
        }
        rawB.append(PARAM_RAW).append('=').append(PARAM_RAW_TRUE);
        String out = "<html lang=\"en\">\n\t<head>\n\t\t<meta charset=\"utf-8\" />\n       <style>\n.hlQuot {\n\tcolor: #88F;\n}\n.hlAttr {\n\tcolor: #888;\n}\n.hlTagName {\n\tcolor: #006699;\n}\n.hlControl {\n\tcolor: #660000;\n}\n.hlText {\n\tcolor: #000000;\n}\n.hlUrlBase {\n}       </style>\n\t</head>\n\n\t<body>This result is being rendered in HTML for easy viewing. <a href=\"" + rawB.toString() + "\">Click here</a> to disable this.<br/><br/>" + "<pre>" + this.format(encoded, encoding) + "</pre>" + "   </body>" + "</html>";
        try {
            theServletResponse.getWriter().append(out);
            theServletResponse.getWriter().close();
        }
        catch (IOException e) {
            throw new InternalErrorException(e);
        }
    }

    @Override
    public boolean handleException(RequestDetails theRequestDetails, BaseServerResponseException theException, HttpServletRequest theServletRequest, HttpServletResponse theServletResponse) throws ServletException, IOException {
        Set<String> accept = RestfulServerUtils.parseAcceptHeaderAndReturnHighestRankedOptions(theRequestDetails.getServletRequest());
        if (!accept.contains("text/html")) {
            return super.handleException(theRequestDetails, theException, theServletRequest, theServletResponse);
        }
        String requestedWith = theServletRequest.getHeader("X-Requested-With");
        if (requestedWith != null) {
            return super.handleException(theRequestDetails, theException, theServletRequest, theServletResponse);
        }
        if (theRequestDetails.getRequestType() != RequestTypeEnum.GET) {
            return super.handleException(theRequestDetails, theException, theServletRequest, theServletResponse);
        }
        if (theException.getOperationOutcome() == null) {
            return super.handleException(theRequestDetails, theException, theServletRequest, theServletResponse);
        }
        this.streamResponse(theRequestDetails, theServletResponse, theException.getOperationOutcome());
        return false;
    }
}

