/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementCompositeDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeChildChoiceDefinition;
import ca.uhn.fhir.context.RuntimeChildDirectResource;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.model.api.ExtensionDt;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.ISupportsUndeclaredExtensions;
import ca.uhn.fhir.model.base.composite.BaseContainedDt;
import ca.uhn.fhir.model.base.composite.BaseResourceReferenceDt;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.util.IModelVisitor;
import ca.uhn.fhir.util.IModelVisitor2;
import ca.uhn.fhir.util.ResourceReferenceInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public class FhirTerser {
    private FhirContext myContext;

    public FhirTerser(FhirContext theContext) {
        this.myContext = theContext;
    }

    private void addUndeclaredExtensions(IBase theElement, BaseRuntimeElementDefinition<?> theDefinition, BaseRuntimeChildDefinition theChildDefinition, IModelVisitor theCallback) {
        if (theElement instanceof ISupportsUndeclaredExtensions) {
            ISupportsUndeclaredExtensions containingElement = (ISupportsUndeclaredExtensions)theElement;
            for (ExtensionDt nextExt : containingElement.getUndeclaredExtensions()) {
                theCallback.acceptUndeclaredExtension(containingElement, null, theChildDefinition, theDefinition, nextExt);
                this.addUndeclaredExtensions(nextExt, theDefinition, theChildDefinition, theCallback);
            }
        }
    }

    public <T extends IBase> List<T> getAllPopulatedChildElementsOfType(IBaseResource theResource, final Class<T> theType) {
        final ArrayList retVal = new ArrayList();
        RuntimeResourceDefinition def = this.myContext.getResourceDefinition(theResource);
        this.visit(new IdentityHashMap<Object, Object>(), theResource, null, null, def, new IModelVisitor(){

            @Override
            public void acceptElement(IBase theElement, List<String> thePathToElement, BaseRuntimeChildDefinition theChildDefinition, BaseRuntimeElementDefinition<?> theDefinition) {
                if (theElement == null || theElement.isEmpty()) {
                    return;
                }
                if (theType.isAssignableFrom(theElement.getClass())) {
                    retVal.add(theElement);
                }
            }

            @Override
            public void acceptUndeclaredExtension(ISupportsUndeclaredExtensions theContainingElement, List<String> thePathToElement, BaseRuntimeChildDefinition theChildDefinition, BaseRuntimeElementDefinition<?> theDefinition, ExtensionDt theNextExt) {
                if (theType.isAssignableFrom(theNextExt.getClass())) {
                    retVal.add(theNextExt);
                }
                if (theNextExt.getValue() != null && theType.isAssignableFrom(theNextExt.getValue().getClass())) {
                    retVal.add(theNextExt.getValue());
                }
            }
        });
        return retVal;
    }

    public List<ResourceReferenceInfo> getAllResourceReferences(final IBaseResource theResource) {
        final ArrayList<ResourceReferenceInfo> retVal = new ArrayList<ResourceReferenceInfo>();
        RuntimeResourceDefinition def = this.myContext.getResourceDefinition(theResource);
        this.visit(new IdentityHashMap<Object, Object>(), theResource, null, null, def, new IModelVisitor(){

            @Override
            public void acceptElement(IBase theElement, List<String> thePathToElement, BaseRuntimeChildDefinition theChildDefinition, BaseRuntimeElementDefinition<?> theDefinition) {
                if (theElement == null || theElement.isEmpty()) {
                    return;
                }
                if (IBaseReference.class.isAssignableFrom(theElement.getClass())) {
                    retVal.add(new ResourceReferenceInfo(FhirTerser.this.myContext, theResource, thePathToElement, (IBaseReference)theElement));
                }
            }

            @Override
            public void acceptUndeclaredExtension(ISupportsUndeclaredExtensions theContainingElement, List<String> thePathToElement, BaseRuntimeChildDefinition theChildDefinition, BaseRuntimeElementDefinition<?> theDefinition, ExtensionDt theNextExt) {
                if (theNextExt.getValue() != null && BaseResourceReferenceDt.class.isAssignableFrom(theNextExt.getValue().getClass())) {
                    retVal.add(new ResourceReferenceInfo(FhirTerser.this.myContext, theResource, thePathToElement, (BaseResourceReferenceDt)theNextExt.getValue()));
                }
            }
        });
        return retVal;
    }

    private BaseRuntimeChildDefinition getDefinition(BaseRuntimeElementCompositeDefinition<?> theCurrentDef, List<String> theSubList) {
        BaseRuntimeChildDefinition nextDef = theCurrentDef.getChildByNameOrThrowDataFormatException(theSubList.get(0));
        if (theSubList.size() == 1) {
            return nextDef;
        }
        BaseRuntimeElementCompositeDefinition cmp = (BaseRuntimeElementCompositeDefinition)nextDef.getChildByName(theSubList.get(0));
        return this.getDefinition(cmp, theSubList.subList(1, theSubList.size()));
    }

    public BaseRuntimeChildDefinition getDefinition(Class<? extends IBaseResource> theResourceType, String thePath) {
        RuntimeResourceDefinition def;
        RuntimeResourceDefinition currentDef = def = this.myContext.getResourceDefinition(theResourceType);
        List<String> parts = Arrays.asList(thePath.split("\\."));
        List<String> subList = parts.subList(1, parts.size());
        if (subList.size() < 1) {
            throw new ConfigurationException("Invalid path: " + thePath);
        }
        return this.getDefinition(currentDef, subList);
    }

    private <T> List<T> getValues(BaseRuntimeElementCompositeDefinition<?> theCurrentDef, Object theCurrentObj, List<String> theSubList, Class<T> theWantedClass) {
        String name = theSubList.get(0);
        BaseRuntimeChildDefinition nextDef = theCurrentDef.getChildByNameOrThrowDataFormatException(name);
        List<IBase> values = nextDef.getAccessor().getValues(theCurrentObj);
        ArrayList<IBase> retVal = new ArrayList<IBase>();
        if (theSubList.size() == 1) {
            if (nextDef instanceof RuntimeChildChoiceDefinition) {
                for (IBase next : values) {
                    if (next == null) continue;
                    if (name.endsWith("[x]")) {
                        if (theWantedClass != null && !theWantedClass.isAssignableFrom(next.getClass())) continue;
                        retVal.add(next);
                        continue;
                    }
                    String childName = nextDef.getChildNameByDatatype(next.getClass());
                    if (!theSubList.get(0).equals(childName) || theWantedClass != null && !theWantedClass.isAssignableFrom(next.getClass())) continue;
                    retVal.add(next);
                }
            } else {
                for (IBase next : values) {
                    if (next == null || theWantedClass != null && !theWantedClass.isAssignableFrom(next.getClass())) continue;
                    retVal.add(next);
                }
            }
        } else {
            for (IBase nextElement : values) {
                BaseRuntimeElementCompositeDefinition nextChildDef = (BaseRuntimeElementCompositeDefinition)this.myContext.getElementDefinition(nextElement.getClass());
                List<T> foundValues = this.getValues(nextChildDef, nextElement, theSubList.subList(1, theSubList.size()), theWantedClass);
                retVal.addAll(foundValues);
            }
        }
        return retVal;
    }

    public List<Object> getValues(IBaseResource theResource, String thePath) {
        Class<Object> wantedClass = Object.class;
        return this.getValues(theResource, thePath, wantedClass);
    }

    public <T> List<T> getValues(IBaseResource theResource, String thePath, Class<T> theWantedClass) {
        RuntimeResourceDefinition def;
        RuntimeResourceDefinition currentDef = def = this.myContext.getResourceDefinition(theResource);
        IBaseResource currentObj = theResource;
        List<String> parts = Arrays.asList(thePath.split("\\."));
        List<String> subList = parts.subList(1, parts.size());
        if (subList.size() < 1) {
            throw new ConfigurationException("Invalid path: " + thePath);
        }
        return this.getValues(currentDef, currentObj, subList, theWantedClass);
    }

    private List<String> addNameToList(List<String> theCurrentList, BaseRuntimeChildDefinition theChildDefinition) {
        if (theChildDefinition == null) {
            return null;
        }
        if (theCurrentList == null || theCurrentList.isEmpty()) {
            return new ArrayList<String>(Arrays.asList(theChildDefinition.getElementName()));
        }
        ArrayList<String> newList = new ArrayList<String>(theCurrentList);
        newList.add(theChildDefinition.getElementName());
        return newList;
    }

    private void visit(IdentityHashMap<Object, Object> theStack, IBase theElement, List<String> thePathToElement, BaseRuntimeChildDefinition theChildDefinition, BaseRuntimeElementDefinition<?> theDefinition, IModelVisitor theCallback) {
        List<String> pathToElement = this.addNameToList(thePathToElement, theChildDefinition);
        if (theStack.put(theElement, theElement) != null) {
            return;
        }
        theCallback.acceptElement(theElement, pathToElement, theChildDefinition, theDefinition);
        this.addUndeclaredExtensions(theElement, theDefinition, theChildDefinition, theCallback);
        BaseRuntimeElementDefinition def = theDefinition;
        if (def.getChildType() == BaseRuntimeElementDefinition.ChildTypeEnum.CONTAINED_RESOURCE_LIST) {
            def = this.myContext.getElementDefinition(theElement.getClass());
        }
        switch (def.getChildType()) {
            case ID_DATATYPE: 
            case PRIMITIVE_XHTML_HL7ORG: 
            case PRIMITIVE_XHTML: 
            case PRIMITIVE_DATATYPE: {
                break;
            }
            case RESOURCE_REF: {
                IBaseResource theResource;
                IBaseReference resRefDt = (IBaseReference)theElement;
                if (resRefDt.getReferenceElement().getValue() != null || resRefDt.getResource() == null || (theResource = resRefDt.getResource()).getIdElement() != null && !theResource.getIdElement().isEmpty() && !theResource.getIdElement().isLocal()) break;
                def = this.myContext.getResourceDefinition(theResource);
                this.visit(theStack, theResource, pathToElement, null, def, theCallback);
                break;
            }
            case RESOURCE: 
            case RESOURCE_BLOCK: 
            case COMPOSITE_DATATYPE: {
                BaseRuntimeElementCompositeDefinition childDef = (BaseRuntimeElementCompositeDefinition)def;
                for (BaseRuntimeChildDefinition baseRuntimeChildDefinition : childDef.getChildrenAndExtension()) {
                    List<IBase> values = baseRuntimeChildDefinition.getAccessor().getValues(theElement);
                    if (values == null) continue;
                    for (IBase nextValue : values) {
                        if (nextValue == null || nextValue.isEmpty()) continue;
                        BaseRuntimeElementDefinition<?> childElementDef = baseRuntimeChildDefinition.getChildElementDefinitionByDatatype(nextValue.getClass());
                        if (childElementDef == null) {
                            childElementDef = this.myContext.getElementDefinition(nextValue.getClass());
                        }
                        if (baseRuntimeChildDefinition instanceof RuntimeChildDirectResource) {
                            theCallback.acceptElement(nextValue, null, baseRuntimeChildDefinition, childElementDef);
                            continue;
                        }
                        this.visit(theStack, nextValue, pathToElement, baseRuntimeChildDefinition, childElementDef, theCallback);
                    }
                }
                break;
            }
            case CONTAINED_RESOURCES: {
                BaseContainedDt value = (BaseContainedDt)theElement;
                for (IResource iResource : value.getContainedResources()) {
                    def = this.myContext.getResourceDefinition(iResource);
                    this.visit(theStack, iResource, pathToElement, null, def, theCallback);
                }
                break;
            }
            case CONTAINED_RESOURCE_LIST: 
            case EXTENSION_DECLARED: 
            case UNDECL_EXT: {
                throw new IllegalStateException("state should not happen: " + (Object)((Object)def.getChildType()));
            }
        }
        theStack.remove(theElement);
    }

    private void visit(IBase theElement, BaseRuntimeChildDefinition theChildDefinition, BaseRuntimeElementDefinition<?> theDefinition, IModelVisitor2 theCallback, List<IBase> theContainingElementPath, List<BaseRuntimeChildDefinition> theChildDefinitionPath, List<BaseRuntimeElementDefinition<?>> theElementDefinitionPath) {
        if (theChildDefinition != null) {
            theChildDefinitionPath.add(theChildDefinition);
        }
        theContainingElementPath.add(theElement);
        theElementDefinitionPath.add(theDefinition);
        theCallback.acceptElement(theElement, Collections.unmodifiableList(theContainingElementPath), Collections.unmodifiableList(theChildDefinitionPath), Collections.unmodifiableList(theElementDefinitionPath));
        if (theElement instanceof ISupportsUndeclaredExtensions) {
            ISupportsUndeclaredExtensions containingElement = (ISupportsUndeclaredExtensions)theElement;
            for (ExtensionDt nextExt : containingElement.getUndeclaredExtensions()) {
                theContainingElementPath.add(nextExt);
                theCallback.acceptUndeclaredExtension(nextExt, theContainingElementPath, theChildDefinitionPath, theElementDefinitionPath);
                theContainingElementPath.remove(theContainingElementPath.size() - 1);
            }
        }
        switch (theDefinition.getChildType()) {
            case ID_DATATYPE: 
            case PRIMITIVE_XHTML_HL7ORG: 
            case PRIMITIVE_XHTML: 
            case PRIMITIVE_DATATYPE: {
                break;
            }
            case RESOURCE_REF: {
                IBaseResource theResource;
                IBaseReference resRefDt = (IBaseReference)theElement;
                if (resRefDt.getReferenceElement().getValue() != null || resRefDt.getResource() == null || (theResource = resRefDt.getResource()).getIdElement() != null && !theResource.getIdElement().isEmpty() && !theResource.getIdElement().isLocal()) break;
                RuntimeResourceDefinition def = this.myContext.getResourceDefinition(theResource);
                this.visit(theResource, null, def, theCallback, theContainingElementPath, theChildDefinitionPath, theElementDefinitionPath);
                break;
            }
            case RESOURCE: 
            case RESOURCE_BLOCK: 
            case COMPOSITE_DATATYPE: {
                BaseRuntimeElementCompositeDefinition childDef = (BaseRuntimeElementCompositeDefinition)theDefinition;
                for (BaseRuntimeChildDefinition baseRuntimeChildDefinition : childDef.getChildrenAndExtension()) {
                    List<IBase> values = baseRuntimeChildDefinition.getAccessor().getValues(theElement);
                    if (values == null) continue;
                    for (IBase nextValue : values) {
                        if (nextValue == null || nextValue.isEmpty()) continue;
                        BaseRuntimeElementDefinition<?> childElementDef = baseRuntimeChildDefinition.getChildElementDefinitionByDatatype(nextValue.getClass());
                        if (childElementDef == null) {
                            StringBuilder b = new StringBuilder();
                            b.append("Found value of type[");
                            b.append(nextValue.getClass().getSimpleName());
                            b.append("] which is not valid for field[");
                            b.append(baseRuntimeChildDefinition.getElementName());
                            b.append("] in ");
                            b.append(childDef.getName());
                            b.append(" - Valid types: ");
                            Iterator<String> iter = new TreeSet<String>(baseRuntimeChildDefinition.getValidChildNames()).iterator();
                            while (iter.hasNext()) {
                                BaseRuntimeElementDefinition<?> childByName = baseRuntimeChildDefinition.getChildByName(iter.next());
                                b.append(childByName.getImplementingClass().getSimpleName());
                                if (!iter.hasNext()) continue;
                                b.append(", ");
                            }
                            throw new DataFormatException(b.toString());
                        }
                        if (baseRuntimeChildDefinition instanceof RuntimeChildDirectResource) {
                            theContainingElementPath.add(nextValue);
                            theChildDefinitionPath.add(baseRuntimeChildDefinition);
                            theElementDefinitionPath.add(this.myContext.getElementDefinition(nextValue.getClass()));
                            theCallback.acceptElement(nextValue, Collections.unmodifiableList(theContainingElementPath), Collections.unmodifiableList(theChildDefinitionPath), Collections.unmodifiableList(theElementDefinitionPath));
                            theChildDefinitionPath.remove(theChildDefinitionPath.size() - 1);
                            theContainingElementPath.remove(theContainingElementPath.size() - 1);
                            theElementDefinitionPath.remove(theElementDefinitionPath.size() - 1);
                            continue;
                        }
                        this.visit(nextValue, baseRuntimeChildDefinition, childElementDef, theCallback, theContainingElementPath, theChildDefinitionPath, theElementDefinitionPath);
                    }
                }
                break;
            }
            case CONTAINED_RESOURCES: {
                BaseContainedDt value = (BaseContainedDt)theElement;
                for (IResource iResource : value.getContainedResources()) {
                    RuntimeResourceDefinition def = this.myContext.getResourceDefinition(iResource);
                    this.visit(iResource, null, def, theCallback, theContainingElementPath, theChildDefinitionPath, theElementDefinitionPath);
                }
                break;
            }
            case EXTENSION_DECLARED: 
            case UNDECL_EXT: {
                throw new IllegalStateException("state should not happen: " + (Object)((Object)theDefinition.getChildType()));
            }
            case CONTAINED_RESOURCE_LIST: {
                if (theElement == null) break;
                BaseRuntimeElementDefinition<?> def = this.myContext.getElementDefinition(theElement.getClass());
                this.visit(theElement, null, def, theCallback, theContainingElementPath, theChildDefinitionPath, theElementDefinitionPath);
            }
        }
        if (theChildDefinition != null) {
            theChildDefinitionPath.remove(theChildDefinitionPath.size() - 1);
        }
        theContainingElementPath.remove(theContainingElementPath.size() - 1);
        theElementDefinitionPath.remove(theElementDefinitionPath.size() - 1);
    }

    public void visit(IBaseResource theResource, IModelVisitor theVisitor) {
        RuntimeResourceDefinition def = this.myContext.getResourceDefinition(theResource);
        this.visit(new IdentityHashMap<Object, Object>(), theResource, null, null, def, theVisitor);
    }

    void visit(IBaseResource theResource, IModelVisitor2 theVisitor) {
        RuntimeResourceDefinition def = this.myContext.getResourceDefinition(theResource);
        this.visit(theResource, null, def, theVisitor, new ArrayList<IBase>(), new ArrayList<BaseRuntimeChildDefinition>(), new ArrayList());
    }

    public Object getSingleValueOrNull(IBase theTarget, String thePath) {
        Class<Object> wantedType = Object.class;
        return this.getSingleValueOrNull(theTarget, thePath, wantedType);
    }

    public <T> T getSingleValueOrNull(IBase theTarget, String thePath, Class<T> theWantedType) {
        Validate.notNull((Object)theTarget, (String)"theTarget must not be null", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)thePath, (String)"thePath must not be empty", (Object[])new Object[0]);
        BaseRuntimeElementDefinition<?> def = this.myContext.getElementDefinition(theTarget.getClass());
        if (!(def instanceof BaseRuntimeElementCompositeDefinition)) {
            throw new IllegalArgumentException("Target is not a composite type: " + theTarget.getClass().getName());
        }
        BaseRuntimeElementCompositeDefinition currentDef = (BaseRuntimeElementCompositeDefinition)def;
        IBase currentObj = theTarget;
        List<String> parts = Arrays.asList(thePath.split("\\."));
        List<T> retVal = this.getValues(currentDef, currentObj, parts, theWantedType);
        if (retVal.isEmpty()) {
            return null;
        }
        return retVal.get(0);
    }

    public void cloneInto(IBase theSource, IBase theTarget, boolean theIgnoreMissingFields) {
        Validate.notNull((Object)theSource, (String)"theSource must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)theTarget, (String)"theTarget must not be null", (Object[])new Object[0]);
        if (theSource instanceof IPrimitiveType) {
            if (theTarget instanceof IPrimitiveType) {
                ((IPrimitiveType)theTarget).setValueAsString(((IPrimitiveType)theSource).getValueAsString());
                return;
            }
            if (theIgnoreMissingFields) {
                return;
            }
            throw new DataFormatException("Can not copy value from primitive of type " + theSource.getClass().getName() + " into type " + theTarget.getClass().getName());
        }
        BaseRuntimeElementCompositeDefinition sourceDef = (BaseRuntimeElementCompositeDefinition)this.myContext.getElementDefinition(theSource.getClass());
        BaseRuntimeElementCompositeDefinition targetDef = (BaseRuntimeElementCompositeDefinition)this.myContext.getElementDefinition(theTarget.getClass());
        for (BaseRuntimeChildDefinition nextChild : sourceDef.getChildren()) {
            for (IBase nextValue : nextChild.getAccessor().getValues(theSource)) {
                BaseRuntimeChildDefinition targetChild = targetDef.getChildByName(nextChild.getElementName());
                if (targetChild == null) {
                    if (theIgnoreMissingFields) continue;
                    throw new DataFormatException("Type " + theTarget.getClass().getName() + " does not have a child with name " + nextChild.getElementName());
                }
                Object target = targetChild.getChildByName(nextChild.getElementName()).newInstance();
                targetChild.getMutator().addValue(theTarget, (IBase)target);
                this.cloneInto(nextValue, (IBase)target, theIgnoreMissingFields);
            }
        }
    }
}

