/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.Include;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class ResourceReferenceInfo {
    private String myOwningResource;
    private String myName;
    private IBaseReference myResource;

    public ResourceReferenceInfo(FhirContext theContext, IBaseResource theOwningResource, List<String> thePathToElement, IBaseReference theElement) {
        this.myOwningResource = theContext.getResourceDefinition(theOwningResource).getName();
        this.myResource = theElement;
        if (thePathToElement != null && !thePathToElement.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            thePathToElement.iterator();
            Iterator<String> iterator = thePathToElement.iterator();
            while (iterator.hasNext()) {
                sb.append(iterator.next());
                if (!iterator.hasNext()) continue;
                sb.append(".");
            }
            this.myName = sb.toString();
        } else {
            this.myName = null;
        }
    }

    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        b.append("name", (Object)this.myName);
        b.append("resource", (Object)this.myResource.getReferenceElement());
        return b.build();
    }

    public String getName() {
        return this.myName;
    }

    public IBaseReference getResourceReference() {
        return this.myResource;
    }

    public boolean matchesIncludeSet(Set<Include> theIncludes) {
        if (theIncludes == null) {
            return false;
        }
        for (Include include : theIncludes) {
            if (!this.matchesInclude(include)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesInclude(Include theInclude) {
        if (theInclude.getValue().equals("*")) {
            return true;
        }
        if (theInclude.getValue().indexOf(58) != -1) {
            return theInclude.getValue().equals(this.myOwningResource + ':' + this.myName);
        }
        return theInclude.getValue().equals(this.myOwningResource + '.' + this.myName);
    }
}

