/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlUtil {
    private static final Logger ourLog = LoggerFactory.getLogger(UrlUtil.class);

    public static void main(String[] args) {
        System.out.println(UrlUtil.escape("http://snomed.info/sct?fhir_vs=isa/126851005"));
    }

    public static String constructAbsoluteUrl(String theBase, String theEndpoint) {
        if (theEndpoint == null) {
            return null;
        }
        if (UrlUtil.isAbsolute(theEndpoint)) {
            return theEndpoint;
        }
        if (theBase == null) {
            return theEndpoint;
        }
        try {
            return new URL(new URL(theBase), theEndpoint).toString();
        }
        catch (MalformedURLException e) {
            ourLog.warn("Failed to resolve relative URL[" + theEndpoint + "] against absolute base[" + theBase + "]", (Throwable)e);
            return theEndpoint;
        }
    }

    public static boolean isAbsolute(String theValue) {
        String value = theValue.toLowerCase();
        return value.startsWith("http://") || value.startsWith("https://");
    }

    public static String constructRelativeUrl(String theParentExtensionUrl, String theExtensionUrl) {
        if (theParentExtensionUrl == null) {
            return theExtensionUrl;
        }
        if (theExtensionUrl == null) {
            return theExtensionUrl;
        }
        int parentLastSlashIdx = theParentExtensionUrl.lastIndexOf(47);
        int childLastSlashIdx = theExtensionUrl.lastIndexOf(47);
        if (parentLastSlashIdx == -1 || childLastSlashIdx == -1) {
            return theExtensionUrl;
        }
        if (parentLastSlashIdx != childLastSlashIdx) {
            return theExtensionUrl;
        }
        if (!theParentExtensionUrl.substring(0, parentLastSlashIdx).equals(theExtensionUrl.substring(0, parentLastSlashIdx))) {
            return theExtensionUrl;
        }
        if (theExtensionUrl.length() > parentLastSlashIdx) {
            return theExtensionUrl.substring(parentLastSlashIdx + 1);
        }
        return theExtensionUrl;
    }

    public static boolean isValid(String theUrl) {
        int slashOffset;
        if (theUrl == null || theUrl.length() < 8) {
            return false;
        }
        String url = theUrl.toLowerCase();
        if (url.charAt(0) != 'h') {
            return false;
        }
        if (url.charAt(1) != 't') {
            return false;
        }
        if (url.charAt(2) != 't') {
            return false;
        }
        if (url.charAt(3) != 'p') {
            return false;
        }
        if (url.charAt(4) == ':') {
            slashOffset = 5;
        } else if (url.charAt(4) == 's') {
            if (url.charAt(5) != ':') {
                return false;
            }
            slashOffset = 6;
        } else {
            return false;
        }
        if (url.charAt(slashOffset) != '/') {
            return false;
        }
        return url.charAt(slashOffset + 1) == '/';
    }

    public static String unescape(String theString) {
        if (theString == null) {
            return null;
        }
        if (theString.indexOf(37) == -1) {
            return theString;
        }
        try {
            return URLDecoder.decode(theString, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("UTF-8 not supported, this shouldn't happen", e);
        }
    }

    public static String escape(String theValue) {
        if (theValue == null) {
            return null;
        }
        try {
            return URLEncoder.encode(theValue, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("UTF-8 not supported on this platform");
        }
    }

    public static UrlParts parseUrl(String theUrl) {
        String url = theUrl;
        if (url.matches("\\/[a-zA-Z]+\\?.*")) {
            url = url.substring(1);
        }
        UrlParts retVal = new UrlParts();
        int nextStart = 0;
        boolean nextIsHistory = false;
        for (int idx = 0; idx < url.length(); ++idx) {
            boolean atEnd;
            char nextChar = url.charAt(idx);
            boolean bl = atEnd = idx + 1 == url.length();
            if (nextChar != '?' && nextChar != '/' && !atEnd) continue;
            int endIdx = atEnd && nextChar != '?' ? idx + 1 : idx;
            String nextSubstring = url.substring(nextStart, endIdx);
            if (retVal.getResourceType() == null) {
                retVal.setResourceType(nextSubstring);
            } else if (retVal.getResourceId() == null) {
                retVal.setResourceId(nextSubstring);
            } else if (nextIsHistory) {
                retVal.setVersionId(nextSubstring);
            } else if (nextSubstring.equals("_history")) {
                nextIsHistory = true;
            } else {
                throw new InvalidRequestException("Invalid FHIR resource URL: " + url);
            }
            if (nextChar == '?') {
                if (url.length() <= idx + 1) break;
                retVal.setParams(url.substring(idx + 1, url.length()));
                break;
            }
            nextStart = idx + 1;
        }
        return retVal;
    }

    public static class UrlParts {
        private String myParams;
        private String myResourceId;
        private String myResourceType;
        private String myVersionId;

        public String getParams() {
            return this.myParams;
        }

        public String getResourceId() {
            return this.myResourceId;
        }

        public String getResourceType() {
            return this.myResourceType;
        }

        public String getVersionId() {
            return this.myVersionId;
        }

        public void setParams(String theParams) {
            this.myParams = theParams;
        }

        public void setResourceId(String theResourceId) {
            this.myResourceId = theResourceId;
        }

        public void setResourceType(String theResourceType) {
            this.myResourceType = theResourceType;
        }

        public void setVersionId(String theVersionId) {
            this.myVersionId = theVersionId;
        }
    }
}

