/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util.reflection;

import ca.uhn.fhir.util.reflection.IBeanUtils;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;

public class JavaBeansBeanUtil
implements IBeanUtils {
    @Override
    public Method findAccessor(Class<?> theClassToIntrospect, Class<?> theTargetReturnType, String thePropertyName) throws NoSuchFieldException {
        BeanInfo info;
        try {
            info = Introspector.getBeanInfo(theClassToIntrospect);
        }
        catch (IntrospectionException e) {
            throw new NoSuchFieldException(e.getMessage());
        }
        for (PropertyDescriptor pd : info.getPropertyDescriptors()) {
            if (!thePropertyName.equals(pd.getName())) continue;
            if (theTargetReturnType.isAssignableFrom(pd.getPropertyType())) {
                return pd.getReadMethod();
            }
            throw new NoSuchFieldException(theClassToIntrospect + " has an accessor for field " + thePropertyName + " but it does not return type " + theTargetReturnType);
        }
        throw new NoSuchFieldException(theClassToIntrospect + " has no accessor for field " + thePropertyName);
    }

    @Override
    public Method findMutator(Class<?> theClassToIntrospect, Class<?> theTargetReturnType, String thePropertyName) throws NoSuchFieldException {
        BeanInfo info;
        try {
            info = Introspector.getBeanInfo(theClassToIntrospect);
        }
        catch (IntrospectionException e) {
            throw new NoSuchFieldException(e.getMessage());
        }
        for (PropertyDescriptor pd : info.getPropertyDescriptors()) {
            if (!thePropertyName.equals(pd.getName())) continue;
            if (theTargetReturnType.isAssignableFrom(pd.getPropertyType())) {
                return pd.getWriteMethod();
            }
            throw new NoSuchFieldException(theClassToIntrospect + " has an mutator for field " + thePropertyName + " but it does not return type " + theTargetReturnType);
        }
        throw new NoSuchFieldException(theClassToIntrospect + " has no mutator for field " + thePropertyName);
    }
}

