/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util.reflection;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.util.reflection.IBeanUtils;
import java.lang.reflect.Method;
import org.apache.commons.lang3.text.WordUtils;

public class JavaReflectBeanUtil
implements IBeanUtils {
    @Override
    public Method findAccessor(Class<?> theClassToIntrospect, Class<?> theTargetReturnType, String thePropertyName) throws NoSuchFieldException {
        String methodName = "get" + WordUtils.capitalize((String)thePropertyName);
        try {
            Method method = theClassToIntrospect.getMethod(methodName, new Class[0]);
            if (theTargetReturnType.isAssignableFrom(method.getReturnType())) {
                return method;
            }
        }
        catch (NoSuchMethodException method) {
        }
        catch (SecurityException e) {
            throw new ConfigurationException("Failed to scan class '" + theClassToIntrospect + "' because of a security exception", e);
        }
        throw new NoSuchFieldException(theClassToIntrospect + " has no accessor for field " + thePropertyName);
    }

    @Override
    public Method findMutator(Class<?> theClassToIntrospect, Class<?> theTargetArgumentType, String thePropertyName) throws NoSuchFieldException {
        String methodName = "set" + WordUtils.capitalize((String)thePropertyName);
        try {
            return theClassToIntrospect.getMethod(methodName, theTargetArgumentType);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException e) {
            throw new ConfigurationException("Failed to scan class '" + theClassToIntrospect + "' because of a security exception", e);
        }
        throw new NoSuchFieldException(theClassToIntrospect + " has an mutator for field " + thePropertyName + " but it does not return type " + theTargetArgumentType);
    }
}

