/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.validation.schematron;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.validation.FhirValidator;
import ca.uhn.fhir.validation.IValidatorModule;
import java.lang.reflect.Constructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchematronProvider {
    private static final String I18N_KEY_NO_PHLOC_WARNING = FhirValidator.class.getName() + ".noPhlocWarningOnStartup";
    private static final Logger ourLog = LoggerFactory.getLogger(FhirValidator.class);

    public static boolean isScematronAvailable(FhirContext theFhirContext) {
        try {
            Class.forName("com.phloc.schematron.ISchematronResource");
            return true;
        }
        catch (ClassNotFoundException e) {
            ourLog.info(theFhirContext.getLocalizer().getMessage(I18N_KEY_NO_PHLOC_WARNING, new Object[0]));
            return false;
        }
    }

    public static Class<? extends IValidatorModule> getSchematronValidatorClass() {
        try {
            return Class.forName("ca.uhn.fhir.validation.schematron.SchematronBaseValidator");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Cannot resolve schematron validator ", e);
        }
    }

    public static IValidatorModule getSchematronValidatorInstance(FhirContext myContext) {
        try {
            Class<? extends IValidatorModule> cls = SchematronProvider.getSchematronValidatorClass();
            Constructor<? extends IValidatorModule> constructor = cls.getConstructor(FhirContext.class);
            return constructor.newInstance(myContext);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("Cannot construct schematron validator ", e);
        }
    }
}

