/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.composite;

import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.ICompositeDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.dstu2.composite.PeriodDt;
import ca.uhn.fhir.model.dstu2.valueset.AddressTypeEnum;
import ca.uhn.fhir.model.dstu2.valueset.AddressUseEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;

@DatatypeDef(name="AddressDt")
public class AddressDt
extends BaseIdentifiableElement
implements ICompositeDatatype {
    @Child(name="use", type={CodeDt.class}, order=0, min=0, max=1, summary=true, modifier=true)
    @Description(shortDefinition="", formalDefinition="The purpose of this address")
    private BoundCodeDt<AddressUseEnum> myUse;
    @Child(name="type", type={CodeDt.class}, order=1, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Distinguishes between physical addresses (those you can visit) and mailing addresses (e.g. PO Boxes and care-of addresses). Most addresses are both")
    private BoundCodeDt<AddressTypeEnum> myType;
    @Child(name="text", type={StringDt.class}, order=2, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="A full text representation of the address")
    private StringDt myText;
    @Child(name="line", type={StringDt.class}, order=3, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="This component contains the house number, apartment number, street name, street direction,  P.O. Box number, delivery hints, and similar address information")
    private List<StringDt> myLine;
    @Child(name="city", type={StringDt.class}, order=4, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The name of the city, town, village or other community or delivery center")
    private StringDt myCity;
    @Child(name="district", type={StringDt.class}, order=5, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The name of the administrative area (county)")
    private StringDt myDistrict;
    @Child(name="state", type={StringDt.class}, order=6, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Sub-unit of a country with limited sovereignty in a federally organized country. A code may be used if codes are in common use (i.e. US 2 letter state codes)")
    private StringDt myState;
    @Child(name="postalCode", type={StringDt.class}, order=7, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="A postal code designating a region defined by the postal service")
    private StringDt myPostalCode;
    @Child(name="country", type={StringDt.class}, order=8, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Country - a nation as commonly understood or generally accepted")
    private StringDt myCountry;
    @Child(name="period", type={PeriodDt.class}, order=9, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Time period when address was/is in use")
    private PeriodDt myPeriod;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myUse, this.myType, this.myText, this.myLine, this.myCity, this.myDistrict, this.myState, this.myPostalCode, this.myCountry, this.myPeriod});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myUse, this.myType, this.myText, this.myLine, this.myCity, this.myDistrict, this.myState, this.myPostalCode, this.myCountry, this.myPeriod});
    }

    public BoundCodeDt<AddressUseEnum> getUseElement() {
        if (this.myUse == null) {
            this.myUse = new BoundCodeDt(AddressUseEnum.VALUESET_BINDER);
        }
        return this.myUse;
    }

    public String getUse() {
        return (String)this.getUseElement().getValue();
    }

    public AddressDt setUse(BoundCodeDt<AddressUseEnum> theValue) {
        this.myUse = theValue;
        return this;
    }

    public AddressDt setUse(AddressUseEnum theValue) {
        this.getUseElement().setValueAsEnum((Enum)theValue);
        return this;
    }

    public BoundCodeDt<AddressTypeEnum> getTypeElement() {
        if (this.myType == null) {
            this.myType = new BoundCodeDt(AddressTypeEnum.VALUESET_BINDER);
        }
        return this.myType;
    }

    public String getType() {
        return (String)this.getTypeElement().getValue();
    }

    public AddressDt setType(BoundCodeDt<AddressTypeEnum> theValue) {
        this.myType = theValue;
        return this;
    }

    public AddressDt setType(AddressTypeEnum theValue) {
        this.getTypeElement().setValueAsEnum((Enum)theValue);
        return this;
    }

    public StringDt getTextElement() {
        if (this.myText == null) {
            this.myText = new StringDt();
        }
        return this.myText;
    }

    public String getText() {
        return (String)this.getTextElement().getValue();
    }

    public AddressDt setText(StringDt theValue) {
        this.myText = theValue;
        return this;
    }

    public AddressDt setText(String theString) {
        this.myText = new StringDt(theString);
        return this;
    }

    public List<StringDt> getLine() {
        if (this.myLine == null) {
            this.myLine = new ArrayList<StringDt>();
        }
        return this.myLine;
    }

    public AddressDt setLine(List<StringDt> theValue) {
        this.myLine = theValue;
        return this;
    }

    public StringDt addLine() {
        StringDt newType = new StringDt();
        this.getLine().add(newType);
        return newType;
    }

    public AddressDt addLine(StringDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getLine().add(theValue);
        return this;
    }

    public StringDt getLineFirstRep() {
        if (this.getLine().isEmpty()) {
            return this.addLine();
        }
        return this.getLine().get(0);
    }

    public AddressDt addLine(String theString) {
        if (this.myLine == null) {
            this.myLine = new ArrayList<StringDt>();
        }
        this.myLine.add(new StringDt(theString));
        return this;
    }

    public StringDt getCityElement() {
        if (this.myCity == null) {
            this.myCity = new StringDt();
        }
        return this.myCity;
    }

    public String getCity() {
        return (String)this.getCityElement().getValue();
    }

    public AddressDt setCity(StringDt theValue) {
        this.myCity = theValue;
        return this;
    }

    public AddressDt setCity(String theString) {
        this.myCity = new StringDt(theString);
        return this;
    }

    public StringDt getDistrictElement() {
        if (this.myDistrict == null) {
            this.myDistrict = new StringDt();
        }
        return this.myDistrict;
    }

    public String getDistrict() {
        return (String)this.getDistrictElement().getValue();
    }

    public AddressDt setDistrict(StringDt theValue) {
        this.myDistrict = theValue;
        return this;
    }

    public AddressDt setDistrict(String theString) {
        this.myDistrict = new StringDt(theString);
        return this;
    }

    public StringDt getStateElement() {
        if (this.myState == null) {
            this.myState = new StringDt();
        }
        return this.myState;
    }

    public String getState() {
        return (String)this.getStateElement().getValue();
    }

    public AddressDt setState(StringDt theValue) {
        this.myState = theValue;
        return this;
    }

    public AddressDt setState(String theString) {
        this.myState = new StringDt(theString);
        return this;
    }

    public StringDt getPostalCodeElement() {
        if (this.myPostalCode == null) {
            this.myPostalCode = new StringDt();
        }
        return this.myPostalCode;
    }

    public String getPostalCode() {
        return (String)this.getPostalCodeElement().getValue();
    }

    public AddressDt setPostalCode(StringDt theValue) {
        this.myPostalCode = theValue;
        return this;
    }

    public AddressDt setPostalCode(String theString) {
        this.myPostalCode = new StringDt(theString);
        return this;
    }

    public StringDt getCountryElement() {
        if (this.myCountry == null) {
            this.myCountry = new StringDt();
        }
        return this.myCountry;
    }

    public String getCountry() {
        return (String)this.getCountryElement().getValue();
    }

    public AddressDt setCountry(StringDt theValue) {
        this.myCountry = theValue;
        return this;
    }

    public AddressDt setCountry(String theString) {
        this.myCountry = new StringDt(theString);
        return this;
    }

    public PeriodDt getPeriod() {
        if (this.myPeriod == null) {
            this.myPeriod = new PeriodDt();
        }
        return this.myPeriod;
    }

    public AddressDt setPeriod(PeriodDt theValue) {
        this.myPeriod = theValue;
        return this;
    }
}

