/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.composite;

import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.ICompositeDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.dstu2.composite.PeriodDt;
import ca.uhn.fhir.model.dstu2.valueset.ContactPointSystemEnum;
import ca.uhn.fhir.model.dstu2.valueset.ContactPointUseEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.PositiveIntDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;

@DatatypeDef(name="ContactPointDt")
public class ContactPointDt
extends BaseIdentifiableElement
implements ICompositeDatatype {
    @Child(name="system", type={CodeDt.class}, order=0, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Telecommunications form for contact point - what communications system is required to make use of the contact")
    private BoundCodeDt<ContactPointSystemEnum> mySystem;
    @Child(name="value", type={StringDt.class}, order=1, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The actual contact point details, in a form that is meaningful to the designated communication system (i.e. phone number or email address).")
    private StringDt myValue;
    @Child(name="use", type={CodeDt.class}, order=2, min=0, max=1, summary=true, modifier=true)
    @Description(shortDefinition="", formalDefinition="Identifies the purpose for the contact point")
    private BoundCodeDt<ContactPointUseEnum> myUse;
    @Child(name="rank", type={PositiveIntDt.class}, order=3, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Specifies a preferred order in which to use a set of contacts. Contacts are ranked with lower values coming before higher values")
    private PositiveIntDt myRank;
    @Child(name="period", type={PeriodDt.class}, order=4, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Time period when the contact point was/is in use")
    private PeriodDt myPeriod;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.mySystem, this.myValue, this.myUse, this.myRank, this.myPeriod});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.mySystem, this.myValue, this.myUse, this.myRank, this.myPeriod});
    }

    public BoundCodeDt<ContactPointSystemEnum> getSystemElement() {
        if (this.mySystem == null) {
            this.mySystem = new BoundCodeDt(ContactPointSystemEnum.VALUESET_BINDER);
        }
        return this.mySystem;
    }

    public String getSystem() {
        return (String)this.getSystemElement().getValue();
    }

    public ContactPointDt setSystem(BoundCodeDt<ContactPointSystemEnum> theValue) {
        this.mySystem = theValue;
        return this;
    }

    public ContactPointDt setSystem(ContactPointSystemEnum theValue) {
        this.getSystemElement().setValueAsEnum((Enum)theValue);
        return this;
    }

    public StringDt getValueElement() {
        if (this.myValue == null) {
            this.myValue = new StringDt();
        }
        return this.myValue;
    }

    public String getValue() {
        return (String)this.getValueElement().getValue();
    }

    public ContactPointDt setValue(StringDt theValue) {
        this.myValue = theValue;
        return this;
    }

    public ContactPointDt setValue(String theString) {
        this.myValue = new StringDt(theString);
        return this;
    }

    public BoundCodeDt<ContactPointUseEnum> getUseElement() {
        if (this.myUse == null) {
            this.myUse = new BoundCodeDt(ContactPointUseEnum.VALUESET_BINDER);
        }
        return this.myUse;
    }

    public String getUse() {
        return (String)this.getUseElement().getValue();
    }

    public ContactPointDt setUse(BoundCodeDt<ContactPointUseEnum> theValue) {
        this.myUse = theValue;
        return this;
    }

    public ContactPointDt setUse(ContactPointUseEnum theValue) {
        this.getUseElement().setValueAsEnum((Enum)theValue);
        return this;
    }

    public PositiveIntDt getRankElement() {
        if (this.myRank == null) {
            this.myRank = new PositiveIntDt();
        }
        return this.myRank;
    }

    public Integer getRank() {
        return (Integer)this.getRankElement().getValue();
    }

    public ContactPointDt setRank(PositiveIntDt theValue) {
        this.myRank = theValue;
        return this;
    }

    public ContactPointDt setRank(int theInteger) {
        this.myRank = new PositiveIntDt(theInteger);
        return this;
    }

    public PeriodDt getPeriod() {
        if (this.myPeriod == null) {
            this.myPeriod = new PeriodDt();
        }
        return this.myPeriod;
    }

    public ContactPointDt setPeriod(PeriodDt theValue) {
        this.myPeriod = theValue;
        return this;
    }
}

