/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.composite;

import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.ICompositeDatatype;
import ca.uhn.fhir.model.api.IDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.dstu2.composite.CodingDt;
import ca.uhn.fhir.model.dstu2.resource.ValueSet;
import ca.uhn.fhir.model.dstu2.valueset.AggregationModeEnum;
import ca.uhn.fhir.model.dstu2.valueset.BindingStrengthEnum;
import ca.uhn.fhir.model.dstu2.valueset.ConstraintSeverityEnum;
import ca.uhn.fhir.model.dstu2.valueset.PropertyRepresentationEnum;
import ca.uhn.fhir.model.dstu2.valueset.SlicingRulesEnum;
import ca.uhn.fhir.model.primitive.BooleanDt;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.model.primitive.IntegerDt;
import ca.uhn.fhir.model.primitive.MarkdownDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.model.primitive.UriDt;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;

@DatatypeDef(name="ElementDefinitionDt")
public class ElementDefinitionDt
extends BaseIdentifiableElement
implements ICompositeDatatype {
    @Child(name="path", type={StringDt.class}, order=0, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The path identifies the element and is expressed as a \".\"-separated list of ancestor elements, beginning with the name of the resource or extension")
    private StringDt myPath;
    @Child(name="representation", type={CodeDt.class}, order=1, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Codes that define how this element is represented in instances, when the deviation varies from the normal case")
    private List<BoundCodeDt<PropertyRepresentationEnum>> myRepresentation;
    @Child(name="name", type={StringDt.class}, order=2, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The name of this element definition (to refer to it from other element definitions using ElementDefinition.nameReference). This is a unique name referring to a specific set of constraints applied to this element. One use of this is to provide a name to different slices of the same element")
    private StringDt myName;
    @Child(name="label", type={StringDt.class}, order=3, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The text to display beside the element indicating its meaning or to use to prompt for the element in a user display or form.")
    private StringDt myLabel;
    @Child(name="code", type={CodingDt.class}, order=4, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="A code that provides the meaning for the element according to a particular terminology.")
    private List<CodingDt> myCode;
    @Child(name="slicing", order=5, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Indicates that the element is sliced into a set of alternative definitions (i.e. in a structure definition, there are multiple different constraints on a single element in the base resource). Slicing can be used in any resource that has cardinality ..* on the base resource, or any resource with a choice of types. The set of slices is any elements that come after this in the element sequence that have the same path, until a shorter path occurs (the shorter path terminates the set)")
    private Slicing mySlicing;
    @Child(name="short", type={StringDt.class}, order=6, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="A concise description of what this element means (e.g. for use in autogenerated summaries)")
    private StringDt myShort;
    @Child(name="definition", type={MarkdownDt.class}, order=7, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Provides a complete explanation of the meaning of the data element for human readability.  For the case of elements derived from existing elements (e.g. constraints), the definition SHALL be consistent with the base definition, but convey the meaning of the element in the particular context of use of the resource")
    private MarkdownDt myDefinition;
    @Child(name="comments", type={MarkdownDt.class}, order=8, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Explanatory notes and implementation guidance about the data element, including notes about how to use the data properly, exceptions to proper use, etc.")
    private MarkdownDt myComments;
    @Child(name="requirements", type={MarkdownDt.class}, order=9, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="This element is for traceability of why the element was created and why the constraints exist as they do. This may be used to point to source materials or specifications that drove the structure of this element.")
    private MarkdownDt myRequirements;
    @Child(name="alias", type={StringDt.class}, order=10, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Identifies additional names by which this element might also be known")
    private List<StringDt> myAlias;
    @Child(name="min", type={IntegerDt.class}, order=11, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The minimum number of times this element SHALL appear in the instance")
    private IntegerDt myMin;
    @Child(name="max", type={StringDt.class}, order=12, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The maximum number of times this element is permitted to appear in the instance")
    private StringDt myMax;
    @Child(name="base", order=13, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Information about the base definition of the element, provided to make it unncessary for tools to trace the deviation of the element through the derived and related profiles. This information is only provided where the element definition represents a constraint on another element definition, and must be present if there is a base element definition.")
    private Base myBase;
    @Child(name="type", order=14, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The data type or resource that the value of this element is permitted to be")
    private List<Type> myType;
    @Child(name="nameReference", type={StringDt.class}, order=15, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Identifies the name of a slice defined elsewhere in the profile whose constraints should be applied to the current element")
    private StringDt myNameReference;
    @Child(name="defaultValue", type={IDatatype.class}, order=16, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false')")
    private IDatatype myDefaultValue;
    @Child(name="meaningWhenMissing", type={MarkdownDt.class}, order=17, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The Implicit meaning that is to be understood when this element is missing (e.g. 'when this element is missing, the period is ongoing'")
    private MarkdownDt myMeaningWhenMissing;
    @Child(name="fixed", type={IDatatype.class}, order=18, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Specifies a value that SHALL be exactly the value  for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.")
    private IDatatype myFixed;
    @Child(name="pattern", type={IDatatype.class}, order=19, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example.  The values of elements present in the pattern must match exactly (case-sensitive, accent-sensitive, etc.).")
    private IDatatype myPattern;
    @Child(name="example", type={IDatatype.class}, order=20, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="A sample value for this element demonstrating the type of information that would typically be captured.")
    private IDatatype myExample;
    @Child(name="minValue", type={IDatatype.class}, order=21, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The minimum allowed value for the element. The value is inclusive. This is allowed for the types date, dateTime, instant, time, decimal, integer, and Quantity")
    private IDatatype myMinValue;
    @Child(name="maxValue", type={IDatatype.class}, order=22, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The maximum allowed value for the element. The value is inclusive. This is allowed for the types date, dateTime, instant, time, decimal, integer, and Quantity")
    private IDatatype myMaxValue;
    @Child(name="maxLength", type={IntegerDt.class}, order=23, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Indicates the maximum length in characters that is permitted to be present in conformant instances and which is expected to be supported by conformant consumers that support the element")
    private IntegerDt myMaxLength;
    @Child(name="condition", type={IdDt.class}, order=24, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="A reference to an invariant that may make additional statements about the cardinality or value in the instance")
    private List<IdDt> myCondition;
    @Child(name="constraint", order=25, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Formal constraints such as co-occurrence and other constraints that can be computationally evaluated within the context of the instance")
    private List<Constraint> myConstraint;
    @Child(name="mustSupport", type={BooleanDt.class}, order=26, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="If true, implementations that produce or consume resources SHALL provide \"support\" for the element in some meaningful way.  If false, the element may be ignored and not supported")
    private BooleanDt myMustSupport;
    @Child(name="isModifier", type={BooleanDt.class}, order=27, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="If true, the value of this element affects the interpretation of the element or resource that contains it, and the value of the element cannot be ignored. Typically, this is used for status, negation and qualification codes. The effect of this is that the element cannot be ignored by systems: they SHALL either recognize the element and process it, and/or a pre-determination has been made that it is not relevant to their particular system.")
    private BooleanDt myIsModifier;
    @Child(name="isSummary", type={BooleanDt.class}, order=28, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Whether the element should be included if a client requests a search with the parameter _summary=true")
    private BooleanDt myIsSummary;
    @Child(name="binding", order=29, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Binds to a value set if this element is coded (code, Coding, CodeableConcept)")
    private Binding myBinding;
    @Child(name="mapping", order=30, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Identifies a concept from an external specification that roughly corresponds to this element")
    private List<Mapping> myMapping;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myPath, this.myRepresentation, this.myName, this.myLabel, this.myCode, this.mySlicing, this.myShort, this.myDefinition, this.myComments, this.myRequirements, this.myAlias, this.myMin, this.myMax, this.myBase, this.myType, this.myNameReference, this.myDefaultValue, this.myMeaningWhenMissing, this.myFixed, this.myPattern, this.myExample, this.myMinValue, this.myMaxValue, this.myMaxLength, this.myCondition, this.myConstraint, this.myMustSupport, this.myIsModifier, this.myIsSummary, this.myBinding, this.myMapping});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myPath, this.myRepresentation, this.myName, this.myLabel, this.myCode, this.mySlicing, this.myShort, this.myDefinition, this.myComments, this.myRequirements, this.myAlias, this.myMin, this.myMax, this.myBase, this.myType, this.myNameReference, this.myDefaultValue, this.myMeaningWhenMissing, this.myFixed, this.myPattern, this.myExample, this.myMinValue, this.myMaxValue, this.myMaxLength, this.myCondition, this.myConstraint, this.myMustSupport, this.myIsModifier, this.myIsSummary, this.myBinding, this.myMapping});
    }

    public StringDt getPathElement() {
        if (this.myPath == null) {
            this.myPath = new StringDt();
        }
        return this.myPath;
    }

    public String getPath() {
        return (String)this.getPathElement().getValue();
    }

    public ElementDefinitionDt setPath(StringDt theValue) {
        this.myPath = theValue;
        return this;
    }

    public ElementDefinitionDt setPath(String theString) {
        this.myPath = new StringDt(theString);
        return this;
    }

    public List<BoundCodeDt<PropertyRepresentationEnum>> getRepresentation() {
        if (this.myRepresentation == null) {
            this.myRepresentation = new ArrayList<BoundCodeDt<PropertyRepresentationEnum>>();
        }
        return this.myRepresentation;
    }

    public ElementDefinitionDt setRepresentation(List<BoundCodeDt<PropertyRepresentationEnum>> theValue) {
        this.myRepresentation = theValue;
        return this;
    }

    public BoundCodeDt<PropertyRepresentationEnum> addRepresentation(PropertyRepresentationEnum theValue) {
        BoundCodeDt retVal = new BoundCodeDt(PropertyRepresentationEnum.VALUESET_BINDER, (Enum)theValue);
        this.getRepresentation().add((BoundCodeDt<PropertyRepresentationEnum>)retVal);
        return retVal;
    }

    public BoundCodeDt<PropertyRepresentationEnum> getRepresentationFirstRep() {
        if (this.getRepresentation().size() == 0) {
            this.addRepresentation();
        }
        return this.getRepresentation().get(0);
    }

    public BoundCodeDt<PropertyRepresentationEnum> addRepresentation() {
        BoundCodeDt retVal = new BoundCodeDt(PropertyRepresentationEnum.VALUESET_BINDER);
        this.getRepresentation().add((BoundCodeDt<PropertyRepresentationEnum>)retVal);
        return retVal;
    }

    public ElementDefinitionDt setRepresentation(PropertyRepresentationEnum theValue) {
        this.getRepresentation().clear();
        this.addRepresentation(theValue);
        return this;
    }

    public StringDt getNameElement() {
        if (this.myName == null) {
            this.myName = new StringDt();
        }
        return this.myName;
    }

    public String getName() {
        return (String)this.getNameElement().getValue();
    }

    public ElementDefinitionDt setName(StringDt theValue) {
        this.myName = theValue;
        return this;
    }

    public ElementDefinitionDt setName(String theString) {
        this.myName = new StringDt(theString);
        return this;
    }

    public StringDt getLabelElement() {
        if (this.myLabel == null) {
            this.myLabel = new StringDt();
        }
        return this.myLabel;
    }

    public String getLabel() {
        return (String)this.getLabelElement().getValue();
    }

    public ElementDefinitionDt setLabel(StringDt theValue) {
        this.myLabel = theValue;
        return this;
    }

    public ElementDefinitionDt setLabel(String theString) {
        this.myLabel = new StringDt(theString);
        return this;
    }

    public List<CodingDt> getCode() {
        if (this.myCode == null) {
            this.myCode = new ArrayList<CodingDt>();
        }
        return this.myCode;
    }

    public ElementDefinitionDt setCode(List<CodingDt> theValue) {
        this.myCode = theValue;
        return this;
    }

    public CodingDt addCode() {
        CodingDt newType = new CodingDt();
        this.getCode().add(newType);
        return newType;
    }

    public ElementDefinitionDt addCode(CodingDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getCode().add(theValue);
        return this;
    }

    public CodingDt getCodeFirstRep() {
        if (this.getCode().isEmpty()) {
            return this.addCode();
        }
        return this.getCode().get(0);
    }

    public Slicing getSlicing() {
        if (this.mySlicing == null) {
            this.mySlicing = new Slicing();
        }
        return this.mySlicing;
    }

    public ElementDefinitionDt setSlicing(Slicing theValue) {
        this.mySlicing = theValue;
        return this;
    }

    public StringDt getShortElement() {
        if (this.myShort == null) {
            this.myShort = new StringDt();
        }
        return this.myShort;
    }

    public String getShort() {
        return (String)this.getShortElement().getValue();
    }

    public ElementDefinitionDt setShort(StringDt theValue) {
        this.myShort = theValue;
        return this;
    }

    public ElementDefinitionDt setShort(String theString) {
        this.myShort = new StringDt(theString);
        return this;
    }

    public MarkdownDt getDefinitionElement() {
        if (this.myDefinition == null) {
            this.myDefinition = new MarkdownDt();
        }
        return this.myDefinition;
    }

    public String getDefinition() {
        return (String)this.getDefinitionElement().getValue();
    }

    public ElementDefinitionDt setDefinition(MarkdownDt theValue) {
        this.myDefinition = theValue;
        return this;
    }

    public MarkdownDt getCommentsElement() {
        if (this.myComments == null) {
            this.myComments = new MarkdownDt();
        }
        return this.myComments;
    }

    public String getComments() {
        return (String)this.getCommentsElement().getValue();
    }

    public ElementDefinitionDt setComments(MarkdownDt theValue) {
        this.myComments = theValue;
        return this;
    }

    public MarkdownDt getRequirementsElement() {
        if (this.myRequirements == null) {
            this.myRequirements = new MarkdownDt();
        }
        return this.myRequirements;
    }

    public String getRequirements() {
        return (String)this.getRequirementsElement().getValue();
    }

    public ElementDefinitionDt setRequirements(MarkdownDt theValue) {
        this.myRequirements = theValue;
        return this;
    }

    public List<StringDt> getAlias() {
        if (this.myAlias == null) {
            this.myAlias = new ArrayList<StringDt>();
        }
        return this.myAlias;
    }

    public ElementDefinitionDt setAlias(List<StringDt> theValue) {
        this.myAlias = theValue;
        return this;
    }

    public StringDt addAlias() {
        StringDt newType = new StringDt();
        this.getAlias().add(newType);
        return newType;
    }

    public ElementDefinitionDt addAlias(StringDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getAlias().add(theValue);
        return this;
    }

    public StringDt getAliasFirstRep() {
        if (this.getAlias().isEmpty()) {
            return this.addAlias();
        }
        return this.getAlias().get(0);
    }

    public ElementDefinitionDt addAlias(String theString) {
        if (this.myAlias == null) {
            this.myAlias = new ArrayList<StringDt>();
        }
        this.myAlias.add(new StringDt(theString));
        return this;
    }

    public IntegerDt getMinElement() {
        if (this.myMin == null) {
            this.myMin = new IntegerDt();
        }
        return this.myMin;
    }

    public Integer getMin() {
        return (Integer)this.getMinElement().getValue();
    }

    public ElementDefinitionDt setMin(IntegerDt theValue) {
        this.myMin = theValue;
        return this;
    }

    public ElementDefinitionDt setMin(int theInteger) {
        this.myMin = new IntegerDt(theInteger);
        return this;
    }

    public StringDt getMaxElement() {
        if (this.myMax == null) {
            this.myMax = new StringDt();
        }
        return this.myMax;
    }

    public String getMax() {
        return (String)this.getMaxElement().getValue();
    }

    public ElementDefinitionDt setMax(StringDt theValue) {
        this.myMax = theValue;
        return this;
    }

    public ElementDefinitionDt setMax(String theString) {
        this.myMax = new StringDt(theString);
        return this;
    }

    public Base getBase() {
        if (this.myBase == null) {
            this.myBase = new Base();
        }
        return this.myBase;
    }

    public ElementDefinitionDt setBase(Base theValue) {
        this.myBase = theValue;
        return this;
    }

    public List<Type> getType() {
        if (this.myType == null) {
            this.myType = new ArrayList<Type>();
        }
        return this.myType;
    }

    public ElementDefinitionDt setType(List<Type> theValue) {
        this.myType = theValue;
        return this;
    }

    public Type addType() {
        Type newType = new Type();
        this.getType().add(newType);
        return newType;
    }

    public ElementDefinitionDt addType(Type theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getType().add(theValue);
        return this;
    }

    public Type getTypeFirstRep() {
        if (this.getType().isEmpty()) {
            return this.addType();
        }
        return this.getType().get(0);
    }

    public StringDt getNameReferenceElement() {
        if (this.myNameReference == null) {
            this.myNameReference = new StringDt();
        }
        return this.myNameReference;
    }

    public String getNameReference() {
        return (String)this.getNameReferenceElement().getValue();
    }

    public ElementDefinitionDt setNameReference(StringDt theValue) {
        this.myNameReference = theValue;
        return this;
    }

    public ElementDefinitionDt setNameReference(String theString) {
        this.myNameReference = new StringDt(theString);
        return this;
    }

    public IDatatype getDefaultValue() {
        return this.myDefaultValue;
    }

    public ElementDefinitionDt setDefaultValue(IDatatype theValue) {
        this.myDefaultValue = theValue;
        return this;
    }

    public MarkdownDt getMeaningWhenMissingElement() {
        if (this.myMeaningWhenMissing == null) {
            this.myMeaningWhenMissing = new MarkdownDt();
        }
        return this.myMeaningWhenMissing;
    }

    public String getMeaningWhenMissing() {
        return (String)this.getMeaningWhenMissingElement().getValue();
    }

    public ElementDefinitionDt setMeaningWhenMissing(MarkdownDt theValue) {
        this.myMeaningWhenMissing = theValue;
        return this;
    }

    public IDatatype getFixed() {
        return this.myFixed;
    }

    public ElementDefinitionDt setFixed(IDatatype theValue) {
        this.myFixed = theValue;
        return this;
    }

    public IDatatype getPattern() {
        return this.myPattern;
    }

    public ElementDefinitionDt setPattern(IDatatype theValue) {
        this.myPattern = theValue;
        return this;
    }

    public IDatatype getExample() {
        return this.myExample;
    }

    public ElementDefinitionDt setExample(IDatatype theValue) {
        this.myExample = theValue;
        return this;
    }

    public IDatatype getMinValue() {
        return this.myMinValue;
    }

    public ElementDefinitionDt setMinValue(IDatatype theValue) {
        this.myMinValue = theValue;
        return this;
    }

    public IDatatype getMaxValue() {
        return this.myMaxValue;
    }

    public ElementDefinitionDt setMaxValue(IDatatype theValue) {
        this.myMaxValue = theValue;
        return this;
    }

    public IntegerDt getMaxLengthElement() {
        if (this.myMaxLength == null) {
            this.myMaxLength = new IntegerDt();
        }
        return this.myMaxLength;
    }

    public Integer getMaxLength() {
        return (Integer)this.getMaxLengthElement().getValue();
    }

    public ElementDefinitionDt setMaxLength(IntegerDt theValue) {
        this.myMaxLength = theValue;
        return this;
    }

    public ElementDefinitionDt setMaxLength(int theInteger) {
        this.myMaxLength = new IntegerDt(theInteger);
        return this;
    }

    public List<IdDt> getCondition() {
        if (this.myCondition == null) {
            this.myCondition = new ArrayList<IdDt>();
        }
        return this.myCondition;
    }

    public ElementDefinitionDt setCondition(List<IdDt> theValue) {
        this.myCondition = theValue;
        return this;
    }

    public IdDt addCondition() {
        IdDt newType = new IdDt();
        this.getCondition().add(newType);
        return newType;
    }

    public ElementDefinitionDt addCondition(IdDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getCondition().add(theValue);
        return this;
    }

    public IdDt getConditionFirstRep() {
        if (this.getCondition().isEmpty()) {
            return this.addCondition();
        }
        return this.getCondition().get(0);
    }

    public ElementDefinitionDt addCondition(String theId) {
        if (this.myCondition == null) {
            this.myCondition = new ArrayList<IdDt>();
        }
        this.myCondition.add(new IdDt(theId));
        return this;
    }

    public List<Constraint> getConstraint() {
        if (this.myConstraint == null) {
            this.myConstraint = new ArrayList<Constraint>();
        }
        return this.myConstraint;
    }

    public ElementDefinitionDt setConstraint(List<Constraint> theValue) {
        this.myConstraint = theValue;
        return this;
    }

    public Constraint addConstraint() {
        Constraint newType = new Constraint();
        this.getConstraint().add(newType);
        return newType;
    }

    public ElementDefinitionDt addConstraint(Constraint theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getConstraint().add(theValue);
        return this;
    }

    public Constraint getConstraintFirstRep() {
        if (this.getConstraint().isEmpty()) {
            return this.addConstraint();
        }
        return this.getConstraint().get(0);
    }

    public BooleanDt getMustSupportElement() {
        if (this.myMustSupport == null) {
            this.myMustSupport = new BooleanDt();
        }
        return this.myMustSupport;
    }

    public Boolean getMustSupport() {
        return (Boolean)this.getMustSupportElement().getValue();
    }

    public ElementDefinitionDt setMustSupport(BooleanDt theValue) {
        this.myMustSupport = theValue;
        return this;
    }

    public ElementDefinitionDt setMustSupport(boolean theBoolean) {
        this.myMustSupport = new BooleanDt(theBoolean);
        return this;
    }

    public BooleanDt getIsModifierElement() {
        if (this.myIsModifier == null) {
            this.myIsModifier = new BooleanDt();
        }
        return this.myIsModifier;
    }

    public Boolean getIsModifier() {
        return (Boolean)this.getIsModifierElement().getValue();
    }

    public ElementDefinitionDt setIsModifier(BooleanDt theValue) {
        this.myIsModifier = theValue;
        return this;
    }

    public ElementDefinitionDt setIsModifier(boolean theBoolean) {
        this.myIsModifier = new BooleanDt(theBoolean);
        return this;
    }

    public BooleanDt getIsSummaryElement() {
        if (this.myIsSummary == null) {
            this.myIsSummary = new BooleanDt();
        }
        return this.myIsSummary;
    }

    public Boolean getIsSummary() {
        return (Boolean)this.getIsSummaryElement().getValue();
    }

    public ElementDefinitionDt setIsSummary(BooleanDt theValue) {
        this.myIsSummary = theValue;
        return this;
    }

    public ElementDefinitionDt setIsSummary(boolean theBoolean) {
        this.myIsSummary = new BooleanDt(theBoolean);
        return this;
    }

    public Binding getBinding() {
        if (this.myBinding == null) {
            this.myBinding = new Binding();
        }
        return this.myBinding;
    }

    public ElementDefinitionDt setBinding(Binding theValue) {
        this.myBinding = theValue;
        return this;
    }

    public List<Mapping> getMapping() {
        if (this.myMapping == null) {
            this.myMapping = new ArrayList<Mapping>();
        }
        return this.myMapping;
    }

    public ElementDefinitionDt setMapping(List<Mapping> theValue) {
        this.myMapping = theValue;
        return this;
    }

    public Mapping addMapping() {
        Mapping newType = new Mapping();
        this.getMapping().add(newType);
        return newType;
    }

    public ElementDefinitionDt addMapping(Mapping theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getMapping().add(theValue);
        return this;
    }

    public Mapping getMappingFirstRep() {
        if (this.getMapping().isEmpty()) {
            return this.addMapping();
        }
        return this.getMapping().get(0);
    }

    @Block
    public static class Mapping
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="identity", type={IdDt.class}, order=0, min=1, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="An internal reference to the definition of a mapping")
        private IdDt myIdentity;
        @Child(name="language", type={CodeDt.class}, order=1, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="Identifies the computable language in which mapping.map is expressed.")
        private CodeDt myLanguage;
        @Child(name="map", type={StringDt.class}, order=2, min=1, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="Expresses what part of the target specification corresponds to this element")
        private StringDt myMap;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myIdentity, this.myLanguage, this.myMap});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentity, this.myLanguage, this.myMap});
        }

        public IdDt getIdentityElement() {
            if (this.myIdentity == null) {
                this.myIdentity = new IdDt();
            }
            return this.myIdentity;
        }

        public String getIdentity() {
            return this.getIdentityElement().getValue();
        }

        public Mapping setIdentity(IdDt theValue) {
            this.myIdentity = theValue;
            return this;
        }

        public Mapping setIdentity(String theId) {
            this.myIdentity = new IdDt(theId);
            return this;
        }

        public CodeDt getLanguageElement() {
            if (this.myLanguage == null) {
                this.myLanguage = new CodeDt();
            }
            return this.myLanguage;
        }

        public String getLanguage() {
            return (String)this.getLanguageElement().getValue();
        }

        public Mapping setLanguage(CodeDt theValue) {
            this.myLanguage = theValue;
            return this;
        }

        public Mapping setLanguage(String theCode) {
            this.myLanguage = new CodeDt(theCode);
            return this;
        }

        public StringDt getMapElement() {
            if (this.myMap == null) {
                this.myMap = new StringDt();
            }
            return this.myMap;
        }

        public String getMap() {
            return (String)this.getMapElement().getValue();
        }

        public Mapping setMap(StringDt theValue) {
            this.myMap = theValue;
            return this;
        }

        public Mapping setMap(String theString) {
            this.myMap = new StringDt(theString);
            return this;
        }
    }

    @Block
    public static class Binding
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="strength", type={CodeDt.class}, order=0, min=1, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="Indicates the degree of conformance expectations associated with this binding - that is, the degree to which the provided value set must be adhered to in the instances")
        private BoundCodeDt<BindingStrengthEnum> myStrength;
        @Child(name="description", type={StringDt.class}, order=1, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="Describes the intended use of this particular set of codes")
        private StringDt myDescription;
        @Child(name="valueSet", order=2, min=0, max=1, summary=true, modifier=false, type={UriDt.class, ValueSet.class})
        @Description(shortDefinition="", formalDefinition="Points to the value set or external definition (e.g. implicit value set) that identifies the set of codes to be used")
        private IDatatype myValueSet;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myStrength, this.myDescription, this.myValueSet});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myStrength, this.myDescription, this.myValueSet});
        }

        public BoundCodeDt<BindingStrengthEnum> getStrengthElement() {
            if (this.myStrength == null) {
                this.myStrength = new BoundCodeDt(BindingStrengthEnum.VALUESET_BINDER);
            }
            return this.myStrength;
        }

        public String getStrength() {
            return (String)this.getStrengthElement().getValue();
        }

        public Binding setStrength(BoundCodeDt<BindingStrengthEnum> theValue) {
            this.myStrength = theValue;
            return this;
        }

        public Binding setStrength(BindingStrengthEnum theValue) {
            this.getStrengthElement().setValueAsEnum((Enum)theValue);
            return this;
        }

        public StringDt getDescriptionElement() {
            if (this.myDescription == null) {
                this.myDescription = new StringDt();
            }
            return this.myDescription;
        }

        public String getDescription() {
            return (String)this.getDescriptionElement().getValue();
        }

        public Binding setDescription(StringDt theValue) {
            this.myDescription = theValue;
            return this;
        }

        public Binding setDescription(String theString) {
            this.myDescription = new StringDt(theString);
            return this;
        }

        public IDatatype getValueSet() {
            return this.myValueSet;
        }

        public Binding setValueSet(IDatatype theValue) {
            this.myValueSet = theValue;
            return this;
        }
    }

    @Block
    public static class Constraint
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="key", type={IdDt.class}, order=0, min=1, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="Allows identification of which elements have their cardinalities impacted by the constraint.  Will not be referenced for constraints that do not affect cardinality")
        private IdDt myKey;
        @Child(name="requirements", type={StringDt.class}, order=1, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="Description of why this constraint is necessary or appropriate")
        private StringDt myRequirements;
        @Child(name="severity", type={CodeDt.class}, order=2, min=1, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="Identifies the impact constraint violation has on the conformance of the instance")
        private BoundCodeDt<ConstraintSeverityEnum> mySeverity;
        @Child(name="human", type={StringDt.class}, order=3, min=1, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="Text that can be used to describe the constraint in messages identifying that the constraint has been violated")
        private StringDt myHuman;
        @Child(name="xpath", type={StringDt.class}, order=4, min=1, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="An XPath expression of constraint that can be executed to see if this constraint is met")
        private StringDt myXpath;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myKey, this.myRequirements, this.mySeverity, this.myHuman, this.myXpath});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myKey, this.myRequirements, this.mySeverity, this.myHuman, this.myXpath});
        }

        public IdDt getKeyElement() {
            if (this.myKey == null) {
                this.myKey = new IdDt();
            }
            return this.myKey;
        }

        public String getKey() {
            return this.getKeyElement().getValue();
        }

        public Constraint setKey(IdDt theValue) {
            this.myKey = theValue;
            return this;
        }

        public Constraint setKey(String theId) {
            this.myKey = new IdDt(theId);
            return this;
        }

        public StringDt getRequirementsElement() {
            if (this.myRequirements == null) {
                this.myRequirements = new StringDt();
            }
            return this.myRequirements;
        }

        public String getRequirements() {
            return (String)this.getRequirementsElement().getValue();
        }

        public Constraint setRequirements(StringDt theValue) {
            this.myRequirements = theValue;
            return this;
        }

        public Constraint setRequirements(String theString) {
            this.myRequirements = new StringDt(theString);
            return this;
        }

        public BoundCodeDt<ConstraintSeverityEnum> getSeverityElement() {
            if (this.mySeverity == null) {
                this.mySeverity = new BoundCodeDt(ConstraintSeverityEnum.VALUESET_BINDER);
            }
            return this.mySeverity;
        }

        public String getSeverity() {
            return (String)this.getSeverityElement().getValue();
        }

        public Constraint setSeverity(BoundCodeDt<ConstraintSeverityEnum> theValue) {
            this.mySeverity = theValue;
            return this;
        }

        public Constraint setSeverity(ConstraintSeverityEnum theValue) {
            this.getSeverityElement().setValueAsEnum((Enum)theValue);
            return this;
        }

        public StringDt getHumanElement() {
            if (this.myHuman == null) {
                this.myHuman = new StringDt();
            }
            return this.myHuman;
        }

        public String getHuman() {
            return (String)this.getHumanElement().getValue();
        }

        public Constraint setHuman(StringDt theValue) {
            this.myHuman = theValue;
            return this;
        }

        public Constraint setHuman(String theString) {
            this.myHuman = new StringDt(theString);
            return this;
        }

        public StringDt getXpathElement() {
            if (this.myXpath == null) {
                this.myXpath = new StringDt();
            }
            return this.myXpath;
        }

        public String getXpath() {
            return (String)this.getXpathElement().getValue();
        }

        public Constraint setXpath(StringDt theValue) {
            this.myXpath = theValue;
            return this;
        }

        public Constraint setXpath(String theString) {
            this.myXpath = new StringDt(theString);
            return this;
        }
    }

    @Block
    public static class Type
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="code", type={CodeDt.class}, order=0, min=1, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="Name of Data type or Resource that is a(or the) type used for this element")
        private CodeDt myCode;
        @Child(name="profile", type={UriDt.class}, order=1, min=0, max=-1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="Identifies a profile structure or implementation Guide that SHALL hold for resources or datatypes referenced as the type of this element. Can be a local reference - to another structure in this profile, or a reference to a structure in another profile. When more than one profile is specified, the content must conform to all of them. When an implementation guide is specified, the resource SHALL conform to at least one profile defined in the implementation guide")
        private List<UriDt> myProfile;
        @Child(name="aggregation", type={CodeDt.class}, order=2, min=0, max=-1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="If the type is a reference to another resource, how the resource is or can be aggregated - is it a contained resource, or a reference, and if the context is a bundle, is it included in the bundle.")
        private List<BoundCodeDt<AggregationModeEnum>> myAggregation;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myCode, this.myProfile, this.myAggregation});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myCode, this.myProfile, this.myAggregation});
        }

        public CodeDt getCodeElement() {
            if (this.myCode == null) {
                this.myCode = new CodeDt();
            }
            return this.myCode;
        }

        public String getCode() {
            return (String)this.getCodeElement().getValue();
        }

        public Type setCode(CodeDt theValue) {
            this.myCode = theValue;
            return this;
        }

        public Type setCode(String theCode) {
            this.myCode = new CodeDt(theCode);
            return this;
        }

        public List<UriDt> getProfile() {
            if (this.myProfile == null) {
                this.myProfile = new ArrayList<UriDt>();
            }
            return this.myProfile;
        }

        public Type setProfile(List<UriDt> theValue) {
            this.myProfile = theValue;
            return this;
        }

        public UriDt addProfile() {
            UriDt newType = new UriDt();
            this.getProfile().add(newType);
            return newType;
        }

        public Type addProfile(UriDt theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getProfile().add(theValue);
            return this;
        }

        public UriDt getProfileFirstRep() {
            if (this.getProfile().isEmpty()) {
                return this.addProfile();
            }
            return this.getProfile().get(0);
        }

        public Type addProfile(String theUri) {
            if (this.myProfile == null) {
                this.myProfile = new ArrayList<UriDt>();
            }
            this.myProfile.add(new UriDt(theUri));
            return this;
        }

        public List<BoundCodeDt<AggregationModeEnum>> getAggregation() {
            if (this.myAggregation == null) {
                this.myAggregation = new ArrayList<BoundCodeDt<AggregationModeEnum>>();
            }
            return this.myAggregation;
        }

        public Type setAggregation(List<BoundCodeDt<AggregationModeEnum>> theValue) {
            this.myAggregation = theValue;
            return this;
        }

        public BoundCodeDt<AggregationModeEnum> addAggregation(AggregationModeEnum theValue) {
            BoundCodeDt retVal = new BoundCodeDt(AggregationModeEnum.VALUESET_BINDER, (Enum)theValue);
            this.getAggregation().add((BoundCodeDt<AggregationModeEnum>)retVal);
            return retVal;
        }

        public BoundCodeDt<AggregationModeEnum> getAggregationFirstRep() {
            if (this.getAggregation().size() == 0) {
                this.addAggregation();
            }
            return this.getAggregation().get(0);
        }

        public BoundCodeDt<AggregationModeEnum> addAggregation() {
            BoundCodeDt retVal = new BoundCodeDt(AggregationModeEnum.VALUESET_BINDER);
            this.getAggregation().add((BoundCodeDt<AggregationModeEnum>)retVal);
            return retVal;
        }

        public Type setAggregation(AggregationModeEnum theValue) {
            this.getAggregation().clear();
            this.addAggregation(theValue);
            return this;
        }
    }

    @Block
    public static class Base
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="path", type={StringDt.class}, order=0, min=1, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="The Path that identifies the base element - this matches the ElementDefinition.path for that element. Across FHIR, there is only one base definition of any element - that is, an element definition on a [[[StructureDefinition]]] without a StructureDefinition.base")
        private StringDt myPath;
        @Child(name="min", type={IntegerDt.class}, order=1, min=1, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="Minimum cardinality of the base element identified by the path")
        private IntegerDt myMin;
        @Child(name="max", type={StringDt.class}, order=2, min=1, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="Maximum cardinality of the base element identified by the path")
        private StringDt myMax;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myPath, this.myMin, this.myMax});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myPath, this.myMin, this.myMax});
        }

        public StringDt getPathElement() {
            if (this.myPath == null) {
                this.myPath = new StringDt();
            }
            return this.myPath;
        }

        public String getPath() {
            return (String)this.getPathElement().getValue();
        }

        public Base setPath(StringDt theValue) {
            this.myPath = theValue;
            return this;
        }

        public Base setPath(String theString) {
            this.myPath = new StringDt(theString);
            return this;
        }

        public IntegerDt getMinElement() {
            if (this.myMin == null) {
                this.myMin = new IntegerDt();
            }
            return this.myMin;
        }

        public Integer getMin() {
            return (Integer)this.getMinElement().getValue();
        }

        public Base setMin(IntegerDt theValue) {
            this.myMin = theValue;
            return this;
        }

        public Base setMin(int theInteger) {
            this.myMin = new IntegerDt(theInteger);
            return this;
        }

        public StringDt getMaxElement() {
            if (this.myMax == null) {
                this.myMax = new StringDt();
            }
            return this.myMax;
        }

        public String getMax() {
            return (String)this.getMaxElement().getValue();
        }

        public Base setMax(StringDt theValue) {
            this.myMax = theValue;
            return this;
        }

        public Base setMax(String theString) {
            this.myMax = new StringDt(theString);
            return this;
        }
    }

    @Block
    public static class Slicing
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="discriminator", type={StringDt.class}, order=0, min=0, max=-1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="Designates which child elements are used to discriminate between the slices when processing an instance. If one or more discriminators are provided, the value of the child elements in the instance data SHALL completely distinguish which slice the element in the resource matches based on the allowed values for those elements in each of the slices")
        private List<StringDt> myDiscriminator;
        @Child(name="description", type={StringDt.class}, order=1, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="A human-readable text description of how the slicing works. If there is no discriminator, this is required to be present to provide whatever information is possible about how the slices can be differentiated")
        private StringDt myDescription;
        @Child(name="ordered", type={BooleanDt.class}, order=2, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="If the matching elements have to occur in the same order as defined in the profile")
        private BooleanDt myOrdered;
        @Child(name="rules", type={CodeDt.class}, order=3, min=1, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="Whether additional slices are allowed or not. When the slices are ordered, profile authors can also say that additional slices are only allowed at the end")
        private BoundCodeDt<SlicingRulesEnum> myRules;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myDiscriminator, this.myDescription, this.myOrdered, this.myRules});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myDiscriminator, this.myDescription, this.myOrdered, this.myRules});
        }

        public List<StringDt> getDiscriminator() {
            if (this.myDiscriminator == null) {
                this.myDiscriminator = new ArrayList<StringDt>();
            }
            return this.myDiscriminator;
        }

        public Slicing setDiscriminator(List<StringDt> theValue) {
            this.myDiscriminator = theValue;
            return this;
        }

        public StringDt addDiscriminator() {
            StringDt newType = new StringDt();
            this.getDiscriminator().add(newType);
            return newType;
        }

        public Slicing addDiscriminator(StringDt theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getDiscriminator().add(theValue);
            return this;
        }

        public StringDt getDiscriminatorFirstRep() {
            if (this.getDiscriminator().isEmpty()) {
                return this.addDiscriminator();
            }
            return this.getDiscriminator().get(0);
        }

        public Slicing addDiscriminator(String theString) {
            if (this.myDiscriminator == null) {
                this.myDiscriminator = new ArrayList<StringDt>();
            }
            this.myDiscriminator.add(new StringDt(theString));
            return this;
        }

        public StringDt getDescriptionElement() {
            if (this.myDescription == null) {
                this.myDescription = new StringDt();
            }
            return this.myDescription;
        }

        public String getDescription() {
            return (String)this.getDescriptionElement().getValue();
        }

        public Slicing setDescription(StringDt theValue) {
            this.myDescription = theValue;
            return this;
        }

        public Slicing setDescription(String theString) {
            this.myDescription = new StringDt(theString);
            return this;
        }

        public BooleanDt getOrderedElement() {
            if (this.myOrdered == null) {
                this.myOrdered = new BooleanDt();
            }
            return this.myOrdered;
        }

        public Boolean getOrdered() {
            return (Boolean)this.getOrderedElement().getValue();
        }

        public Slicing setOrdered(BooleanDt theValue) {
            this.myOrdered = theValue;
            return this;
        }

        public Slicing setOrdered(boolean theBoolean) {
            this.myOrdered = new BooleanDt(theBoolean);
            return this;
        }

        public BoundCodeDt<SlicingRulesEnum> getRulesElement() {
            if (this.myRules == null) {
                this.myRules = new BoundCodeDt(SlicingRulesEnum.VALUESET_BINDER);
            }
            return this.myRules;
        }

        public String getRules() {
            return (String)this.getRulesElement().getValue();
        }

        public Slicing setRules(BoundCodeDt<SlicingRulesEnum> theValue) {
            this.myRules = theValue;
            return this;
        }

        public Slicing setRules(SlicingRulesEnum theValue) {
            this.getRulesElement().setValueAsEnum((Enum)theValue);
            return this;
        }
    }
}

