/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.composite;

import ca.uhn.fhir.model.api.ICompositeDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.SimpleSetter;
import ca.uhn.fhir.model.base.composite.BaseIdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.BoundCodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.PeriodDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.resource.Organization;
import ca.uhn.fhir.model.dstu2.valueset.IdentifierTypeCodesEnum;
import ca.uhn.fhir.model.dstu2.valueset.IdentifierUseEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.model.primitive.UriDt;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;

@DatatypeDef(name="IdentifierDt")
public class IdentifierDt
extends BaseIdentifierDt
implements ICompositeDatatype {
    @Child(name="use", type={CodeDt.class}, order=0, min=0, max=1, summary=true, modifier=true)
    @Description(shortDefinition="", formalDefinition="The purpose of this identifier")
    private BoundCodeDt<IdentifierUseEnum> myUse;
    @Child(name="type", type={CodeableConceptDt.class}, order=1, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="A coded type for the identifier that can be used to determine which identifier to use for a specific purpose")
    private BoundCodeableConceptDt<IdentifierTypeCodesEnum> myType;
    @Child(name="system", type={UriDt.class}, order=2, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Establishes the namespace in which set of possible id values is unique.")
    private UriDt mySystem;
    @Child(name="value", type={StringDt.class}, order=3, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The portion of the identifier typically displayed to the user and which is unique within the context of the system.")
    private StringDt myValue;
    @Child(name="period", type={PeriodDt.class}, order=4, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Time period during which identifier is/was valid for use")
    private PeriodDt myPeriod;
    @Child(name="assigner", order=5, min=0, max=1, summary=true, modifier=false, type={Organization.class})
    @Description(shortDefinition="", formalDefinition="Organization that issued/manages the identifier")
    private ResourceReferenceDt myAssigner;

    public IdentifierDt() {
    }

    @SimpleSetter
    public IdentifierDt(@SimpleSetter.Parameter(name="theSystem") String theSystem, @SimpleSetter.Parameter(name="theValue") String theValue) {
        this.setSystem(theSystem);
        this.setValue(theValue);
    }

    public String toString() {
        return "IdentifierDt[" + this.getValueAsQueryToken() + "]";
    }

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myUse, this.myType, this.mySystem, this.myValue, this.myPeriod, this.myAssigner});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myUse, this.myType, this.mySystem, this.myValue, this.myPeriod, this.myAssigner});
    }

    public BoundCodeDt<IdentifierUseEnum> getUseElement() {
        if (this.myUse == null) {
            this.myUse = new BoundCodeDt(IdentifierUseEnum.VALUESET_BINDER);
        }
        return this.myUse;
    }

    public String getUse() {
        return (String)this.getUseElement().getValue();
    }

    public IdentifierDt setUse(BoundCodeDt<IdentifierUseEnum> theValue) {
        this.myUse = theValue;
        return this;
    }

    public IdentifierDt setUse(IdentifierUseEnum theValue) {
        this.getUseElement().setValueAsEnum((Enum)theValue);
        return this;
    }

    public BoundCodeableConceptDt<IdentifierTypeCodesEnum> getType() {
        if (this.myType == null) {
            this.myType = new BoundCodeableConceptDt<IdentifierTypeCodesEnum>(IdentifierTypeCodesEnum.VALUESET_BINDER);
        }
        return this.myType;
    }

    public IdentifierDt setType(BoundCodeableConceptDt<IdentifierTypeCodesEnum> theValue) {
        this.myType = theValue;
        return this;
    }

    public IdentifierDt setType(IdentifierTypeCodesEnum theValue) {
        this.getType().setValueAsEnum(theValue);
        return this;
    }

    public UriDt getSystemElement() {
        if (this.mySystem == null) {
            this.mySystem = new UriDt();
        }
        return this.mySystem;
    }

    public String getSystem() {
        return (String)this.getSystemElement().getValue();
    }

    public IdentifierDt setSystem(UriDt theValue) {
        this.mySystem = theValue;
        return this;
    }

    public IdentifierDt setSystem(String theUri) {
        this.mySystem = new UriDt(theUri);
        return this;
    }

    public StringDt getValueElement() {
        if (this.myValue == null) {
            this.myValue = new StringDt();
        }
        return this.myValue;
    }

    public String getValue() {
        return (String)this.getValueElement().getValue();
    }

    public IdentifierDt setValue(StringDt theValue) {
        this.myValue = theValue;
        return this;
    }

    public IdentifierDt setValue(String theString) {
        this.myValue = new StringDt(theString);
        return this;
    }

    public PeriodDt getPeriod() {
        if (this.myPeriod == null) {
            this.myPeriod = new PeriodDt();
        }
        return this.myPeriod;
    }

    public IdentifierDt setPeriod(PeriodDt theValue) {
        this.myPeriod = theValue;
        return this;
    }

    public ResourceReferenceDt getAssigner() {
        if (this.myAssigner == null) {
            this.myAssigner = new ResourceReferenceDt();
        }
        return this.myAssigner;
    }

    public IdentifierDt setAssigner(ResourceReferenceDt theValue) {
        this.myAssigner = theValue;
        return this;
    }
}

