/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.composite;

import ca.uhn.fhir.model.api.ICompositeDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.SimpleSetter;
import ca.uhn.fhir.model.base.composite.BaseQuantityDt;
import ca.uhn.fhir.model.dstu2.valueset.QuantityComparatorEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DecimalDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.model.primitive.UriDt;
import ca.uhn.fhir.util.ElementUtil;
import java.math.BigDecimal;
import java.util.List;

@DatatypeDef(name="QuantityDt")
public class QuantityDt
extends BaseQuantityDt
implements ICompositeDatatype {
    @Child(name="value", type={DecimalDt.class}, order=0, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The value of the measured amount. The value includes an implicit precision in the presentation of the value")
    private DecimalDt myValue;
    @Child(name="comparator", type={CodeDt.class}, order=1, min=0, max=1, summary=true, modifier=true)
    @Description(shortDefinition="", formalDefinition="How the value should be understood and represented - whether the actual value is greater or less than the stated value due to measurement issues; e.g. if the comparator is \"<\" , then the real value is < stated value")
    private BoundCodeDt<QuantityComparatorEnum> myComparator;
    @Child(name="unit", type={StringDt.class}, order=2, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="A human-readable form of the unit")
    private StringDt myUnit;
    @Child(name="system", type={UriDt.class}, order=3, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The identification of the system that provides the coded form of the unit")
    private UriDt mySystem;
    @Child(name="code", type={CodeDt.class}, order=4, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="A computer processable form of the unit in some unit representation system")
    private CodeDt myCode;

    public QuantityDt() {
    }

    @SimpleSetter
    public QuantityDt(@SimpleSetter.Parameter(name="theValue") double theValue) {
        this.setValue(theValue);
    }

    @SimpleSetter
    public QuantityDt(@SimpleSetter.Parameter(name="theValue") long theValue) {
        this.setValue(theValue);
    }

    @SimpleSetter
    public QuantityDt(@SimpleSetter.Parameter(name="theComparator") QuantityComparatorEnum theComparator, @SimpleSetter.Parameter(name="theValue") double theValue, @SimpleSetter.Parameter(name="theUnits") String theUnits) {
        this.setValue(theValue);
        this.setComparator(theComparator);
        this.setUnits(theUnits);
    }

    @SimpleSetter
    public QuantityDt(@SimpleSetter.Parameter(name="theComparator") QuantityComparatorEnum theComparator, @SimpleSetter.Parameter(name="theValue") long theValue, @SimpleSetter.Parameter(name="theUnits") String theUnits) {
        this.setValue(theValue);
        this.setComparator(theComparator);
        this.setUnits(theUnits);
    }

    @SimpleSetter
    public QuantityDt(@SimpleSetter.Parameter(name="theComparator") QuantityComparatorEnum theComparator, @SimpleSetter.Parameter(name="theValue") double theValue, @SimpleSetter.Parameter(name="theSystem") String theSystem, @SimpleSetter.Parameter(name="theUnits") String theUnits) {
        this.setValue(theValue);
        this.setComparator(theComparator);
        this.setSystem(theSystem);
        this.setUnits(theUnits);
    }

    @SimpleSetter
    public QuantityDt(@SimpleSetter.Parameter(name="theComparator") QuantityComparatorEnum theComparator, @SimpleSetter.Parameter(name="theValue") long theValue, @SimpleSetter.Parameter(name="theSystem") String theSystem, @SimpleSetter.Parameter(name="theUnits") String theUnits) {
        this.setValue(theValue);
        this.setComparator(theComparator);
        this.setSystem(theSystem);
        this.setUnits(theUnits);
    }

    @Deprecated
    public BaseQuantityDt setUnits(String theString) {
        return this.setUnit(theString);
    }

    @Deprecated
    public StringDt getUnitsElement() {
        return this.getUnitElement();
    }

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myValue, this.myComparator, this.myUnit, this.mySystem, this.myCode});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myValue, this.myComparator, this.myUnit, this.mySystem, this.myCode});
    }

    public DecimalDt getValueElement() {
        if (this.myValue == null) {
            this.myValue = new DecimalDt();
        }
        return this.myValue;
    }

    public BigDecimal getValue() {
        return (BigDecimal)this.getValueElement().getValue();
    }

    public QuantityDt setValue(DecimalDt theValue) {
        this.myValue = theValue;
        return this;
    }

    public QuantityDt setValue(long theValue) {
        this.myValue = new DecimalDt(theValue);
        return this;
    }

    public QuantityDt setValue(double theValue) {
        this.myValue = new DecimalDt(theValue);
        return this;
    }

    public QuantityDt setValue(BigDecimal theValue) {
        this.myValue = new DecimalDt(theValue);
        return this;
    }

    public BoundCodeDt<QuantityComparatorEnum> getComparatorElement() {
        if (this.myComparator == null) {
            this.myComparator = new BoundCodeDt(QuantityComparatorEnum.VALUESET_BINDER);
        }
        return this.myComparator;
    }

    public String getComparator() {
        return (String)this.getComparatorElement().getValue();
    }

    public QuantityDt setComparator(BoundCodeDt<QuantityComparatorEnum> theValue) {
        this.myComparator = theValue;
        return this;
    }

    public QuantityDt setComparator(QuantityComparatorEnum theValue) {
        this.getComparatorElement().setValueAsEnum((Enum)theValue);
        return this;
    }

    public StringDt getUnitElement() {
        if (this.myUnit == null) {
            this.myUnit = new StringDt();
        }
        return this.myUnit;
    }

    public String getUnit() {
        return (String)this.getUnitElement().getValue();
    }

    public QuantityDt setUnit(StringDt theValue) {
        this.myUnit = theValue;
        return this;
    }

    public QuantityDt setUnit(String theString) {
        this.myUnit = new StringDt(theString);
        return this;
    }

    public UriDt getSystemElement() {
        if (this.mySystem == null) {
            this.mySystem = new UriDt();
        }
        return this.mySystem;
    }

    public String getSystem() {
        return (String)this.getSystemElement().getValue();
    }

    public QuantityDt setSystem(UriDt theValue) {
        this.mySystem = theValue;
        return this;
    }

    public QuantityDt setSystem(String theUri) {
        this.mySystem = new UriDt(theUri);
        return this;
    }

    public CodeDt getCodeElement() {
        if (this.myCode == null) {
            this.myCode = new CodeDt();
        }
        return this.myCode;
    }

    public String getCode() {
        return (String)this.getCodeElement().getValue();
    }

    public QuantityDt setCode(CodeDt theValue) {
        this.myCode = theValue;
        return this;
    }

    public QuantityDt setCode(String theCode) {
        this.myCode = new CodeDt(theCode);
        return this;
    }
}

