/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.AnnotationDt;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.Patient;
import ca.uhn.fhir.model.dstu2.resource.Practitioner;
import ca.uhn.fhir.model.dstu2.resource.RelatedPerson;
import ca.uhn.fhir.model.dstu2.valueset.AllergyIntoleranceCategoryEnum;
import ca.uhn.fhir.model.dstu2.valueset.AllergyIntoleranceCertaintyEnum;
import ca.uhn.fhir.model.dstu2.valueset.AllergyIntoleranceCriticalityEnum;
import ca.uhn.fhir.model.dstu2.valueset.AllergyIntoleranceSeverityEnum;
import ca.uhn.fhir.model.dstu2.valueset.AllergyIntoleranceStatusEnum;
import ca.uhn.fhir.model.dstu2.valueset.AllergyIntoleranceTypeEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="AllergyIntolerance", profile="http://hl7.org/fhir/profiles/AllergyIntolerance", id="allergyintolerance")
public class AllergyIntolerance
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="substance", path="AllergyIntolerance.substance | AllergyIntolerance.reaction.substance", description="", type="token")
    public static final String SP_SUBSTANCE = "substance";
    public static final TokenClientParam SUBSTANCE = new TokenClientParam("substance");
    @SearchParamDefinition(name="status", path="AllergyIntolerance.status", description="", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="criticality", path="AllergyIntolerance.criticality", description="", type="token")
    public static final String SP_CRITICALITY = "criticality";
    public static final TokenClientParam CRITICALITY = new TokenClientParam("criticality");
    @SearchParamDefinition(name="type", path="AllergyIntolerance.type", description="", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="category", path="AllergyIntolerance.category", description="", type="token")
    public static final String SP_CATEGORY = "category";
    public static final TokenClientParam CATEGORY = new TokenClientParam("category");
    @SearchParamDefinition(name="last-date", path="AllergyIntolerance.lastOccurence", description="", type="date")
    public static final String SP_LAST_DATE = "last-date";
    public static final DateClientParam LAST_DATE = new DateClientParam("last-date");
    @SearchParamDefinition(name="manifestation", path="AllergyIntolerance.reaction.manifestation", description="", type="token")
    public static final String SP_MANIFESTATION = "manifestation";
    public static final TokenClientParam MANIFESTATION = new TokenClientParam("manifestation");
    @SearchParamDefinition(name="onset", path="AllergyIntolerance.reaction.onset", description="", type="date")
    public static final String SP_ONSET = "onset";
    public static final DateClientParam ONSET = new DateClientParam("onset");
    @SearchParamDefinition(name="severity", path="AllergyIntolerance.reaction.severity", description="", type="token")
    public static final String SP_SEVERITY = "severity";
    public static final TokenClientParam SEVERITY = new TokenClientParam("severity");
    @SearchParamDefinition(name="route", path="AllergyIntolerance.reaction.exposureRoute", description="", type="token")
    public static final String SP_ROUTE = "route";
    public static final TokenClientParam ROUTE = new TokenClientParam("route");
    @SearchParamDefinition(name="identifier", path="AllergyIntolerance.identifier", description="", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="date", path="AllergyIntolerance.recordedDate", description="", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="recorder", path="AllergyIntolerance.recorder", description="", type="reference")
    public static final String SP_RECORDER = "recorder";
    public static final ReferenceClientParam RECORDER = new ReferenceClientParam("recorder");
    @SearchParamDefinition(name="patient", path="AllergyIntolerance.patient", description="", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    @SearchParamDefinition(name="reporter", path="AllergyIntolerance.reporter", description="", type="reference")
    public static final String SP_REPORTER = "reporter";
    public static final ReferenceClientParam REPORTER = new ReferenceClientParam("reporter");
    public static final Include INCLUDE_PATIENT = new Include("AllergyIntolerance:patient");
    public static final Include INCLUDE_RECORDER = new Include("AllergyIntolerance:recorder");
    public static final Include INCLUDE_REPORTER = new Include("AllergyIntolerance:reporter");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="This records identifiers associated with this allergy/intolerance concern that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate (e.g. in CDA documents, or in written / printed documentation)")
    private List<IdentifierDt> myIdentifier;
    @Child(name="onset", type={DateTimeDt.class}, order=1, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Record of the date and/or time of the onset of the Allergy or Intolerance")
    private DateTimeDt myOnset;
    @Child(name="recordedDate", type={DateTimeDt.class}, order=2, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Date when the sensitivity was recorded")
    private DateTimeDt myRecordedDate;
    @Child(name="recorder", order=3, min=0, max=1, summary=true, modifier=false, type={Practitioner.class, Patient.class})
    @Description(shortDefinition="", formalDefinition="Individual who recorded the record and takes responsibility for its conten")
    private ResourceReferenceDt myRecorder;
    @Child(name="patient", order=4, min=1, max=1, summary=true, modifier=false, type={Patient.class})
    @Description(shortDefinition="", formalDefinition="The patient who has the allergy or intolerance")
    private ResourceReferenceDt myPatient;
    @Child(name="reporter", order=5, min=0, max=1, summary=true, modifier=false, type={Patient.class, RelatedPerson.class, Practitioner.class})
    @Description(shortDefinition="", formalDefinition="The source of the information about the allergy that is recorded")
    private ResourceReferenceDt myReporter;
    @Child(name="substance", type={CodeableConceptDt.class}, order=6, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Identification of a substance, or a class of substances, that is considered to be responsible for the adverse reaction risk")
    private CodeableConceptDt mySubstance;
    @Child(name="status", type={CodeDt.class}, order=7, min=0, max=1, summary=true, modifier=true)
    @Description(shortDefinition="", formalDefinition="Assertion about certainty associated with the propensity, or potential risk, of a reaction to the identified Substance")
    private BoundCodeDt<AllergyIntoleranceStatusEnum> myStatus;
    @Child(name="criticality", type={CodeDt.class}, order=8, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Estimate of the potential clinical harm, or seriousness, of the reaction to the identified Substance")
    private BoundCodeDt<AllergyIntoleranceCriticalityEnum> myCriticality;
    @Child(name="type", type={CodeDt.class}, order=9, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Identification of the underlying physiological mechanism for the reaction risk.")
    private BoundCodeDt<AllergyIntoleranceTypeEnum> myType;
    @Child(name="category", type={CodeDt.class}, order=10, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Category of the identified Substance")
    private BoundCodeDt<AllergyIntoleranceCategoryEnum> myCategory;
    @Child(name="lastOccurence", type={DateTimeDt.class}, order=11, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Represents the date and/or time of the last known occurrence of a reaction event")
    private DateTimeDt myLastOccurence;
    @Child(name="note", type={AnnotationDt.class}, order=12, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Additional narrative about the propensity for the Adverse Reaction, not captured in other fields.")
    private AnnotationDt myNote;
    @Child(name="reaction", order=13, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Details about each adverse reaction event linked to exposure to the identified Substance")
    private List<Reaction> myReaction;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myOnset, this.myRecordedDate, this.myRecorder, this.myPatient, this.myReporter, this.mySubstance, this.myStatus, this.myCriticality, this.myType, this.myCategory, this.myLastOccurence, this.myNote, this.myReaction});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myOnset, this.myRecordedDate, this.myRecorder, this.myPatient, this.myReporter, this.mySubstance, this.myStatus, this.myCriticality, this.myType, this.myCategory, this.myLastOccurence, this.myNote, this.myReaction});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public AllergyIntolerance setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public AllergyIntolerance addIdentifier(IdentifierDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getIdentifier().add(theValue);
        return this;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public DateTimeDt getOnsetElement() {
        if (this.myOnset == null) {
            this.myOnset = new DateTimeDt();
        }
        return this.myOnset;
    }

    public Date getOnset() {
        return (Date)this.getOnsetElement().getValue();
    }

    public AllergyIntolerance setOnset(DateTimeDt theValue) {
        this.myOnset = theValue;
        return this;
    }

    public AllergyIntolerance setOnset(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myOnset = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public AllergyIntolerance setOnsetWithSecondsPrecision(Date theDate) {
        this.myOnset = new DateTimeDt(theDate);
        return this;
    }

    public DateTimeDt getRecordedDateElement() {
        if (this.myRecordedDate == null) {
            this.myRecordedDate = new DateTimeDt();
        }
        return this.myRecordedDate;
    }

    public Date getRecordedDate() {
        return (Date)this.getRecordedDateElement().getValue();
    }

    public AllergyIntolerance setRecordedDate(DateTimeDt theValue) {
        this.myRecordedDate = theValue;
        return this;
    }

    public AllergyIntolerance setRecordedDate(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myRecordedDate = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public AllergyIntolerance setRecordedDateWithSecondsPrecision(Date theDate) {
        this.myRecordedDate = new DateTimeDt(theDate);
        return this;
    }

    public ResourceReferenceDt getRecorder() {
        if (this.myRecorder == null) {
            this.myRecorder = new ResourceReferenceDt();
        }
        return this.myRecorder;
    }

    public AllergyIntolerance setRecorder(ResourceReferenceDt theValue) {
        this.myRecorder = theValue;
        return this;
    }

    public ResourceReferenceDt getPatient() {
        if (this.myPatient == null) {
            this.myPatient = new ResourceReferenceDt();
        }
        return this.myPatient;
    }

    public AllergyIntolerance setPatient(ResourceReferenceDt theValue) {
        this.myPatient = theValue;
        return this;
    }

    public ResourceReferenceDt getReporter() {
        if (this.myReporter == null) {
            this.myReporter = new ResourceReferenceDt();
        }
        return this.myReporter;
    }

    public AllergyIntolerance setReporter(ResourceReferenceDt theValue) {
        this.myReporter = theValue;
        return this;
    }

    public CodeableConceptDt getSubstance() {
        if (this.mySubstance == null) {
            this.mySubstance = new CodeableConceptDt();
        }
        return this.mySubstance;
    }

    public AllergyIntolerance setSubstance(CodeableConceptDt theValue) {
        this.mySubstance = theValue;
        return this;
    }

    public BoundCodeDt<AllergyIntoleranceStatusEnum> getStatusElement() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(AllergyIntoleranceStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public String getStatus() {
        return (String)this.getStatusElement().getValue();
    }

    public AllergyIntolerance setStatus(BoundCodeDt<AllergyIntoleranceStatusEnum> theValue) {
        this.myStatus = theValue;
        return this;
    }

    public AllergyIntolerance setStatus(AllergyIntoleranceStatusEnum theValue) {
        this.getStatusElement().setValueAsEnum((Enum)theValue);
        return this;
    }

    public BoundCodeDt<AllergyIntoleranceCriticalityEnum> getCriticalityElement() {
        if (this.myCriticality == null) {
            this.myCriticality = new BoundCodeDt(AllergyIntoleranceCriticalityEnum.VALUESET_BINDER);
        }
        return this.myCriticality;
    }

    public String getCriticality() {
        return (String)this.getCriticalityElement().getValue();
    }

    public AllergyIntolerance setCriticality(BoundCodeDt<AllergyIntoleranceCriticalityEnum> theValue) {
        this.myCriticality = theValue;
        return this;
    }

    public AllergyIntolerance setCriticality(AllergyIntoleranceCriticalityEnum theValue) {
        this.getCriticalityElement().setValueAsEnum((Enum)theValue);
        return this;
    }

    public BoundCodeDt<AllergyIntoleranceTypeEnum> getTypeElement() {
        if (this.myType == null) {
            this.myType = new BoundCodeDt(AllergyIntoleranceTypeEnum.VALUESET_BINDER);
        }
        return this.myType;
    }

    public String getType() {
        return (String)this.getTypeElement().getValue();
    }

    public AllergyIntolerance setType(BoundCodeDt<AllergyIntoleranceTypeEnum> theValue) {
        this.myType = theValue;
        return this;
    }

    public AllergyIntolerance setType(AllergyIntoleranceTypeEnum theValue) {
        this.getTypeElement().setValueAsEnum((Enum)theValue);
        return this;
    }

    public BoundCodeDt<AllergyIntoleranceCategoryEnum> getCategoryElement() {
        if (this.myCategory == null) {
            this.myCategory = new BoundCodeDt(AllergyIntoleranceCategoryEnum.VALUESET_BINDER);
        }
        return this.myCategory;
    }

    public String getCategory() {
        return (String)this.getCategoryElement().getValue();
    }

    public AllergyIntolerance setCategory(BoundCodeDt<AllergyIntoleranceCategoryEnum> theValue) {
        this.myCategory = theValue;
        return this;
    }

    public AllergyIntolerance setCategory(AllergyIntoleranceCategoryEnum theValue) {
        this.getCategoryElement().setValueAsEnum((Enum)theValue);
        return this;
    }

    public DateTimeDt getLastOccurenceElement() {
        if (this.myLastOccurence == null) {
            this.myLastOccurence = new DateTimeDt();
        }
        return this.myLastOccurence;
    }

    public Date getLastOccurence() {
        return (Date)this.getLastOccurenceElement().getValue();
    }

    public AllergyIntolerance setLastOccurence(DateTimeDt theValue) {
        this.myLastOccurence = theValue;
        return this;
    }

    public AllergyIntolerance setLastOccurence(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myLastOccurence = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public AllergyIntolerance setLastOccurenceWithSecondsPrecision(Date theDate) {
        this.myLastOccurence = new DateTimeDt(theDate);
        return this;
    }

    public AnnotationDt getNote() {
        if (this.myNote == null) {
            this.myNote = new AnnotationDt();
        }
        return this.myNote;
    }

    public AllergyIntolerance setNote(AnnotationDt theValue) {
        this.myNote = theValue;
        return this;
    }

    public List<Reaction> getReaction() {
        if (this.myReaction == null) {
            this.myReaction = new ArrayList<Reaction>();
        }
        return this.myReaction;
    }

    public AllergyIntolerance setReaction(List<Reaction> theValue) {
        this.myReaction = theValue;
        return this;
    }

    public Reaction addReaction() {
        Reaction newType = new Reaction();
        this.getReaction().add(newType);
        return newType;
    }

    public AllergyIntolerance addReaction(Reaction theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getReaction().add(theValue);
        return this;
    }

    public Reaction getReactionFirstRep() {
        if (this.getReaction().isEmpty()) {
            return this.addReaction();
        }
        return this.getReaction().get(0);
    }

    public String getResourceName() {
        return "AllergyIntolerance";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }

    @Block
    public static class Reaction
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="substance", type={CodeableConceptDt.class}, order=0, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="Identification of the specific substance considered to be responsible for the Adverse Reaction event. Note: the substance for a specific reaction may be different to the substance identified as the cause of the risk, but must be consistent with it. For instance, it may be a more specific substance (e.g. a brand medication) or a composite substance that includes the identified substance. It must be clinically safe to only process the AllergyIntolerance.substance and ignore the AllergyIntolerance.event.substance")
        private CodeableConceptDt mySubstance;
        @Child(name="certainty", type={CodeDt.class}, order=1, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="Statement about the degree of clinical certainty that the specific substance was the cause of the manifestation in this reaction event")
        private BoundCodeDt<AllergyIntoleranceCertaintyEnum> myCertainty;
        @Child(name="manifestation", type={CodeableConceptDt.class}, order=2, min=1, max=-1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="Clinical symptoms and/or signs that are observed or associated with the adverse reaction event")
        private List<CodeableConceptDt> myManifestation;
        @Child(name="description", type={StringDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Text description about the reaction as a whole, including details of the manifestation if required")
        private StringDt myDescription;
        @Child(name="onset", type={DateTimeDt.class}, order=4, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="Record of the date and/or time of the onset of the Reaction")
        private DateTimeDt myOnset;
        @Child(name="severity", type={CodeDt.class}, order=5, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="Clinical assessment of the severity of the reaction event as a whole, potentially considering multiple different manifestations")
        private BoundCodeDt<AllergyIntoleranceSeverityEnum> mySeverity;
        @Child(name="exposureRoute", type={CodeableConceptDt.class}, order=6, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="Identification of the route by which the subject was exposed to the substance.")
        private CodeableConceptDt myExposureRoute;
        @Child(name="note", type={AnnotationDt.class}, order=7, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Additional text about the adverse reaction event not captured in other fields")
        private AnnotationDt myNote;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.mySubstance, this.myCertainty, this.myManifestation, this.myDescription, this.myOnset, this.mySeverity, this.myExposureRoute, this.myNote});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.mySubstance, this.myCertainty, this.myManifestation, this.myDescription, this.myOnset, this.mySeverity, this.myExposureRoute, this.myNote});
        }

        public CodeableConceptDt getSubstance() {
            if (this.mySubstance == null) {
                this.mySubstance = new CodeableConceptDt();
            }
            return this.mySubstance;
        }

        public Reaction setSubstance(CodeableConceptDt theValue) {
            this.mySubstance = theValue;
            return this;
        }

        public BoundCodeDt<AllergyIntoleranceCertaintyEnum> getCertaintyElement() {
            if (this.myCertainty == null) {
                this.myCertainty = new BoundCodeDt(AllergyIntoleranceCertaintyEnum.VALUESET_BINDER);
            }
            return this.myCertainty;
        }

        public String getCertainty() {
            return (String)this.getCertaintyElement().getValue();
        }

        public Reaction setCertainty(BoundCodeDt<AllergyIntoleranceCertaintyEnum> theValue) {
            this.myCertainty = theValue;
            return this;
        }

        public Reaction setCertainty(AllergyIntoleranceCertaintyEnum theValue) {
            this.getCertaintyElement().setValueAsEnum((Enum)theValue);
            return this;
        }

        public List<CodeableConceptDt> getManifestation() {
            if (this.myManifestation == null) {
                this.myManifestation = new ArrayList<CodeableConceptDt>();
            }
            return this.myManifestation;
        }

        public Reaction setManifestation(List<CodeableConceptDt> theValue) {
            this.myManifestation = theValue;
            return this;
        }

        public CodeableConceptDt addManifestation() {
            CodeableConceptDt newType = new CodeableConceptDt();
            this.getManifestation().add(newType);
            return newType;
        }

        public Reaction addManifestation(CodeableConceptDt theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getManifestation().add(theValue);
            return this;
        }

        public CodeableConceptDt getManifestationFirstRep() {
            if (this.getManifestation().isEmpty()) {
                return this.addManifestation();
            }
            return this.getManifestation().get(0);
        }

        public StringDt getDescriptionElement() {
            if (this.myDescription == null) {
                this.myDescription = new StringDt();
            }
            return this.myDescription;
        }

        public String getDescription() {
            return (String)this.getDescriptionElement().getValue();
        }

        public Reaction setDescription(StringDt theValue) {
            this.myDescription = theValue;
            return this;
        }

        public Reaction setDescription(String theString) {
            this.myDescription = new StringDt(theString);
            return this;
        }

        public DateTimeDt getOnsetElement() {
            if (this.myOnset == null) {
                this.myOnset = new DateTimeDt();
            }
            return this.myOnset;
        }

        public Date getOnset() {
            return (Date)this.getOnsetElement().getValue();
        }

        public Reaction setOnset(DateTimeDt theValue) {
            this.myOnset = theValue;
            return this;
        }

        public Reaction setOnset(Date theDate, TemporalPrecisionEnum thePrecision) {
            this.myOnset = new DateTimeDt(theDate, thePrecision);
            return this;
        }

        public Reaction setOnsetWithSecondsPrecision(Date theDate) {
            this.myOnset = new DateTimeDt(theDate);
            return this;
        }

        public BoundCodeDt<AllergyIntoleranceSeverityEnum> getSeverityElement() {
            if (this.mySeverity == null) {
                this.mySeverity = new BoundCodeDt(AllergyIntoleranceSeverityEnum.VALUESET_BINDER);
            }
            return this.mySeverity;
        }

        public String getSeverity() {
            return (String)this.getSeverityElement().getValue();
        }

        public Reaction setSeverity(BoundCodeDt<AllergyIntoleranceSeverityEnum> theValue) {
            this.mySeverity = theValue;
            return this;
        }

        public Reaction setSeverity(AllergyIntoleranceSeverityEnum theValue) {
            this.getSeverityElement().setValueAsEnum((Enum)theValue);
            return this;
        }

        public CodeableConceptDt getExposureRoute() {
            if (this.myExposureRoute == null) {
                this.myExposureRoute = new CodeableConceptDt();
            }
            return this.myExposureRoute;
        }

        public Reaction setExposureRoute(CodeableConceptDt theValue) {
            this.myExposureRoute = theValue;
            return this;
        }

        public AnnotationDt getNote() {
            if (this.myNote == null) {
                this.myNote = new AnnotationDt();
            }
            return this.myNote;
        }

        public Reaction setNote(AnnotationDt theValue) {
            this.myNote = theValue;
            return this;
        }
    }
}

