/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.BoundCodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.Device;
import ca.uhn.fhir.model.dstu2.resource.HealthcareService;
import ca.uhn.fhir.model.dstu2.resource.Location;
import ca.uhn.fhir.model.dstu2.resource.Patient;
import ca.uhn.fhir.model.dstu2.resource.Practitioner;
import ca.uhn.fhir.model.dstu2.resource.RelatedPerson;
import ca.uhn.fhir.model.dstu2.resource.Slot;
import ca.uhn.fhir.model.dstu2.valueset.AppointmentStatusEnum;
import ca.uhn.fhir.model.dstu2.valueset.ParticipantRequiredEnum;
import ca.uhn.fhir.model.dstu2.valueset.ParticipantTypeEnum;
import ca.uhn.fhir.model.dstu2.valueset.ParticipationStatusEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.model.primitive.PositiveIntDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.model.primitive.UnsignedIntDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="Appointment", profile="http://hl7.org/fhir/profiles/Appointment", id="appointment")
public class Appointment
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="date", path="Appointment.start", description="Appointment date/time.", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="status", path="Appointment.status", description="The overall status of the appointment", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="actor", path="Appointment.participant.actor", description="Any one of the individuals participating in the appointment", type="reference")
    public static final String SP_ACTOR = "actor";
    public static final ReferenceClientParam ACTOR = new ReferenceClientParam("actor");
    @SearchParamDefinition(name="part-status", path="Appointment.participant.status", description="The Participation status of the subject, or other participant on the appointment. Can be used to locate participants that have not responded to meeting requests.", type="token")
    public static final String SP_PART_STATUS = "part-status";
    public static final TokenClientParam PART_STATUS = new TokenClientParam("part-status");
    @SearchParamDefinition(name="patient", path="Appointment.participant.actor", description="One of the individuals of the appointment is this patient", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    @SearchParamDefinition(name="practitioner", path="Appointment.participant.actor", description="One of the individuals of the appointment is this practitioner", type="reference")
    public static final String SP_PRACTITIONER = "practitioner";
    public static final ReferenceClientParam PRACTITIONER = new ReferenceClientParam("practitioner");
    @SearchParamDefinition(name="location", path="Appointment.participant.actor", description="This location is listed in the participants of the appointment", type="reference")
    public static final String SP_LOCATION = "location";
    public static final ReferenceClientParam LOCATION = new ReferenceClientParam("location");
    @SearchParamDefinition(name="identifier", path="Appointment.identifier", description="An Identifier of the Appointment", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    public static final Include INCLUDE_ACTOR = new Include("Appointment:actor");
    public static final Include INCLUDE_LOCATION = new Include("Appointment:location");
    public static final Include INCLUDE_PATIENT = new Include("Appointment:patient");
    public static final Include INCLUDE_PRACTITIONER = new Include("Appointment:practitioner");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="This records identifiers associated with this appointment concern that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate (e.g. in CDA documents, or in written / printed documentation)")
    private List<IdentifierDt> myIdentifier;
    @Child(name="status", type={CodeDt.class}, order=1, min=1, max=1, summary=true, modifier=true)
    @Description(shortDefinition="", formalDefinition="The overall status of the Appointment. Each of the participants has their own participation status which indicates their involvement in the process, however this status indicates the shared status")
    private BoundCodeDt<AppointmentStatusEnum> myStatus;
    @Child(name="type", type={CodeableConceptDt.class}, order=2, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The type of appointment that is being booked (This may also be associated with participants for location, and/or a HealthcareService)")
    private CodeableConceptDt myType;
    @Child(name="reason", type={CodeableConceptDt.class}, order=3, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The reason that this appointment is being scheduled. This is more clinical than administrative")
    private CodeableConceptDt myReason;
    @Child(name="priority", type={UnsignedIntDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The priority of the appointment. Can be used to make informed decisions if needing to re-prioritize appointments. (The iCal Standard specifies 0 as undefined, 1 as highest, 9 as lowest priority)")
    private UnsignedIntDt myPriority;
    @Child(name="description", type={StringDt.class}, order=5, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The brief description of the appointment as would be shown on a subject line in a meeting request, or appointment list. Detailed or expanded information should be put in the comment field")
    private StringDt myDescription;
    @Child(name="start", type={InstantDt.class}, order=6, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Date/Time that the appointment is to take place")
    private InstantDt myStart;
    @Child(name="end", type={InstantDt.class}, order=7, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Date/Time that the appointment is to conclude")
    private InstantDt myEnd;
    @Child(name="minutesDuration", type={PositiveIntDt.class}, order=8, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Number of minutes that the appointment is to take. This can be less than the duration between the start and end times (where actual time of appointment is only an estimate or is a planned appointment request)")
    private PositiveIntDt myMinutesDuration;
    @Child(name="slot", order=9, min=0, max=-1, summary=false, modifier=false, type={Slot.class})
    @Description(shortDefinition="", formalDefinition="The slot that this appointment is filling. If provided then the schedule will not be provided as slots are not recursive, and the start/end values MUST be the same as from the slot")
    private List<ResourceReferenceDt> mySlot;
    @Child(name="comment", type={StringDt.class}, order=10, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Additional comments about the appointment")
    private StringDt myComment;
    @Child(name="participant", order=11, min=1, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="List of participants involved in the appointment")
    private List<Participant> myParticipant;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myStatus, this.myType, this.myReason, this.myPriority, this.myDescription, this.myStart, this.myEnd, this.myMinutesDuration, this.mySlot, this.myComment, this.myParticipant});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myStatus, this.myType, this.myReason, this.myPriority, this.myDescription, this.myStart, this.myEnd, this.myMinutesDuration, this.mySlot, this.myComment, this.myParticipant});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public Appointment setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public Appointment addIdentifier(IdentifierDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getIdentifier().add(theValue);
        return this;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public BoundCodeDt<AppointmentStatusEnum> getStatusElement() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(AppointmentStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public String getStatus() {
        return (String)this.getStatusElement().getValue();
    }

    public Appointment setStatus(BoundCodeDt<AppointmentStatusEnum> theValue) {
        this.myStatus = theValue;
        return this;
    }

    public Appointment setStatus(AppointmentStatusEnum theValue) {
        this.getStatusElement().setValueAsEnum((Enum)theValue);
        return this;
    }

    public CodeableConceptDt getType() {
        if (this.myType == null) {
            this.myType = new CodeableConceptDt();
        }
        return this.myType;
    }

    public Appointment setType(CodeableConceptDt theValue) {
        this.myType = theValue;
        return this;
    }

    public CodeableConceptDt getReason() {
        if (this.myReason == null) {
            this.myReason = new CodeableConceptDt();
        }
        return this.myReason;
    }

    public Appointment setReason(CodeableConceptDt theValue) {
        this.myReason = theValue;
        return this;
    }

    public UnsignedIntDt getPriorityElement() {
        if (this.myPriority == null) {
            this.myPriority = new UnsignedIntDt();
        }
        return this.myPriority;
    }

    public Integer getPriority() {
        return (Integer)this.getPriorityElement().getValue();
    }

    public Appointment setPriority(UnsignedIntDt theValue) {
        this.myPriority = theValue;
        return this;
    }

    public Appointment setPriority(int theInteger) {
        this.myPriority = new UnsignedIntDt(theInteger);
        return this;
    }

    public StringDt getDescriptionElement() {
        if (this.myDescription == null) {
            this.myDescription = new StringDt();
        }
        return this.myDescription;
    }

    public String getDescription() {
        return (String)this.getDescriptionElement().getValue();
    }

    public Appointment setDescription(StringDt theValue) {
        this.myDescription = theValue;
        return this;
    }

    public Appointment setDescription(String theString) {
        this.myDescription = new StringDt(theString);
        return this;
    }

    public InstantDt getStartElement() {
        if (this.myStart == null) {
            this.myStart = new InstantDt();
        }
        return this.myStart;
    }

    public Date getStart() {
        return (Date)this.getStartElement().getValue();
    }

    public Appointment setStart(InstantDt theValue) {
        this.myStart = theValue;
        return this;
    }

    public Appointment setStartWithMillisPrecision(Date theDate) {
        this.myStart = new InstantDt(theDate);
        return this;
    }

    public Appointment setStart(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myStart = new InstantDt(theDate, thePrecision);
        return this;
    }

    public InstantDt getEndElement() {
        if (this.myEnd == null) {
            this.myEnd = new InstantDt();
        }
        return this.myEnd;
    }

    public Date getEnd() {
        return (Date)this.getEndElement().getValue();
    }

    public Appointment setEnd(InstantDt theValue) {
        this.myEnd = theValue;
        return this;
    }

    public Appointment setEndWithMillisPrecision(Date theDate) {
        this.myEnd = new InstantDt(theDate);
        return this;
    }

    public Appointment setEnd(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myEnd = new InstantDt(theDate, thePrecision);
        return this;
    }

    public PositiveIntDt getMinutesDurationElement() {
        if (this.myMinutesDuration == null) {
            this.myMinutesDuration = new PositiveIntDt();
        }
        return this.myMinutesDuration;
    }

    public Integer getMinutesDuration() {
        return (Integer)this.getMinutesDurationElement().getValue();
    }

    public Appointment setMinutesDuration(PositiveIntDt theValue) {
        this.myMinutesDuration = theValue;
        return this;
    }

    public Appointment setMinutesDuration(int theInteger) {
        this.myMinutesDuration = new PositiveIntDt(theInteger);
        return this;
    }

    public List<ResourceReferenceDt> getSlot() {
        if (this.mySlot == null) {
            this.mySlot = new ArrayList<ResourceReferenceDt>();
        }
        return this.mySlot;
    }

    public Appointment setSlot(List<ResourceReferenceDt> theValue) {
        this.mySlot = theValue;
        return this;
    }

    public ResourceReferenceDt addSlot() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getSlot().add(newType);
        return newType;
    }

    public StringDt getCommentElement() {
        if (this.myComment == null) {
            this.myComment = new StringDt();
        }
        return this.myComment;
    }

    public String getComment() {
        return (String)this.getCommentElement().getValue();
    }

    public Appointment setComment(StringDt theValue) {
        this.myComment = theValue;
        return this;
    }

    public Appointment setComment(String theString) {
        this.myComment = new StringDt(theString);
        return this;
    }

    public List<Participant> getParticipant() {
        if (this.myParticipant == null) {
            this.myParticipant = new ArrayList<Participant>();
        }
        return this.myParticipant;
    }

    public Appointment setParticipant(List<Participant> theValue) {
        this.myParticipant = theValue;
        return this;
    }

    public Participant addParticipant() {
        Participant newType = new Participant();
        this.getParticipant().add(newType);
        return newType;
    }

    public Appointment addParticipant(Participant theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getParticipant().add(theValue);
        return this;
    }

    public Participant getParticipantFirstRep() {
        if (this.getParticipant().isEmpty()) {
            return this.addParticipant();
        }
        return this.getParticipant().get(0);
    }

    public String getResourceName() {
        return "Appointment";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }

    @Block
    public static class Participant
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="type", type={CodeableConceptDt.class}, order=0, min=0, max=-1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="Role of participant in the appointment")
        private List<BoundCodeableConceptDt<ParticipantTypeEnum>> myType;
        @Child(name="actor", order=1, min=0, max=1, summary=true, modifier=false, type={Patient.class, Practitioner.class, RelatedPerson.class, Device.class, HealthcareService.class, Location.class})
        @Description(shortDefinition="", formalDefinition="A Person, Location/HealthcareService or Device that is participating in the appointment")
        private ResourceReferenceDt myActor;
        @Child(name="required", type={CodeDt.class}, order=2, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="Is this participant required to be present at the meeting. This covers a use-case where 2 doctors need to meet to discuss the results for a specific patient, and the patient is not required to be present.")
        private BoundCodeDt<ParticipantRequiredEnum> myRequired;
        @Child(name="status", type={CodeDt.class}, order=3, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Participation status of the Patient")
        private BoundCodeDt<ParticipationStatusEnum> myStatus;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myType, this.myActor, this.myRequired, this.myStatus});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myType, this.myActor, this.myRequired, this.myStatus});
        }

        public List<BoundCodeableConceptDt<ParticipantTypeEnum>> getType() {
            if (this.myType == null) {
                this.myType = new ArrayList<BoundCodeableConceptDt<ParticipantTypeEnum>>();
            }
            return this.myType;
        }

        public Participant setType(List<BoundCodeableConceptDt<ParticipantTypeEnum>> theValue) {
            this.myType = theValue;
            return this;
        }

        public BoundCodeableConceptDt<ParticipantTypeEnum> addType(ParticipantTypeEnum theValue) {
            BoundCodeableConceptDt<ParticipantTypeEnum> retVal = new BoundCodeableConceptDt<ParticipantTypeEnum>(ParticipantTypeEnum.VALUESET_BINDER, theValue);
            this.getType().add(retVal);
            return retVal;
        }

        public BoundCodeableConceptDt<ParticipantTypeEnum> getTypeFirstRep() {
            if (this.getType().size() == 0) {
                this.addType();
            }
            return this.getType().get(0);
        }

        public BoundCodeableConceptDt<ParticipantTypeEnum> addType() {
            BoundCodeableConceptDt<ParticipantTypeEnum> retVal = new BoundCodeableConceptDt<ParticipantTypeEnum>(ParticipantTypeEnum.VALUESET_BINDER);
            this.getType().add(retVal);
            return retVal;
        }

        public Participant setType(ParticipantTypeEnum theValue) {
            this.getType().clear();
            this.addType(theValue);
            return this;
        }

        public ResourceReferenceDt getActor() {
            if (this.myActor == null) {
                this.myActor = new ResourceReferenceDt();
            }
            return this.myActor;
        }

        public Participant setActor(ResourceReferenceDt theValue) {
            this.myActor = theValue;
            return this;
        }

        public BoundCodeDt<ParticipantRequiredEnum> getRequiredElement() {
            if (this.myRequired == null) {
                this.myRequired = new BoundCodeDt(ParticipantRequiredEnum.VALUESET_BINDER);
            }
            return this.myRequired;
        }

        public String getRequired() {
            return (String)this.getRequiredElement().getValue();
        }

        public Participant setRequired(BoundCodeDt<ParticipantRequiredEnum> theValue) {
            this.myRequired = theValue;
            return this;
        }

        public Participant setRequired(ParticipantRequiredEnum theValue) {
            this.getRequiredElement().setValueAsEnum((Enum)theValue);
            return this;
        }

        public BoundCodeDt<ParticipationStatusEnum> getStatusElement() {
            if (this.myStatus == null) {
                this.myStatus = new BoundCodeDt(ParticipationStatusEnum.VALUESET_BINDER);
            }
            return this.myStatus;
        }

        public String getStatus() {
            return (String)this.getStatusElement().getValue();
        }

        public Participant setStatus(BoundCodeDt<ParticipationStatusEnum> theValue) {
            this.myStatus = theValue;
            return this;
        }

        public Participant setStatus(ParticipationStatusEnum theValue) {
            this.getStatusElement().setValueAsEnum((Enum)theValue);
            return this;
        }
    }
}

