/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.BoundCodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.resource.Appointment;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.Device;
import ca.uhn.fhir.model.dstu2.resource.HealthcareService;
import ca.uhn.fhir.model.dstu2.resource.Location;
import ca.uhn.fhir.model.dstu2.resource.Patient;
import ca.uhn.fhir.model.dstu2.resource.Practitioner;
import ca.uhn.fhir.model.dstu2.resource.RelatedPerson;
import ca.uhn.fhir.model.dstu2.valueset.ParticipantStatusEnum;
import ca.uhn.fhir.model.dstu2.valueset.ParticipantTypeEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="AppointmentResponse", profile="http://hl7.org/fhir/profiles/AppointmentResponse", id="appointmentresponse")
public class AppointmentResponse
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="appointment", path="AppointmentResponse.appointment", description="The appointment that the response is attached to", type="reference")
    public static final String SP_APPOINTMENT = "appointment";
    public static final ReferenceClientParam APPOINTMENT = new ReferenceClientParam("appointment");
    @SearchParamDefinition(name="part-status", path="AppointmentResponse.participantStatus", description="The participants acceptance status for this appointment", type="token")
    public static final String SP_PART_STATUS = "part-status";
    public static final TokenClientParam PART_STATUS = new TokenClientParam("part-status");
    @SearchParamDefinition(name="actor", path="AppointmentResponse.actor", description="The Person, Location/HealthcareService or Device that this appointment response replies for", type="reference")
    public static final String SP_ACTOR = "actor";
    public static final ReferenceClientParam ACTOR = new ReferenceClientParam("actor");
    @SearchParamDefinition(name="patient", path="AppointmentResponse.actor", description="This Response is for this Patient", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    @SearchParamDefinition(name="practitioner", path="AppointmentResponse.actor", description="This Response is for this Practitioner", type="reference")
    public static final String SP_PRACTITIONER = "practitioner";
    public static final ReferenceClientParam PRACTITIONER = new ReferenceClientParam("practitioner");
    @SearchParamDefinition(name="location", path="AppointmentResponse.actor", description="This Response is for this Location", type="reference")
    public static final String SP_LOCATION = "location";
    public static final ReferenceClientParam LOCATION = new ReferenceClientParam("location");
    @SearchParamDefinition(name="identifier", path="AppointmentResponse.identifier", description="An Identifier in this appointment response", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    public static final Include INCLUDE_ACTOR = new Include("AppointmentResponse:actor");
    public static final Include INCLUDE_APPOINTMENT = new Include("AppointmentResponse:appointment");
    public static final Include INCLUDE_LOCATION = new Include("AppointmentResponse:location");
    public static final Include INCLUDE_PATIENT = new Include("AppointmentResponse:patient");
    public static final Include INCLUDE_PRACTITIONER = new Include("AppointmentResponse:practitioner");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="This records identifiers associated with this appointment response concern that are defined by business processes and/ or used to refer to it when a direct URL reference to the resource itself is not appropriate")
    private List<IdentifierDt> myIdentifier;
    @Child(name="appointment", order=1, min=1, max=1, summary=true, modifier=false, type={Appointment.class})
    @Description(shortDefinition="", formalDefinition="")
    private ResourceReferenceDt myAppointment;
    @Child(name="start", type={InstantDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Date/Time that the appointment is to take place, or requested new start time")
    private InstantDt myStart;
    @Child(name="end", type={InstantDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="This may be either the same as the appointment request to confirm the details of the appointment, or alternately a new time to request a re-negotiation of the end time.")
    private InstantDt myEnd;
    @Child(name="participantType", type={CodeableConceptDt.class}, order=4, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Role of participant in the appointment")
    private List<BoundCodeableConceptDt<ParticipantTypeEnum>> myParticipantType;
    @Child(name="actor", order=5, min=0, max=1, summary=true, modifier=false, type={Patient.class, Practitioner.class, RelatedPerson.class, Device.class, HealthcareService.class, Location.class})
    @Description(shortDefinition="", formalDefinition="A Person, Location/HealthcareService or Device that is participating in the appointment")
    private ResourceReferenceDt myActor;
    @Child(name="participantStatus", type={CodeDt.class}, order=6, min=1, max=1, summary=true, modifier=true)
    @Description(shortDefinition="", formalDefinition="Participation status of the participant. When the status is declined or tentative if the start/end times are different to the appointment, then these times should be interpreted as a requested time change. When the status is accepted, the times can either be the time of the appointment (as a confirmation of the time) or can be empty.")
    private BoundCodeDt<ParticipantStatusEnum> myParticipantStatus;
    @Child(name="comment", type={StringDt.class}, order=7, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Additional comments about the appointment")
    private StringDt myComment;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myAppointment, this.myStart, this.myEnd, this.myParticipantType, this.myActor, this.myParticipantStatus, this.myComment});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myAppointment, this.myStart, this.myEnd, this.myParticipantType, this.myActor, this.myParticipantStatus, this.myComment});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public AppointmentResponse setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public AppointmentResponse addIdentifier(IdentifierDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getIdentifier().add(theValue);
        return this;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public ResourceReferenceDt getAppointment() {
        if (this.myAppointment == null) {
            this.myAppointment = new ResourceReferenceDt();
        }
        return this.myAppointment;
    }

    public AppointmentResponse setAppointment(ResourceReferenceDt theValue) {
        this.myAppointment = theValue;
        return this;
    }

    public InstantDt getStartElement() {
        if (this.myStart == null) {
            this.myStart = new InstantDt();
        }
        return this.myStart;
    }

    public Date getStart() {
        return (Date)this.getStartElement().getValue();
    }

    public AppointmentResponse setStart(InstantDt theValue) {
        this.myStart = theValue;
        return this;
    }

    public AppointmentResponse setStartWithMillisPrecision(Date theDate) {
        this.myStart = new InstantDt(theDate);
        return this;
    }

    public AppointmentResponse setStart(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myStart = new InstantDt(theDate, thePrecision);
        return this;
    }

    public InstantDt getEndElement() {
        if (this.myEnd == null) {
            this.myEnd = new InstantDt();
        }
        return this.myEnd;
    }

    public Date getEnd() {
        return (Date)this.getEndElement().getValue();
    }

    public AppointmentResponse setEnd(InstantDt theValue) {
        this.myEnd = theValue;
        return this;
    }

    public AppointmentResponse setEndWithMillisPrecision(Date theDate) {
        this.myEnd = new InstantDt(theDate);
        return this;
    }

    public AppointmentResponse setEnd(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myEnd = new InstantDt(theDate, thePrecision);
        return this;
    }

    public List<BoundCodeableConceptDt<ParticipantTypeEnum>> getParticipantType() {
        if (this.myParticipantType == null) {
            this.myParticipantType = new ArrayList<BoundCodeableConceptDt<ParticipantTypeEnum>>();
        }
        return this.myParticipantType;
    }

    public AppointmentResponse setParticipantType(List<BoundCodeableConceptDt<ParticipantTypeEnum>> theValue) {
        this.myParticipantType = theValue;
        return this;
    }

    public BoundCodeableConceptDt<ParticipantTypeEnum> addParticipantType(ParticipantTypeEnum theValue) {
        BoundCodeableConceptDt<ParticipantTypeEnum> retVal = new BoundCodeableConceptDt<ParticipantTypeEnum>(ParticipantTypeEnum.VALUESET_BINDER, theValue);
        this.getParticipantType().add(retVal);
        return retVal;
    }

    public BoundCodeableConceptDt<ParticipantTypeEnum> getParticipantTypeFirstRep() {
        if (this.getParticipantType().size() == 0) {
            this.addParticipantType();
        }
        return this.getParticipantType().get(0);
    }

    public BoundCodeableConceptDt<ParticipantTypeEnum> addParticipantType() {
        BoundCodeableConceptDt<ParticipantTypeEnum> retVal = new BoundCodeableConceptDt<ParticipantTypeEnum>(ParticipantTypeEnum.VALUESET_BINDER);
        this.getParticipantType().add(retVal);
        return retVal;
    }

    public AppointmentResponse setParticipantType(ParticipantTypeEnum theValue) {
        this.getParticipantType().clear();
        this.addParticipantType(theValue);
        return this;
    }

    public ResourceReferenceDt getActor() {
        if (this.myActor == null) {
            this.myActor = new ResourceReferenceDt();
        }
        return this.myActor;
    }

    public AppointmentResponse setActor(ResourceReferenceDt theValue) {
        this.myActor = theValue;
        return this;
    }

    public BoundCodeDt<ParticipantStatusEnum> getParticipantStatusElement() {
        if (this.myParticipantStatus == null) {
            this.myParticipantStatus = new BoundCodeDt(ParticipantStatusEnum.VALUESET_BINDER);
        }
        return this.myParticipantStatus;
    }

    public String getParticipantStatus() {
        return (String)this.getParticipantStatusElement().getValue();
    }

    public AppointmentResponse setParticipantStatus(BoundCodeDt<ParticipantStatusEnum> theValue) {
        this.myParticipantStatus = theValue;
        return this;
    }

    public AppointmentResponse setParticipantStatus(ParticipantStatusEnum theValue) {
        this.getParticipantStatusElement().setValueAsEnum((Enum)theValue);
        return this;
    }

    public StringDt getCommentElement() {
        if (this.myComment == null) {
            this.myComment = new StringDt();
        }
        return this.myComment;
    }

    public String getComment() {
        return (String)this.getCommentElement().getValue();
    }

    public AppointmentResponse setComment(StringDt theValue) {
        this.myComment = theValue;
        return this;
    }

    public AppointmentResponse setComment(String theString) {
        this.myComment = new StringDt(theString);
        return this;
    }

    public String getResourceName() {
        return "AppointmentResponse";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }
}

