/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.AnnotationDt;
import ca.uhn.fhir.model.dstu2.composite.BoundCodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.PeriodDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.composite.SimpleQuantityDt;
import ca.uhn.fhir.model.dstu2.composite.TimingDt;
import ca.uhn.fhir.model.dstu2.resource.Appointment;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.CommunicationRequest;
import ca.uhn.fhir.model.dstu2.resource.Condition;
import ca.uhn.fhir.model.dstu2.resource.DeviceUseRequest;
import ca.uhn.fhir.model.dstu2.resource.DiagnosticOrder;
import ca.uhn.fhir.model.dstu2.resource.Encounter;
import ca.uhn.fhir.model.dstu2.resource.EpisodeOfCare;
import ca.uhn.fhir.model.dstu2.resource.Goal;
import ca.uhn.fhir.model.dstu2.resource.Group;
import ca.uhn.fhir.model.dstu2.resource.Location;
import ca.uhn.fhir.model.dstu2.resource.Medication;
import ca.uhn.fhir.model.dstu2.resource.MedicationOrder;
import ca.uhn.fhir.model.dstu2.resource.NutritionOrder;
import ca.uhn.fhir.model.dstu2.resource.Order;
import ca.uhn.fhir.model.dstu2.resource.Organization;
import ca.uhn.fhir.model.dstu2.resource.Patient;
import ca.uhn.fhir.model.dstu2.resource.Practitioner;
import ca.uhn.fhir.model.dstu2.resource.ProcedureRequest;
import ca.uhn.fhir.model.dstu2.resource.ProcessRequest;
import ca.uhn.fhir.model.dstu2.resource.ReferralRequest;
import ca.uhn.fhir.model.dstu2.resource.RelatedPerson;
import ca.uhn.fhir.model.dstu2.resource.Substance;
import ca.uhn.fhir.model.dstu2.resource.SupplyRequest;
import ca.uhn.fhir.model.dstu2.resource.VisionPrescription;
import ca.uhn.fhir.model.dstu2.valueset.CarePlanActivityCategoryEnum;
import ca.uhn.fhir.model.dstu2.valueset.CarePlanActivityStatusEnum;
import ca.uhn.fhir.model.dstu2.valueset.CarePlanRelationshipEnum;
import ca.uhn.fhir.model.dstu2.valueset.CarePlanStatusEnum;
import ca.uhn.fhir.model.primitive.BooleanDt;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.CompositeClientParam;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="CarePlan", profile="http://hl7.org/fhir/profiles/CarePlan", id="careplan")
public class CarePlan
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="patient", path="CarePlan.subject", description="", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    @SearchParamDefinition(name="subject", path="CarePlan.subject", description="", type="reference")
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    @SearchParamDefinition(name="condition", path="CarePlan.addresses", description="", type="reference")
    public static final String SP_CONDITION = "condition";
    public static final ReferenceClientParam CONDITION = new ReferenceClientParam("condition");
    @SearchParamDefinition(name="date", path="CarePlan.period", description="", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="participant", path="CarePlan.participant.member", description="", type="reference")
    public static final String SP_PARTICIPANT = "participant";
    public static final ReferenceClientParam PARTICIPANT = new ReferenceClientParam("participant");
    @SearchParamDefinition(name="activitycode", path="CarePlan.activity.detail.code", description="", type="token")
    public static final String SP_ACTIVITYCODE = "activitycode";
    public static final TokenClientParam ACTIVITYCODE = new TokenClientParam("activitycode");
    @SearchParamDefinition(name="activitydate", path="CarePlan.activity.detail.scheduled[x]", description="Specified date occurs within period specified by CarePlan.activity.timingSchedule", type="date")
    public static final String SP_ACTIVITYDATE = "activitydate";
    public static final DateClientParam ACTIVITYDATE = new DateClientParam("activitydate");
    @SearchParamDefinition(name="activityreference", path="CarePlan.activity.reference", description="", type="reference")
    public static final String SP_ACTIVITYREFERENCE = "activityreference";
    public static final ReferenceClientParam ACTIVITYREFERENCE = new ReferenceClientParam("activityreference");
    @SearchParamDefinition(name="performer", path="CarePlan.activity.detail.performer", description="Matches if the practitioner is listed as a performer in any of the \"simple\" activities.  (For performers of the detailed activities, chain through the activitydetail search parameter.)", type="reference")
    public static final String SP_PERFORMER = "performer";
    public static final ReferenceClientParam PERFORMER = new ReferenceClientParam("performer");
    @SearchParamDefinition(name="goal", path="CarePlan.goal", description="", type="reference")
    public static final String SP_GOAL = "goal";
    public static final ReferenceClientParam GOAL = new ReferenceClientParam("goal");
    @SearchParamDefinition(name="relatedcode", path="CarePlan.relatedPlan.code", description="", type="token")
    public static final String SP_RELATEDCODE = "relatedcode";
    public static final TokenClientParam RELATEDCODE = new TokenClientParam("relatedcode");
    @SearchParamDefinition(name="relatedplan", path="CarePlan.relatedPlan.plan", description="", type="reference")
    public static final String SP_RELATEDPLAN = "relatedplan";
    public static final ReferenceClientParam RELATEDPLAN = new ReferenceClientParam("relatedplan");
    @SearchParamDefinition(name="relatedcode-relatedplan", path="relatedcode & relatedplan", description="A combination of the type of relationship and the related plan", type="composite", compositeOf={"relatedcode", "relatedplan"})
    public static final String SP_RELATEDCODE_RELATEDPLAN = "relatedcode-relatedplan";
    public static final CompositeClientParam<TokenClientParam, ReferenceClientParam> RELATEDCODE_RELATEDPLAN = new CompositeClientParam("relatedcode-relatedplan");
    public static final Include INCLUDE_ACTIVITYREFERENCE = new Include("CarePlan:activityreference");
    public static final Include INCLUDE_CONDITION = new Include("CarePlan:condition");
    public static final Include INCLUDE_GOAL = new Include("CarePlan:goal");
    public static final Include INCLUDE_PARTICIPANT = new Include("CarePlan:participant");
    public static final Include INCLUDE_PATIENT = new Include("CarePlan:patient");
    public static final Include INCLUDE_PERFORMER = new Include("CarePlan:performer");
    public static final Include INCLUDE_RELATEDPLAN = new Include("CarePlan:relatedplan");
    public static final Include INCLUDE_SUBJECT = new Include("CarePlan:subject");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="This records identifiers associated with this care plan that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate (e.g. in CDA documents, or in written / printed documentation)")
    private List<IdentifierDt> myIdentifier;
    @Child(name="subject", order=1, min=0, max=1, summary=true, modifier=false, type={Patient.class, Group.class})
    @Description(shortDefinition="", formalDefinition="Identifies the patient or group whose intended care is described by the plan.")
    private ResourceReferenceDt mySubject;
    @Child(name="status", type={CodeDt.class}, order=2, min=1, max=1, summary=true, modifier=true)
    @Description(shortDefinition="", formalDefinition="Indicates whether the plan is currently being acted upon, represents future intentions or is now a historical record.")
    private BoundCodeDt<CarePlanStatusEnum> myStatus;
    @Child(name="context", order=3, min=0, max=1, summary=true, modifier=false, type={Encounter.class, EpisodeOfCare.class})
    @Description(shortDefinition="", formalDefinition="Identifies the context in which this particular CarePlan is defined.")
    private ResourceReferenceDt myContext;
    @Child(name="period", type={PeriodDt.class}, order=4, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Indicates when the plan did (or is intended to) come into effect and end.")
    private PeriodDt myPeriod;
    @Child(name="author", order=5, min=0, max=-1, summary=true, modifier=false, type={Patient.class, Practitioner.class, RelatedPerson.class, Organization.class})
    @Description(shortDefinition="", formalDefinition="Identifies the individual(s) or ogranization who is responsible for the content of the care plan.")
    private List<ResourceReferenceDt> myAuthor;
    @Child(name="modified", type={DateTimeDt.class}, order=6, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Identifies the most recent date on which the plan has been revised.")
    private DateTimeDt myModified;
    @Child(name="category", type={CodeableConceptDt.class}, order=7, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Identifies what \"kind\" of plan this is to support differentiation between multiple co-existing plans; e.g. \"Home health\", \"psychiatric\", \"asthma\", \"disease management\", \"wellness plan\", etc.")
    private List<CodeableConceptDt> myCategory;
    @Child(name="description", type={StringDt.class}, order=8, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="A description of the scope and nature of the plan")
    private StringDt myDescription;
    @Child(name="addresses", order=9, min=0, max=-1, summary=true, modifier=false, type={Condition.class})
    @Description(shortDefinition="", formalDefinition="Identifies the conditions/problems/concerns/diagnoses/etc. whose management and/or mitigation are handled by this plan.")
    private List<ResourceReferenceDt> myAddresses;
    @Child(name="support", order=10, min=0, max=-1, summary=false, modifier=false, type={IResource.class})
    @Description(shortDefinition="", formalDefinition="Identifies portions of the patient's record that specifically influenced the formation of the plan.  These might include co-morbidities, recent procedures, limitations, recent assessments, etc.")
    private List<ResourceReferenceDt> mySupport;
    @Child(name="relatedPlan", order=11, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Identifies CarePlans with some sort of formal relationship to the current plan.")
    private List<RelatedPlan> myRelatedPlan;
    @Child(name="participant", order=12, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Identifies all people and organizations who are expected to be involved in the care envisioned by this plan.")
    private List<Participant> myParticipant;
    @Child(name="goal", order=13, min=0, max=-1, summary=false, modifier=false, type={Goal.class})
    @Description(shortDefinition="", formalDefinition="Describes the intended objective(s) of carrying out the care plan.")
    private List<ResourceReferenceDt> myGoal;
    @Child(name="activity", order=14, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Identifies a planned action to occur as part of the plan.  For example, a medication to be used, lab tests to perform, self-monitoring, education, etc.")
    private List<Activity> myActivity;
    @Child(name="note", type={AnnotationDt.class}, order=15, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="General notes about the care plan not covered elsewhere")
    private AnnotationDt myNote;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.mySubject, this.myStatus, this.myContext, this.myPeriod, this.myAuthor, this.myModified, this.myCategory, this.myDescription, this.myAddresses, this.mySupport, this.myRelatedPlan, this.myParticipant, this.myGoal, this.myActivity, this.myNote});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.mySubject, this.myStatus, this.myContext, this.myPeriod, this.myAuthor, this.myModified, this.myCategory, this.myDescription, this.myAddresses, this.mySupport, this.myRelatedPlan, this.myParticipant, this.myGoal, this.myActivity, this.myNote});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public CarePlan setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public CarePlan addIdentifier(IdentifierDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getIdentifier().add(theValue);
        return this;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public ResourceReferenceDt getSubject() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public CarePlan setSubject(ResourceReferenceDt theValue) {
        this.mySubject = theValue;
        return this;
    }

    public BoundCodeDt<CarePlanStatusEnum> getStatusElement() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(CarePlanStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public String getStatus() {
        return (String)this.getStatusElement().getValue();
    }

    public CarePlan setStatus(BoundCodeDt<CarePlanStatusEnum> theValue) {
        this.myStatus = theValue;
        return this;
    }

    public CarePlan setStatus(CarePlanStatusEnum theValue) {
        this.getStatusElement().setValueAsEnum((Enum)theValue);
        return this;
    }

    public ResourceReferenceDt getContext() {
        if (this.myContext == null) {
            this.myContext = new ResourceReferenceDt();
        }
        return this.myContext;
    }

    public CarePlan setContext(ResourceReferenceDt theValue) {
        this.myContext = theValue;
        return this;
    }

    public PeriodDt getPeriod() {
        if (this.myPeriod == null) {
            this.myPeriod = new PeriodDt();
        }
        return this.myPeriod;
    }

    public CarePlan setPeriod(PeriodDt theValue) {
        this.myPeriod = theValue;
        return this;
    }

    public List<ResourceReferenceDt> getAuthor() {
        if (this.myAuthor == null) {
            this.myAuthor = new ArrayList<ResourceReferenceDt>();
        }
        return this.myAuthor;
    }

    public CarePlan setAuthor(List<ResourceReferenceDt> theValue) {
        this.myAuthor = theValue;
        return this;
    }

    public ResourceReferenceDt addAuthor() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getAuthor().add(newType);
        return newType;
    }

    public DateTimeDt getModifiedElement() {
        if (this.myModified == null) {
            this.myModified = new DateTimeDt();
        }
        return this.myModified;
    }

    public Date getModified() {
        return (Date)this.getModifiedElement().getValue();
    }

    public CarePlan setModified(DateTimeDt theValue) {
        this.myModified = theValue;
        return this;
    }

    public CarePlan setModified(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myModified = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public CarePlan setModifiedWithSecondsPrecision(Date theDate) {
        this.myModified = new DateTimeDt(theDate);
        return this;
    }

    public List<CodeableConceptDt> getCategory() {
        if (this.myCategory == null) {
            this.myCategory = new ArrayList<CodeableConceptDt>();
        }
        return this.myCategory;
    }

    public CarePlan setCategory(List<CodeableConceptDt> theValue) {
        this.myCategory = theValue;
        return this;
    }

    public CodeableConceptDt addCategory() {
        CodeableConceptDt newType = new CodeableConceptDt();
        this.getCategory().add(newType);
        return newType;
    }

    public CarePlan addCategory(CodeableConceptDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getCategory().add(theValue);
        return this;
    }

    public CodeableConceptDt getCategoryFirstRep() {
        if (this.getCategory().isEmpty()) {
            return this.addCategory();
        }
        return this.getCategory().get(0);
    }

    public StringDt getDescriptionElement() {
        if (this.myDescription == null) {
            this.myDescription = new StringDt();
        }
        return this.myDescription;
    }

    public String getDescription() {
        return (String)this.getDescriptionElement().getValue();
    }

    public CarePlan setDescription(StringDt theValue) {
        this.myDescription = theValue;
        return this;
    }

    public CarePlan setDescription(String theString) {
        this.myDescription = new StringDt(theString);
        return this;
    }

    public List<ResourceReferenceDt> getAddresses() {
        if (this.myAddresses == null) {
            this.myAddresses = new ArrayList<ResourceReferenceDt>();
        }
        return this.myAddresses;
    }

    public CarePlan setAddresses(List<ResourceReferenceDt> theValue) {
        this.myAddresses = theValue;
        return this;
    }

    public ResourceReferenceDt addAddresses() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getAddresses().add(newType);
        return newType;
    }

    public List<ResourceReferenceDt> getSupport() {
        if (this.mySupport == null) {
            this.mySupport = new ArrayList<ResourceReferenceDt>();
        }
        return this.mySupport;
    }

    public CarePlan setSupport(List<ResourceReferenceDt> theValue) {
        this.mySupport = theValue;
        return this;
    }

    public ResourceReferenceDt addSupport() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getSupport().add(newType);
        return newType;
    }

    public List<RelatedPlan> getRelatedPlan() {
        if (this.myRelatedPlan == null) {
            this.myRelatedPlan = new ArrayList<RelatedPlan>();
        }
        return this.myRelatedPlan;
    }

    public CarePlan setRelatedPlan(List<RelatedPlan> theValue) {
        this.myRelatedPlan = theValue;
        return this;
    }

    public RelatedPlan addRelatedPlan() {
        RelatedPlan newType = new RelatedPlan();
        this.getRelatedPlan().add(newType);
        return newType;
    }

    public CarePlan addRelatedPlan(RelatedPlan theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getRelatedPlan().add(theValue);
        return this;
    }

    public RelatedPlan getRelatedPlanFirstRep() {
        if (this.getRelatedPlan().isEmpty()) {
            return this.addRelatedPlan();
        }
        return this.getRelatedPlan().get(0);
    }

    public List<Participant> getParticipant() {
        if (this.myParticipant == null) {
            this.myParticipant = new ArrayList<Participant>();
        }
        return this.myParticipant;
    }

    public CarePlan setParticipant(List<Participant> theValue) {
        this.myParticipant = theValue;
        return this;
    }

    public Participant addParticipant() {
        Participant newType = new Participant();
        this.getParticipant().add(newType);
        return newType;
    }

    public CarePlan addParticipant(Participant theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getParticipant().add(theValue);
        return this;
    }

    public Participant getParticipantFirstRep() {
        if (this.getParticipant().isEmpty()) {
            return this.addParticipant();
        }
        return this.getParticipant().get(0);
    }

    public List<ResourceReferenceDt> getGoal() {
        if (this.myGoal == null) {
            this.myGoal = new ArrayList<ResourceReferenceDt>();
        }
        return this.myGoal;
    }

    public CarePlan setGoal(List<ResourceReferenceDt> theValue) {
        this.myGoal = theValue;
        return this;
    }

    public ResourceReferenceDt addGoal() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getGoal().add(newType);
        return newType;
    }

    public List<Activity> getActivity() {
        if (this.myActivity == null) {
            this.myActivity = new ArrayList<Activity>();
        }
        return this.myActivity;
    }

    public CarePlan setActivity(List<Activity> theValue) {
        this.myActivity = theValue;
        return this;
    }

    public Activity addActivity() {
        Activity newType = new Activity();
        this.getActivity().add(newType);
        return newType;
    }

    public CarePlan addActivity(Activity theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getActivity().add(theValue);
        return this;
    }

    public Activity getActivityFirstRep() {
        if (this.getActivity().isEmpty()) {
            return this.addActivity();
        }
        return this.getActivity().get(0);
    }

    public AnnotationDt getNote() {
        if (this.myNote == null) {
            this.myNote = new AnnotationDt();
        }
        return this.myNote;
    }

    public CarePlan setNote(AnnotationDt theValue) {
        this.myNote = theValue;
        return this;
    }

    public String getResourceName() {
        return "CarePlan";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }

    @Block
    public static class ActivityDetail
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="category", type={CodeableConceptDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="High-level categorization of the type of activity in a care plan.")
        private BoundCodeableConceptDt<CarePlanActivityCategoryEnum> myCategory;
        @Child(name="code", type={CodeableConceptDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Detailed description of the type of planned activity; e.g. What lab test, what procedure, what kind of encounter.")
        private CodeableConceptDt myCode;
        @Child(name="reasonCode", type={CodeableConceptDt.class}, order=2, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Provides the rationale that drove the inclusion of this particular activity as part of the plan.")
        private List<CodeableConceptDt> myReasonCode;
        @Child(name="reasonReference", order=3, min=0, max=-1, summary=false, modifier=false, type={Condition.class})
        @Description(shortDefinition="", formalDefinition="Provides the health condition(s) that drove the inclusion of this particular activity as part of the plan.")
        private List<ResourceReferenceDt> myReasonReference;
        @Child(name="goal", order=4, min=0, max=-1, summary=false, modifier=false, type={Goal.class})
        @Description(shortDefinition="", formalDefinition="Internal reference that identifies the goals that this activity is intended to contribute towards meeting")
        private List<ResourceReferenceDt> myGoal;
        @Child(name="status", type={CodeDt.class}, order=5, min=0, max=1, summary=false, modifier=true)
        @Description(shortDefinition="", formalDefinition="Identifies what progress is being made for the specific activity.")
        private BoundCodeDt<CarePlanActivityStatusEnum> myStatus;
        @Child(name="statusReason", type={CodeableConceptDt.class}, order=6, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Provides reason why the activity isn't yet started, is on hold, was cancelled, etc.")
        private CodeableConceptDt myStatusReason;
        @Child(name="prohibited", type={BooleanDt.class}, order=7, min=1, max=1, summary=false, modifier=true)
        @Description(shortDefinition="", formalDefinition="If true, indicates that the described activity is one that must NOT be engaged in when following the plan.")
        private BooleanDt myProhibited;
        @Child(name="scheduled", order=8, min=0, max=1, summary=false, modifier=false, type={TimingDt.class, PeriodDt.class, StringDt.class})
        @Description(shortDefinition="", formalDefinition="The period, timing or frequency upon which the described activity is to occur.")
        private IDatatype myScheduled;
        @Child(name="location", order=9, min=0, max=1, summary=false, modifier=false, type={Location.class})
        @Description(shortDefinition="", formalDefinition="Identifies the facility where the activity will occur; e.g. home, hospital, specific clinic, etc.")
        private ResourceReferenceDt myLocation;
        @Child(name="performer", order=10, min=0, max=-1, summary=false, modifier=false, type={Practitioner.class, Organization.class, RelatedPerson.class, Patient.class})
        @Description(shortDefinition="", formalDefinition="Identifies who's expected to be involved in the activity.")
        private List<ResourceReferenceDt> myPerformer;
        @Child(name="product", order=11, min=0, max=1, summary=false, modifier=false, type={CodeableConceptDt.class, Medication.class, Substance.class})
        @Description(shortDefinition="", formalDefinition="Identifies the food, drug or other product to be consumed or supplied in the activity.")
        private IDatatype myProduct;
        @Child(name="dailyAmount", type={SimpleQuantityDt.class}, order=12, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Identifies the quantity expected to be consumed in a given day.")
        private SimpleQuantityDt myDailyAmount;
        @Child(name="quantity", type={SimpleQuantityDt.class}, order=13, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Identifies the quantity expected to be supplied, administered or consumed by the subject")
        private SimpleQuantityDt myQuantity;
        @Child(name="description", type={StringDt.class}, order=14, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="This provides a textual description of constraints on the intended activity occurrence, including relation to other activities.  It may also include objectives, pre-conditions and end-conditions.  Finally, it may convey specifics about the activity such as body site, method, route, etc.")
        private StringDt myDescription;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myCategory, this.myCode, this.myReasonCode, this.myReasonReference, this.myGoal, this.myStatus, this.myStatusReason, this.myProhibited, this.myScheduled, this.myLocation, this.myPerformer, this.myProduct, this.myDailyAmount, this.myQuantity, this.myDescription});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myCategory, this.myCode, this.myReasonCode, this.myReasonReference, this.myGoal, this.myStatus, this.myStatusReason, this.myProhibited, this.myScheduled, this.myLocation, this.myPerformer, this.myProduct, this.myDailyAmount, this.myQuantity, this.myDescription});
        }

        public BoundCodeableConceptDt<CarePlanActivityCategoryEnum> getCategory() {
            if (this.myCategory == null) {
                this.myCategory = new BoundCodeableConceptDt<CarePlanActivityCategoryEnum>(CarePlanActivityCategoryEnum.VALUESET_BINDER);
            }
            return this.myCategory;
        }

        public ActivityDetail setCategory(BoundCodeableConceptDt<CarePlanActivityCategoryEnum> theValue) {
            this.myCategory = theValue;
            return this;
        }

        public ActivityDetail setCategory(CarePlanActivityCategoryEnum theValue) {
            this.getCategory().setValueAsEnum(theValue);
            return this;
        }

        public CodeableConceptDt getCode() {
            if (this.myCode == null) {
                this.myCode = new CodeableConceptDt();
            }
            return this.myCode;
        }

        public ActivityDetail setCode(CodeableConceptDt theValue) {
            this.myCode = theValue;
            return this;
        }

        public List<CodeableConceptDt> getReasonCode() {
            if (this.myReasonCode == null) {
                this.myReasonCode = new ArrayList<CodeableConceptDt>();
            }
            return this.myReasonCode;
        }

        public ActivityDetail setReasonCode(List<CodeableConceptDt> theValue) {
            this.myReasonCode = theValue;
            return this;
        }

        public CodeableConceptDt addReasonCode() {
            CodeableConceptDt newType = new CodeableConceptDt();
            this.getReasonCode().add(newType);
            return newType;
        }

        public ActivityDetail addReasonCode(CodeableConceptDt theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getReasonCode().add(theValue);
            return this;
        }

        public CodeableConceptDt getReasonCodeFirstRep() {
            if (this.getReasonCode().isEmpty()) {
                return this.addReasonCode();
            }
            return this.getReasonCode().get(0);
        }

        public List<ResourceReferenceDt> getReasonReference() {
            if (this.myReasonReference == null) {
                this.myReasonReference = new ArrayList<ResourceReferenceDt>();
            }
            return this.myReasonReference;
        }

        public ActivityDetail setReasonReference(List<ResourceReferenceDt> theValue) {
            this.myReasonReference = theValue;
            return this;
        }

        public ResourceReferenceDt addReasonReference() {
            ResourceReferenceDt newType = new ResourceReferenceDt();
            this.getReasonReference().add(newType);
            return newType;
        }

        public List<ResourceReferenceDt> getGoal() {
            if (this.myGoal == null) {
                this.myGoal = new ArrayList<ResourceReferenceDt>();
            }
            return this.myGoal;
        }

        public ActivityDetail setGoal(List<ResourceReferenceDt> theValue) {
            this.myGoal = theValue;
            return this;
        }

        public ResourceReferenceDt addGoal() {
            ResourceReferenceDt newType = new ResourceReferenceDt();
            this.getGoal().add(newType);
            return newType;
        }

        public BoundCodeDt<CarePlanActivityStatusEnum> getStatusElement() {
            if (this.myStatus == null) {
                this.myStatus = new BoundCodeDt(CarePlanActivityStatusEnum.VALUESET_BINDER);
            }
            return this.myStatus;
        }

        public String getStatus() {
            return (String)this.getStatusElement().getValue();
        }

        public ActivityDetail setStatus(BoundCodeDt<CarePlanActivityStatusEnum> theValue) {
            this.myStatus = theValue;
            return this;
        }

        public ActivityDetail setStatus(CarePlanActivityStatusEnum theValue) {
            this.getStatusElement().setValueAsEnum((Enum)theValue);
            return this;
        }

        public CodeableConceptDt getStatusReason() {
            if (this.myStatusReason == null) {
                this.myStatusReason = new CodeableConceptDt();
            }
            return this.myStatusReason;
        }

        public ActivityDetail setStatusReason(CodeableConceptDt theValue) {
            this.myStatusReason = theValue;
            return this;
        }

        public BooleanDt getProhibitedElement() {
            if (this.myProhibited == null) {
                this.myProhibited = new BooleanDt();
            }
            return this.myProhibited;
        }

        public Boolean getProhibited() {
            return (Boolean)this.getProhibitedElement().getValue();
        }

        public ActivityDetail setProhibited(BooleanDt theValue) {
            this.myProhibited = theValue;
            return this;
        }

        public ActivityDetail setProhibited(boolean theBoolean) {
            this.myProhibited = new BooleanDt(theBoolean);
            return this;
        }

        public IDatatype getScheduled() {
            return this.myScheduled;
        }

        public ActivityDetail setScheduled(IDatatype theValue) {
            this.myScheduled = theValue;
            return this;
        }

        public ResourceReferenceDt getLocation() {
            if (this.myLocation == null) {
                this.myLocation = new ResourceReferenceDt();
            }
            return this.myLocation;
        }

        public ActivityDetail setLocation(ResourceReferenceDt theValue) {
            this.myLocation = theValue;
            return this;
        }

        public List<ResourceReferenceDt> getPerformer() {
            if (this.myPerformer == null) {
                this.myPerformer = new ArrayList<ResourceReferenceDt>();
            }
            return this.myPerformer;
        }

        public ActivityDetail setPerformer(List<ResourceReferenceDt> theValue) {
            this.myPerformer = theValue;
            return this;
        }

        public ResourceReferenceDt addPerformer() {
            ResourceReferenceDt newType = new ResourceReferenceDt();
            this.getPerformer().add(newType);
            return newType;
        }

        public IDatatype getProduct() {
            return this.myProduct;
        }

        public ActivityDetail setProduct(IDatatype theValue) {
            this.myProduct = theValue;
            return this;
        }

        public SimpleQuantityDt getDailyAmount() {
            if (this.myDailyAmount == null) {
                this.myDailyAmount = new SimpleQuantityDt();
            }
            return this.myDailyAmount;
        }

        public ActivityDetail setDailyAmount(SimpleQuantityDt theValue) {
            this.myDailyAmount = theValue;
            return this;
        }

        public SimpleQuantityDt getQuantity() {
            if (this.myQuantity == null) {
                this.myQuantity = new SimpleQuantityDt();
            }
            return this.myQuantity;
        }

        public ActivityDetail setQuantity(SimpleQuantityDt theValue) {
            this.myQuantity = theValue;
            return this;
        }

        public StringDt getDescriptionElement() {
            if (this.myDescription == null) {
                this.myDescription = new StringDt();
            }
            return this.myDescription;
        }

        public String getDescription() {
            return (String)this.getDescriptionElement().getValue();
        }

        public ActivityDetail setDescription(StringDt theValue) {
            this.myDescription = theValue;
            return this;
        }

        public ActivityDetail setDescription(String theString) {
            this.myDescription = new StringDt(theString);
            return this;
        }
    }

    @Block
    public static class Activity
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="actionResulting", order=0, min=0, max=-1, summary=false, modifier=false, type={IResource.class})
        @Description(shortDefinition="", formalDefinition="Resources that describe follow-on actions resulting from the plan, such as drug prescriptions, encounter records, appointments, etc.")
        private List<ResourceReferenceDt> myActionResulting;
        @Child(name="progress", type={AnnotationDt.class}, order=1, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Notes about the adherence/status/progress of the activity")
        private List<AnnotationDt> myProgress;
        @Child(name="reference", order=2, min=0, max=1, summary=false, modifier=false, type={Appointment.class, CommunicationRequest.class, DeviceUseRequest.class, DiagnosticOrder.class, MedicationOrder.class, NutritionOrder.class, Order.class, ProcedureRequest.class, ProcessRequest.class, ReferralRequest.class, SupplyRequest.class, VisionPrescription.class})
        @Description(shortDefinition="", formalDefinition="The details of the proposed activity represented in a specific resource")
        private ResourceReferenceDt myReference;
        @Child(name="detail", order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A simple summary of a planned activity suitable for a general care plan system (e.g. form driven) that doesn't know about specific resources such as procedure etc.")
        private ActivityDetail myDetail;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myActionResulting, this.myProgress, this.myReference, this.myDetail});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myActionResulting, this.myProgress, this.myReference, this.myDetail});
        }

        public List<ResourceReferenceDt> getActionResulting() {
            if (this.myActionResulting == null) {
                this.myActionResulting = new ArrayList<ResourceReferenceDt>();
            }
            return this.myActionResulting;
        }

        public Activity setActionResulting(List<ResourceReferenceDt> theValue) {
            this.myActionResulting = theValue;
            return this;
        }

        public ResourceReferenceDt addActionResulting() {
            ResourceReferenceDt newType = new ResourceReferenceDt();
            this.getActionResulting().add(newType);
            return newType;
        }

        public List<AnnotationDt> getProgress() {
            if (this.myProgress == null) {
                this.myProgress = new ArrayList<AnnotationDt>();
            }
            return this.myProgress;
        }

        public Activity setProgress(List<AnnotationDt> theValue) {
            this.myProgress = theValue;
            return this;
        }

        public AnnotationDt addProgress() {
            AnnotationDt newType = new AnnotationDt();
            this.getProgress().add(newType);
            return newType;
        }

        public Activity addProgress(AnnotationDt theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getProgress().add(theValue);
            return this;
        }

        public AnnotationDt getProgressFirstRep() {
            if (this.getProgress().isEmpty()) {
                return this.addProgress();
            }
            return this.getProgress().get(0);
        }

        public ResourceReferenceDt getReference() {
            if (this.myReference == null) {
                this.myReference = new ResourceReferenceDt();
            }
            return this.myReference;
        }

        public Activity setReference(ResourceReferenceDt theValue) {
            this.myReference = theValue;
            return this;
        }

        public ActivityDetail getDetail() {
            if (this.myDetail == null) {
                this.myDetail = new ActivityDetail();
            }
            return this.myDetail;
        }

        public Activity setDetail(ActivityDetail theValue) {
            this.myDetail = theValue;
            return this;
        }
    }

    @Block
    public static class Participant
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="role", type={CodeableConceptDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Indicates specific responsibility of an individual within the care plan; e.g. \"Primary physician\", \"Team coordinator\", \"Caregiver\", etc.")
        private CodeableConceptDt myRole;
        @Child(name="member", order=1, min=0, max=1, summary=false, modifier=false, type={Practitioner.class, RelatedPerson.class, Patient.class, Organization.class})
        @Description(shortDefinition="", formalDefinition="The specific person or organization who is participating/expected to participate in the care plan.")
        private ResourceReferenceDt myMember;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myRole, this.myMember});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myRole, this.myMember});
        }

        public CodeableConceptDt getRole() {
            if (this.myRole == null) {
                this.myRole = new CodeableConceptDt();
            }
            return this.myRole;
        }

        public Participant setRole(CodeableConceptDt theValue) {
            this.myRole = theValue;
            return this;
        }

        public ResourceReferenceDt getMember() {
            if (this.myMember == null) {
                this.myMember = new ResourceReferenceDt();
            }
            return this.myMember;
        }

        public Participant setMember(ResourceReferenceDt theValue) {
            this.myMember = theValue;
            return this;
        }
    }

    @Block
    public static class RelatedPlan
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="code", type={CodeDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Identifies the type of relationship this plan has to the target plan.")
        private BoundCodeDt<CarePlanRelationshipEnum> myCode;
        @Child(name="plan", order=1, min=1, max=1, summary=false, modifier=false, type={CarePlan.class})
        @Description(shortDefinition="", formalDefinition="A reference to the plan to which a relationship is asserted.")
        private ResourceReferenceDt myPlan;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myCode, this.myPlan});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myCode, this.myPlan});
        }

        public BoundCodeDt<CarePlanRelationshipEnum> getCodeElement() {
            if (this.myCode == null) {
                this.myCode = new BoundCodeDt(CarePlanRelationshipEnum.VALUESET_BINDER);
            }
            return this.myCode;
        }

        public String getCode() {
            return (String)this.getCodeElement().getValue();
        }

        public RelatedPlan setCode(BoundCodeDt<CarePlanRelationshipEnum> theValue) {
            this.myCode = theValue;
            return this;
        }

        public RelatedPlan setCode(CarePlanRelationshipEnum theValue) {
            this.getCodeElement().setValueAsEnum((Enum)theValue);
            return this;
        }

        public ResourceReferenceDt getPlan() {
            if (this.myPlan == null) {
                this.myPlan = new ResourceReferenceDt();
            }
            return this.myPlan;
        }

        public RelatedPlan setPlan(ResourceReferenceDt theValue) {
            this.myPlan = theValue;
            return this;
        }
    }
}

