/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.CodingDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.MoneyDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.Claim;
import ca.uhn.fhir.model.dstu2.resource.Organization;
import ca.uhn.fhir.model.dstu2.resource.Practitioner;
import ca.uhn.fhir.model.dstu2.valueset.RemittanceOutcomeEnum;
import ca.uhn.fhir.model.primitive.BooleanDt;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.DecimalDt;
import ca.uhn.fhir.model.primitive.PositiveIntDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="ClaimResponse", profile="http://hl7.org/fhir/profiles/ClaimResponse", id="claimresponse")
public class ClaimResponse
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="identifier", path="ClaimResponse.identifier", description="The identity of the insurer", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The Response business identifier")
    private List<IdentifierDt> myIdentifier;
    @Child(name="request", order=1, min=0, max=1, summary=false, modifier=false, type={Claim.class})
    @Description(shortDefinition="", formalDefinition="Original request resource referrence")
    private ResourceReferenceDt myRequest;
    @Child(name="ruleset", type={CodingDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The version of the style of resource contents. This should be mapped to the allowable profiles for this and supporting resources.")
    private CodingDt myRuleset;
    @Child(name="originalRuleset", type={CodingDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The style (standard) and version of the original material which was converted into this resource.")
    private CodingDt myOriginalRuleset;
    @Child(name="created", type={DateTimeDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The date when the enclosed suite of services were performed or completed")
    private DateTimeDt myCreated;
    @Child(name="organization", order=5, min=0, max=1, summary=false, modifier=false, type={Organization.class})
    @Description(shortDefinition="", formalDefinition="The Insurer who produced this adjudicated response.")
    private ResourceReferenceDt myOrganization;
    @Child(name="requestProvider", order=6, min=0, max=1, summary=false, modifier=false, type={Practitioner.class})
    @Description(shortDefinition="", formalDefinition="The practitioner who is responsible for the services rendered to the patient.")
    private ResourceReferenceDt myRequestProvider;
    @Child(name="requestOrganization", order=7, min=0, max=1, summary=false, modifier=false, type={Organization.class})
    @Description(shortDefinition="", formalDefinition="The organization which is responsible for the services rendered to the patient.")
    private ResourceReferenceDt myRequestOrganization;
    @Child(name="outcome", type={CodeDt.class}, order=8, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Transaction status: error, complete")
    private BoundCodeDt<RemittanceOutcomeEnum> myOutcome;
    @Child(name="disposition", type={StringDt.class}, order=9, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="A description of the status of the adjudication.")
    private StringDt myDisposition;
    @Child(name="payeeType", type={CodingDt.class}, order=10, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Party to be reimbursed: Subscriber, provider, other.")
    private CodingDt myPayeeType;
    @Child(name="item", order=11, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The first tier service adjudications for submitted services.")
    private List<Item> myItem;
    @Child(name="addItem", order=12, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The first tier service adjudications for payor added services.")
    private List<AddItem> myAddItem;
    @Child(name="error", order=13, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Mutually exclusive with Services Provided (Item).")
    private List<Error> myError;
    @Child(name="totalCost", type={MoneyDt.class}, order=14, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The total cost of the services reported.")
    private MoneyDt myTotalCost;
    @Child(name="unallocDeductable", type={MoneyDt.class}, order=15, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The amount of deductible applied which was not allocated to any particular service line.")
    private MoneyDt myUnallocDeductable;
    @Child(name="totalBenefit", type={MoneyDt.class}, order=16, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Total amount of benefit payable (Equal to sum of the Benefit amounts from all detail lines and additions less the Unallocated Deductible)")
    private MoneyDt myTotalBenefit;
    @Child(name="paymentAdjustment", type={MoneyDt.class}, order=17, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Adjustment to the payment of this transaction which is not related to adjudication of this transaction.")
    private MoneyDt myPaymentAdjustment;
    @Child(name="paymentAdjustmentReason", type={CodingDt.class}, order=18, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Reason for the payment adjustment.")
    private CodingDt myPaymentAdjustmentReason;
    @Child(name="paymentDate", type={DateDt.class}, order=19, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Estimated payment data")
    private DateDt myPaymentDate;
    @Child(name="paymentAmount", type={MoneyDt.class}, order=20, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Payable less any payment adjustment.")
    private MoneyDt myPaymentAmount;
    @Child(name="paymentRef", type={IdentifierDt.class}, order=21, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Payment identifier")
    private IdentifierDt myPaymentRef;
    @Child(name="reserved", type={CodingDt.class}, order=22, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Status of funds reservation (For provider, for Patient, None).")
    private CodingDt myReserved;
    @Child(name="form", type={CodingDt.class}, order=23, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The form to be used for printing the content.")
    private CodingDt myForm;
    @Child(name="note", order=24, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Note text")
    private List<Note> myNote;
    @Child(name="coverage", order=25, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Financial instrument by which payment information for health care")
    private List<Coverage> myCoverage;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myRequest, this.myRuleset, this.myOriginalRuleset, this.myCreated, this.myOrganization, this.myRequestProvider, this.myRequestOrganization, this.myOutcome, this.myDisposition, this.myPayeeType, this.myItem, this.myAddItem, this.myError, this.myTotalCost, this.myUnallocDeductable, this.myTotalBenefit, this.myPaymentAdjustment, this.myPaymentAdjustmentReason, this.myPaymentDate, this.myPaymentAmount, this.myPaymentRef, this.myReserved, this.myForm, this.myNote, this.myCoverage});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myRequest, this.myRuleset, this.myOriginalRuleset, this.myCreated, this.myOrganization, this.myRequestProvider, this.myRequestOrganization, this.myOutcome, this.myDisposition, this.myPayeeType, this.myItem, this.myAddItem, this.myError, this.myTotalCost, this.myUnallocDeductable, this.myTotalBenefit, this.myPaymentAdjustment, this.myPaymentAdjustmentReason, this.myPaymentDate, this.myPaymentAmount, this.myPaymentRef, this.myReserved, this.myForm, this.myNote, this.myCoverage});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public ClaimResponse setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public ClaimResponse addIdentifier(IdentifierDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getIdentifier().add(theValue);
        return this;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public ResourceReferenceDt getRequest() {
        if (this.myRequest == null) {
            this.myRequest = new ResourceReferenceDt();
        }
        return this.myRequest;
    }

    public ClaimResponse setRequest(ResourceReferenceDt theValue) {
        this.myRequest = theValue;
        return this;
    }

    public CodingDt getRuleset() {
        if (this.myRuleset == null) {
            this.myRuleset = new CodingDt();
        }
        return this.myRuleset;
    }

    public ClaimResponse setRuleset(CodingDt theValue) {
        this.myRuleset = theValue;
        return this;
    }

    public CodingDt getOriginalRuleset() {
        if (this.myOriginalRuleset == null) {
            this.myOriginalRuleset = new CodingDt();
        }
        return this.myOriginalRuleset;
    }

    public ClaimResponse setOriginalRuleset(CodingDt theValue) {
        this.myOriginalRuleset = theValue;
        return this;
    }

    public DateTimeDt getCreatedElement() {
        if (this.myCreated == null) {
            this.myCreated = new DateTimeDt();
        }
        return this.myCreated;
    }

    public Date getCreated() {
        return (Date)this.getCreatedElement().getValue();
    }

    public ClaimResponse setCreated(DateTimeDt theValue) {
        this.myCreated = theValue;
        return this;
    }

    public ClaimResponse setCreated(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myCreated = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public ClaimResponse setCreatedWithSecondsPrecision(Date theDate) {
        this.myCreated = new DateTimeDt(theDate);
        return this;
    }

    public ResourceReferenceDt getOrganization() {
        if (this.myOrganization == null) {
            this.myOrganization = new ResourceReferenceDt();
        }
        return this.myOrganization;
    }

    public ClaimResponse setOrganization(ResourceReferenceDt theValue) {
        this.myOrganization = theValue;
        return this;
    }

    public ResourceReferenceDt getRequestProvider() {
        if (this.myRequestProvider == null) {
            this.myRequestProvider = new ResourceReferenceDt();
        }
        return this.myRequestProvider;
    }

    public ClaimResponse setRequestProvider(ResourceReferenceDt theValue) {
        this.myRequestProvider = theValue;
        return this;
    }

    public ResourceReferenceDt getRequestOrganization() {
        if (this.myRequestOrganization == null) {
            this.myRequestOrganization = new ResourceReferenceDt();
        }
        return this.myRequestOrganization;
    }

    public ClaimResponse setRequestOrganization(ResourceReferenceDt theValue) {
        this.myRequestOrganization = theValue;
        return this;
    }

    public BoundCodeDt<RemittanceOutcomeEnum> getOutcomeElement() {
        if (this.myOutcome == null) {
            this.myOutcome = new BoundCodeDt(RemittanceOutcomeEnum.VALUESET_BINDER);
        }
        return this.myOutcome;
    }

    public String getOutcome() {
        return (String)this.getOutcomeElement().getValue();
    }

    public ClaimResponse setOutcome(BoundCodeDt<RemittanceOutcomeEnum> theValue) {
        this.myOutcome = theValue;
        return this;
    }

    public ClaimResponse setOutcome(RemittanceOutcomeEnum theValue) {
        this.getOutcomeElement().setValueAsEnum((Enum)theValue);
        return this;
    }

    public StringDt getDispositionElement() {
        if (this.myDisposition == null) {
            this.myDisposition = new StringDt();
        }
        return this.myDisposition;
    }

    public String getDisposition() {
        return (String)this.getDispositionElement().getValue();
    }

    public ClaimResponse setDisposition(StringDt theValue) {
        this.myDisposition = theValue;
        return this;
    }

    public ClaimResponse setDisposition(String theString) {
        this.myDisposition = new StringDt(theString);
        return this;
    }

    public CodingDt getPayeeType() {
        if (this.myPayeeType == null) {
            this.myPayeeType = new CodingDt();
        }
        return this.myPayeeType;
    }

    public ClaimResponse setPayeeType(CodingDt theValue) {
        this.myPayeeType = theValue;
        return this;
    }

    public List<Item> getItem() {
        if (this.myItem == null) {
            this.myItem = new ArrayList<Item>();
        }
        return this.myItem;
    }

    public ClaimResponse setItem(List<Item> theValue) {
        this.myItem = theValue;
        return this;
    }

    public Item addItem() {
        Item newType = new Item();
        this.getItem().add(newType);
        return newType;
    }

    public ClaimResponse addItem(Item theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getItem().add(theValue);
        return this;
    }

    public Item getItemFirstRep() {
        if (this.getItem().isEmpty()) {
            return this.addItem();
        }
        return this.getItem().get(0);
    }

    public List<AddItem> getAddItem() {
        if (this.myAddItem == null) {
            this.myAddItem = new ArrayList<AddItem>();
        }
        return this.myAddItem;
    }

    public ClaimResponse setAddItem(List<AddItem> theValue) {
        this.myAddItem = theValue;
        return this;
    }

    public AddItem addAddItem() {
        AddItem newType = new AddItem();
        this.getAddItem().add(newType);
        return newType;
    }

    public ClaimResponse addAddItem(AddItem theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getAddItem().add(theValue);
        return this;
    }

    public AddItem getAddItemFirstRep() {
        if (this.getAddItem().isEmpty()) {
            return this.addAddItem();
        }
        return this.getAddItem().get(0);
    }

    public List<Error> getError() {
        if (this.myError == null) {
            this.myError = new ArrayList<Error>();
        }
        return this.myError;
    }

    public ClaimResponse setError(List<Error> theValue) {
        this.myError = theValue;
        return this;
    }

    public Error addError() {
        Error newType = new Error();
        this.getError().add(newType);
        return newType;
    }

    public ClaimResponse addError(Error theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getError().add(theValue);
        return this;
    }

    public Error getErrorFirstRep() {
        if (this.getError().isEmpty()) {
            return this.addError();
        }
        return this.getError().get(0);
    }

    public MoneyDt getTotalCost() {
        if (this.myTotalCost == null) {
            this.myTotalCost = new MoneyDt();
        }
        return this.myTotalCost;
    }

    public ClaimResponse setTotalCost(MoneyDt theValue) {
        this.myTotalCost = theValue;
        return this;
    }

    public MoneyDt getUnallocDeductable() {
        if (this.myUnallocDeductable == null) {
            this.myUnallocDeductable = new MoneyDt();
        }
        return this.myUnallocDeductable;
    }

    public ClaimResponse setUnallocDeductable(MoneyDt theValue) {
        this.myUnallocDeductable = theValue;
        return this;
    }

    public MoneyDt getTotalBenefit() {
        if (this.myTotalBenefit == null) {
            this.myTotalBenefit = new MoneyDt();
        }
        return this.myTotalBenefit;
    }

    public ClaimResponse setTotalBenefit(MoneyDt theValue) {
        this.myTotalBenefit = theValue;
        return this;
    }

    public MoneyDt getPaymentAdjustment() {
        if (this.myPaymentAdjustment == null) {
            this.myPaymentAdjustment = new MoneyDt();
        }
        return this.myPaymentAdjustment;
    }

    public ClaimResponse setPaymentAdjustment(MoneyDt theValue) {
        this.myPaymentAdjustment = theValue;
        return this;
    }

    public CodingDt getPaymentAdjustmentReason() {
        if (this.myPaymentAdjustmentReason == null) {
            this.myPaymentAdjustmentReason = new CodingDt();
        }
        return this.myPaymentAdjustmentReason;
    }

    public ClaimResponse setPaymentAdjustmentReason(CodingDt theValue) {
        this.myPaymentAdjustmentReason = theValue;
        return this;
    }

    public DateDt getPaymentDateElement() {
        if (this.myPaymentDate == null) {
            this.myPaymentDate = new DateDt();
        }
        return this.myPaymentDate;
    }

    public Date getPaymentDate() {
        return (Date)this.getPaymentDateElement().getValue();
    }

    public ClaimResponse setPaymentDate(DateDt theValue) {
        this.myPaymentDate = theValue;
        return this;
    }

    public ClaimResponse setPaymentDate(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myPaymentDate = new DateDt(theDate, thePrecision);
        return this;
    }

    public ClaimResponse setPaymentDateWithDayPrecision(Date theDate) {
        this.myPaymentDate = new DateDt(theDate);
        return this;
    }

    public MoneyDt getPaymentAmount() {
        if (this.myPaymentAmount == null) {
            this.myPaymentAmount = new MoneyDt();
        }
        return this.myPaymentAmount;
    }

    public ClaimResponse setPaymentAmount(MoneyDt theValue) {
        this.myPaymentAmount = theValue;
        return this;
    }

    public IdentifierDt getPaymentRef() {
        if (this.myPaymentRef == null) {
            this.myPaymentRef = new IdentifierDt();
        }
        return this.myPaymentRef;
    }

    public ClaimResponse setPaymentRef(IdentifierDt theValue) {
        this.myPaymentRef = theValue;
        return this;
    }

    public CodingDt getReserved() {
        if (this.myReserved == null) {
            this.myReserved = new CodingDt();
        }
        return this.myReserved;
    }

    public ClaimResponse setReserved(CodingDt theValue) {
        this.myReserved = theValue;
        return this;
    }

    public CodingDt getForm() {
        if (this.myForm == null) {
            this.myForm = new CodingDt();
        }
        return this.myForm;
    }

    public ClaimResponse setForm(CodingDt theValue) {
        this.myForm = theValue;
        return this;
    }

    public List<Note> getNote() {
        if (this.myNote == null) {
            this.myNote = new ArrayList<Note>();
        }
        return this.myNote;
    }

    public ClaimResponse setNote(List<Note> theValue) {
        this.myNote = theValue;
        return this;
    }

    public Note addNote() {
        Note newType = new Note();
        this.getNote().add(newType);
        return newType;
    }

    public ClaimResponse addNote(Note theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getNote().add(theValue);
        return this;
    }

    public Note getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            return this.addNote();
        }
        return this.getNote().get(0);
    }

    public List<Coverage> getCoverage() {
        if (this.myCoverage == null) {
            this.myCoverage = new ArrayList<Coverage>();
        }
        return this.myCoverage;
    }

    public ClaimResponse setCoverage(List<Coverage> theValue) {
        this.myCoverage = theValue;
        return this;
    }

    public Coverage addCoverage() {
        Coverage newType = new Coverage();
        this.getCoverage().add(newType);
        return newType;
    }

    public ClaimResponse addCoverage(Coverage theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getCoverage().add(theValue);
        return this;
    }

    public Coverage getCoverageFirstRep() {
        if (this.getCoverage().isEmpty()) {
            return this.addCoverage();
        }
        return this.getCoverage().get(0);
    }

    public String getResourceName() {
        return "ClaimResponse";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }

    @Block
    public static class Coverage
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="sequence", type={PositiveIntDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A service line item.")
        private PositiveIntDt mySequence;
        @Child(name="focal", type={BooleanDt.class}, order=1, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The instance number of the Coverage which is the focus for adjudication. The Coverage against which the claim is to be adjudicated.")
        private BooleanDt myFocal;
        @Child(name="coverage", order=2, min=1, max=1, summary=false, modifier=false, type={ca.uhn.fhir.model.dstu2.resource.Coverage.class})
        @Description(shortDefinition="", formalDefinition="Reference to the program or plan identification, underwriter or payor.")
        private ResourceReferenceDt myCoverage;
        @Child(name="businessArrangement", type={StringDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The contract number of a business agreement which describes the terms and conditions.")
        private StringDt myBusinessArrangement;
        @Child(name="relationship", type={CodingDt.class}, order=4, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The relationship of the patient to the subscriber")
        private CodingDt myRelationship;
        @Child(name="preAuthRef", type={StringDt.class}, order=5, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A list of references from the Insurer to which these services pertain.")
        private List<StringDt> myPreAuthRef;
        @Child(name="claimResponse", order=6, min=0, max=1, summary=false, modifier=false, type={ClaimResponse.class})
        @Description(shortDefinition="", formalDefinition="The Coverages adjudication details.")
        private ResourceReferenceDt myClaimResponse;
        @Child(name="originalRuleset", type={CodingDt.class}, order=7, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The style (standard) and version of the original material which was converted into this resource.")
        private CodingDt myOriginalRuleset;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.mySequence, this.myFocal, this.myCoverage, this.myBusinessArrangement, this.myRelationship, this.myPreAuthRef, this.myClaimResponse, this.myOriginalRuleset});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.mySequence, this.myFocal, this.myCoverage, this.myBusinessArrangement, this.myRelationship, this.myPreAuthRef, this.myClaimResponse, this.myOriginalRuleset});
        }

        public PositiveIntDt getSequenceElement() {
            if (this.mySequence == null) {
                this.mySequence = new PositiveIntDt();
            }
            return this.mySequence;
        }

        public Integer getSequence() {
            return (Integer)this.getSequenceElement().getValue();
        }

        public Coverage setSequence(PositiveIntDt theValue) {
            this.mySequence = theValue;
            return this;
        }

        public Coverage setSequence(int theInteger) {
            this.mySequence = new PositiveIntDt(theInteger);
            return this;
        }

        public BooleanDt getFocalElement() {
            if (this.myFocal == null) {
                this.myFocal = new BooleanDt();
            }
            return this.myFocal;
        }

        public Boolean getFocal() {
            return (Boolean)this.getFocalElement().getValue();
        }

        public Coverage setFocal(BooleanDt theValue) {
            this.myFocal = theValue;
            return this;
        }

        public Coverage setFocal(boolean theBoolean) {
            this.myFocal = new BooleanDt(theBoolean);
            return this;
        }

        public ResourceReferenceDt getCoverage() {
            if (this.myCoverage == null) {
                this.myCoverage = new ResourceReferenceDt();
            }
            return this.myCoverage;
        }

        public Coverage setCoverage(ResourceReferenceDt theValue) {
            this.myCoverage = theValue;
            return this;
        }

        public StringDt getBusinessArrangementElement() {
            if (this.myBusinessArrangement == null) {
                this.myBusinessArrangement = new StringDt();
            }
            return this.myBusinessArrangement;
        }

        public String getBusinessArrangement() {
            return (String)this.getBusinessArrangementElement().getValue();
        }

        public Coverage setBusinessArrangement(StringDt theValue) {
            this.myBusinessArrangement = theValue;
            return this;
        }

        public Coverage setBusinessArrangement(String theString) {
            this.myBusinessArrangement = new StringDt(theString);
            return this;
        }

        public CodingDt getRelationship() {
            if (this.myRelationship == null) {
                this.myRelationship = new CodingDt();
            }
            return this.myRelationship;
        }

        public Coverage setRelationship(CodingDt theValue) {
            this.myRelationship = theValue;
            return this;
        }

        public List<StringDt> getPreAuthRef() {
            if (this.myPreAuthRef == null) {
                this.myPreAuthRef = new ArrayList<StringDt>();
            }
            return this.myPreAuthRef;
        }

        public Coverage setPreAuthRef(List<StringDt> theValue) {
            this.myPreAuthRef = theValue;
            return this;
        }

        public StringDt addPreAuthRef() {
            StringDt newType = new StringDt();
            this.getPreAuthRef().add(newType);
            return newType;
        }

        public Coverage addPreAuthRef(StringDt theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getPreAuthRef().add(theValue);
            return this;
        }

        public StringDt getPreAuthRefFirstRep() {
            if (this.getPreAuthRef().isEmpty()) {
                return this.addPreAuthRef();
            }
            return this.getPreAuthRef().get(0);
        }

        public Coverage addPreAuthRef(String theString) {
            if (this.myPreAuthRef == null) {
                this.myPreAuthRef = new ArrayList<StringDt>();
            }
            this.myPreAuthRef.add(new StringDt(theString));
            return this;
        }

        public ResourceReferenceDt getClaimResponse() {
            if (this.myClaimResponse == null) {
                this.myClaimResponse = new ResourceReferenceDt();
            }
            return this.myClaimResponse;
        }

        public Coverage setClaimResponse(ResourceReferenceDt theValue) {
            this.myClaimResponse = theValue;
            return this;
        }

        public CodingDt getOriginalRuleset() {
            if (this.myOriginalRuleset == null) {
                this.myOriginalRuleset = new CodingDt();
            }
            return this.myOriginalRuleset;
        }

        public Coverage setOriginalRuleset(CodingDt theValue) {
            this.myOriginalRuleset = theValue;
            return this;
        }
    }

    @Block
    public static class Note
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="number", type={PositiveIntDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="An integer associated with each note which may be referred to from each service line item.")
        private PositiveIntDt myNumber;
        @Child(name="type", type={CodingDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The note purpose: Print/Display.")
        private CodingDt myType;
        @Child(name="text", type={StringDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The note text.")
        private StringDt myText;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myNumber, this.myType, this.myText});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myNumber, this.myType, this.myText});
        }

        public PositiveIntDt getNumberElement() {
            if (this.myNumber == null) {
                this.myNumber = new PositiveIntDt();
            }
            return this.myNumber;
        }

        public Integer getNumber() {
            return (Integer)this.getNumberElement().getValue();
        }

        public Note setNumber(PositiveIntDt theValue) {
            this.myNumber = theValue;
            return this;
        }

        public Note setNumber(int theInteger) {
            this.myNumber = new PositiveIntDt(theInteger);
            return this;
        }

        public CodingDt getType() {
            if (this.myType == null) {
                this.myType = new CodingDt();
            }
            return this.myType;
        }

        public Note setType(CodingDt theValue) {
            this.myType = theValue;
            return this;
        }

        public StringDt getTextElement() {
            if (this.myText == null) {
                this.myText = new StringDt();
            }
            return this.myText;
        }

        public String getText() {
            return (String)this.getTextElement().getValue();
        }

        public Note setText(StringDt theValue) {
            this.myText = theValue;
            return this;
        }

        public Note setText(String theString) {
            this.myText = new StringDt(theString);
            return this;
        }
    }

    @Block
    public static class Error
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="sequenceLinkId", type={PositiveIntDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The sequence number of the line item submitted which contains the error. This value is omitted when the error is elsewhere.")
        private PositiveIntDt mySequenceLinkId;
        @Child(name="detailSequenceLinkId", type={PositiveIntDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The sequence number of the addition within the line item submitted which contains the error. This value is omitted when the error is not related to an Addition.")
        private PositiveIntDt myDetailSequenceLinkId;
        @Child(name="subdetailSequenceLinkId", type={PositiveIntDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The sequence number of the addition within the line item submitted which contains the error. This value is omitted when the error is not related to an Addition.")
        private PositiveIntDt mySubdetailSequenceLinkId;
        @Child(name="code", type={CodingDt.class}, order=3, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="An error code,froma specified code system, which details why the claim could not be adjudicated.")
        private CodingDt myCode;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.mySequenceLinkId, this.myDetailSequenceLinkId, this.mySubdetailSequenceLinkId, this.myCode});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.mySequenceLinkId, this.myDetailSequenceLinkId, this.mySubdetailSequenceLinkId, this.myCode});
        }

        public PositiveIntDt getSequenceLinkIdElement() {
            if (this.mySequenceLinkId == null) {
                this.mySequenceLinkId = new PositiveIntDt();
            }
            return this.mySequenceLinkId;
        }

        public Integer getSequenceLinkId() {
            return (Integer)this.getSequenceLinkIdElement().getValue();
        }

        public Error setSequenceLinkId(PositiveIntDt theValue) {
            this.mySequenceLinkId = theValue;
            return this;
        }

        public Error setSequenceLinkId(int theInteger) {
            this.mySequenceLinkId = new PositiveIntDt(theInteger);
            return this;
        }

        public PositiveIntDt getDetailSequenceLinkIdElement() {
            if (this.myDetailSequenceLinkId == null) {
                this.myDetailSequenceLinkId = new PositiveIntDt();
            }
            return this.myDetailSequenceLinkId;
        }

        public Integer getDetailSequenceLinkId() {
            return (Integer)this.getDetailSequenceLinkIdElement().getValue();
        }

        public Error setDetailSequenceLinkId(PositiveIntDt theValue) {
            this.myDetailSequenceLinkId = theValue;
            return this;
        }

        public Error setDetailSequenceLinkId(int theInteger) {
            this.myDetailSequenceLinkId = new PositiveIntDt(theInteger);
            return this;
        }

        public PositiveIntDt getSubdetailSequenceLinkIdElement() {
            if (this.mySubdetailSequenceLinkId == null) {
                this.mySubdetailSequenceLinkId = new PositiveIntDt();
            }
            return this.mySubdetailSequenceLinkId;
        }

        public Integer getSubdetailSequenceLinkId() {
            return (Integer)this.getSubdetailSequenceLinkIdElement().getValue();
        }

        public Error setSubdetailSequenceLinkId(PositiveIntDt theValue) {
            this.mySubdetailSequenceLinkId = theValue;
            return this;
        }

        public Error setSubdetailSequenceLinkId(int theInteger) {
            this.mySubdetailSequenceLinkId = new PositiveIntDt(theInteger);
            return this;
        }

        public CodingDt getCode() {
            if (this.myCode == null) {
                this.myCode = new CodingDt();
            }
            return this.myCode;
        }

        public Error setCode(CodingDt theValue) {
            this.myCode = theValue;
            return this;
        }
    }

    @Block
    public static class AddItemDetailAdjudication
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="code", type={CodingDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Code indicating: Co-Pay, deductible, eligible, benefit, tax, etc.")
        private CodingDt myCode;
        @Child(name="amount", type={MoneyDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Monetary amount associated with the code")
        private MoneyDt myAmount;
        @Child(name="value", type={DecimalDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A non-monetary value for example a percentage. Mutually exclusive to the amount element above.")
        private DecimalDt myValue;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myCode, this.myAmount, this.myValue});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myCode, this.myAmount, this.myValue});
        }

        public CodingDt getCode() {
            if (this.myCode == null) {
                this.myCode = new CodingDt();
            }
            return this.myCode;
        }

        public AddItemDetailAdjudication setCode(CodingDt theValue) {
            this.myCode = theValue;
            return this;
        }

        public MoneyDt getAmount() {
            if (this.myAmount == null) {
                this.myAmount = new MoneyDt();
            }
            return this.myAmount;
        }

        public AddItemDetailAdjudication setAmount(MoneyDt theValue) {
            this.myAmount = theValue;
            return this;
        }

        public DecimalDt getValueElement() {
            if (this.myValue == null) {
                this.myValue = new DecimalDt();
            }
            return this.myValue;
        }

        public BigDecimal getValue() {
            return (BigDecimal)this.getValueElement().getValue();
        }

        public AddItemDetailAdjudication setValue(DecimalDt theValue) {
            this.myValue = theValue;
            return this;
        }

        public AddItemDetailAdjudication setValue(long theValue) {
            this.myValue = new DecimalDt(theValue);
            return this;
        }

        public AddItemDetailAdjudication setValue(double theValue) {
            this.myValue = new DecimalDt(theValue);
            return this;
        }

        public AddItemDetailAdjudication setValue(BigDecimal theValue) {
            this.myValue = new DecimalDt(theValue);
            return this;
        }
    }

    @Block
    public static class AddItemDetail
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="service", type={CodingDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A code to indicate the Professional Service or Product supplied.")
        private CodingDt myService;
        @Child(name="fee", type={MoneyDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The fee charged for the professional service or product..")
        private MoneyDt myFee;
        @Child(name="adjudication", order=2, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The adjudications results.")
        private List<AddItemDetailAdjudication> myAdjudication;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myService, this.myFee, this.myAdjudication});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myService, this.myFee, this.myAdjudication});
        }

        public CodingDt getService() {
            if (this.myService == null) {
                this.myService = new CodingDt();
            }
            return this.myService;
        }

        public AddItemDetail setService(CodingDt theValue) {
            this.myService = theValue;
            return this;
        }

        public MoneyDt getFee() {
            if (this.myFee == null) {
                this.myFee = new MoneyDt();
            }
            return this.myFee;
        }

        public AddItemDetail setFee(MoneyDt theValue) {
            this.myFee = theValue;
            return this;
        }

        public List<AddItemDetailAdjudication> getAdjudication() {
            if (this.myAdjudication == null) {
                this.myAdjudication = new ArrayList<AddItemDetailAdjudication>();
            }
            return this.myAdjudication;
        }

        public AddItemDetail setAdjudication(List<AddItemDetailAdjudication> theValue) {
            this.myAdjudication = theValue;
            return this;
        }

        public AddItemDetailAdjudication addAdjudication() {
            AddItemDetailAdjudication newType = new AddItemDetailAdjudication();
            this.getAdjudication().add(newType);
            return newType;
        }

        public AddItemDetail addAdjudication(AddItemDetailAdjudication theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getAdjudication().add(theValue);
            return this;
        }

        public AddItemDetailAdjudication getAdjudicationFirstRep() {
            if (this.getAdjudication().isEmpty()) {
                return this.addAdjudication();
            }
            return this.getAdjudication().get(0);
        }
    }

    @Block
    public static class AddItemAdjudication
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="code", type={CodingDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Code indicating: Co-Pay, deductible, eligible, benefit, tax, etc.")
        private CodingDt myCode;
        @Child(name="amount", type={MoneyDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Monetary amount associated with the code")
        private MoneyDt myAmount;
        @Child(name="value", type={DecimalDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A non-monetary value for example a percentage. Mutually exclusive to the amount element above.")
        private DecimalDt myValue;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myCode, this.myAmount, this.myValue});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myCode, this.myAmount, this.myValue});
        }

        public CodingDt getCode() {
            if (this.myCode == null) {
                this.myCode = new CodingDt();
            }
            return this.myCode;
        }

        public AddItemAdjudication setCode(CodingDt theValue) {
            this.myCode = theValue;
            return this;
        }

        public MoneyDt getAmount() {
            if (this.myAmount == null) {
                this.myAmount = new MoneyDt();
            }
            return this.myAmount;
        }

        public AddItemAdjudication setAmount(MoneyDt theValue) {
            this.myAmount = theValue;
            return this;
        }

        public DecimalDt getValueElement() {
            if (this.myValue == null) {
                this.myValue = new DecimalDt();
            }
            return this.myValue;
        }

        public BigDecimal getValue() {
            return (BigDecimal)this.getValueElement().getValue();
        }

        public AddItemAdjudication setValue(DecimalDt theValue) {
            this.myValue = theValue;
            return this;
        }

        public AddItemAdjudication setValue(long theValue) {
            this.myValue = new DecimalDt(theValue);
            return this;
        }

        public AddItemAdjudication setValue(double theValue) {
            this.myValue = new DecimalDt(theValue);
            return this;
        }

        public AddItemAdjudication setValue(BigDecimal theValue) {
            this.myValue = new DecimalDt(theValue);
            return this;
        }
    }

    @Block
    public static class AddItem
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="sequenceLinkId", type={PositiveIntDt.class}, order=0, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="List of input service items which this service line is intended to replace.")
        private List<PositiveIntDt> mySequenceLinkId;
        @Child(name="service", type={CodingDt.class}, order=1, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A code to indicate the Professional Service or Product supplied.")
        private CodingDt myService;
        @Child(name="fee", type={MoneyDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The fee charged for the professional service or product..")
        private MoneyDt myFee;
        @Child(name="noteNumberLinkId", type={PositiveIntDt.class}, order=3, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A list of note references to the notes provided below.")
        private List<PositiveIntDt> myNoteNumberLinkId;
        @Child(name="adjudication", order=4, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The adjudications results.")
        private List<AddItemAdjudication> myAdjudication;
        @Child(name="detail", order=5, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The second tier service adjudications for payor added services.")
        private List<AddItemDetail> myDetail;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.mySequenceLinkId, this.myService, this.myFee, this.myNoteNumberLinkId, this.myAdjudication, this.myDetail});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.mySequenceLinkId, this.myService, this.myFee, this.myNoteNumberLinkId, this.myAdjudication, this.myDetail});
        }

        public List<PositiveIntDt> getSequenceLinkId() {
            if (this.mySequenceLinkId == null) {
                this.mySequenceLinkId = new ArrayList<PositiveIntDt>();
            }
            return this.mySequenceLinkId;
        }

        public AddItem setSequenceLinkId(List<PositiveIntDt> theValue) {
            this.mySequenceLinkId = theValue;
            return this;
        }

        public PositiveIntDt addSequenceLinkId() {
            PositiveIntDt newType = new PositiveIntDt();
            this.getSequenceLinkId().add(newType);
            return newType;
        }

        public AddItem addSequenceLinkId(PositiveIntDt theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getSequenceLinkId().add(theValue);
            return this;
        }

        public PositiveIntDt getSequenceLinkIdFirstRep() {
            if (this.getSequenceLinkId().isEmpty()) {
                return this.addSequenceLinkId();
            }
            return this.getSequenceLinkId().get(0);
        }

        public AddItem addSequenceLinkId(int theInteger) {
            if (this.mySequenceLinkId == null) {
                this.mySequenceLinkId = new ArrayList<PositiveIntDt>();
            }
            this.mySequenceLinkId.add(new PositiveIntDt(theInteger));
            return this;
        }

        public CodingDt getService() {
            if (this.myService == null) {
                this.myService = new CodingDt();
            }
            return this.myService;
        }

        public AddItem setService(CodingDt theValue) {
            this.myService = theValue;
            return this;
        }

        public MoneyDt getFee() {
            if (this.myFee == null) {
                this.myFee = new MoneyDt();
            }
            return this.myFee;
        }

        public AddItem setFee(MoneyDt theValue) {
            this.myFee = theValue;
            return this;
        }

        public List<PositiveIntDt> getNoteNumberLinkId() {
            if (this.myNoteNumberLinkId == null) {
                this.myNoteNumberLinkId = new ArrayList<PositiveIntDt>();
            }
            return this.myNoteNumberLinkId;
        }

        public AddItem setNoteNumberLinkId(List<PositiveIntDt> theValue) {
            this.myNoteNumberLinkId = theValue;
            return this;
        }

        public PositiveIntDt addNoteNumberLinkId() {
            PositiveIntDt newType = new PositiveIntDt();
            this.getNoteNumberLinkId().add(newType);
            return newType;
        }

        public AddItem addNoteNumberLinkId(PositiveIntDt theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getNoteNumberLinkId().add(theValue);
            return this;
        }

        public PositiveIntDt getNoteNumberLinkIdFirstRep() {
            if (this.getNoteNumberLinkId().isEmpty()) {
                return this.addNoteNumberLinkId();
            }
            return this.getNoteNumberLinkId().get(0);
        }

        public AddItem addNoteNumberLinkId(int theInteger) {
            if (this.myNoteNumberLinkId == null) {
                this.myNoteNumberLinkId = new ArrayList<PositiveIntDt>();
            }
            this.myNoteNumberLinkId.add(new PositiveIntDt(theInteger));
            return this;
        }

        public List<AddItemAdjudication> getAdjudication() {
            if (this.myAdjudication == null) {
                this.myAdjudication = new ArrayList<AddItemAdjudication>();
            }
            return this.myAdjudication;
        }

        public AddItem setAdjudication(List<AddItemAdjudication> theValue) {
            this.myAdjudication = theValue;
            return this;
        }

        public AddItemAdjudication addAdjudication() {
            AddItemAdjudication newType = new AddItemAdjudication();
            this.getAdjudication().add(newType);
            return newType;
        }

        public AddItem addAdjudication(AddItemAdjudication theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getAdjudication().add(theValue);
            return this;
        }

        public AddItemAdjudication getAdjudicationFirstRep() {
            if (this.getAdjudication().isEmpty()) {
                return this.addAdjudication();
            }
            return this.getAdjudication().get(0);
        }

        public List<AddItemDetail> getDetail() {
            if (this.myDetail == null) {
                this.myDetail = new ArrayList<AddItemDetail>();
            }
            return this.myDetail;
        }

        public AddItem setDetail(List<AddItemDetail> theValue) {
            this.myDetail = theValue;
            return this;
        }

        public AddItemDetail addDetail() {
            AddItemDetail newType = new AddItemDetail();
            this.getDetail().add(newType);
            return newType;
        }

        public AddItem addDetail(AddItemDetail theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getDetail().add(theValue);
            return this;
        }

        public AddItemDetail getDetailFirstRep() {
            if (this.getDetail().isEmpty()) {
                return this.addDetail();
            }
            return this.getDetail().get(0);
        }
    }

    @Block
    public static class ItemDetailSubDetailAdjudication
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="code", type={CodingDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Code indicating: Co-Pay, deductible, eligible, benefit, tax, etc.")
        private CodingDt myCode;
        @Child(name="amount", type={MoneyDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Monetary amount associated with the code.")
        private MoneyDt myAmount;
        @Child(name="value", type={DecimalDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A non-monetary value for example a percentage. Mutually exclusive to the amount element above.")
        private DecimalDt myValue;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myCode, this.myAmount, this.myValue});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myCode, this.myAmount, this.myValue});
        }

        public CodingDt getCode() {
            if (this.myCode == null) {
                this.myCode = new CodingDt();
            }
            return this.myCode;
        }

        public ItemDetailSubDetailAdjudication setCode(CodingDt theValue) {
            this.myCode = theValue;
            return this;
        }

        public MoneyDt getAmount() {
            if (this.myAmount == null) {
                this.myAmount = new MoneyDt();
            }
            return this.myAmount;
        }

        public ItemDetailSubDetailAdjudication setAmount(MoneyDt theValue) {
            this.myAmount = theValue;
            return this;
        }

        public DecimalDt getValueElement() {
            if (this.myValue == null) {
                this.myValue = new DecimalDt();
            }
            return this.myValue;
        }

        public BigDecimal getValue() {
            return (BigDecimal)this.getValueElement().getValue();
        }

        public ItemDetailSubDetailAdjudication setValue(DecimalDt theValue) {
            this.myValue = theValue;
            return this;
        }

        public ItemDetailSubDetailAdjudication setValue(long theValue) {
            this.myValue = new DecimalDt(theValue);
            return this;
        }

        public ItemDetailSubDetailAdjudication setValue(double theValue) {
            this.myValue = new DecimalDt(theValue);
            return this;
        }

        public ItemDetailSubDetailAdjudication setValue(BigDecimal theValue) {
            this.myValue = new DecimalDt(theValue);
            return this;
        }
    }

    @Block
    public static class ItemDetailSubDetail
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="sequenceLinkId", type={PositiveIntDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A service line number.")
        private PositiveIntDt mySequenceLinkId;
        @Child(name="adjudication", order=1, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The adjudications results.")
        private List<ItemDetailSubDetailAdjudication> myAdjudication;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.mySequenceLinkId, this.myAdjudication});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.mySequenceLinkId, this.myAdjudication});
        }

        public PositiveIntDt getSequenceLinkIdElement() {
            if (this.mySequenceLinkId == null) {
                this.mySequenceLinkId = new PositiveIntDt();
            }
            return this.mySequenceLinkId;
        }

        public Integer getSequenceLinkId() {
            return (Integer)this.getSequenceLinkIdElement().getValue();
        }

        public ItemDetailSubDetail setSequenceLinkId(PositiveIntDt theValue) {
            this.mySequenceLinkId = theValue;
            return this;
        }

        public ItemDetailSubDetail setSequenceLinkId(int theInteger) {
            this.mySequenceLinkId = new PositiveIntDt(theInteger);
            return this;
        }

        public List<ItemDetailSubDetailAdjudication> getAdjudication() {
            if (this.myAdjudication == null) {
                this.myAdjudication = new ArrayList<ItemDetailSubDetailAdjudication>();
            }
            return this.myAdjudication;
        }

        public ItemDetailSubDetail setAdjudication(List<ItemDetailSubDetailAdjudication> theValue) {
            this.myAdjudication = theValue;
            return this;
        }

        public ItemDetailSubDetailAdjudication addAdjudication() {
            ItemDetailSubDetailAdjudication newType = new ItemDetailSubDetailAdjudication();
            this.getAdjudication().add(newType);
            return newType;
        }

        public ItemDetailSubDetail addAdjudication(ItemDetailSubDetailAdjudication theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getAdjudication().add(theValue);
            return this;
        }

        public ItemDetailSubDetailAdjudication getAdjudicationFirstRep() {
            if (this.getAdjudication().isEmpty()) {
                return this.addAdjudication();
            }
            return this.getAdjudication().get(0);
        }
    }

    @Block
    public static class ItemDetailAdjudication
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="code", type={CodingDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Code indicating: Co-Pay, deductible, eligible, benefit, tax, etc.")
        private CodingDt myCode;
        @Child(name="amount", type={MoneyDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Monetary amount associated with the code.")
        private MoneyDt myAmount;
        @Child(name="value", type={DecimalDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A non-monetary value for example a percentage. Mutually exclusive to the amount element above.")
        private DecimalDt myValue;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myCode, this.myAmount, this.myValue});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myCode, this.myAmount, this.myValue});
        }

        public CodingDt getCode() {
            if (this.myCode == null) {
                this.myCode = new CodingDt();
            }
            return this.myCode;
        }

        public ItemDetailAdjudication setCode(CodingDt theValue) {
            this.myCode = theValue;
            return this;
        }

        public MoneyDt getAmount() {
            if (this.myAmount == null) {
                this.myAmount = new MoneyDt();
            }
            return this.myAmount;
        }

        public ItemDetailAdjudication setAmount(MoneyDt theValue) {
            this.myAmount = theValue;
            return this;
        }

        public DecimalDt getValueElement() {
            if (this.myValue == null) {
                this.myValue = new DecimalDt();
            }
            return this.myValue;
        }

        public BigDecimal getValue() {
            return (BigDecimal)this.getValueElement().getValue();
        }

        public ItemDetailAdjudication setValue(DecimalDt theValue) {
            this.myValue = theValue;
            return this;
        }

        public ItemDetailAdjudication setValue(long theValue) {
            this.myValue = new DecimalDt(theValue);
            return this;
        }

        public ItemDetailAdjudication setValue(double theValue) {
            this.myValue = new DecimalDt(theValue);
            return this;
        }

        public ItemDetailAdjudication setValue(BigDecimal theValue) {
            this.myValue = new DecimalDt(theValue);
            return this;
        }
    }

    @Block
    public static class ItemDetail
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="sequenceLinkId", type={PositiveIntDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A service line number.")
        private PositiveIntDt mySequenceLinkId;
        @Child(name="adjudication", order=1, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The adjudications results.")
        private List<ItemDetailAdjudication> myAdjudication;
        @Child(name="subDetail", order=2, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The third tier service adjudications for submitted services.")
        private List<ItemDetailSubDetail> mySubDetail;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.mySequenceLinkId, this.myAdjudication, this.mySubDetail});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.mySequenceLinkId, this.myAdjudication, this.mySubDetail});
        }

        public PositiveIntDt getSequenceLinkIdElement() {
            if (this.mySequenceLinkId == null) {
                this.mySequenceLinkId = new PositiveIntDt();
            }
            return this.mySequenceLinkId;
        }

        public Integer getSequenceLinkId() {
            return (Integer)this.getSequenceLinkIdElement().getValue();
        }

        public ItemDetail setSequenceLinkId(PositiveIntDt theValue) {
            this.mySequenceLinkId = theValue;
            return this;
        }

        public ItemDetail setSequenceLinkId(int theInteger) {
            this.mySequenceLinkId = new PositiveIntDt(theInteger);
            return this;
        }

        public List<ItemDetailAdjudication> getAdjudication() {
            if (this.myAdjudication == null) {
                this.myAdjudication = new ArrayList<ItemDetailAdjudication>();
            }
            return this.myAdjudication;
        }

        public ItemDetail setAdjudication(List<ItemDetailAdjudication> theValue) {
            this.myAdjudication = theValue;
            return this;
        }

        public ItemDetailAdjudication addAdjudication() {
            ItemDetailAdjudication newType = new ItemDetailAdjudication();
            this.getAdjudication().add(newType);
            return newType;
        }

        public ItemDetail addAdjudication(ItemDetailAdjudication theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getAdjudication().add(theValue);
            return this;
        }

        public ItemDetailAdjudication getAdjudicationFirstRep() {
            if (this.getAdjudication().isEmpty()) {
                return this.addAdjudication();
            }
            return this.getAdjudication().get(0);
        }

        public List<ItemDetailSubDetail> getSubDetail() {
            if (this.mySubDetail == null) {
                this.mySubDetail = new ArrayList<ItemDetailSubDetail>();
            }
            return this.mySubDetail;
        }

        public ItemDetail setSubDetail(List<ItemDetailSubDetail> theValue) {
            this.mySubDetail = theValue;
            return this;
        }

        public ItemDetailSubDetail addSubDetail() {
            ItemDetailSubDetail newType = new ItemDetailSubDetail();
            this.getSubDetail().add(newType);
            return newType;
        }

        public ItemDetail addSubDetail(ItemDetailSubDetail theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getSubDetail().add(theValue);
            return this;
        }

        public ItemDetailSubDetail getSubDetailFirstRep() {
            if (this.getSubDetail().isEmpty()) {
                return this.addSubDetail();
            }
            return this.getSubDetail().get(0);
        }
    }

    @Block
    public static class ItemAdjudication
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="code", type={CodingDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Code indicating: Co-Pay, deductible, eligible, benefit, tax, etc.")
        private CodingDt myCode;
        @Child(name="amount", type={MoneyDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Monetary amount associated with the code")
        private MoneyDt myAmount;
        @Child(name="value", type={DecimalDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A non-monetary value for example a percentage. Mutually exclusive to the amount element above.")
        private DecimalDt myValue;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myCode, this.myAmount, this.myValue});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myCode, this.myAmount, this.myValue});
        }

        public CodingDt getCode() {
            if (this.myCode == null) {
                this.myCode = new CodingDt();
            }
            return this.myCode;
        }

        public ItemAdjudication setCode(CodingDt theValue) {
            this.myCode = theValue;
            return this;
        }

        public MoneyDt getAmount() {
            if (this.myAmount == null) {
                this.myAmount = new MoneyDt();
            }
            return this.myAmount;
        }

        public ItemAdjudication setAmount(MoneyDt theValue) {
            this.myAmount = theValue;
            return this;
        }

        public DecimalDt getValueElement() {
            if (this.myValue == null) {
                this.myValue = new DecimalDt();
            }
            return this.myValue;
        }

        public BigDecimal getValue() {
            return (BigDecimal)this.getValueElement().getValue();
        }

        public ItemAdjudication setValue(DecimalDt theValue) {
            this.myValue = theValue;
            return this;
        }

        public ItemAdjudication setValue(long theValue) {
            this.myValue = new DecimalDt(theValue);
            return this;
        }

        public ItemAdjudication setValue(double theValue) {
            this.myValue = new DecimalDt(theValue);
            return this;
        }

        public ItemAdjudication setValue(BigDecimal theValue) {
            this.myValue = new DecimalDt(theValue);
            return this;
        }
    }

    @Block
    public static class Item
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="sequenceLinkId", type={PositiveIntDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A service line number.")
        private PositiveIntDt mySequenceLinkId;
        @Child(name="noteNumber", type={PositiveIntDt.class}, order=1, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A list of note references to the notes provided below.")
        private List<PositiveIntDt> myNoteNumber;
        @Child(name="adjudication", order=2, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The adjudications results.")
        private List<ItemAdjudication> myAdjudication;
        @Child(name="detail", order=3, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The second tier service adjudications for submitted services.")
        private List<ItemDetail> myDetail;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.mySequenceLinkId, this.myNoteNumber, this.myAdjudication, this.myDetail});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.mySequenceLinkId, this.myNoteNumber, this.myAdjudication, this.myDetail});
        }

        public PositiveIntDt getSequenceLinkIdElement() {
            if (this.mySequenceLinkId == null) {
                this.mySequenceLinkId = new PositiveIntDt();
            }
            return this.mySequenceLinkId;
        }

        public Integer getSequenceLinkId() {
            return (Integer)this.getSequenceLinkIdElement().getValue();
        }

        public Item setSequenceLinkId(PositiveIntDt theValue) {
            this.mySequenceLinkId = theValue;
            return this;
        }

        public Item setSequenceLinkId(int theInteger) {
            this.mySequenceLinkId = new PositiveIntDt(theInteger);
            return this;
        }

        public List<PositiveIntDt> getNoteNumber() {
            if (this.myNoteNumber == null) {
                this.myNoteNumber = new ArrayList<PositiveIntDt>();
            }
            return this.myNoteNumber;
        }

        public Item setNoteNumber(List<PositiveIntDt> theValue) {
            this.myNoteNumber = theValue;
            return this;
        }

        public PositiveIntDt addNoteNumber() {
            PositiveIntDt newType = new PositiveIntDt();
            this.getNoteNumber().add(newType);
            return newType;
        }

        public Item addNoteNumber(PositiveIntDt theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getNoteNumber().add(theValue);
            return this;
        }

        public PositiveIntDt getNoteNumberFirstRep() {
            if (this.getNoteNumber().isEmpty()) {
                return this.addNoteNumber();
            }
            return this.getNoteNumber().get(0);
        }

        public Item addNoteNumber(int theInteger) {
            if (this.myNoteNumber == null) {
                this.myNoteNumber = new ArrayList<PositiveIntDt>();
            }
            this.myNoteNumber.add(new PositiveIntDt(theInteger));
            return this;
        }

        public List<ItemAdjudication> getAdjudication() {
            if (this.myAdjudication == null) {
                this.myAdjudication = new ArrayList<ItemAdjudication>();
            }
            return this.myAdjudication;
        }

        public Item setAdjudication(List<ItemAdjudication> theValue) {
            this.myAdjudication = theValue;
            return this;
        }

        public ItemAdjudication addAdjudication() {
            ItemAdjudication newType = new ItemAdjudication();
            this.getAdjudication().add(newType);
            return newType;
        }

        public Item addAdjudication(ItemAdjudication theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getAdjudication().add(theValue);
            return this;
        }

        public ItemAdjudication getAdjudicationFirstRep() {
            if (this.getAdjudication().isEmpty()) {
                return this.addAdjudication();
            }
            return this.getAdjudication().get(0);
        }

        public List<ItemDetail> getDetail() {
            if (this.myDetail == null) {
                this.myDetail = new ArrayList<ItemDetail>();
            }
            return this.myDetail;
        }

        public Item setDetail(List<ItemDetail> theValue) {
            this.myDetail = theValue;
            return this;
        }

        public ItemDetail addDetail() {
            ItemDetail newType = new ItemDetail();
            this.getDetail().add(newType);
            return newType;
        }

        public Item addDetail(ItemDetail theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getDetail().add(theValue);
            return this;
        }

        public ItemDetail getDetailFirstRep() {
            if (this.getDetail().isEmpty()) {
                return this.addDetail();
            }
            return this.getDetail().get(0);
        }
    }
}

