/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.base.resource.BaseConformance;
import ca.uhn.fhir.model.dstu2.composite.BoundCodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.CodingDt;
import ca.uhn.fhir.model.dstu2.composite.ContactPointDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.OperationDefinition;
import ca.uhn.fhir.model.dstu2.resource.StructureDefinition;
import ca.uhn.fhir.model.dstu2.valueset.ConditionalDeleteStatusEnum;
import ca.uhn.fhir.model.dstu2.valueset.ConformanceEventModeEnum;
import ca.uhn.fhir.model.dstu2.valueset.ConformanceResourceStatusEnum;
import ca.uhn.fhir.model.dstu2.valueset.ConformanceStatementKindEnum;
import ca.uhn.fhir.model.dstu2.valueset.DocumentModeEnum;
import ca.uhn.fhir.model.dstu2.valueset.MessageSignificanceCategoryEnum;
import ca.uhn.fhir.model.dstu2.valueset.ResourceTypeEnum;
import ca.uhn.fhir.model.dstu2.valueset.ResourceVersionPolicyEnum;
import ca.uhn.fhir.model.dstu2.valueset.RestfulConformanceModeEnum;
import ca.uhn.fhir.model.dstu2.valueset.RestfulSecurityServiceEnum;
import ca.uhn.fhir.model.dstu2.valueset.SearchModifierCodeEnum;
import ca.uhn.fhir.model.dstu2.valueset.SearchParamTypeEnum;
import ca.uhn.fhir.model.dstu2.valueset.SystemRestfulInteractionEnum;
import ca.uhn.fhir.model.dstu2.valueset.TransactionModeEnum;
import ca.uhn.fhir.model.dstu2.valueset.TypeRestfulInteractionEnum;
import ca.uhn.fhir.model.dstu2.valueset.UnknownContentCodeEnum;
import ca.uhn.fhir.model.primitive.Base64BinaryDt;
import ca.uhn.fhir.model.primitive.BooleanDt;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.model.primitive.UnsignedIntDt;
import ca.uhn.fhir.model.primitive.UriDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="Conformance", profile="http://hl7.org/fhir/profiles/Conformance", id="conformance")
public class Conformance
extends BaseResource
implements BaseConformance {
    @SearchParamDefinition(name="url", path="Conformance.url", description="The uri that identifies the conformance statement", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="version", path="Conformance.version", description="The version identifier of the conformance statement", type="token")
    public static final String SP_VERSION = "version";
    public static final TokenClientParam VERSION = new TokenClientParam("version");
    @SearchParamDefinition(name="name", path="Conformance.name", description="Name of the conformance statement", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="publisher", path="Conformance.publisher", description="Name of the publisher of the conformance statement", type="string")
    public static final String SP_PUBLISHER = "publisher";
    public static final StringClientParam PUBLISHER = new StringClientParam("publisher");
    @SearchParamDefinition(name="description", path="Conformance.description", description="Text search in the description of the conformance statement", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="status", path="Conformance.status", description="The current status of the conformance statement", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="date", path="Conformance.date", description="The conformance statement publication date", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="software", path="Conformance.software.name", description="Part of a the name of a software application", type="string")
    public static final String SP_SOFTWARE = "software";
    public static final StringClientParam SOFTWARE = new StringClientParam("software");
    @SearchParamDefinition(name="fhirversion", path="Conformance.version", description="The version of FHIR", type="token")
    public static final String SP_FHIRVERSION = "fhirversion";
    public static final TokenClientParam FHIRVERSION = new TokenClientParam("fhirversion");
    @SearchParamDefinition(name="resource", path="Conformance.rest.resource.type", description="Name of a resource mentioned in a conformance statement", type="token")
    public static final String SP_RESOURCE = "resource";
    public static final TokenClientParam RESOURCE = new TokenClientParam("resource");
    @SearchParamDefinition(name="event", path="Conformance.messaging.event.code", description="Event code in a conformance statement", type="token")
    public static final String SP_EVENT = "event";
    public static final TokenClientParam EVENT = new TokenClientParam("event");
    @SearchParamDefinition(name="mode", path="Conformance.rest.mode", description="Mode - restful (server/client) or messaging (sender/receiver)", type="token")
    public static final String SP_MODE = "mode";
    public static final TokenClientParam MODE = new TokenClientParam("mode");
    @SearchParamDefinition(name="profile", path="Conformance.rest.resource.profile", description="A profile id invoked in a conformance statement", type="reference")
    public static final String SP_PROFILE = "profile";
    public static final ReferenceClientParam PROFILE = new ReferenceClientParam("profile");
    @SearchParamDefinition(name="format", path="Conformance.format", description="", type="token")
    public static final String SP_FORMAT = "format";
    public static final TokenClientParam FORMAT = new TokenClientParam("format");
    @SearchParamDefinition(name="security", path="Conformance.rest.security.service", description="", type="token")
    public static final String SP_SECURITY = "security";
    public static final TokenClientParam SECURITY = new TokenClientParam("security");
    @SearchParamDefinition(name="supported-profile", path="Conformance.profile", description="", type="reference")
    public static final String SP_SUPPORTED_PROFILE = "supported-profile";
    public static final ReferenceClientParam SUPPORTED_PROFILE = new ReferenceClientParam("supported-profile");
    public static final Include INCLUDE_PROFILE = new Include("Conformance:profile");
    public static final Include INCLUDE_SUPPORTED_PROFILE = new Include("Conformance:supported-profile");
    @Child(name="url", type={UriDt.class}, order=0, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="An absolute URL that is used to identify this conformance statement when it is referenced in a specification, model, design or an instance. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this conformance statement is (or will be) published")
    private UriDt myUrl;
    @Child(name="version", type={StringDt.class}, order=1, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The identifier that is used to identify this version of the conformance statement when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the profile author manually and the value should be a timestamp")
    private StringDt myVersion;
    @Child(name="name", type={StringDt.class}, order=2, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="A free text natural language name identifying the conformance statement")
    private StringDt myName;
    @Child(name="status", type={CodeDt.class}, order=3, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The status of this conformance statement")
    private BoundCodeDt<ConformanceResourceStatusEnum> myStatus;
    @Child(name="experimental", type={BooleanDt.class}, order=4, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="A flag to indicate that this conformance statement is authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage")
    private BooleanDt myExperimental;
    @Child(name="publisher", type={StringDt.class}, order=5, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The name of the individual or organization that published the conformance")
    private StringDt myPublisher;
    @Child(name="contact", order=6, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Contacts to assist a user in finding and communicating with the publisher")
    private List<Contact> myContact;
    @Child(name="date", type={DateTimeDt.class}, order=7, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The date  (and optionally time) when the conformance statement was published. The date must change when the business version changes, if it does, and it must change if the status code changes. In addition, it should change when the substantive content of the conformance statement changes")
    private DateTimeDt myDate;
    @Child(name="description", type={StringDt.class}, order=8, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="A free text natural language description of the conformance statement and its use. Typically, this is used when the conformance statement describes a desired rather than an actual solution, for example as a formal expression of requirements as part of an RFP")
    private StringDt myDescription;
    @Child(name="requirements", type={StringDt.class}, order=9, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Explains why this conformance statement is needed and why it's been constrained as it has")
    private StringDt myRequirements;
    @Child(name="copyright", type={StringDt.class}, order=10, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="A copyright statement relating to the conformance statement and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the details of the system described by the conformance statement")
    private StringDt myCopyright;
    @Child(name="kind", type={CodeDt.class}, order=11, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The way that this statement is intended to be used, to describe an actual running instance of software, a particular product (kind not instance of software) or a class of implementation (e.g. a desired purchase)")
    private BoundCodeDt<ConformanceStatementKindEnum> myKind;
    @Child(name="software", order=12, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Software that is covered by this conformance statement.  It is used when the conformance statement describes the capabilities of a particular software version, independent of an installation.")
    private Software mySoftware;
    @Child(name="implementation", order=13, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Identifies a specific implementation instance that is described by the conformance statement - i.e. a particular installation, rather than the capabilities of a software program")
    private Implementation myImplementation;
    @Child(name="fhirVersion", type={IdDt.class}, order=14, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The version of the FHIR specification on which this conformance statement is based")
    private IdDt myFhirVersion;
    @Child(name="acceptUnknown", type={CodeDt.class}, order=15, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="A code that indicates whether the application accepts unknown elements or extensions when reading resources")
    private BoundCodeDt<UnknownContentCodeEnum> myAcceptUnknown;
    @Child(name="format", type={CodeDt.class}, order=16, min=1, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="A list of the formats supported by this implementation using their content types")
    private List<CodeDt> myFormat;
    @Child(name="profile", order=17, min=0, max=-1, summary=false, modifier=false, type={StructureDefinition.class})
    @Description(shortDefinition="", formalDefinition="A list of profiles that represent different use cases supported by the system. For a server, \"supported by the system\" means the system hosts/produces a set of resources that are conformant to a particular profile, and allows clients that use its services to search using this profile and to find appropriate data. For a client, it means the system will search by this profile and process data according to the guidance implicit in the profile. See further discussion in [Using Profiles]{profiling.html#profile-uses}")
    private List<ResourceReferenceDt> myProfile;
    @Child(name="rest", order=18, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="A definition of the restful capabilities of the solution, if any")
    private List<Rest> myRest;
    @Child(name="messaging", order=19, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="A description of the messaging capabilities of the solution")
    private List<Messaging> myMessaging;
    @Child(name="document", order=20, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="A document definition")
    private List<Document> myDocument;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myUrl, this.myVersion, this.myName, this.myStatus, this.myExperimental, this.myPublisher, this.myContact, this.myDate, this.myDescription, this.myRequirements, this.myCopyright, this.myKind, this.mySoftware, this.myImplementation, this.myFhirVersion, this.myAcceptUnknown, this.myFormat, this.myProfile, this.myRest, this.myMessaging, this.myDocument});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myUrl, this.myVersion, this.myName, this.myStatus, this.myExperimental, this.myPublisher, this.myContact, this.myDate, this.myDescription, this.myRequirements, this.myCopyright, this.myKind, this.mySoftware, this.myImplementation, this.myFhirVersion, this.myAcceptUnknown, this.myFormat, this.myProfile, this.myRest, this.myMessaging, this.myDocument});
    }

    public UriDt getUrlElement() {
        if (this.myUrl == null) {
            this.myUrl = new UriDt();
        }
        return this.myUrl;
    }

    public String getUrl() {
        return (String)this.getUrlElement().getValue();
    }

    public Conformance setUrl(UriDt theValue) {
        this.myUrl = theValue;
        return this;
    }

    public Conformance setUrl(String theUri) {
        this.myUrl = new UriDt(theUri);
        return this;
    }

    public StringDt getVersionElement() {
        if (this.myVersion == null) {
            this.myVersion = new StringDt();
        }
        return this.myVersion;
    }

    public String getVersion() {
        return (String)this.getVersionElement().getValue();
    }

    public Conformance setVersion(StringDt theValue) {
        this.myVersion = theValue;
        return this;
    }

    public Conformance setVersion(String theString) {
        this.myVersion = new StringDt(theString);
        return this;
    }

    public StringDt getNameElement() {
        if (this.myName == null) {
            this.myName = new StringDt();
        }
        return this.myName;
    }

    public String getName() {
        return (String)this.getNameElement().getValue();
    }

    public Conformance setName(StringDt theValue) {
        this.myName = theValue;
        return this;
    }

    public Conformance setName(String theString) {
        this.myName = new StringDt(theString);
        return this;
    }

    public BoundCodeDt<ConformanceResourceStatusEnum> getStatusElement() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(ConformanceResourceStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public String getStatus() {
        return (String)this.getStatusElement().getValue();
    }

    public Conformance setStatus(BoundCodeDt<ConformanceResourceStatusEnum> theValue) {
        this.myStatus = theValue;
        return this;
    }

    public Conformance setStatus(ConformanceResourceStatusEnum theValue) {
        this.getStatusElement().setValueAsEnum((Enum)theValue);
        return this;
    }

    public BooleanDt getExperimentalElement() {
        if (this.myExperimental == null) {
            this.myExperimental = new BooleanDt();
        }
        return this.myExperimental;
    }

    public Boolean getExperimental() {
        return (Boolean)this.getExperimentalElement().getValue();
    }

    public Conformance setExperimental(BooleanDt theValue) {
        this.myExperimental = theValue;
        return this;
    }

    public Conformance setExperimental(boolean theBoolean) {
        this.myExperimental = new BooleanDt(theBoolean);
        return this;
    }

    public StringDt getPublisherElement() {
        if (this.myPublisher == null) {
            this.myPublisher = new StringDt();
        }
        return this.myPublisher;
    }

    public String getPublisher() {
        return (String)this.getPublisherElement().getValue();
    }

    public Conformance setPublisher(StringDt theValue) {
        this.myPublisher = theValue;
        return this;
    }

    public Conformance setPublisher(String theString) {
        this.myPublisher = new StringDt(theString);
        return this;
    }

    public List<Contact> getContact() {
        if (this.myContact == null) {
            this.myContact = new ArrayList<Contact>();
        }
        return this.myContact;
    }

    public Conformance setContact(List<Contact> theValue) {
        this.myContact = theValue;
        return this;
    }

    public Contact addContact() {
        Contact newType = new Contact();
        this.getContact().add(newType);
        return newType;
    }

    public Conformance addContact(Contact theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getContact().add(theValue);
        return this;
    }

    public Contact getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            return this.addContact();
        }
        return this.getContact().get(0);
    }

    public DateTimeDt getDateElement() {
        if (this.myDate == null) {
            this.myDate = new DateTimeDt();
        }
        return this.myDate;
    }

    public Date getDate() {
        return (Date)this.getDateElement().getValue();
    }

    public Conformance setDate(DateTimeDt theValue) {
        this.myDate = theValue;
        return this;
    }

    public Conformance setDate(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myDate = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public Conformance setDateWithSecondsPrecision(Date theDate) {
        this.myDate = new DateTimeDt(theDate);
        return this;
    }

    public StringDt getDescriptionElement() {
        if (this.myDescription == null) {
            this.myDescription = new StringDt();
        }
        return this.myDescription;
    }

    public String getDescription() {
        return (String)this.getDescriptionElement().getValue();
    }

    public Conformance setDescription(StringDt theValue) {
        this.myDescription = theValue;
        return this;
    }

    public Conformance setDescription(String theString) {
        this.myDescription = new StringDt(theString);
        return this;
    }

    public StringDt getRequirementsElement() {
        if (this.myRequirements == null) {
            this.myRequirements = new StringDt();
        }
        return this.myRequirements;
    }

    public String getRequirements() {
        return (String)this.getRequirementsElement().getValue();
    }

    public Conformance setRequirements(StringDt theValue) {
        this.myRequirements = theValue;
        return this;
    }

    public Conformance setRequirements(String theString) {
        this.myRequirements = new StringDt(theString);
        return this;
    }

    public StringDt getCopyrightElement() {
        if (this.myCopyright == null) {
            this.myCopyright = new StringDt();
        }
        return this.myCopyright;
    }

    public String getCopyright() {
        return (String)this.getCopyrightElement().getValue();
    }

    public Conformance setCopyright(StringDt theValue) {
        this.myCopyright = theValue;
        return this;
    }

    public Conformance setCopyright(String theString) {
        this.myCopyright = new StringDt(theString);
        return this;
    }

    public BoundCodeDt<ConformanceStatementKindEnum> getKindElement() {
        if (this.myKind == null) {
            this.myKind = new BoundCodeDt(ConformanceStatementKindEnum.VALUESET_BINDER);
        }
        return this.myKind;
    }

    public String getKind() {
        return (String)this.getKindElement().getValue();
    }

    public Conformance setKind(BoundCodeDt<ConformanceStatementKindEnum> theValue) {
        this.myKind = theValue;
        return this;
    }

    public Conformance setKind(ConformanceStatementKindEnum theValue) {
        this.getKindElement().setValueAsEnum((Enum)theValue);
        return this;
    }

    public Software getSoftware() {
        if (this.mySoftware == null) {
            this.mySoftware = new Software();
        }
        return this.mySoftware;
    }

    public Conformance setSoftware(Software theValue) {
        this.mySoftware = theValue;
        return this;
    }

    public Implementation getImplementation() {
        if (this.myImplementation == null) {
            this.myImplementation = new Implementation();
        }
        return this.myImplementation;
    }

    public Conformance setImplementation(Implementation theValue) {
        this.myImplementation = theValue;
        return this;
    }

    public IdDt getFhirVersionElement() {
        if (this.myFhirVersion == null) {
            this.myFhirVersion = new IdDt();
        }
        return this.myFhirVersion;
    }

    public String getFhirVersion() {
        return this.getFhirVersionElement().getValue();
    }

    public Conformance setFhirVersion(IdDt theValue) {
        this.myFhirVersion = theValue;
        return this;
    }

    public Conformance setFhirVersion(String theId) {
        this.myFhirVersion = new IdDt(theId);
        return this;
    }

    public BoundCodeDt<UnknownContentCodeEnum> getAcceptUnknownElement() {
        if (this.myAcceptUnknown == null) {
            this.myAcceptUnknown = new BoundCodeDt(UnknownContentCodeEnum.VALUESET_BINDER);
        }
        return this.myAcceptUnknown;
    }

    public String getAcceptUnknown() {
        return (String)this.getAcceptUnknownElement().getValue();
    }

    public Conformance setAcceptUnknown(BoundCodeDt<UnknownContentCodeEnum> theValue) {
        this.myAcceptUnknown = theValue;
        return this;
    }

    public Conformance setAcceptUnknown(UnknownContentCodeEnum theValue) {
        this.getAcceptUnknownElement().setValueAsEnum((Enum)theValue);
        return this;
    }

    public List<CodeDt> getFormat() {
        if (this.myFormat == null) {
            this.myFormat = new ArrayList<CodeDt>();
        }
        return this.myFormat;
    }

    public Conformance setFormat(List<CodeDt> theValue) {
        this.myFormat = theValue;
        return this;
    }

    public CodeDt addFormat() {
        CodeDt newType = new CodeDt();
        this.getFormat().add(newType);
        return newType;
    }

    public Conformance addFormat(CodeDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getFormat().add(theValue);
        return this;
    }

    public CodeDt getFormatFirstRep() {
        if (this.getFormat().isEmpty()) {
            return this.addFormat();
        }
        return this.getFormat().get(0);
    }

    public Conformance addFormat(String theCode) {
        if (this.myFormat == null) {
            this.myFormat = new ArrayList<CodeDt>();
        }
        this.myFormat.add(new CodeDt(theCode));
        return this;
    }

    public List<ResourceReferenceDt> getProfile() {
        if (this.myProfile == null) {
            this.myProfile = new ArrayList<ResourceReferenceDt>();
        }
        return this.myProfile;
    }

    public Conformance setProfile(List<ResourceReferenceDt> theValue) {
        this.myProfile = theValue;
        return this;
    }

    public ResourceReferenceDt addProfile() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getProfile().add(newType);
        return newType;
    }

    public List<Rest> getRest() {
        if (this.myRest == null) {
            this.myRest = new ArrayList<Rest>();
        }
        return this.myRest;
    }

    public Conformance setRest(List<Rest> theValue) {
        this.myRest = theValue;
        return this;
    }

    public Rest addRest() {
        Rest newType = new Rest();
        this.getRest().add(newType);
        return newType;
    }

    public Conformance addRest(Rest theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getRest().add(theValue);
        return this;
    }

    public Rest getRestFirstRep() {
        if (this.getRest().isEmpty()) {
            return this.addRest();
        }
        return this.getRest().get(0);
    }

    public List<Messaging> getMessaging() {
        if (this.myMessaging == null) {
            this.myMessaging = new ArrayList<Messaging>();
        }
        return this.myMessaging;
    }

    public Conformance setMessaging(List<Messaging> theValue) {
        this.myMessaging = theValue;
        return this;
    }

    public Messaging addMessaging() {
        Messaging newType = new Messaging();
        this.getMessaging().add(newType);
        return newType;
    }

    public Conformance addMessaging(Messaging theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getMessaging().add(theValue);
        return this;
    }

    public Messaging getMessagingFirstRep() {
        if (this.getMessaging().isEmpty()) {
            return this.addMessaging();
        }
        return this.getMessaging().get(0);
    }

    public List<Document> getDocument() {
        if (this.myDocument == null) {
            this.myDocument = new ArrayList<Document>();
        }
        return this.myDocument;
    }

    public Conformance setDocument(List<Document> theValue) {
        this.myDocument = theValue;
        return this;
    }

    public Document addDocument() {
        Document newType = new Document();
        this.getDocument().add(newType);
        return newType;
    }

    public Conformance addDocument(Document theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getDocument().add(theValue);
        return this;
    }

    public Document getDocumentFirstRep() {
        if (this.getDocument().isEmpty()) {
            return this.addDocument();
        }
        return this.getDocument().get(0);
    }

    public String getResourceName() {
        return "Conformance";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }

    @Block
    public static class Document
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="mode", type={CodeDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Mode of this document declaration - whether application is producer or consumer")
        private BoundCodeDt<DocumentModeEnum> myMode;
        @Child(name="documentation", type={StringDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A description of how the application supports or uses the specified document profile.  For example, when are documents created, what action is taken with consumed documents, etc.")
        private StringDt myDocumentation;
        @Child(name="profile", order=2, min=1, max=1, summary=false, modifier=false, type={StructureDefinition.class})
        @Description(shortDefinition="", formalDefinition="A constraint on a resource used in the document")
        private ResourceReferenceDt myProfile;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myMode, this.myDocumentation, this.myProfile});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myMode, this.myDocumentation, this.myProfile});
        }

        public BoundCodeDt<DocumentModeEnum> getModeElement() {
            if (this.myMode == null) {
                this.myMode = new BoundCodeDt(DocumentModeEnum.VALUESET_BINDER);
            }
            return this.myMode;
        }

        public String getMode() {
            return (String)this.getModeElement().getValue();
        }

        public Document setMode(BoundCodeDt<DocumentModeEnum> theValue) {
            this.myMode = theValue;
            return this;
        }

        public Document setMode(DocumentModeEnum theValue) {
            this.getModeElement().setValueAsEnum((Enum)theValue);
            return this;
        }

        public StringDt getDocumentationElement() {
            if (this.myDocumentation == null) {
                this.myDocumentation = new StringDt();
            }
            return this.myDocumentation;
        }

        public String getDocumentation() {
            return (String)this.getDocumentationElement().getValue();
        }

        public Document setDocumentation(StringDt theValue) {
            this.myDocumentation = theValue;
            return this;
        }

        public Document setDocumentation(String theString) {
            this.myDocumentation = new StringDt(theString);
            return this;
        }

        public ResourceReferenceDt getProfile() {
            if (this.myProfile == null) {
                this.myProfile = new ResourceReferenceDt();
            }
            return this.myProfile;
        }

        public Document setProfile(ResourceReferenceDt theValue) {
            this.myProfile = theValue;
            return this;
        }
    }

    @Block
    public static class MessagingEvent
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="code", type={CodingDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A coded identifier of a supported messaging event")
        private CodingDt myCode;
        @Child(name="category", type={CodeDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The impact of the content of the message")
        private BoundCodeDt<MessageSignificanceCategoryEnum> myCategory;
        @Child(name="mode", type={CodeDt.class}, order=2, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The mode of this event declaration - whether application is sender or receiver")
        private BoundCodeDt<ConformanceEventModeEnum> myMode;
        @Child(name="focus", type={CodeDt.class}, order=3, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A resource associated with the event.  This is the resource that defines the event.")
        private BoundCodeDt<ResourceTypeEnum> myFocus;
        @Child(name="request", order=4, min=1, max=1, summary=false, modifier=false, type={StructureDefinition.class})
        @Description(shortDefinition="", formalDefinition="Information about the request for this event")
        private ResourceReferenceDt myRequest;
        @Child(name="response", order=5, min=1, max=1, summary=false, modifier=false, type={StructureDefinition.class})
        @Description(shortDefinition="", formalDefinition="Information about the response for this event")
        private ResourceReferenceDt myResponse;
        @Child(name="documentation", type={StringDt.class}, order=6, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Guidance on how this event is handled, such as internal system trigger points, business rules, etc.")
        private StringDt myDocumentation;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myCode, this.myCategory, this.myMode, this.myFocus, this.myRequest, this.myResponse, this.myDocumentation});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myCode, this.myCategory, this.myMode, this.myFocus, this.myRequest, this.myResponse, this.myDocumentation});
        }

        public CodingDt getCode() {
            if (this.myCode == null) {
                this.myCode = new CodingDt();
            }
            return this.myCode;
        }

        public MessagingEvent setCode(CodingDt theValue) {
            this.myCode = theValue;
            return this;
        }

        public BoundCodeDt<MessageSignificanceCategoryEnum> getCategoryElement() {
            if (this.myCategory == null) {
                this.myCategory = new BoundCodeDt(MessageSignificanceCategoryEnum.VALUESET_BINDER);
            }
            return this.myCategory;
        }

        public String getCategory() {
            return (String)this.getCategoryElement().getValue();
        }

        public MessagingEvent setCategory(BoundCodeDt<MessageSignificanceCategoryEnum> theValue) {
            this.myCategory = theValue;
            return this;
        }

        public MessagingEvent setCategory(MessageSignificanceCategoryEnum theValue) {
            this.getCategoryElement().setValueAsEnum((Enum)theValue);
            return this;
        }

        public BoundCodeDt<ConformanceEventModeEnum> getModeElement() {
            if (this.myMode == null) {
                this.myMode = new BoundCodeDt(ConformanceEventModeEnum.VALUESET_BINDER);
            }
            return this.myMode;
        }

        public String getMode() {
            return (String)this.getModeElement().getValue();
        }

        public MessagingEvent setMode(BoundCodeDt<ConformanceEventModeEnum> theValue) {
            this.myMode = theValue;
            return this;
        }

        public MessagingEvent setMode(ConformanceEventModeEnum theValue) {
            this.getModeElement().setValueAsEnum((Enum)theValue);
            return this;
        }

        public BoundCodeDt<ResourceTypeEnum> getFocusElement() {
            if (this.myFocus == null) {
                this.myFocus = new BoundCodeDt(ResourceTypeEnum.VALUESET_BINDER);
            }
            return this.myFocus;
        }

        public String getFocus() {
            return (String)this.getFocusElement().getValue();
        }

        public MessagingEvent setFocus(BoundCodeDt<ResourceTypeEnum> theValue) {
            this.myFocus = theValue;
            return this;
        }

        public MessagingEvent setFocus(ResourceTypeEnum theValue) {
            this.getFocusElement().setValueAsEnum((Enum)theValue);
            return this;
        }

        public ResourceReferenceDt getRequest() {
            if (this.myRequest == null) {
                this.myRequest = new ResourceReferenceDt();
            }
            return this.myRequest;
        }

        public MessagingEvent setRequest(ResourceReferenceDt theValue) {
            this.myRequest = theValue;
            return this;
        }

        public ResourceReferenceDt getResponse() {
            if (this.myResponse == null) {
                this.myResponse = new ResourceReferenceDt();
            }
            return this.myResponse;
        }

        public MessagingEvent setResponse(ResourceReferenceDt theValue) {
            this.myResponse = theValue;
            return this;
        }

        public StringDt getDocumentationElement() {
            if (this.myDocumentation == null) {
                this.myDocumentation = new StringDt();
            }
            return this.myDocumentation;
        }

        public String getDocumentation() {
            return (String)this.getDocumentationElement().getValue();
        }

        public MessagingEvent setDocumentation(StringDt theValue) {
            this.myDocumentation = theValue;
            return this;
        }

        public MessagingEvent setDocumentation(String theString) {
            this.myDocumentation = new StringDt(theString);
            return this;
        }
    }

    @Block
    public static class MessagingEndpoint
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="protocol", type={CodingDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A list of the messaging transport protocol(s) identifiers, supported by this endpoint")
        private CodingDt myProtocol;
        @Child(name="address", type={UriDt.class}, order=1, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The network address of the end-point. For solutions that do not use network addresses for routing, it can be just an identifier")
        private UriDt myAddress;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myProtocol, this.myAddress});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myProtocol, this.myAddress});
        }

        public CodingDt getProtocol() {
            if (this.myProtocol == null) {
                this.myProtocol = new CodingDt();
            }
            return this.myProtocol;
        }

        public MessagingEndpoint setProtocol(CodingDt theValue) {
            this.myProtocol = theValue;
            return this;
        }

        public UriDt getAddressElement() {
            if (this.myAddress == null) {
                this.myAddress = new UriDt();
            }
            return this.myAddress;
        }

        public String getAddress() {
            return (String)this.getAddressElement().getValue();
        }

        public MessagingEndpoint setAddress(UriDt theValue) {
            this.myAddress = theValue;
            return this;
        }

        public MessagingEndpoint setAddress(String theUri) {
            this.myAddress = new UriDt(theUri);
            return this;
        }
    }

    @Block
    public static class Messaging
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="endpoint", order=0, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="An endpoint (network accessible address) to which messages and/or replies are to be sent.")
        private List<MessagingEndpoint> myEndpoint;
        @Child(name="reliableCache", type={UnsignedIntDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Length if the receiver's reliable messaging cache in minutes (if a receiver) or how long the cache length on the receiver should be (if a sender)")
        private UnsignedIntDt myReliableCache;
        @Child(name="documentation", type={StringDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Documentation about the system's messaging capabilities for this endpoint not otherwise documented by the conformance statement.  For example, process for becoming an authorized messaging exchange partner.")
        private StringDt myDocumentation;
        @Child(name="event", order=3, min=1, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A description of the solution's support for an event at this end-point.")
        private List<MessagingEvent> myEvent;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myEndpoint, this.myReliableCache, this.myDocumentation, this.myEvent});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myEndpoint, this.myReliableCache, this.myDocumentation, this.myEvent});
        }

        public List<MessagingEndpoint> getEndpoint() {
            if (this.myEndpoint == null) {
                this.myEndpoint = new ArrayList<MessagingEndpoint>();
            }
            return this.myEndpoint;
        }

        public Messaging setEndpoint(List<MessagingEndpoint> theValue) {
            this.myEndpoint = theValue;
            return this;
        }

        public MessagingEndpoint addEndpoint() {
            MessagingEndpoint newType = new MessagingEndpoint();
            this.getEndpoint().add(newType);
            return newType;
        }

        public Messaging addEndpoint(MessagingEndpoint theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getEndpoint().add(theValue);
            return this;
        }

        public MessagingEndpoint getEndpointFirstRep() {
            if (this.getEndpoint().isEmpty()) {
                return this.addEndpoint();
            }
            return this.getEndpoint().get(0);
        }

        public UnsignedIntDt getReliableCacheElement() {
            if (this.myReliableCache == null) {
                this.myReliableCache = new UnsignedIntDt();
            }
            return this.myReliableCache;
        }

        public Integer getReliableCache() {
            return (Integer)this.getReliableCacheElement().getValue();
        }

        public Messaging setReliableCache(UnsignedIntDt theValue) {
            this.myReliableCache = theValue;
            return this;
        }

        public Messaging setReliableCache(int theInteger) {
            this.myReliableCache = new UnsignedIntDt(theInteger);
            return this;
        }

        public StringDt getDocumentationElement() {
            if (this.myDocumentation == null) {
                this.myDocumentation = new StringDt();
            }
            return this.myDocumentation;
        }

        public String getDocumentation() {
            return (String)this.getDocumentationElement().getValue();
        }

        public Messaging setDocumentation(StringDt theValue) {
            this.myDocumentation = theValue;
            return this;
        }

        public Messaging setDocumentation(String theString) {
            this.myDocumentation = new StringDt(theString);
            return this;
        }

        public List<MessagingEvent> getEvent() {
            if (this.myEvent == null) {
                this.myEvent = new ArrayList<MessagingEvent>();
            }
            return this.myEvent;
        }

        public Messaging setEvent(List<MessagingEvent> theValue) {
            this.myEvent = theValue;
            return this;
        }

        public MessagingEvent addEvent() {
            MessagingEvent newType = new MessagingEvent();
            this.getEvent().add(newType);
            return newType;
        }

        public Messaging addEvent(MessagingEvent theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getEvent().add(theValue);
            return this;
        }

        public MessagingEvent getEventFirstRep() {
            if (this.getEvent().isEmpty()) {
                return this.addEvent();
            }
            return this.getEvent().get(0);
        }
    }

    @Block
    public static class RestOperation
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="name", type={StringDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The name of a query, which is used in the _query parameter when the query is called")
        private StringDt myName;
        @Child(name="definition", order=1, min=1, max=1, summary=false, modifier=false, type={OperationDefinition.class})
        @Description(shortDefinition="", formalDefinition="Where the formal definition can be found")
        private ResourceReferenceDt myDefinition;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myName, this.myDefinition});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myName, this.myDefinition});
        }

        public StringDt getNameElement() {
            if (this.myName == null) {
                this.myName = new StringDt();
            }
            return this.myName;
        }

        public String getName() {
            return (String)this.getNameElement().getValue();
        }

        public RestOperation setName(StringDt theValue) {
            this.myName = theValue;
            return this;
        }

        public RestOperation setName(String theString) {
            this.myName = new StringDt(theString);
            return this;
        }

        public ResourceReferenceDt getDefinition() {
            if (this.myDefinition == null) {
                this.myDefinition = new ResourceReferenceDt();
            }
            return this.myDefinition;
        }

        public RestOperation setDefinition(ResourceReferenceDt theValue) {
            this.myDefinition = theValue;
            return this;
        }
    }

    @Block
    public static class RestInteraction
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="code", type={CodeDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A coded identifier of the operation, supported by the system")
        private BoundCodeDt<SystemRestfulInteractionEnum> myCode;
        @Child(name="documentation", type={StringDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Guidance specific to the implementation of this operation, such as limitations on the kind of transactions allowed, or information about system wide search is implemented")
        private StringDt myDocumentation;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myCode, this.myDocumentation});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myCode, this.myDocumentation});
        }

        public BoundCodeDt<SystemRestfulInteractionEnum> getCodeElement() {
            if (this.myCode == null) {
                this.myCode = new BoundCodeDt(SystemRestfulInteractionEnum.VALUESET_BINDER);
            }
            return this.myCode;
        }

        public String getCode() {
            return (String)this.getCodeElement().getValue();
        }

        public RestInteraction setCode(BoundCodeDt<SystemRestfulInteractionEnum> theValue) {
            this.myCode = theValue;
            return this;
        }

        public RestInteraction setCode(SystemRestfulInteractionEnum theValue) {
            this.getCodeElement().setValueAsEnum((Enum)theValue);
            return this;
        }

        public StringDt getDocumentationElement() {
            if (this.myDocumentation == null) {
                this.myDocumentation = new StringDt();
            }
            return this.myDocumentation;
        }

        public String getDocumentation() {
            return (String)this.getDocumentationElement().getValue();
        }

        public RestInteraction setDocumentation(StringDt theValue) {
            this.myDocumentation = theValue;
            return this;
        }

        public RestInteraction setDocumentation(String theString) {
            this.myDocumentation = new StringDt(theString);
            return this;
        }
    }

    @Block
    public static class RestResourceSearchParam
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="name", type={StringDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The name of the search parameter used in the interface")
        private StringDt myName;
        @Child(name="definition", type={UriDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="An absolute URI that is a formal reference to where this parameter was first defined, so that a client can be confident of the meaning of the search parameter (a reference to [[[SearchParameter.url]]])")
        private UriDt myDefinition;
        @Child(name="type", type={CodeDt.class}, order=2, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The type of value a search parameter refers to, and how the content is interpreted")
        private BoundCodeDt<SearchParamTypeEnum> myType;
        @Child(name="documentation", type={StringDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="This allows documentation of any distinct behaviors about how the search parameter is used.  For example, text matching algorithms.")
        private StringDt myDocumentation;
        @Child(name="target", type={CodeDt.class}, order=4, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Types of resource (if a resource is referenced)")
        private List<BoundCodeDt<ResourceTypeEnum>> myTarget;
        @Child(name="modifier", type={CodeDt.class}, order=5, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A modifier supported for the search parameter")
        private List<BoundCodeDt<SearchModifierCodeEnum>> myModifier;
        @Child(name="chain", type={StringDt.class}, order=6, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Contains the names of any search parameters which may be chained to the containing search parameter. Chained parameters may be added to search parameters of type reference, and specify that resources will only be returned if they contain a reference to a resource which matches the chained parameter value. Values for this field should be drawn from Conformance.rest.resource.searchParam.name on the target resource type")
        private List<StringDt> myChain;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myName, this.myDefinition, this.myType, this.myDocumentation, this.myTarget, this.myModifier, this.myChain});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myName, this.myDefinition, this.myType, this.myDocumentation, this.myTarget, this.myModifier, this.myChain});
        }

        public StringDt getNameElement() {
            if (this.myName == null) {
                this.myName = new StringDt();
            }
            return this.myName;
        }

        public String getName() {
            return (String)this.getNameElement().getValue();
        }

        public RestResourceSearchParam setName(StringDt theValue) {
            this.myName = theValue;
            return this;
        }

        public RestResourceSearchParam setName(String theString) {
            this.myName = new StringDt(theString);
            return this;
        }

        public UriDt getDefinitionElement() {
            if (this.myDefinition == null) {
                this.myDefinition = new UriDt();
            }
            return this.myDefinition;
        }

        public String getDefinition() {
            return (String)this.getDefinitionElement().getValue();
        }

        public RestResourceSearchParam setDefinition(UriDt theValue) {
            this.myDefinition = theValue;
            return this;
        }

        public RestResourceSearchParam setDefinition(String theUri) {
            this.myDefinition = new UriDt(theUri);
            return this;
        }

        public BoundCodeDt<SearchParamTypeEnum> getTypeElement() {
            if (this.myType == null) {
                this.myType = new BoundCodeDt(SearchParamTypeEnum.VALUESET_BINDER);
            }
            return this.myType;
        }

        public String getType() {
            return (String)this.getTypeElement().getValue();
        }

        public RestResourceSearchParam setType(BoundCodeDt<SearchParamTypeEnum> theValue) {
            this.myType = theValue;
            return this;
        }

        public RestResourceSearchParam setType(SearchParamTypeEnum theValue) {
            this.getTypeElement().setValueAsEnum((Enum)theValue);
            return this;
        }

        public StringDt getDocumentationElement() {
            if (this.myDocumentation == null) {
                this.myDocumentation = new StringDt();
            }
            return this.myDocumentation;
        }

        public String getDocumentation() {
            return (String)this.getDocumentationElement().getValue();
        }

        public RestResourceSearchParam setDocumentation(StringDt theValue) {
            this.myDocumentation = theValue;
            return this;
        }

        public RestResourceSearchParam setDocumentation(String theString) {
            this.myDocumentation = new StringDt(theString);
            return this;
        }

        public List<BoundCodeDt<ResourceTypeEnum>> getTarget() {
            if (this.myTarget == null) {
                this.myTarget = new ArrayList<BoundCodeDt<ResourceTypeEnum>>();
            }
            return this.myTarget;
        }

        public RestResourceSearchParam setTarget(List<BoundCodeDt<ResourceTypeEnum>> theValue) {
            this.myTarget = theValue;
            return this;
        }

        public BoundCodeDt<ResourceTypeEnum> addTarget(ResourceTypeEnum theValue) {
            BoundCodeDt retVal = new BoundCodeDt(ResourceTypeEnum.VALUESET_BINDER, (Enum)theValue);
            this.getTarget().add((BoundCodeDt<ResourceTypeEnum>)retVal);
            return retVal;
        }

        public BoundCodeDt<ResourceTypeEnum> getTargetFirstRep() {
            if (this.getTarget().size() == 0) {
                this.addTarget();
            }
            return this.getTarget().get(0);
        }

        public BoundCodeDt<ResourceTypeEnum> addTarget() {
            BoundCodeDt retVal = new BoundCodeDt(ResourceTypeEnum.VALUESET_BINDER);
            this.getTarget().add((BoundCodeDt<ResourceTypeEnum>)retVal);
            return retVal;
        }

        public RestResourceSearchParam setTarget(ResourceTypeEnum theValue) {
            this.getTarget().clear();
            this.addTarget(theValue);
            return this;
        }

        public List<BoundCodeDt<SearchModifierCodeEnum>> getModifier() {
            if (this.myModifier == null) {
                this.myModifier = new ArrayList<BoundCodeDt<SearchModifierCodeEnum>>();
            }
            return this.myModifier;
        }

        public RestResourceSearchParam setModifier(List<BoundCodeDt<SearchModifierCodeEnum>> theValue) {
            this.myModifier = theValue;
            return this;
        }

        public BoundCodeDt<SearchModifierCodeEnum> addModifier(SearchModifierCodeEnum theValue) {
            BoundCodeDt retVal = new BoundCodeDt(SearchModifierCodeEnum.VALUESET_BINDER, (Enum)theValue);
            this.getModifier().add((BoundCodeDt<SearchModifierCodeEnum>)retVal);
            return retVal;
        }

        public BoundCodeDt<SearchModifierCodeEnum> getModifierFirstRep() {
            if (this.getModifier().size() == 0) {
                this.addModifier();
            }
            return this.getModifier().get(0);
        }

        public BoundCodeDt<SearchModifierCodeEnum> addModifier() {
            BoundCodeDt retVal = new BoundCodeDt(SearchModifierCodeEnum.VALUESET_BINDER);
            this.getModifier().add((BoundCodeDt<SearchModifierCodeEnum>)retVal);
            return retVal;
        }

        public RestResourceSearchParam setModifier(SearchModifierCodeEnum theValue) {
            this.getModifier().clear();
            this.addModifier(theValue);
            return this;
        }

        public List<StringDt> getChain() {
            if (this.myChain == null) {
                this.myChain = new ArrayList<StringDt>();
            }
            return this.myChain;
        }

        public RestResourceSearchParam setChain(List<StringDt> theValue) {
            this.myChain = theValue;
            return this;
        }

        public StringDt addChain() {
            StringDt newType = new StringDt();
            this.getChain().add(newType);
            return newType;
        }

        public RestResourceSearchParam addChain(StringDt theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getChain().add(theValue);
            return this;
        }

        public StringDt getChainFirstRep() {
            if (this.getChain().isEmpty()) {
                return this.addChain();
            }
            return this.getChain().get(0);
        }

        public RestResourceSearchParam addChain(String theString) {
            if (this.myChain == null) {
                this.myChain = new ArrayList<StringDt>();
            }
            this.myChain.add(new StringDt(theString));
            return this;
        }
    }

    @Block
    public static class RestResourceInteraction
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="code", type={CodeDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Coded identifier of the operation, supported by the system resource")
        private BoundCodeDt<TypeRestfulInteractionEnum> myCode;
        @Child(name="documentation", type={StringDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Guidance specific to the implementation of this operation, such as 'delete is a logical delete' or 'updates are only allowed with version id' or 'creates permitted from pre-authorized certificates only'")
        private StringDt myDocumentation;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myCode, this.myDocumentation});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myCode, this.myDocumentation});
        }

        public BoundCodeDt<TypeRestfulInteractionEnum> getCodeElement() {
            if (this.myCode == null) {
                this.myCode = new BoundCodeDt(TypeRestfulInteractionEnum.VALUESET_BINDER);
            }
            return this.myCode;
        }

        public String getCode() {
            return (String)this.getCodeElement().getValue();
        }

        public RestResourceInteraction setCode(BoundCodeDt<TypeRestfulInteractionEnum> theValue) {
            this.myCode = theValue;
            return this;
        }

        public RestResourceInteraction setCode(TypeRestfulInteractionEnum theValue) {
            this.getCodeElement().setValueAsEnum((Enum)theValue);
            return this;
        }

        public StringDt getDocumentationElement() {
            if (this.myDocumentation == null) {
                this.myDocumentation = new StringDt();
            }
            return this.myDocumentation;
        }

        public String getDocumentation() {
            return (String)this.getDocumentationElement().getValue();
        }

        public RestResourceInteraction setDocumentation(StringDt theValue) {
            this.myDocumentation = theValue;
            return this;
        }

        public RestResourceInteraction setDocumentation(String theString) {
            this.myDocumentation = new StringDt(theString);
            return this;
        }
    }

    @Block
    public static class RestResource
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="type", type={CodeDt.class}, order=0, min=1, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="A type of resource exposed via the restful interface")
        private BoundCodeDt<ResourceTypeEnum> myType;
        @Child(name="profile", order=1, min=0, max=1, summary=false, modifier=false, type={StructureDefinition.class})
        @Description(shortDefinition="", formalDefinition="A specification of the profile that describes the solution's overall support for the resource, including any constraints on cardinality, bindings, lengths or other limitations. See further discussion in [Using Profiles]{profiling.html#profile-uses}")
        private ResourceReferenceDt myProfile;
        @Child(name="interaction", order=2, min=1, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Identifies a restful operation supported by the solution")
        private List<RestResourceInteraction> myInteraction;
        @Child(name="versioning", type={CodeDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="This field is set to no-version to specify that the system does not support (server) or use (client) versioning for this resource type. If this has some other value, the server must at least correctly track and populate the versionId meta-property on resources. If the value is 'versioned-update', then the server supports all the versioning features, including using e-tags for version integrity in the API")
        private BoundCodeDt<ResourceVersionPolicyEnum> myVersioning;
        @Child(name="readHistory", type={BooleanDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A flag for whether the server is able to return past versions as part of the vRead operation")
        private BooleanDt myReadHistory;
        @Child(name="updateCreate", type={BooleanDt.class}, order=5, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A flag to indicate that the server allows or needs to allow the client to create new identities on the server (e.g. that is, the client PUTs to a location where there is no existing resource). Allowing this operation means that the server allows the client to create new identities on the server")
        private BooleanDt myUpdateCreate;
        @Child(name="conditionalCreate", type={BooleanDt.class}, order=6, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A flag that indicates that the server supports conditional create")
        private BooleanDt myConditionalCreate;
        @Child(name="conditionalUpdate", type={BooleanDt.class}, order=7, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A flag that indicates that the server supports conditional update")
        private BooleanDt myConditionalUpdate;
        @Child(name="conditionalDelete", type={CodeDt.class}, order=8, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A code that indicates how the server supports conditional delete")
        private BoundCodeDt<ConditionalDeleteStatusEnum> myConditionalDelete;
        @Child(name="searchInclude", type={StringDt.class}, order=9, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A list of _include values supported by the server")
        private List<StringDt> mySearchInclude;
        @Child(name="searchRevInclude", type={StringDt.class}, order=10, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A list of _revinclude (reverse include) values supported by the server")
        private List<StringDt> mySearchRevInclude;
        @Child(name="searchParam", order=11, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Search parameters for implementations to support and/or make use of - either references to ones defined in the specification, or additional ones defined for/by the implementation")
        private List<RestResourceSearchParam> mySearchParam;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myType, this.myProfile, this.myInteraction, this.myVersioning, this.myReadHistory, this.myUpdateCreate, this.myConditionalCreate, this.myConditionalUpdate, this.myConditionalDelete, this.mySearchInclude, this.mySearchRevInclude, this.mySearchParam});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myType, this.myProfile, this.myInteraction, this.myVersioning, this.myReadHistory, this.myUpdateCreate, this.myConditionalCreate, this.myConditionalUpdate, this.myConditionalDelete, this.mySearchInclude, this.mySearchRevInclude, this.mySearchParam});
        }

        public BoundCodeDt<ResourceTypeEnum> getTypeElement() {
            if (this.myType == null) {
                this.myType = new BoundCodeDt(ResourceTypeEnum.VALUESET_BINDER);
            }
            return this.myType;
        }

        public String getType() {
            return (String)this.getTypeElement().getValue();
        }

        public RestResource setType(BoundCodeDt<ResourceTypeEnum> theValue) {
            this.myType = theValue;
            return this;
        }

        public RestResource setType(ResourceTypeEnum theValue) {
            this.getTypeElement().setValueAsEnum((Enum)theValue);
            return this;
        }

        public ResourceReferenceDt getProfile() {
            if (this.myProfile == null) {
                this.myProfile = new ResourceReferenceDt();
            }
            return this.myProfile;
        }

        public RestResource setProfile(ResourceReferenceDt theValue) {
            this.myProfile = theValue;
            return this;
        }

        public List<RestResourceInteraction> getInteraction() {
            if (this.myInteraction == null) {
                this.myInteraction = new ArrayList<RestResourceInteraction>();
            }
            return this.myInteraction;
        }

        public RestResource setInteraction(List<RestResourceInteraction> theValue) {
            this.myInteraction = theValue;
            return this;
        }

        public RestResourceInteraction addInteraction() {
            RestResourceInteraction newType = new RestResourceInteraction();
            this.getInteraction().add(newType);
            return newType;
        }

        public RestResource addInteraction(RestResourceInteraction theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getInteraction().add(theValue);
            return this;
        }

        public RestResourceInteraction getInteractionFirstRep() {
            if (this.getInteraction().isEmpty()) {
                return this.addInteraction();
            }
            return this.getInteraction().get(0);
        }

        public BoundCodeDt<ResourceVersionPolicyEnum> getVersioningElement() {
            if (this.myVersioning == null) {
                this.myVersioning = new BoundCodeDt(ResourceVersionPolicyEnum.VALUESET_BINDER);
            }
            return this.myVersioning;
        }

        public String getVersioning() {
            return (String)this.getVersioningElement().getValue();
        }

        public RestResource setVersioning(BoundCodeDt<ResourceVersionPolicyEnum> theValue) {
            this.myVersioning = theValue;
            return this;
        }

        public RestResource setVersioning(ResourceVersionPolicyEnum theValue) {
            this.getVersioningElement().setValueAsEnum((Enum)theValue);
            return this;
        }

        public BooleanDt getReadHistoryElement() {
            if (this.myReadHistory == null) {
                this.myReadHistory = new BooleanDt();
            }
            return this.myReadHistory;
        }

        public Boolean getReadHistory() {
            return (Boolean)this.getReadHistoryElement().getValue();
        }

        public RestResource setReadHistory(BooleanDt theValue) {
            this.myReadHistory = theValue;
            return this;
        }

        public RestResource setReadHistory(boolean theBoolean) {
            this.myReadHistory = new BooleanDt(theBoolean);
            return this;
        }

        public BooleanDt getUpdateCreateElement() {
            if (this.myUpdateCreate == null) {
                this.myUpdateCreate = new BooleanDt();
            }
            return this.myUpdateCreate;
        }

        public Boolean getUpdateCreate() {
            return (Boolean)this.getUpdateCreateElement().getValue();
        }

        public RestResource setUpdateCreate(BooleanDt theValue) {
            this.myUpdateCreate = theValue;
            return this;
        }

        public RestResource setUpdateCreate(boolean theBoolean) {
            this.myUpdateCreate = new BooleanDt(theBoolean);
            return this;
        }

        public BooleanDt getConditionalCreateElement() {
            if (this.myConditionalCreate == null) {
                this.myConditionalCreate = new BooleanDt();
            }
            return this.myConditionalCreate;
        }

        public Boolean getConditionalCreate() {
            return (Boolean)this.getConditionalCreateElement().getValue();
        }

        public RestResource setConditionalCreate(BooleanDt theValue) {
            this.myConditionalCreate = theValue;
            return this;
        }

        public RestResource setConditionalCreate(boolean theBoolean) {
            this.myConditionalCreate = new BooleanDt(theBoolean);
            return this;
        }

        public BooleanDt getConditionalUpdateElement() {
            if (this.myConditionalUpdate == null) {
                this.myConditionalUpdate = new BooleanDt();
            }
            return this.myConditionalUpdate;
        }

        public Boolean getConditionalUpdate() {
            return (Boolean)this.getConditionalUpdateElement().getValue();
        }

        public RestResource setConditionalUpdate(BooleanDt theValue) {
            this.myConditionalUpdate = theValue;
            return this;
        }

        public RestResource setConditionalUpdate(boolean theBoolean) {
            this.myConditionalUpdate = new BooleanDt(theBoolean);
            return this;
        }

        public BoundCodeDt<ConditionalDeleteStatusEnum> getConditionalDeleteElement() {
            if (this.myConditionalDelete == null) {
                this.myConditionalDelete = new BoundCodeDt(ConditionalDeleteStatusEnum.VALUESET_BINDER);
            }
            return this.myConditionalDelete;
        }

        public String getConditionalDelete() {
            return (String)this.getConditionalDeleteElement().getValue();
        }

        public RestResource setConditionalDelete(BoundCodeDt<ConditionalDeleteStatusEnum> theValue) {
            this.myConditionalDelete = theValue;
            return this;
        }

        public RestResource setConditionalDelete(ConditionalDeleteStatusEnum theValue) {
            this.getConditionalDeleteElement().setValueAsEnum((Enum)theValue);
            return this;
        }

        public List<StringDt> getSearchInclude() {
            if (this.mySearchInclude == null) {
                this.mySearchInclude = new ArrayList<StringDt>();
            }
            return this.mySearchInclude;
        }

        public RestResource setSearchInclude(List<StringDt> theValue) {
            this.mySearchInclude = theValue;
            return this;
        }

        public StringDt addSearchInclude() {
            StringDt newType = new StringDt();
            this.getSearchInclude().add(newType);
            return newType;
        }

        public RestResource addSearchInclude(StringDt theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getSearchInclude().add(theValue);
            return this;
        }

        public StringDt getSearchIncludeFirstRep() {
            if (this.getSearchInclude().isEmpty()) {
                return this.addSearchInclude();
            }
            return this.getSearchInclude().get(0);
        }

        public RestResource addSearchInclude(String theString) {
            if (this.mySearchInclude == null) {
                this.mySearchInclude = new ArrayList<StringDt>();
            }
            this.mySearchInclude.add(new StringDt(theString));
            return this;
        }

        public List<StringDt> getSearchRevInclude() {
            if (this.mySearchRevInclude == null) {
                this.mySearchRevInclude = new ArrayList<StringDt>();
            }
            return this.mySearchRevInclude;
        }

        public RestResource setSearchRevInclude(List<StringDt> theValue) {
            this.mySearchRevInclude = theValue;
            return this;
        }

        public StringDt addSearchRevInclude() {
            StringDt newType = new StringDt();
            this.getSearchRevInclude().add(newType);
            return newType;
        }

        public RestResource addSearchRevInclude(StringDt theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getSearchRevInclude().add(theValue);
            return this;
        }

        public StringDt getSearchRevIncludeFirstRep() {
            if (this.getSearchRevInclude().isEmpty()) {
                return this.addSearchRevInclude();
            }
            return this.getSearchRevInclude().get(0);
        }

        public RestResource addSearchRevInclude(String theString) {
            if (this.mySearchRevInclude == null) {
                this.mySearchRevInclude = new ArrayList<StringDt>();
            }
            this.mySearchRevInclude.add(new StringDt(theString));
            return this;
        }

        public List<RestResourceSearchParam> getSearchParam() {
            if (this.mySearchParam == null) {
                this.mySearchParam = new ArrayList<RestResourceSearchParam>();
            }
            return this.mySearchParam;
        }

        public RestResource setSearchParam(List<RestResourceSearchParam> theValue) {
            this.mySearchParam = theValue;
            return this;
        }

        public RestResourceSearchParam addSearchParam() {
            RestResourceSearchParam newType = new RestResourceSearchParam();
            this.getSearchParam().add(newType);
            return newType;
        }

        public RestResource addSearchParam(RestResourceSearchParam theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getSearchParam().add(theValue);
            return this;
        }

        public RestResourceSearchParam getSearchParamFirstRep() {
            if (this.getSearchParam().isEmpty()) {
                return this.addSearchParam();
            }
            return this.getSearchParam().get(0);
        }
    }

    @Block
    public static class RestSecurityCertificate
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="type", type={CodeDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Mime type for certificate")
        private CodeDt myType;
        @Child(name="blob", type={Base64BinaryDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Actual certificate")
        private Base64BinaryDt myBlob;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myType, this.myBlob});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myType, this.myBlob});
        }

        public CodeDt getTypeElement() {
            if (this.myType == null) {
                this.myType = new CodeDt();
            }
            return this.myType;
        }

        public String getType() {
            return (String)this.getTypeElement().getValue();
        }

        public RestSecurityCertificate setType(CodeDt theValue) {
            this.myType = theValue;
            return this;
        }

        public RestSecurityCertificate setType(String theCode) {
            this.myType = new CodeDt(theCode);
            return this;
        }

        public Base64BinaryDt getBlobElement() {
            if (this.myBlob == null) {
                this.myBlob = new Base64BinaryDt();
            }
            return this.myBlob;
        }

        public byte[] getBlob() {
            return (byte[])this.getBlobElement().getValue();
        }

        public RestSecurityCertificate setBlob(Base64BinaryDt theValue) {
            this.myBlob = theValue;
            return this;
        }

        public RestSecurityCertificate setBlob(byte[] theBytes) {
            this.myBlob = new Base64BinaryDt(theBytes);
            return this;
        }
    }

    @Block
    public static class RestSecurity
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="cors", type={BooleanDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Server adds CORS headers when responding to requests - this enables javascript applications to use the server")
        private BooleanDt myCors;
        @Child(name="service", type={CodeableConceptDt.class}, order=1, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Types of security services are supported/required by the system")
        private List<BoundCodeableConceptDt<RestfulSecurityServiceEnum>> myService;
        @Child(name="description", type={StringDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="General description of how security works")
        private StringDt myDescription;
        @Child(name="certificate", order=3, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Certificates associated with security profiles")
        private List<RestSecurityCertificate> myCertificate;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myCors, this.myService, this.myDescription, this.myCertificate});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myCors, this.myService, this.myDescription, this.myCertificate});
        }

        public BooleanDt getCorsElement() {
            if (this.myCors == null) {
                this.myCors = new BooleanDt();
            }
            return this.myCors;
        }

        public Boolean getCors() {
            return (Boolean)this.getCorsElement().getValue();
        }

        public RestSecurity setCors(BooleanDt theValue) {
            this.myCors = theValue;
            return this;
        }

        public RestSecurity setCors(boolean theBoolean) {
            this.myCors = new BooleanDt(theBoolean);
            return this;
        }

        public List<BoundCodeableConceptDt<RestfulSecurityServiceEnum>> getService() {
            if (this.myService == null) {
                this.myService = new ArrayList<BoundCodeableConceptDt<RestfulSecurityServiceEnum>>();
            }
            return this.myService;
        }

        public RestSecurity setService(List<BoundCodeableConceptDt<RestfulSecurityServiceEnum>> theValue) {
            this.myService = theValue;
            return this;
        }

        public BoundCodeableConceptDt<RestfulSecurityServiceEnum> addService(RestfulSecurityServiceEnum theValue) {
            BoundCodeableConceptDt<RestfulSecurityServiceEnum> retVal = new BoundCodeableConceptDt<RestfulSecurityServiceEnum>(RestfulSecurityServiceEnum.VALUESET_BINDER, theValue);
            this.getService().add(retVal);
            return retVal;
        }

        public BoundCodeableConceptDt<RestfulSecurityServiceEnum> getServiceFirstRep() {
            if (this.getService().size() == 0) {
                this.addService();
            }
            return this.getService().get(0);
        }

        public BoundCodeableConceptDt<RestfulSecurityServiceEnum> addService() {
            BoundCodeableConceptDt<RestfulSecurityServiceEnum> retVal = new BoundCodeableConceptDt<RestfulSecurityServiceEnum>(RestfulSecurityServiceEnum.VALUESET_BINDER);
            this.getService().add(retVal);
            return retVal;
        }

        public RestSecurity setService(RestfulSecurityServiceEnum theValue) {
            this.getService().clear();
            this.addService(theValue);
            return this;
        }

        public StringDt getDescriptionElement() {
            if (this.myDescription == null) {
                this.myDescription = new StringDt();
            }
            return this.myDescription;
        }

        public String getDescription() {
            return (String)this.getDescriptionElement().getValue();
        }

        public RestSecurity setDescription(StringDt theValue) {
            this.myDescription = theValue;
            return this;
        }

        public RestSecurity setDescription(String theString) {
            this.myDescription = new StringDt(theString);
            return this;
        }

        public List<RestSecurityCertificate> getCertificate() {
            if (this.myCertificate == null) {
                this.myCertificate = new ArrayList<RestSecurityCertificate>();
            }
            return this.myCertificate;
        }

        public RestSecurity setCertificate(List<RestSecurityCertificate> theValue) {
            this.myCertificate = theValue;
            return this;
        }

        public RestSecurityCertificate addCertificate() {
            RestSecurityCertificate newType = new RestSecurityCertificate();
            this.getCertificate().add(newType);
            return newType;
        }

        public RestSecurity addCertificate(RestSecurityCertificate theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getCertificate().add(theValue);
            return this;
        }

        public RestSecurityCertificate getCertificateFirstRep() {
            if (this.getCertificate().isEmpty()) {
                return this.addCertificate();
            }
            return this.getCertificate().get(0);
        }
    }

    @Block
    public static class Rest
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="mode", type={CodeDt.class}, order=0, min=1, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="Identifies whether this portion of the statement is describing ability to initiate or receive restful operations")
        private BoundCodeDt<RestfulConformanceModeEnum> myMode;
        @Child(name="documentation", type={StringDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Information about the system's restful capabilities that apply across all applications, such as security")
        private StringDt myDocumentation;
        @Child(name="security", order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Information about security implementation from an interface perspective - what a client needs to know")
        private RestSecurity mySecurity;
        @Child(name="resource", order=3, min=1, max=-1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="A specification of the restful capabilities of the solution for a specific resource type")
        private List<RestResource> myResource;
        @Child(name="interaction", order=4, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A specification of restful operations supported by the system")
        private List<RestInteraction> myInteraction;
        @Child(name="transactionMode", type={CodeDt.class}, order=5, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A code that indicates how transactions are supported")
        private BoundCodeDt<TransactionModeEnum> myTransactionMode;
        @Child(name="searchParam", type={RestResourceSearchParam.class}, order=6, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Search parameters that are supported for searching all resources for implementations to support and/or make use of - either references to ones defined in the specification, or additional ones defined for/by the implementation")
        private List<RestResourceSearchParam> mySearchParam;
        @Child(name="operation", order=7, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Definition of an operation or a named query and with its parameters and their meaning and type")
        private List<RestOperation> myOperation;
        @Child(name="compartment", type={UriDt.class}, order=8, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="An absolute URI which is a reference to the definition of a compartment hosted by the system")
        private List<UriDt> myCompartment;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myMode, this.myDocumentation, this.mySecurity, this.myResource, this.myInteraction, this.myTransactionMode, this.mySearchParam, this.myOperation, this.myCompartment});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myMode, this.myDocumentation, this.mySecurity, this.myResource, this.myInteraction, this.myTransactionMode, this.mySearchParam, this.myOperation, this.myCompartment});
        }

        public BoundCodeDt<RestfulConformanceModeEnum> getModeElement() {
            if (this.myMode == null) {
                this.myMode = new BoundCodeDt(RestfulConformanceModeEnum.VALUESET_BINDER);
            }
            return this.myMode;
        }

        public String getMode() {
            return (String)this.getModeElement().getValue();
        }

        public Rest setMode(BoundCodeDt<RestfulConformanceModeEnum> theValue) {
            this.myMode = theValue;
            return this;
        }

        public Rest setMode(RestfulConformanceModeEnum theValue) {
            this.getModeElement().setValueAsEnum((Enum)theValue);
            return this;
        }

        public StringDt getDocumentationElement() {
            if (this.myDocumentation == null) {
                this.myDocumentation = new StringDt();
            }
            return this.myDocumentation;
        }

        public String getDocumentation() {
            return (String)this.getDocumentationElement().getValue();
        }

        public Rest setDocumentation(StringDt theValue) {
            this.myDocumentation = theValue;
            return this;
        }

        public Rest setDocumentation(String theString) {
            this.myDocumentation = new StringDt(theString);
            return this;
        }

        public RestSecurity getSecurity() {
            if (this.mySecurity == null) {
                this.mySecurity = new RestSecurity();
            }
            return this.mySecurity;
        }

        public Rest setSecurity(RestSecurity theValue) {
            this.mySecurity = theValue;
            return this;
        }

        public List<RestResource> getResource() {
            if (this.myResource == null) {
                this.myResource = new ArrayList<RestResource>();
            }
            return this.myResource;
        }

        public Rest setResource(List<RestResource> theValue) {
            this.myResource = theValue;
            return this;
        }

        public RestResource addResource() {
            RestResource newType = new RestResource();
            this.getResource().add(newType);
            return newType;
        }

        public Rest addResource(RestResource theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getResource().add(theValue);
            return this;
        }

        public RestResource getResourceFirstRep() {
            if (this.getResource().isEmpty()) {
                return this.addResource();
            }
            return this.getResource().get(0);
        }

        public List<RestInteraction> getInteraction() {
            if (this.myInteraction == null) {
                this.myInteraction = new ArrayList<RestInteraction>();
            }
            return this.myInteraction;
        }

        public Rest setInteraction(List<RestInteraction> theValue) {
            this.myInteraction = theValue;
            return this;
        }

        public RestInteraction addInteraction() {
            RestInteraction newType = new RestInteraction();
            this.getInteraction().add(newType);
            return newType;
        }

        public Rest addInteraction(RestInteraction theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getInteraction().add(theValue);
            return this;
        }

        public RestInteraction getInteractionFirstRep() {
            if (this.getInteraction().isEmpty()) {
                return this.addInteraction();
            }
            return this.getInteraction().get(0);
        }

        public BoundCodeDt<TransactionModeEnum> getTransactionModeElement() {
            if (this.myTransactionMode == null) {
                this.myTransactionMode = new BoundCodeDt(TransactionModeEnum.VALUESET_BINDER);
            }
            return this.myTransactionMode;
        }

        public String getTransactionMode() {
            return (String)this.getTransactionModeElement().getValue();
        }

        public Rest setTransactionMode(BoundCodeDt<TransactionModeEnum> theValue) {
            this.myTransactionMode = theValue;
            return this;
        }

        public Rest setTransactionMode(TransactionModeEnum theValue) {
            this.getTransactionModeElement().setValueAsEnum((Enum)theValue);
            return this;
        }

        public List<RestResourceSearchParam> getSearchParam() {
            if (this.mySearchParam == null) {
                this.mySearchParam = new ArrayList<RestResourceSearchParam>();
            }
            return this.mySearchParam;
        }

        public Rest setSearchParam(List<RestResourceSearchParam> theValue) {
            this.mySearchParam = theValue;
            return this;
        }

        public RestResourceSearchParam addSearchParam() {
            RestResourceSearchParam newType = new RestResourceSearchParam();
            this.getSearchParam().add(newType);
            return newType;
        }

        public Rest addSearchParam(RestResourceSearchParam theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getSearchParam().add(theValue);
            return this;
        }

        public RestResourceSearchParam getSearchParamFirstRep() {
            if (this.getSearchParam().isEmpty()) {
                return this.addSearchParam();
            }
            return this.getSearchParam().get(0);
        }

        public List<RestOperation> getOperation() {
            if (this.myOperation == null) {
                this.myOperation = new ArrayList<RestOperation>();
            }
            return this.myOperation;
        }

        public Rest setOperation(List<RestOperation> theValue) {
            this.myOperation = theValue;
            return this;
        }

        public RestOperation addOperation() {
            RestOperation newType = new RestOperation();
            this.getOperation().add(newType);
            return newType;
        }

        public Rest addOperation(RestOperation theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getOperation().add(theValue);
            return this;
        }

        public RestOperation getOperationFirstRep() {
            if (this.getOperation().isEmpty()) {
                return this.addOperation();
            }
            return this.getOperation().get(0);
        }

        public List<UriDt> getCompartment() {
            if (this.myCompartment == null) {
                this.myCompartment = new ArrayList<UriDt>();
            }
            return this.myCompartment;
        }

        public Rest setCompartment(List<UriDt> theValue) {
            this.myCompartment = theValue;
            return this;
        }

        public UriDt addCompartment() {
            UriDt newType = new UriDt();
            this.getCompartment().add(newType);
            return newType;
        }

        public Rest addCompartment(UriDt theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getCompartment().add(theValue);
            return this;
        }

        public UriDt getCompartmentFirstRep() {
            if (this.getCompartment().isEmpty()) {
                return this.addCompartment();
            }
            return this.getCompartment().get(0);
        }

        public Rest addCompartment(String theUri) {
            if (this.myCompartment == null) {
                this.myCompartment = new ArrayList<UriDt>();
            }
            this.myCompartment.add(new UriDt(theUri));
            return this;
        }
    }

    @Block
    public static class Implementation
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="description", type={StringDt.class}, order=0, min=1, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="Information about the specific installation that this conformance statement relates to")
        private StringDt myDescription;
        @Child(name="url", type={UriDt.class}, order=1, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="An absolute base URL for the implementation.  This forms the base for REST interfaces as well as the mailbox and document interfaces.")
        private UriDt myUrl;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myDescription, this.myUrl});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myDescription, this.myUrl});
        }

        public StringDt getDescriptionElement() {
            if (this.myDescription == null) {
                this.myDescription = new StringDt();
            }
            return this.myDescription;
        }

        public String getDescription() {
            return (String)this.getDescriptionElement().getValue();
        }

        public Implementation setDescription(StringDt theValue) {
            this.myDescription = theValue;
            return this;
        }

        public Implementation setDescription(String theString) {
            this.myDescription = new StringDt(theString);
            return this;
        }

        public UriDt getUrlElement() {
            if (this.myUrl == null) {
                this.myUrl = new UriDt();
            }
            return this.myUrl;
        }

        public String getUrl() {
            return (String)this.getUrlElement().getValue();
        }

        public Implementation setUrl(UriDt theValue) {
            this.myUrl = theValue;
            return this;
        }

        public Implementation setUrl(String theUri) {
            this.myUrl = new UriDt(theUri);
            return this;
        }
    }

    @Block
    public static class Software
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="name", type={StringDt.class}, order=0, min=1, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="Name software is known by")
        private StringDt myName;
        @Child(name="version", type={StringDt.class}, order=1, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="The version identifier for the software covered by this statement")
        private StringDt myVersion;
        @Child(name="releaseDate", type={DateTimeDt.class}, order=2, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="Date this version of the software released")
        private DateTimeDt myReleaseDate;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myName, this.myVersion, this.myReleaseDate});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myName, this.myVersion, this.myReleaseDate});
        }

        public StringDt getNameElement() {
            if (this.myName == null) {
                this.myName = new StringDt();
            }
            return this.myName;
        }

        public String getName() {
            return (String)this.getNameElement().getValue();
        }

        public Software setName(StringDt theValue) {
            this.myName = theValue;
            return this;
        }

        public Software setName(String theString) {
            this.myName = new StringDt(theString);
            return this;
        }

        public StringDt getVersionElement() {
            if (this.myVersion == null) {
                this.myVersion = new StringDt();
            }
            return this.myVersion;
        }

        public String getVersion() {
            return (String)this.getVersionElement().getValue();
        }

        public Software setVersion(StringDt theValue) {
            this.myVersion = theValue;
            return this;
        }

        public Software setVersion(String theString) {
            this.myVersion = new StringDt(theString);
            return this;
        }

        public DateTimeDt getReleaseDateElement() {
            if (this.myReleaseDate == null) {
                this.myReleaseDate = new DateTimeDt();
            }
            return this.myReleaseDate;
        }

        public Date getReleaseDate() {
            return (Date)this.getReleaseDateElement().getValue();
        }

        public Software setReleaseDate(DateTimeDt theValue) {
            this.myReleaseDate = theValue;
            return this;
        }

        public Software setReleaseDate(Date theDate, TemporalPrecisionEnum thePrecision) {
            this.myReleaseDate = new DateTimeDt(theDate, thePrecision);
            return this;
        }

        public Software setReleaseDateWithSecondsPrecision(Date theDate) {
            this.myReleaseDate = new DateTimeDt(theDate);
            return this;
        }
    }

    @Block
    public static class Contact
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="name", type={StringDt.class}, order=0, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="The name of an individual to contact regarding the conformance")
        private StringDt myName;
        @Child(name="telecom", type={ContactPointDt.class}, order=1, min=0, max=-1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="Contact details for individual (if a name was provided) or the publisher")
        private List<ContactPointDt> myTelecom;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myName, this.myTelecom});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myName, this.myTelecom});
        }

        public StringDt getNameElement() {
            if (this.myName == null) {
                this.myName = new StringDt();
            }
            return this.myName;
        }

        public String getName() {
            return (String)this.getNameElement().getValue();
        }

        public Contact setName(StringDt theValue) {
            this.myName = theValue;
            return this;
        }

        public Contact setName(String theString) {
            this.myName = new StringDt(theString);
            return this;
        }

        public List<ContactPointDt> getTelecom() {
            if (this.myTelecom == null) {
                this.myTelecom = new ArrayList<ContactPointDt>();
            }
            return this.myTelecom;
        }

        public Contact setTelecom(List<ContactPointDt> theValue) {
            this.myTelecom = theValue;
            return this;
        }

        public ContactPointDt addTelecom() {
            ContactPointDt newType = new ContactPointDt();
            this.getTelecom().add(newType);
            return newType;
        }

        public Contact addTelecom(ContactPointDt theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getTelecom().add(theValue);
            return this;
        }

        public ContactPointDt getTelecomFirstRep() {
            if (this.getTelecom().isEmpty()) {
                return this.addTelecom();
            }
            return this.getTelecom().get(0);
        }
    }
}

