/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.AttachmentDt;
import ca.uhn.fhir.model.dstu2.composite.CodingDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.Organization;
import ca.uhn.fhir.model.dstu2.resource.Patient;
import ca.uhn.fhir.model.dstu2.resource.Practitioner;
import ca.uhn.fhir.model.primitive.DateDt;
import ca.uhn.fhir.model.primitive.IntegerDt;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="Documentation", profile="http://hl7.org/fhir/profiles/Documentation", id="documentation")
public class Documentation
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="identifier", path="Documentation.identifier", description="The business identifier of the Eligibility", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="author", path="Documentation.author", description="The person who generated this resource", type="reference")
    public static final String SP_AUTHOR = "author";
    public static final ReferenceClientParam AUTHOR = new ReferenceClientParam("author");
    @SearchParamDefinition(name="subject", path="Documentation.subject", description="The patient to  whom the documents refer", type="reference")
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    @SearchParamDefinition(name="patient", path="Documentation.subject", description="The patient to  whom the documents refer", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_AUTHOR = new Include("Documentation:author");
    public static final Include INCLUDE_PATIENT = new Include("Documentation:patient");
    public static final Include INCLUDE_SUBJECT = new Include("Documentation:subject");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=1, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The Response business identifier")
    private List<IdentifierDt> myIdentifier;
    @Child(name="ruleset", type={CodingDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The version of the style of resource contents. This should be mapped to the allowable profiles for this and supporting resources.")
    private CodingDt myRuleset;
    @Child(name="originalRuleset", type={CodingDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The style (standard) and version of the original material which was converted into this resource.")
    private CodingDt myOriginalRuleset;
    @Child(name="date", type={DateDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The date when this resource was created.")
    private DateDt myDate;
    @Child(name="target", order=4, min=0, max=1, summary=false, modifier=false, type={Organization.class, Practitioner.class})
    @Description(shortDefinition="", formalDefinition="The Insurer, organization or Provider who is target  of the submission.")
    private ResourceReferenceDt myTarget;
    @Child(name="provider", order=5, min=0, max=1, summary=false, modifier=false, type={Practitioner.class})
    @Description(shortDefinition="", formalDefinition="The practitioner who is responsible for the services rendered to the patient.")
    private ResourceReferenceDt myProvider;
    @Child(name="organization", order=6, min=0, max=1, summary=false, modifier=false, type={Organization.class})
    @Description(shortDefinition="", formalDefinition="The organization which is responsible for the services rendered to the patient.")
    private ResourceReferenceDt myOrganization;
    @Child(name="requestIdentifier", type={IdentifierDt.class}, order=7, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Original request identifier")
    private IdentifierDt myRequestIdentifier;
    @Child(name="request", order=8, min=0, max=1, summary=false, modifier=false, type={IResource.class})
    @Description(shortDefinition="", formalDefinition="Original request identifier")
    private ResourceReferenceDt myRequest;
    @Child(name="responseIdentifier", type={IdentifierDt.class}, order=9, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Original response identifier")
    private IdentifierDt myResponseIdentifier;
    @Child(name="response", order=10, min=0, max=1, summary=false, modifier=false, type={IResource.class})
    @Description(shortDefinition="", formalDefinition="Original response identifier")
    private ResourceReferenceDt myResponse;
    @Child(name="author", order=11, min=0, max=1, summary=false, modifier=false, type={Practitioner.class})
    @Description(shortDefinition="", formalDefinition="Person who created the submission")
    private ResourceReferenceDt myAuthor;
    @Child(name="subject", order=12, min=0, max=1, summary=false, modifier=false, type={Patient.class})
    @Description(shortDefinition="", formalDefinition="The patient who is directly or indirectly the subject of the supporting information.")
    private ResourceReferenceDt mySubject;
    @Child(name="detail", order=13, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="")
    private List<Detail> myDetail;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myRuleset, this.myOriginalRuleset, this.myDate, this.myTarget, this.myProvider, this.myOrganization, this.myRequestIdentifier, this.myRequest, this.myResponseIdentifier, this.myResponse, this.myAuthor, this.mySubject, this.myDetail});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myRuleset, this.myOriginalRuleset, this.myDate, this.myTarget, this.myProvider, this.myOrganization, this.myRequestIdentifier, this.myRequest, this.myResponseIdentifier, this.myResponse, this.myAuthor, this.mySubject, this.myDetail});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public Documentation setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public Documentation addIdentifier(IdentifierDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getIdentifier().add(theValue);
        return this;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public CodingDt getRuleset() {
        if (this.myRuleset == null) {
            this.myRuleset = new CodingDt();
        }
        return this.myRuleset;
    }

    public Documentation setRuleset(CodingDt theValue) {
        this.myRuleset = theValue;
        return this;
    }

    public CodingDt getOriginalRuleset() {
        if (this.myOriginalRuleset == null) {
            this.myOriginalRuleset = new CodingDt();
        }
        return this.myOriginalRuleset;
    }

    public Documentation setOriginalRuleset(CodingDt theValue) {
        this.myOriginalRuleset = theValue;
        return this;
    }

    public DateDt getDateElement() {
        if (this.myDate == null) {
            this.myDate = new DateDt();
        }
        return this.myDate;
    }

    public Date getDate() {
        return (Date)this.getDateElement().getValue();
    }

    public Documentation setDate(DateDt theValue) {
        this.myDate = theValue;
        return this;
    }

    public Documentation setDate(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myDate = new DateDt(theDate, thePrecision);
        return this;
    }

    public Documentation setDateWithDayPrecision(Date theDate) {
        this.myDate = new DateDt(theDate);
        return this;
    }

    public ResourceReferenceDt getTarget() {
        if (this.myTarget == null) {
            this.myTarget = new ResourceReferenceDt();
        }
        return this.myTarget;
    }

    public Documentation setTarget(ResourceReferenceDt theValue) {
        this.myTarget = theValue;
        return this;
    }

    public ResourceReferenceDt getProvider() {
        if (this.myProvider == null) {
            this.myProvider = new ResourceReferenceDt();
        }
        return this.myProvider;
    }

    public Documentation setProvider(ResourceReferenceDt theValue) {
        this.myProvider = theValue;
        return this;
    }

    public ResourceReferenceDt getOrganization() {
        if (this.myOrganization == null) {
            this.myOrganization = new ResourceReferenceDt();
        }
        return this.myOrganization;
    }

    public Documentation setOrganization(ResourceReferenceDt theValue) {
        this.myOrganization = theValue;
        return this;
    }

    public IdentifierDt getRequestIdentifier() {
        if (this.myRequestIdentifier == null) {
            this.myRequestIdentifier = new IdentifierDt();
        }
        return this.myRequestIdentifier;
    }

    public Documentation setRequestIdentifier(IdentifierDt theValue) {
        this.myRequestIdentifier = theValue;
        return this;
    }

    public ResourceReferenceDt getRequest() {
        if (this.myRequest == null) {
            this.myRequest = new ResourceReferenceDt();
        }
        return this.myRequest;
    }

    public Documentation setRequest(ResourceReferenceDt theValue) {
        this.myRequest = theValue;
        return this;
    }

    public IdentifierDt getResponseIdentifier() {
        if (this.myResponseIdentifier == null) {
            this.myResponseIdentifier = new IdentifierDt();
        }
        return this.myResponseIdentifier;
    }

    public Documentation setResponseIdentifier(IdentifierDt theValue) {
        this.myResponseIdentifier = theValue;
        return this;
    }

    public ResourceReferenceDt getResponse() {
        if (this.myResponse == null) {
            this.myResponse = new ResourceReferenceDt();
        }
        return this.myResponse;
    }

    public Documentation setResponse(ResourceReferenceDt theValue) {
        this.myResponse = theValue;
        return this;
    }

    public ResourceReferenceDt getAuthor() {
        if (this.myAuthor == null) {
            this.myAuthor = new ResourceReferenceDt();
        }
        return this.myAuthor;
    }

    public Documentation setAuthor(ResourceReferenceDt theValue) {
        this.myAuthor = theValue;
        return this;
    }

    public ResourceReferenceDt getSubject() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public Documentation setSubject(ResourceReferenceDt theValue) {
        this.mySubject = theValue;
        return this;
    }

    public List<Detail> getDetail() {
        if (this.myDetail == null) {
            this.myDetail = new ArrayList<Detail>();
        }
        return this.myDetail;
    }

    public Documentation setDetail(List<Detail> theValue) {
        this.myDetail = theValue;
        return this;
    }

    public Detail addDetail() {
        Detail newType = new Detail();
        this.getDetail().add(newType);
        return newType;
    }

    public Documentation addDetail(Detail theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getDetail().add(theValue);
        return this;
    }

    public Detail getDetailFirstRep() {
        if (this.getDetail().isEmpty()) {
            return this.addDetail();
        }
        return this.getDetail().get(0);
    }

    public String getResourceName() {
        return "Documentation";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }

    @Block
    public static class Detail
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="linkId", type={IntegerDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A link Id for the response to reference.")
        private IntegerDt myLinkId;
        @Child(name="content", order=1, min=1, max=1, summary=false, modifier=false, type={IResource.class, AttachmentDt.class})
        @Description(shortDefinition="", formalDefinition="The attached content.")
        private IDatatype myContent;
        @Child(name="date", type={DateDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The date when the material was created.")
        private DateDt myDate;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myLinkId, this.myContent, this.myDate});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myLinkId, this.myContent, this.myDate});
        }

        public IntegerDt getLinkIdElement() {
            if (this.myLinkId == null) {
                this.myLinkId = new IntegerDt();
            }
            return this.myLinkId;
        }

        public Integer getLinkId() {
            return (Integer)this.getLinkIdElement().getValue();
        }

        public Detail setLinkId(IntegerDt theValue) {
            this.myLinkId = theValue;
            return this;
        }

        public Detail setLinkId(int theInteger) {
            this.myLinkId = new IntegerDt(theInteger);
            return this;
        }

        public IDatatype getContent() {
            return this.myContent;
        }

        public Detail setContent(IDatatype theValue) {
            this.myContent = theValue;
            return this;
        }

        public DateDt getDateElement() {
            if (this.myDate == null) {
                this.myDate = new DateDt();
            }
            return this.myDate;
        }

        public Date getDate() {
            return (Date)this.getDateElement().getValue();
        }

        public Detail setDate(DateDt theValue) {
            this.myDate = theValue;
            return this;
        }

        public Detail setDate(Date theDate, TemporalPrecisionEnum thePrecision) {
            this.myDate = new DateDt(theDate, thePrecision);
            return this;
        }

        public Detail setDateWithDayPrecision(Date theDate) {
            this.myDate = new DateDt(theDate);
            return this;
        }
    }
}

